/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.repository;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.repository.SchemaObject;
import com.alibaba.fastsql.sql.repository.SchemaObjectType;
import com.alibaba.fastsql.sql.repository.SchemaRepository;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Schema {
    private String catalog;
    private String name;
    protected final Map<Long, SchemaObject> objects = new ConcurrentHashMap<Long, SchemaObject>(16, 0.75f, 1);
    protected final Map<Long, SchemaObject> functions = new ConcurrentHashMap<Long, SchemaObject>(16, 0.75f, 1);
    private SchemaRepository repository;

    protected Schema(SchemaRepository repository) {
        this(repository, null);
    }

    protected Schema(SchemaRepository repository, String name) {
        this.repository = repository;
        this.setName(name);
    }

    protected Schema(SchemaRepository repository, String catalog, String name) {
        this.repository = repository;
        this.catalog = catalog;
        this.name = name;
    }

    public SchemaRepository getRepository() {
        return this.repository;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        if (this.name != null) {
            int p = this.name.indexOf(46);
            if (p != -1) {
                SQLExpr expr = SQLUtils.toSQLExpr(this.name, this.repository.dbType);
                if (expr instanceof SQLPropertyExpr) {
                    return ((SQLPropertyExpr)expr).getSimpleName();
                }
                return this.name.substring(p + 1);
            }
            return this.name;
        }
        return null;
    }

    public void setName(String name) {
        SQLExpr expr;
        this.name = name;
        if (name != null && name.indexOf(46) != -1 && (expr = SQLUtils.toSQLExpr(name, this.repository.dbType)) instanceof SQLPropertyExpr) {
            this.catalog = ((SQLPropertyExpr)expr).getOwnernName();
        }
    }

    public SchemaObject findTable(String tableName) {
        long hashCode64 = FnvHash.hashCode64(tableName);
        return this.findTable(hashCode64);
    }

    public SchemaObject findTable(long nameHashCode64) {
        SchemaObject object = this.objects.get(nameHashCode64);
        if (object != null && object.getType() == SchemaObjectType.Table) {
            return object;
        }
        return null;
    }

    public SchemaObject findView(String viewName) {
        long hashCode64 = FnvHash.hashCode64(viewName);
        return this.findView(hashCode64);
    }

    public SchemaObject findView(long nameHashCode64) {
        SchemaObject object = this.objects.get(nameHashCode64);
        if (object != null && object.getType() == SchemaObjectType.View) {
            return object;
        }
        return null;
    }

    public SchemaObject findTableOrView(String tableName) {
        long hashCode64 = FnvHash.hashCode64(tableName);
        return this.findTableOrView(hashCode64);
    }

    public SchemaObject findTableOrView(long hashCode64) {
        SchemaObject object = this.objects.get(hashCode64);
        if (object == null) {
            return null;
        }
        SchemaObjectType type = object.getType();
        if (type == SchemaObjectType.Table || type == SchemaObjectType.View) {
            return object;
        }
        return null;
    }

    public SchemaObject findFunction(String functionName) {
        functionName = SQLUtils.normalize(functionName);
        String lowerName = functionName.toLowerCase();
        return this.functions.get(lowerName);
    }

    public boolean isSequence(String name) {
        long nameHashCode64 = FnvHash.hashCode64(name);
        SchemaObject object = this.objects.get(nameHashCode64);
        return object != null && object.getType() == SchemaObjectType.Sequence;
    }

    public SchemaObject findTable(SQLTableSource tableSource, String alias) {
        if (tableSource instanceof SQLExprTableSource) {
            if (StringUtils.equalsIgnoreCase(alias, tableSource.computeAlias())) {
                SQLExprTableSource exprTableSource = (SQLExprTableSource)tableSource;
                SchemaObject tableObject = exprTableSource.getSchemaObject();
                if (tableObject != null) {
                    return tableObject;
                }
                SQLExpr expr = exprTableSource.getExpr();
                if (expr instanceof SQLIdentifierExpr) {
                    long tableNameHashCode64 = ((SQLIdentifierExpr)expr).nameHashCode64();
                    tableObject = this.findTable(tableNameHashCode64);
                    if (tableObject != null) {
                        exprTableSource.setSchemaObject(tableObject);
                    }
                    return tableObject;
                }
                if (expr instanceof SQLPropertyExpr) {
                    long tableNameHashCode64 = ((SQLPropertyExpr)expr).nameHashCode64();
                    tableObject = this.findTable(tableNameHashCode64);
                    if (tableObject != null) {
                        exprTableSource.setSchemaObject(tableObject);
                    }
                    return tableObject;
                }
            }
            return null;
        }
        if (tableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
            SQLTableSource left = join.getLeft();
            SchemaObject tableObject = this.findTable(left, alias);
            if (tableObject != null) {
                return tableObject;
            }
            SQLTableSource right = join.getRight();
            tableObject = this.findTable(right, alias);
            return tableObject;
        }
        return null;
    }

    public SQLColumnDefinition findColumn(SQLTableSource tableSource, SQLSelectItem selectItem) {
        if (selectItem == null) {
            return null;
        }
        return this.findColumn(tableSource, selectItem.getExpr());
    }

    public SQLColumnDefinition findColumn(SQLTableSource tableSource, SQLExpr expr) {
        SchemaObject object = this.findTable(tableSource, expr);
        if (object != null) {
            SQLAggregateExpr aggregateExpr;
            String function;
            if (expr instanceof SQLAggregateExpr && ("min".equalsIgnoreCase(function = (aggregateExpr = (SQLAggregateExpr)expr).getMethodName()) || "max".equalsIgnoreCase(function))) {
                SQLExpr arg;
                expr = arg = aggregateExpr.getArguments().get(0);
            }
            if (expr instanceof SQLName) {
                return object.findColumn(((SQLName)expr).getSimpleName());
            }
        }
        return null;
    }

    public SchemaObject findTable(SQLTableSource tableSource, SQLSelectItem selectItem) {
        if (selectItem == null) {
            return null;
        }
        return this.findTable(tableSource, selectItem.getExpr());
    }

    public SchemaObject findTable(SQLTableSource tableSource, SQLExpr expr) {
        SQLAggregateExpr aggregateExpr;
        String function;
        if (expr instanceof SQLAggregateExpr && ("min".equalsIgnoreCase(function = (aggregateExpr = (SQLAggregateExpr)expr).getMethodName()) || "max".equalsIgnoreCase(function))) {
            SQLExpr arg = aggregateExpr.getArguments().get(0);
            return this.findTable(tableSource, arg);
        }
        if (expr instanceof SQLPropertyExpr) {
            String ownerName = ((SQLPropertyExpr)expr).getOwnernName();
            return this.findTable(tableSource, ownerName);
        }
        if (expr instanceof SQLAllColumnExpr || expr instanceof SQLIdentifierExpr) {
            if (tableSource instanceof SQLExprTableSource) {
                return this.findTable(tableSource, tableSource.computeAlias());
            }
            if (tableSource instanceof SQLJoinTableSource) {
                SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
                SchemaObject table = this.findTable(join.getLeft(), expr);
                if (table == null) {
                    table = this.findTable(join.getRight(), expr);
                }
                return table;
            }
            return null;
        }
        return null;
    }

    public Map<String, SchemaObject> getTables(SQLTableSource x) {
        LinkedHashMap<String, SchemaObject> tables = new LinkedHashMap<String, SchemaObject>();
        this.computeTables(x, tables);
        return tables;
    }

    protected void computeTables(SQLTableSource x, Map<String, SchemaObject> tables) {
        if (x == null) {
            return;
        }
        if (x instanceof SQLExprTableSource) {
            SQLExprTableSource exprTableSource = (SQLExprTableSource)x;
            SQLExpr expr = exprTableSource.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                long tableNameHashCode64 = ((SQLIdentifierExpr)expr).nameHashCode64();
                String tableName = ((SQLIdentifierExpr)expr).getName();
                SchemaObject table = exprTableSource.getSchemaObject();
                if (table == null && (table = this.findTable(tableNameHashCode64)) != null) {
                    exprTableSource.setSchemaObject(table);
                }
                if (table != null) {
                    tables.put(tableName, table);
                    String alias = x.getAlias();
                    if (alias != null && !alias.equalsIgnoreCase(tableName)) {
                        tables.put(alias, table);
                    }
                }
            }
            return;
        }
        if (x instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)x;
            this.computeTables(join.getLeft(), tables);
            this.computeTables(join.getRight(), tables);
        }
    }

    public int getTableCount() {
        int count = 0;
        for (SchemaObject object : this.objects.values()) {
            if (object.getType() != SchemaObjectType.Table) continue;
            ++count;
        }
        return count;
    }

    public Collection<SchemaObject> getObjects() {
        return this.objects.values();
    }

    public int getViewCount() {
        int count = 0;
        for (SchemaObject object : this.objects.values()) {
            if (object.getType() != SchemaObjectType.View) continue;
            ++count;
        }
        return count;
    }

    public List<String> showTables() {
        ArrayList<String> tables = new ArrayList<String>(this.objects.size());
        for (SchemaObject object : this.objects.values()) {
            if (object.getType() != SchemaObjectType.Table) continue;
            tables.add(object.getName());
        }
        Collections.sort(tables);
        return tables;
    }

    public String getCatalog() {
        return this.catalog;
    }
}

