/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLAdhocTableSource;
import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.SQLOrderingSpecification;
import com.alibaba.fastsql.sql.ast.SQLOver;
import com.alibaba.fastsql.sql.ast.SQLWindow;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLGroupingSetExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLRealExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprHint;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionOperator;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUnnestTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLValuesQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveCreateTableParser;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.mysql.ast.expr.MySqlOrderingExpr;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsUsingExpr;
import com.alibaba.fastsql.sql.parser.EOFParserException;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLSelectListCache;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class SQLSelectParser
extends SQLParser {
    protected SQLExprParser exprParser;
    protected SQLSelectListCache selectListCache;

    public SQLSelectParser(String sql) {
        super(sql);
    }

    public SQLSelectParser(Lexer lexer) {
        super(lexer);
    }

    public SQLSelectParser(SQLExprParser exprParser) {
        this(exprParser, null);
    }

    public SQLSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser.getLexer(), exprParser.getDbType());
        this.exprParser = exprParser;
        this.selectListCache = selectListCache;
    }

    public SQLSelect select() {
        SQLSelect select = new SQLSelect();
        this.lexer.setStartPos(select);
        if (this.lexer.token == Token.WITH) {
            SQLWithSubqueryClause with = this.parseWith();
            select.setWithSubQuery(with);
        }
        SQLSelectQuery query = this.query(select);
        select.setQuery(query);
        SQLOrderBy orderBy = this.parseOrderBy();
        if (query instanceof SQLSelectQueryBlock) {
            SQLLimit limit;
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            if (queryBlock.getOrderBy() == null) {
                queryBlock.setOrderBy(orderBy);
                if (this.lexer.token == Token.LIMIT) {
                    limit = this.exprParser.parseLimit();
                    queryBlock.setLimit(limit);
                }
            } else {
                select.setOrderBy(orderBy);
                if (this.lexer.token == Token.LIMIT) {
                    limit = this.exprParser.parseLimit();
                    select.setLimit(limit);
                }
            }
            if (orderBy != null) {
                this.parseFetchClause(queryBlock);
            }
        } else {
            select.setOrderBy(orderBy);
        }
        if (this.lexer.token == Token.LIMIT) {
            SQLLimit limit = this.exprParser.parseLimit();
            select.setLimit(limit);
        }
        while (this.lexer.token == Token.HINT) {
            this.exprParser.parseHints(select.getHints());
        }
        return select;
    }

    protected SQLUnionQuery createSQLUnionQuery() {
        SQLUnionQuery union = new SQLUnionQuery();
        union.setDbType(this.dbType);
        return union;
    }

    public SQLUnionQuery unionRest(SQLUnionQuery union) {
        if (this.lexer.token == Token.ORDER) {
            SQLOrderBy orderBy = this.exprParser.parseOrderBy();
            union.setOrderBy(orderBy);
            return this.unionRest(union);
        }
        if (this.lexer.token == Token.LIMIT) {
            SQLLimit limit = this.exprParser.parseLimit();
            union.setLimit(limit);
        }
        return union;
    }

    public SQLSelectQuery queryRest(SQLSelectQuery selectQuery) {
        return this.queryRest(selectQuery, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SQLSelectQuery queryRest(SQLSelectQuery selectQuery, boolean acceptUnion) {
        if (!acceptUnion) {
            return selectQuery;
        }
        if (this.lexer.token != Token.UNION) {
            if (this.lexer.token == Token.EXCEPT) {
                SQLLimit limit;
                this.lexer.nextToken();
                SQLUnionQuery union = new SQLUnionQuery();
                union.setLeft(selectQuery);
                if (this.lexer.token == Token.ALL) {
                    union.setOperator(SQLUnionOperator.EXCEPT_ALL);
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.DISTINCT) {
                    union.setOperator(SQLUnionOperator.EXCEPT_DISTINCT);
                    this.lexer.nextToken();
                } else {
                    union.setOperator(SQLUnionOperator.EXCEPT);
                }
                boolean paren = this.lexer.token == Token.LPAREN;
                SQLSelectQuery right = this.query(union, false);
                union.setRight(right);
                if (paren) return this.queryRest(union, true);
                if (right instanceof SQLSelectQueryBlock) {
                    SQLLimit limit2;
                    SQLSelectQueryBlock rightQuery = (SQLSelectQueryBlock)right;
                    SQLOrderBy orderBy = rightQuery.getOrderBy();
                    if (orderBy != null) {
                        union.setOrderBy(orderBy);
                        rightQuery.setOrderBy(null);
                    }
                    if ((limit2 = rightQuery.getLimit()) == null) return this.queryRest(union, true);
                    union.setLimit(limit2);
                    rightQuery.setLimit(null);
                    return this.queryRest(union, true);
                }
                if (!(right instanceof SQLUnionQuery)) return this.queryRest(union, true);
                SQLUnionQuery rightUnion = (SQLUnionQuery)right;
                SQLOrderBy orderBy = rightUnion.getOrderBy();
                if (orderBy != null) {
                    union.setOrderBy(orderBy);
                    rightUnion.setOrderBy(null);
                }
                if ((limit = rightUnion.getLimit()) == null) return this.queryRest(union, true);
                union.setLimit(limit);
                rightUnion.setLimit(null);
                return this.queryRest(union, true);
            }
            if (this.lexer.token == Token.INTERSECT) {
                SQLLimit limit;
                this.lexer.nextToken();
                SQLUnionQuery union = new SQLUnionQuery();
                union.setLeft(selectQuery);
                if (this.lexer.token == Token.ALL) {
                    union.setOperator(SQLUnionOperator.INTERSECT_ALL);
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.DISTINCT) {
                    union.setOperator(SQLUnionOperator.INTERSECT_DISTINCT);
                    this.lexer.nextToken();
                } else {
                    union.setOperator(SQLUnionOperator.INTERSECT);
                }
                boolean paren = this.lexer.token == Token.LPAREN;
                SQLSelectQuery right = this.query(union, false);
                union.setRight(right);
                if (paren) return this.queryRest(union, true);
                if (right instanceof SQLSelectQueryBlock) {
                    SQLLimit limit3;
                    SQLSelectQueryBlock rightQuery = (SQLSelectQueryBlock)right;
                    SQLOrderBy orderBy = rightQuery.getOrderBy();
                    if (orderBy != null) {
                        union.setOrderBy(orderBy);
                        rightQuery.setOrderBy(null);
                    }
                    if ((limit3 = rightQuery.getLimit()) == null) return this.queryRest(union, true);
                    union.setLimit(limit3);
                    rightQuery.setLimit(null);
                    return this.queryRest(union, true);
                }
                if (!(right instanceof SQLUnionQuery)) return this.queryRest(union, true);
                SQLUnionQuery rightUnion = (SQLUnionQuery)right;
                SQLOrderBy orderBy = rightUnion.getOrderBy();
                if (orderBy != null) {
                    union.setOrderBy(orderBy);
                    rightUnion.setOrderBy(null);
                }
                if ((limit = rightUnion.getLimit()) == null) return this.queryRest(union, true);
                union.setLimit(limit);
                rightUnion.setLimit(null);
                return this.queryRest(union, true);
            }
            if (!acceptUnion) return selectQuery;
            if (this.lexer.token != Token.MINUS) return selectQuery;
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            if (this.lexer.token == Token.ALL) {
                union.setOperator(SQLUnionOperator.MINUS_ALL);
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.DISTINCT) {
                union.setOperator(SQLUnionOperator.MINUS_DISTINCT);
                this.lexer.nextToken();
            } else {
                union.setOperator(SQLUnionOperator.MINUS);
            }
            SQLSelectQuery right = this.query(union, false);
            union.setRight(right);
            return this.queryRest(union, true);
        }
        do {
            this.lexer.nextToken();
            SQLUnionQuery union = this.createSQLUnionQuery();
            if (union.getRelations().isEmpty()) {
                union.setLeft(selectQuery);
            }
            if (this.lexer.token == Token.ALL) {
                union.setOperator(SQLUnionOperator.UNION_ALL);
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.DISTINCT) {
                union.setOperator(SQLUnionOperator.DISTINCT);
                this.lexer.nextToken();
            }
            boolean paren = this.lexer.token == Token.LPAREN;
            SQLSelectQuery right = this.query(paren ? null : union, false);
            union.setRight(right);
            while (this.lexer.isEnabled(SQLParserFeature.EnableMultiUnion) && this.lexer.token == Token.UNION) {
                block43: {
                    Lexer.SavePoint mark = this.lexer.mark();
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.ALL) {
                        if (union.getOperator() == SQLUnionOperator.UNION_ALL) {
                            this.lexer.nextToken();
                            break block43;
                        } else {
                            this.lexer.reset(mark);
                            break;
                        }
                    }
                    if (this.lexer.token == Token.DISTINCT) {
                        if (union.getOperator() == SQLUnionOperator.DISTINCT) {
                            this.lexer.nextToken();
                            break block43;
                        } else {
                            this.lexer.reset(mark);
                            break;
                        }
                    }
                    if (union.getOperator() != SQLUnionOperator.UNION) {
                        this.lexer.reset(mark);
                        break;
                    }
                }
                paren = this.lexer.token == Token.LPAREN;
                SQLSelectQuery r = this.query(paren ? null : union, false);
                union.addRelation(r);
                right = r;
            }
            if (!paren) {
                SQLLimit limit;
                SQLOrderBy orderBy;
                if (right instanceof SQLSelectQueryBlock) {
                    SQLSelectQueryBlock rightQuery = (SQLSelectQueryBlock)right;
                    orderBy = rightQuery.getOrderBy();
                    if (orderBy != null) {
                        union.setOrderBy(orderBy);
                        rightQuery.setOrderBy(null);
                    }
                    if ((limit = rightQuery.getLimit()) != null) {
                        union.setLimit(limit);
                        rightQuery.setLimit(null);
                    }
                } else if (right instanceof SQLUnionQuery) {
                    SQLUnionQuery rightUnion = (SQLUnionQuery)right;
                    orderBy = rightUnion.getOrderBy();
                    if (orderBy != null) {
                        union.setOrderBy(orderBy);
                        rightUnion.setOrderBy(null);
                    }
                    if ((limit = rightUnion.getLimit()) != null) {
                        union.setLimit(limit);
                        rightUnion.setLimit(null);
                    }
                }
            }
            union = this.unionRest(union);
            selectQuery = union;
        } while (this.lexer.token() == Token.UNION);
        return this.queryRest(selectQuery, true);
    }

    private void setToLeft(SQLSelectQuery selectQuery, SQLUnionQuery parentUnion, SQLUnionQuery union, SQLSelectQuery right) {
        SQLUnionOperator operator = union.getOperator();
        if (union.getLeft() instanceof SQLUnionQuery) {
            SQLUnionQuery left = (SQLUnionQuery)union.getLeft();
            while (left.getLeft() instanceof SQLUnionQuery) {
                left = (SQLUnionQuery)left.getLeft();
            }
            left.setLeft(new SQLUnionQuery(parentUnion.getLeft(), parentUnion.getOperator(), left.getLeft()));
            parentUnion.setLeft(union.getLeft());
            parentUnion.setRight(union.getRight());
        } else {
            parentUnion.setRight(right);
            union.setLeft(parentUnion.getLeft());
            parentUnion.setLeft(union);
            union.setRight(selectQuery);
            union.setOperator(parentUnion.getOperator());
            parentUnion.setOperator(operator);
        }
    }

    public SQLSelectQuery query() {
        return this.query(null, true);
    }

    public SQLSelectQuery query(SQLObject parent) {
        return this.query(parent, true);
    }

    public SQLSelectQuery query(SQLObject parent, boolean acceptUnion) {
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select, acceptUnion);
        }
        if (this.lexer.token() == Token.VALUES) {
            return this.valuesQuery(acceptUnion);
        }
        SQLSelectQueryBlock queryBlock = new SQLSelectQueryBlock(this.dbType);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            queryBlock.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.SELECT);
        if (this.lexer.token() == Token.HINT) {
            this.exprParser.parseHints(queryBlock.getHints());
        }
        if (this.lexer.token == Token.COMMENT) {
            this.lexer.nextToken();
        }
        if (DbType.informix == this.dbType) {
            if (this.lexer.identifierEquals(FnvHash.Constants.SKIP)) {
                this.lexer.nextToken();
                SQLExpr offset = this.exprParser.primary();
                queryBlock.setOffset(offset);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.FIRST)) {
                this.lexer.nextToken();
                SQLExpr first = this.exprParser.primary();
                queryBlock.setFirst(first);
            }
        }
        if (this.lexer.token == Token.DISTINCT) {
            queryBlock.setDistionOption(2);
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.UNIQUE) {
            queryBlock.setDistionOption(3);
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.ALL) {
            queryBlock.setDistionOption(1);
            this.lexer.nextToken();
        }
        this.parseSelectList(queryBlock);
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            SQLExpr expr = this.expr();
            if (this.lexer.token() != Token.COMMA) {
                queryBlock.setInto(expr);
            }
        }
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        if (this.lexer.identifierEquals(FnvHash.Constants.WINDOW)) {
            this.parseWindow(queryBlock);
        }
        this.parseSortBy(queryBlock);
        this.parseFetchClause(queryBlock);
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            this.accept(Token.UPDATE);
            queryBlock.setForUpdate(true);
            if (this.lexer.identifierEquals(FnvHash.Constants.NO_WAIT) || this.lexer.identifierEquals(FnvHash.Constants.NOWAIT)) {
                this.lexer.nextToken();
                queryBlock.setNoWait(true);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.WAIT)) {
                this.lexer.nextToken();
                SQLExpr waitTime = this.exprParser.primary();
                queryBlock.setWaitTime(waitTime);
            }
        }
        return this.queryRest(queryBlock, acceptUnion);
    }

    protected SQLSelectQuery valuesQuery(boolean acceptUnion) {
        this.lexer.nextToken();
        SQLValuesQuery valuesQuery = new SQLValuesQuery();
        while (true) {
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                SQLListExpr listExpr = new SQLListExpr();
                this.exprParser.exprList(listExpr.getItems(), listExpr);
                this.accept(Token.RPAREN);
                valuesQuery.addValue(listExpr);
            } else {
                this.exprParser.exprList(valuesQuery.getValues(), valuesQuery);
            }
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return this.queryRest(valuesQuery, acceptUnion);
    }

    protected void withSubquery(SQLSelect select) {
        if (this.lexer.token == Token.WITH) {
            this.lexer.nextToken();
            SQLWithSubqueryClause withQueryClause = new SQLWithSubqueryClause();
            if (this.lexer.token == Token.RECURSIVE || this.lexer.identifierEquals(FnvHash.Constants.RECURSIVE)) {
                this.lexer.nextToken();
                withQueryClause.setRecursive(true);
            }
            while (true) {
                SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
                entry.setParent(withQueryClause);
                String alias = this.lexer.stringVal();
                this.lexer.nextToken();
                entry.setAlias(alias);
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.names(entry.getColumns());
                    this.accept(Token.RPAREN);
                }
                this.accept(Token.AS);
                this.accept(Token.LPAREN);
                entry.setSubQuery(this.select());
                this.accept(Token.RPAREN);
                withQueryClause.addEntry(entry);
                if (this.lexer.token != Token.COMMA) break;
                this.lexer.nextToken();
            }
            select.setWithSubQuery(withQueryClause);
        }
    }

    public SQLWithSubqueryClause parseWith() {
        SQLWithSubqueryClause withQueryClause = new SQLWithSubqueryClause();
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            withQueryClause.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.WITH);
        if (this.lexer.token == Token.RECURSIVE || this.lexer.identifierEquals(FnvHash.Constants.RECURSIVE)) {
            this.lexer.nextToken();
            withQueryClause.setRecursive(true);
        }
        while (true) {
            SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
            entry.setParent(withQueryClause);
            String alias = this.lexer.stringVal();
            this.lexer.nextToken();
            entry.setAlias(alias);
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(entry.getColumns());
                this.accept(Token.RPAREN);
            }
            this.accept(Token.AS);
            this.accept(Token.LPAREN);
            switch (this.lexer.token) {
                case SELECT: 
                case WITH: {
                    entry.setSubQuery(this.select());
                    break;
                }
            }
            this.accept(Token.RPAREN);
            withQueryClause.addEntry(entry);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return withQueryClause;
    }

    public void parseWhere(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token == Token.WHERE) {
            SQLExpr where;
            this.lexer.nextTokenIdent();
            List<String> beforeComments = null;
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                beforeComments = this.lexer.readAndResetComments();
            }
            if (this.lexer.token == Token.IDENTIFIER) {
                SQLExpr identExpr;
                String ident = this.lexer.stringVal();
                long hash_lower = this.lexer.hash_lower();
                this.lexer.nextTokenEq();
                int startLine = this.lexer.getPosLine();
                int startCol = this.lexer.getPosColumn();
                if (this.lexer.token == Token.LITERAL_CHARS) {
                    String literal = this.lexer.stringVal;
                    if (hash_lower == FnvHash.Constants.TIMESTAMP) {
                        identExpr = new SQLTimestampExpr(literal);
                        this.lexer.nextToken();
                    } else if (hash_lower == FnvHash.Constants.DATE) {
                        identExpr = new SQLDateExpr(literal);
                        this.lexer.nextToken();
                    } else if (hash_lower == FnvHash.Constants.REAL) {
                        identExpr = new SQLRealExpr(Float.parseFloat(literal));
                        this.lexer.nextToken();
                    } else if (hash_lower == FnvHash.Constants.TIME) {
                        identExpr = new SQLTimeExpr(this.lexer.stringVal());
                        this.lexer.nextToken();
                    } else {
                        identExpr = new SQLIdentifierExpr(ident, hash_lower);
                    }
                } else {
                    identExpr = new SQLIdentifierExpr(ident, hash_lower);
                }
                if (this.lexer.token == Token.DOT) {
                    identExpr = this.exprParser.primaryRest(identExpr);
                }
                identExpr.setStartLine(startLine);
                identExpr.setStartColumn(startCol);
                if (this.lexer.token == Token.EQ) {
                    SQLExpr rightExp;
                    this.lexer.nextToken();
                    try {
                        rightExp = this.exprParser.bitOr();
                    }
                    catch (EOFParserException e) {
                        throw new ParserException("EOF, " + ident + "=", this.lexer.getPosLine(), this.lexer.getPosColumn());
                    }
                    where = new SQLBinaryOpExpr(identExpr, SQLBinaryOperator.Equality, rightExp, this.dbType);
                    switch (this.lexer.token) {
                        case BETWEEN: 
                        case IS: 
                        case EQ: 
                        case IN: 
                        case CONTAINS: 
                        case BANG_TILDE_STAR: 
                        case TILDE_EQ: 
                        case LT: 
                        case LTEQ: 
                        case LTEQGT: 
                        case GT: 
                        case GTEQ: 
                        case LTGT: 
                        case BANGEQ: 
                        case LIKE: 
                        case NOT: {
                            where = this.exprParser.relationalRest(where);
                            break;
                        }
                    }
                    where = this.exprParser.andRest(where);
                    where = this.exprParser.xorRest(where);
                    where = this.exprParser.orRest(where);
                } else {
                    identExpr = this.exprParser.primaryRest(identExpr);
                    where = this.exprParser.exprRest(identExpr);
                }
            } else {
                while (this.lexer.token == Token.HINT) {
                    this.lexer.nextToken();
                }
                where = this.exprParser.expr();
                while (this.lexer.token == Token.HINT) {
                    this.lexer.nextToken();
                }
            }
            if (beforeComments != null) {
                where.addBeforeComment(beforeComments);
            }
            if (this.lexer.hasComment() && this.lexer.isKeepComments() && this.lexer.token != Token.INSERT) {
                where.addAfterComment(this.lexer.readAndResetComments());
            }
            queryBlock.setWhere(where);
        }
    }

    protected void parseSortBy(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.parseOrderBy();
            queryBlock.setOrderBy(orderBy);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DISTRIBUTE)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem distributeByItem = this.exprParser.parseSelectOrderByItem();
                queryBlock.addDistributeBy(distributeByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SORT)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem sortByItem = this.exprParser.parseSelectOrderByItem();
                queryBlock.addSortBy(sortByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTER)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem clusterByItem = this.exprParser.parseSelectOrderByItem();
                queryBlock.addClusterBy(clusterByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
    }

    protected void parseWindow(SQLSelectQueryBlock queryBlock) {
        if (!this.lexer.identifierEquals(FnvHash.Constants.WINDOW) && this.lexer.token != Token.WINDOW) {
            return;
        }
        this.lexer.nextToken();
        while (true) {
            SQLName name = this.exprParser.name();
            this.accept(Token.AS);
            SQLOver over = new SQLOver();
            this.exprParser.over(over);
            queryBlock.addWindow(new SQLWindow(name, over));
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    protected void parseGroupBy(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token == Token.GROUP) {
            SQLExpr having;
            this.lexer.nextTokenBy();
            this.accept(Token.BY);
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            if (this.lexer.token == Token.HINT) {
                groupBy.setHint(this.exprParser.parseHint());
            }
            if (this.lexer.token == Token.ALL) {
                this.lexer.nextToken();
                if (!this.lexer.identifierEquals(FnvHash.Constants.GROUPING)) {
                    throw new ParserException("group by all syntax error. " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
                }
            } else if (this.lexer.token == Token.DISTINCT) {
                this.lexer.nextToken();
                groupBy.setDistinct(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                groupBy.setWithRollUp(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.CUBE)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                groupBy.setWithCube(true);
            }
            boolean hasComma = false;
            while (true) {
                SQLExpr item = this.parseGroupByItem();
                item.setParent(groupBy);
                groupBy.addItem(item);
                if (hasComma && item instanceof SQLGroupingSetExpr) {
                    ((SQLGroupingSetExpr)item).setHasComma(true);
                }
                hasComma = false;
                if (this.lexer.token == Token.COMMA) {
                    hasComma = true;
                    this.lexer.nextToken();
                    continue;
                }
                if (!this.lexer.identifierEquals(FnvHash.Constants.GROUPING)) break;
            }
            if (groupBy.isWithRollUp() || groupBy.isWithCube()) {
                this.accept(Token.RPAREN);
                groupBy.setParen(true);
            }
            if (this.lexer.token == Token.HAVING) {
                this.lexer.nextToken();
                having = this.exprParser.expr();
                groupBy.setHaving(having);
            }
            if (this.lexer.token == Token.WITH) {
                Lexer.SavePoint mark = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.CUBE)) {
                    this.lexer.nextToken();
                    groupBy.setWithCube(true);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
                    this.lexer.nextToken();
                    groupBy.setWithRollUp(true);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.RS) && DbType.db2 == this.dbType) {
                    this.lexer.nextToken();
                    ((DB2SelectQueryBlock)queryBlock).setIsolation(DB2SelectQueryBlock.Isolation.RS);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.RR) && DbType.db2 == this.dbType) {
                    this.lexer.nextToken();
                    ((DB2SelectQueryBlock)queryBlock).setIsolation(DB2SelectQueryBlock.Isolation.RR);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.CS) && DbType.db2 == this.dbType) {
                    this.lexer.nextToken();
                    ((DB2SelectQueryBlock)queryBlock).setIsolation(DB2SelectQueryBlock.Isolation.CS);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.UR) && DbType.db2 == this.dbType) {
                    this.lexer.nextToken();
                    ((DB2SelectQueryBlock)queryBlock).setIsolation(DB2SelectQueryBlock.Isolation.UR);
                } else {
                    this.lexer.reset(mark);
                }
            }
            if (groupBy.getHaving() == null && this.lexer.token == Token.HAVING) {
                this.lexer.nextToken();
                having = this.exprParser.expr();
                groupBy.setHaving(having);
            }
            queryBlock.setGroupBy(groupBy);
        } else if (this.lexer.token == Token.HAVING) {
            this.lexer.nextToken();
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            groupBy.setHaving(this.exprParser.expr());
            if (this.lexer.token == Token.GROUP) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                while (true) {
                    SQLExpr item = this.parseGroupByItem();
                    item.setParent(groupBy);
                    groupBy.addItem(item);
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.token == Token.WITH) {
                this.lexer.nextToken();
                this.acceptIdentifier("ROLLUP");
                groupBy.setWithRollUp(true);
            }
            if (DbType.mysql == this.dbType && this.lexer.token == Token.DESC) {
                this.lexer.nextToken();
            }
            queryBlock.setGroupBy(groupBy);
        }
    }

    protected SQLExpr parseGroupByItem() {
        if (this.lexer.token == Token.LPAREN) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token == Token.RPAREN) {
                this.lexer.nextToken();
                return new SQLListExpr();
            }
            this.lexer.reset(mark);
        }
        int startLine = this.lexer.getPosLine();
        int startCol = this.lexer.getPosColumn();
        SQLExpr item = this.exprParser.expr();
        item.setStartLine(startLine);
        item.setStartColumn(startCol);
        if (DbType.mysql == this.dbType) {
            if (this.lexer.token == Token.DESC) {
                this.lexer.nextToken();
                item = new MySqlOrderingExpr(item, SQLOrderingSpecification.DESC);
            } else if (this.lexer.token == Token.ASC) {
                this.lexer.nextToken();
                item = new MySqlOrderingExpr(item, SQLOrderingSpecification.ASC);
            }
        }
        if (this.lexer.token == Token.HINT) {
            SQLCommentHint hint = this.exprParser.parseHint();
            if (item instanceof SQLObjectImpl) {
                ((SQLExprImpl)item).setHint(hint);
            }
        }
        return item;
    }

    protected void parseSelectList(SQLSelectQueryBlock queryBlock) {
        List<SQLSelectItem> selectList = queryBlock.getSelectList();
        while (true) {
            SQLSelectItem selectItem = this.exprParser.parseSelectItem();
            selectList.add(selectItem);
            selectItem.setParent(queryBlock);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    public void parseFrom(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token != Token.FROM) {
            return;
        }
        this.lexer.nextToken();
        queryBlock.setFrom(this.parseTableSource(true));
    }

    public SQLTableSource parseTableSource() {
        return this.parseTableSource(false);
    }

    public SQLTableSource parseTableSource(boolean isFirst) {
        if (this.lexer.token == Token.LPAREN) {
            SQLTableSource tableSource;
            SQLSelectQuery query;
            this.lexer.nextToken();
            if (this.lexer.token == Token.SELECT || this.lexer.token == Token.WITH || this.lexer.token == Token.SEL) {
                SQLSelect select = this.select();
                this.accept(Token.RPAREN);
                if (select.getQuery() instanceof SQLSelectQueryBlock && !isFirst) {
                    ((SQLSelectQueryBlock)select.getQuery()).setParenthesized(true);
                }
                tableSource = (query = this.queryRest(select.getQuery(), false)) instanceof SQLUnionQuery ? new SQLUnionQueryTableSource((SQLUnionQuery)query) : new SQLSubqueryTableSource(select);
            } else {
                tableSource = this.parseTableSource();
                if (this.lexer.token == Token.UNION || this.lexer.token == Token.MINUS || this.lexer.token == Token.EXCEPT || this.lexer.token == Token.INTERSECT) {
                    if (!(tableSource instanceof SQLSubqueryTableSource) && !(tableSource instanceof SQLUnionQueryTableSource)) {
                        throw new ParserException("only query can be unionised  ", this.lexer.getPosLine(), this.lexer.getPosColumn());
                    }
                    SQLSelectQuery leftQuery = tableSource instanceof SQLSubqueryTableSource ? ((SQLSubqueryTableSource)tableSource).getSelect().getQuery() : ((SQLUnionQueryTableSource)tableSource).getUnion();
                    query = this.queryRest(leftQuery, true);
                    query.setBracket(true);
                    tableSource = query instanceof SQLUnionQuery ? new SQLUnionQueryTableSource((SQLUnionQuery)query) : new SQLSubqueryTableSource(query);
                }
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token == Token.AS) {
                SQLTableSourceImpl values;
                tableSource.hasAs(true);
                this.lexer.nextToken();
                SQLExpr tableAlias = this.tableAlias(true);
                if (tableAlias == null) {
                    throw new ParserException("alias miss. ", this.lexer.getPosLine(), this.lexer.getPosColumn());
                }
                if (tableAlias instanceof SQLIdentifierExpr) {
                    String alias = ((SQLIdentifierExpr)tableAlias).getName();
                    tableSource.setAlias(alias);
                } else if (this.dbType == DbType.adb_pg || this.dbType == DbType.greenplum) {
                    tableSource.setAliasExpr(tableAlias);
                } else {
                    throw new ParserException("illegal alias. " + tableAlias.toString(), this.lexer.getPosLine(), this.lexer.getPosColumn());
                }
                if (tableSource instanceof SQLValuesTableSource && ((SQLValuesTableSource)tableSource).getColumns().size() == 0) {
                    values = (SQLValuesTableSource)tableSource;
                    this.accept(Token.LPAREN);
                    this.exprParser.names(((SQLValuesTableSource)values).getColumns(), values);
                    this.accept(Token.RPAREN);
                } else if (tableSource instanceof SQLSubqueryTableSource) {
                    values = (SQLSubqueryTableSource)tableSource;
                    if (this.lexer.token == Token.LPAREN) {
                        this.lexer.nextToken();
                        this.exprParser.names(((SQLSubqueryTableSource)values).getColumns(), values);
                        this.accept(Token.RPAREN);
                    }
                }
            }
            return this.parseTableSourceRest(tableSource);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            SQLValuesTableSource tableSource = new SQLValuesTableSource();
            while (true) {
                this.accept(Token.LPAREN);
                SQLListExpr listExpr = new SQLListExpr();
                this.exprParser.exprList(listExpr.getItems(), listExpr);
                this.accept(Token.RPAREN);
                listExpr.setParent(tableSource);
                tableSource.getValues().add(listExpr);
                if (this.lexer.token != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.RPAREN) {
                return tableSource;
            }
            String alias = this.tableAlias();
            if (alias != null) {
                tableSource.setAlias(alias);
            }
            this.accept(Token.LPAREN);
            this.exprParser.names(tableSource.getColumns(), tableSource);
            this.accept(Token.RPAREN);
            return tableSource;
        }
        if (this.lexer.token == Token.SELECT) {
            throw new ParserException("TODO " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.UNNEST)) {
            this.lexer.nextToken();
            SQLTableSource sqlTableSource = this.parseUnnsetTableSource();
            return this.parseTableSourceRest(sqlTableSource);
        }
        SQLExprTableSource tableReference = this.createExprTableSource();
        int startLine = this.lexer.getPosLine();
        int startCol = this.lexer.getPosColumn();
        this.parseTableSourceQueryTableExpr(tableReference);
        tableReference.setStartLine(startLine);
        tableReference.setStartColumn(startCol);
        SQLTableSource tableSrc = this.parseTableSourceRest(tableReference);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            tableSrc.addAfterComment(this.lexer.readAndResetComments());
        }
        return tableSrc;
    }

    protected SQLExprTableSource createExprTableSource() {
        return new SQLExprTableSource();
    }

    protected SQLExprTableSource createExprTableSource(SQLExpr sqlExpr) {
        return new SQLExprTableSource(sqlExpr);
    }

    protected void parseTableSourceQueryTableExpr(SQLExprTableSource tableReference) {
        int startLine = this.lexer.getPosLine();
        int startCol = this.lexer.getPosColumn();
        if (this.lexer.token == Token.LITERAL_ALIAS || this.lexer.identifierEquals(FnvHash.Constants.IDENTIFIED) || this.lexer.token == Token.LITERAL_CHARS) {
            SQLName sqlName = this.exprParser.name();
            tableReference.setExpr(sqlName);
            sqlName.setStartLine(startLine);
            sqlName.setStartColumn(startCol);
            return;
        }
        SQLExpr sqlExpr = this.expr();
        tableReference.setExpr(sqlExpr);
        sqlExpr.setStartLine(startLine);
        sqlExpr.setStartColumn(startCol);
    }

    protected SQLTableSource parseUnnsetTableSource() {
        SQLUnnestTableSource unnest = new SQLUnnestTableSource();
        this.exprParser.exprList(unnest.getItems(), unnest);
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("ORDINALITY");
            unnest.setOrdinality(true);
        }
        this.fillAlias(unnest);
        return unnest;
    }

    protected void fillAlias(SQLTableSource sqlTableSource) {
        SQLExpr aliasExpr;
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            sqlTableSource.hasAs(true);
        }
        if ((aliasExpr = this.tableAlias(false)) != null) {
            if (aliasExpr instanceof SQLIdentifierExpr) {
                String alias = ((SQLIdentifierExpr)aliasExpr).getName();
                if (this.isEnabled(SQLParserFeature.IgnoreNameQuotes) && alias.length() > 1) {
                    alias = StringUtils.removeNameQuotes(alias);
                }
                sqlTableSource.setAlias(alias);
            } else {
                sqlTableSource.setAliasExpr(aliasExpr);
            }
        }
    }

    protected SQLTableSource primaryTableSourceRest(SQLTableSource tableSource) {
        return tableSource;
    }

    protected SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        SQLExpr aliasExpr;
        long hash;
        Token token;
        if ((tableSource.getAlias() == null || tableSource.getAlias().length() == 0) && tableSource.getAliasExpr() == null && (token = this.lexer.token) != Token.LEFT && token != Token.RIGHT && token != Token.FULL && token != Token.OUTER && (token != Token.IDENTIFIER || (hash = this.lexer.hash_lower()) != FnvHash.Constants.STRAIGHT_JOIN && hash != FnvHash.Constants.CROSS) && (aliasExpr = this.tableAlias(false)) != null) {
            SQLTableSourceImpl values;
            if (aliasExpr instanceof SQLIdentifierExpr) {
                String alias = ((SQLIdentifierExpr)aliasExpr).getName();
                if (this.isEnabled(SQLParserFeature.IgnoreNameQuotes) && alias.length() > 1) {
                    alias = StringUtils.removeNameQuotes(alias);
                }
                tableSource.setAlias(alias);
            } else {
                tableSource.setAliasExpr(aliasExpr);
            }
            if (tableSource instanceof SQLValuesTableSource && ((SQLValuesTableSource)tableSource).getColumns().size() == 0) {
                values = (SQLValuesTableSource)tableSource;
                if (aliasExpr instanceof SQLMethodInvokeExpr) {
                    ArrayList<SQLName> columns = Lists.newArrayList();
                    for (SQLExpr sqlExpr : ((SQLMethodInvokeExpr)aliasExpr).getArguments()) {
                        if (!(sqlExpr instanceof SQLName)) continue;
                        columns.add((SQLName)sqlExpr);
                    }
                    ((SQLValuesTableSource)values).getColumns().addAll(columns);
                } else {
                    this.accept(Token.LPAREN);
                    this.exprParser.names(((SQLValuesTableSource)values).getColumns(), values);
                    this.accept(Token.RPAREN);
                }
            } else if (tableSource instanceof SQLSubqueryTableSource) {
                values = (SQLSubqueryTableSource)tableSource;
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.names(((SQLSubqueryTableSource)values).getColumns(), values);
                    this.accept(Token.RPAREN);
                }
            }
            if (this.lexer.token == Token.WHERE) {
                return tableSource;
            }
            return this.parseTableSourceRest(tableSource);
        }
        SQLJoinTableSource.JoinType joinType = null;
        boolean natural = this.lexer.identifierEquals(FnvHash.Constants.NATURAL);
        if (natural) {
            this.lexer.nextToken();
        }
        switch (this.lexer.token) {
            case LEFT: {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.SEMI)) {
                    this.lexer.nextToken();
                    joinType = SQLJoinTableSource.JoinType.LEFT_SEMI_JOIN;
                } else if (this.lexer.identifierEquals(FnvHash.Constants.ANTI)) {
                    this.lexer.nextToken();
                    joinType = SQLJoinTableSource.JoinType.LEFT_ANTI_JOIN;
                } else if (this.lexer.token == Token.OUTER) {
                    this.lexer.nextToken();
                    joinType = SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN;
                } else {
                    joinType = SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN;
                }
                this.accept(Token.JOIN);
                break;
            }
            case RIGHT: {
                this.lexer.nextToken();
                if (this.lexer.token == Token.OUTER) {
                    this.lexer.nextToken();
                }
                this.accept(Token.JOIN);
                joinType = SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN;
                break;
            }
            case FULL: {
                this.lexer.nextToken();
                if (this.lexer.token == Token.OUTER) {
                    this.lexer.nextToken();
                }
                this.accept(Token.JOIN);
                joinType = SQLJoinTableSource.JoinType.FULL_OUTER_JOIN;
                break;
            }
            case INNER: {
                this.lexer.nextToken();
                this.accept(Token.JOIN);
                joinType = SQLJoinTableSource.JoinType.INNER_JOIN;
                break;
            }
            case JOIN: {
                this.lexer.nextToken();
                joinType = natural ? SQLJoinTableSource.JoinType.NATURAL_JOIN : SQLJoinTableSource.JoinType.JOIN;
                break;
            }
            case COMMA: {
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.COMMA;
                break;
            }
            case OUTER: {
                this.lexer.nextToken();
                if (!this.lexer.identifierEquals(FnvHash.Constants.APPLY)) break;
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.OUTER_APPLY;
                break;
            }
            case IDENTIFIER: {
                long hash2 = this.lexer.hash_lower;
                if (hash2 == FnvHash.Constants.STRAIGHT_JOIN) {
                    this.lexer.nextToken();
                    joinType = SQLJoinTableSource.JoinType.STRAIGHT_JOIN;
                    break;
                }
                if (hash2 == FnvHash.Constants.STRAIGHT) {
                    this.lexer.nextToken();
                    this.accept(Token.JOIN);
                    joinType = SQLJoinTableSource.JoinType.STRAIGHT_JOIN;
                    break;
                }
                if (hash2 != FnvHash.Constants.CROSS) break;
                this.lexer.nextToken();
                if (this.lexer.token == Token.JOIN) {
                    this.lexer.nextToken();
                    joinType = natural ? SQLJoinTableSource.JoinType.NATURAL_CROSS_JOIN : SQLJoinTableSource.JoinType.CROSS_JOIN;
                    break;
                }
                if (!this.lexer.identifierEquals(FnvHash.Constants.APPLY)) break;
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.CROSS_APPLY;
                break;
            }
        }
        if (joinType != null) {
            SQLJoinTableSource join = new SQLJoinTableSource();
            join.setLeft(tableSource);
            join.setJoinType(joinType);
            boolean isBrace = false;
            if (SQLJoinTableSource.JoinType.COMMA == joinType && this.lexer.token == Token.LBRACE) {
                this.lexer.nextToken();
                this.acceptIdentifier("OJ");
                isBrace = true;
            }
            SQLTableSource rightTableSource = null;
            if (this.dbType == DbType.starrocks && this.lexer.token == Token.LATERAL) {
                join.setLateral(true);
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.LPAREN) {
                SQLSelect select;
                this.lexer.nextToken();
                if (this.lexer.token == Token.SELECT) {
                    select = this.select();
                    rightTableSource = new SQLSubqueryTableSource(select);
                } else {
                    rightTableSource = this.parseTableSource();
                }
                if (this.lexer.token == Token.UNION && rightTableSource instanceof SQLSubqueryTableSource) {
                    select = ((SQLSubqueryTableSource)rightTableSource).getSelect();
                    SQLSelectQuery query = this.queryRest(select.getQuery(), true);
                    select.setQuery(query);
                }
                this.accept(Token.RPAREN);
                if (rightTableSource instanceof SQLValuesTableSource && (this.lexer.token == Token.AS || this.lexer.token == Token.IDENTIFIER) && rightTableSource.getAlias() == null && ((SQLValuesTableSource)rightTableSource).getColumns().size() == 0) {
                    rightTableSource.setAlias(this.mustTableAlias());
                    if (this.lexer.token == Token.LPAREN) {
                        this.lexer.nextToken();
                        this.exprParser.names(((SQLValuesTableSource)rightTableSource).getColumns(), rightTableSource);
                        this.accept(Token.RPAREN);
                    }
                }
            } else if (this.lexer.token() == Token.TABLE) {
                HiveCreateTableParser createTableParser = new HiveCreateTableParser(this.lexer);
                HiveCreateTableStatement stmt = (HiveCreateTableStatement)createTableParser.parseCreateTable(false);
                rightTableSource = new SQLAdhocTableSource(stmt);
                this.primaryTableSourceRest(rightTableSource);
            } else {
                if (this.lexer.identifierEquals(FnvHash.Constants.UNNEST)) {
                    Lexer.SavePoint mark = this.lexer.mark();
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.LPAREN) {
                        SQLTableSource tableSrc;
                        this.lexer.nextToken();
                        SQLUnnestTableSource unnest = new SQLUnnestTableSource();
                        this.exprParser.exprList(unnest.getItems(), unnest);
                        this.accept(Token.RPAREN);
                        if (this.lexer.token() == Token.WITH) {
                            this.lexer.nextToken();
                            this.acceptIdentifier("ORDINALITY");
                            unnest.setOrdinality(true);
                        }
                        String alias = this.tableAlias();
                        unnest.setAlias(alias);
                        if (this.lexer.token() == Token.LPAREN) {
                            this.lexer.nextToken();
                            this.exprParser.names(unnest.getColumns(), unnest);
                            this.accept(Token.RPAREN);
                        }
                        rightTableSource = tableSrc = this.parseTableSourceRest(unnest);
                    } else {
                        this.lexer.reset(mark);
                    }
                }
                if (rightTableSource == null) {
                    boolean aliasToken = this.lexer.token == Token.LITERAL_ALIAS;
                    int startLine = this.lexer.getPosLine();
                    int startCol = this.lexer.getPosColumn();
                    SQLExpr expr = this.expr();
                    expr.setStartColumn(startCol);
                    expr.setStartLine(startLine);
                    if (aliasToken && expr instanceof SQLCharExpr) {
                        expr = new SQLIdentifierExpr(((SQLCharExpr)expr).getText());
                    }
                    SQLExprTableSource exprTableSource = this.createExprTableSource(expr);
                    if (expr instanceof SQLMethodInvokeExpr && this.lexer.token == Token.AS) {
                        this.lexer.nextToken();
                        String alias = this.mustTableAlias();
                        exprTableSource.setAlias(alias);
                        if (this.lexer.token == Token.LPAREN) {
                            this.lexer.nextToken();
                            this.exprParser.names(exprTableSource.getColumns(), exprTableSource);
                            this.accept(Token.RPAREN);
                        }
                    }
                    rightTableSource = this.dbType == DbType.odps ? this.parseTableSourceRest(exprTableSource) : exprTableSource;
                }
                this.primaryTableSourceRest(rightTableSource);
            }
            if (this.lexer.token == Token.USING || this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                Lexer.SavePoint savePoint = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    join.setRight(rightTableSource);
                    this.exprParser.exprList(join.getUsing(), join);
                    this.accept(Token.RPAREN);
                } else {
                    if (this.lexer.token == Token.IDENTIFIER) {
                        this.lexer.reset(savePoint);
                        join.setRight(rightTableSource);
                        return join;
                    }
                    join.setAlias(this.tableAlias());
                }
            } else if (rightTableSource.getAlias() == null && !(rightTableSource instanceof SQLValuesTableSource)) {
                String tableAlias = this.tableAlias();
                if (tableAlias != null) {
                    rightTableSource.setAlias(tableAlias);
                    if (this.lexer.token == Token.LPAREN) {
                        List<SQLName> columns;
                        if (rightTableSource instanceof SQLSubqueryTableSource) {
                            this.lexer.nextToken();
                            List<SQLName> columns2 = ((SQLSubqueryTableSource)rightTableSource).getColumns();
                            this.exprParser.names(columns2, rightTableSource);
                            this.accept(Token.RPAREN);
                        } else if (rightTableSource instanceof SQLExprTableSource && ((SQLExprTableSource)rightTableSource).getExpr() instanceof SQLMethodInvokeExpr && (columns = ((SQLExprTableSource)rightTableSource).getColumns()).size() == 0) {
                            this.lexer.nextToken();
                            this.exprParser.names(columns, rightTableSource);
                            this.accept(Token.RPAREN);
                        }
                    }
                }
                this.primaryTableSourceRest(rightTableSource);
            }
            if (this.lexer.token == Token.WITH) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                while (true) {
                    SQLExpr hintExpr = this.expr();
                    SQLExprHint hint = new SQLExprHint(hintExpr);
                    hint.setParent(tableSource);
                    rightTableSource.getHints().add(hint);
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            join.setRight(rightTableSource);
            if (!natural && !StringUtils.isEmpty(tableSource.getAlias()) && tableSource.aliasHashCode64() == FnvHash.Constants.NATURAL && DbType.mysql == this.dbType) {
                tableSource.setAlias(null);
                natural = true;
            }
            join.setNatural(natural);
            if (this.lexer.token == Token.ON) {
                this.lexer.nextToken();
                SQLExpr joinOn = this.expr();
                join.setCondition(joinOn);
                while (this.lexer.token == Token.ON) {
                    this.lexer.nextToken();
                    SQLExpr joinOn2 = this.expr();
                    join.addCondition(joinOn2);
                }
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                Lexer.SavePoint savePoint = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.exprList(join.getUsing(), join);
                    this.accept(Token.RPAREN);
                } else {
                    SQLExpr expr = this.exprParser.expr();
                    if (expr instanceof SQLMethodInvokeExpr) {
                        OdpsUsingExpr usingExpr = new OdpsUsingExpr();
                        usingExpr.setUsingUdj((SQLMethodInvokeExpr)expr);
                        if (this.lexer.token() == Token.IDENTIFIER) {
                            usingExpr.setAlias(this.lexer.stringVal);
                            this.lexer.nextToken();
                        }
                        this.accept(Token.AS);
                        this.accept(Token.LPAREN);
                        this.exprParser.exprList(usingExpr.getResultColumns(), usingExpr);
                        this.accept(Token.RPAREN);
                        join.getUsing().add(usingExpr);
                    } else {
                        this.lexer.reset(savePoint);
                    }
                }
            }
            SQLTableSource tableSourceReturn = this.parseTableSourceRest(join);
            if (isBrace) {
                this.accept(Token.RBRACE);
            }
            return this.parseTableSourceRest(tableSourceReturn);
        }
        if (tableSource.aliasHashCode64() == FnvHash.Constants.LATERAL && this.lexer.token() == Token.VIEW) {
            return this.parseLateralView(tableSource);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LATERAL)) {
            this.lexer.nextToken();
            return this.parseLateralView(tableSource);
        }
        return tableSource;
    }

    public SQLExpr expr() {
        int startLine = this.lexer.getPosLine();
        int startCol = this.lexer.getPosColumn();
        SQLExpr sqlExpr = this.exprParser.expr();
        sqlExpr.setStartLine(startLine);
        sqlExpr.setStartColumn(startCol);
        return sqlExpr;
    }

    public SQLOrderBy parseOrderBy() {
        return this.exprParser.parseOrderBy();
    }

    public void acceptKeyword(String ident) {
        if (this.lexer.token != Token.IDENTIFIER || !ident.equalsIgnoreCase(this.lexer.stringVal())) {
            this.setErrorEndPos(this.lexer.pos());
            throw new ParserException("syntax error, expect " + ident + ", actual " + (Object)((Object)this.lexer.token) + ", " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
        }
        this.lexer.nextToken();
    }

    public void parseFetchClause(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token == Token.LIMIT) {
            SQLLimit limit = this.exprParser.parseLimit();
            queryBlock.setLimit(limit);
            return;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.OFFSET) || this.lexer.token == Token.OFFSET) {
            this.lexer.nextToken();
            SQLExpr offset = this.exprParser.expr();
            queryBlock.setOffset(offset);
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW) || this.lexer.identifierEquals(FnvHash.Constants.ROWS)) {
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token == Token.FETCH) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.FIRST || this.lexer.token == Token.NEXT || this.lexer.identifierEquals(FnvHash.Constants.NEXT)) {
                this.lexer.nextToken();
            } else {
                this.acceptIdentifier("FIRST");
            }
            SQLExpr first = this.exprParser.primary();
            queryBlock.setFirst(first);
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW) || this.lexer.identifierEquals(FnvHash.Constants.ROWS)) {
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.ONLY) {
                this.lexer.nextToken();
            } else {
                this.acceptIdentifier("ONLY");
            }
        }
    }

    protected void parseHierachical(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token == Token.CONNECT || this.lexer.identifierEquals(FnvHash.Constants.CONNECT)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.token == Token.PRIOR || this.lexer.identifierEquals(FnvHash.Constants.PRIOR)) {
                this.lexer.nextToken();
                queryBlock.setPrior(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.NOCYCLE)) {
                queryBlock.setNoCycle(true);
                this.lexer.nextToken();
                if (this.lexer.token == Token.PRIOR) {
                    this.lexer.nextToken();
                    queryBlock.setPrior(true);
                }
            }
            queryBlock.setConnectBy(this.exprParser.expr());
        }
        if (this.lexer.token == Token.START || this.lexer.identifierEquals(FnvHash.Constants.START)) {
            this.lexer.nextToken();
            this.accept(Token.WITH);
            queryBlock.setStartWith(this.exprParser.expr());
        }
        if (this.lexer.token == Token.CONNECT || this.lexer.identifierEquals(FnvHash.Constants.CONNECT)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.token == Token.PRIOR || this.lexer.identifierEquals(FnvHash.Constants.PRIOR)) {
                this.lexer.nextToken();
                queryBlock.setPrior(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.NOCYCLE)) {
                queryBlock.setNoCycle(true);
                this.lexer.nextToken();
                if (this.lexer.token == Token.PRIOR || this.lexer.identifierEquals(FnvHash.Constants.PRIOR)) {
                    this.lexer.nextToken();
                    queryBlock.setPrior(true);
                }
            }
            queryBlock.setConnectBy(this.exprParser.expr());
        }
    }

    protected SQLTableSource parseLateralView(SQLTableSource tableSource) {
        this.accept(Token.VIEW);
        if ("LATERAL".equalsIgnoreCase(tableSource.getAlias())) {
            tableSource.setAlias(null);
        }
        SQLLateralViewTableSource lateralViewTabSrc = new SQLLateralViewTableSource();
        lateralViewTabSrc.setTableSource(tableSource);
        if (this.lexer.token == Token.OUTER) {
            lateralViewTabSrc.setOuter(true);
            this.lexer.nextToken();
        }
        SQLMethodInvokeExpr udtf = (SQLMethodInvokeExpr)this.exprParser.expr();
        lateralViewTabSrc.setMethod(udtf);
        String alias = this.as();
        lateralViewTabSrc.setAlias(alias);
        if (this.lexer.token == Token.AS) {
            this.lexer.nextToken();
            this.exprParser.names(lateralViewTabSrc.getColumns());
        }
        return this.parseTableSourceRest(lateralViewTabSrc);
    }

    public SQLValuesTableSource parseValues() {
        this.accept(Token.VALUES);
        SQLValuesTableSource tableSource = new SQLValuesTableSource();
        while (true) {
            boolean isSingleValue = true;
            if (this.lexer.token == Token.ROW) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.LPAREN) {
                this.accept(Token.LPAREN);
                isSingleValue = false;
            }
            SQLListExpr listExpr = new SQLListExpr();
            if (isSingleValue) {
                SQLExpr expr = this.expr();
                expr.setParent(listExpr);
                listExpr.getItems().add(expr);
            } else {
                this.exprParser.exprList(listExpr.getItems(), listExpr);
                this.accept(Token.RPAREN);
            }
            listExpr.setParent(tableSource);
            tableSource.getValues().add(listExpr);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        String alias = this.tableAlias();
        if (alias != null) {
            tableSource.setAlias(alias);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.names(tableSource.getColumns(), tableSource);
            this.accept(Token.RPAREN);
        }
        return tableSource;
    }
}

