/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.parser;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.util.FnvHash;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InsertColumnsCache {
    public static InsertColumnsCache global = new InsertColumnsCache(8192);
    public ConcurrentMap<Long, Entry> cache = new ConcurrentHashMap<Long, Entry>();
    private final Entry[] buckets;
    private final int indexMask;

    public InsertColumnsCache(int tableSize) {
        this.indexMask = tableSize - 1;
        this.buckets = new Entry[tableSize];
    }

    public final Entry get(long hashCode64) {
        int bucket = (int)hashCode64 & this.indexMask;
        Entry entry = this.buckets[bucket];
        while (entry != null) {
            if (hashCode64 == entry.hashCode64) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean put(long hashCode64, String columnsString, String columnsFormattedString, List<SQLExpr> columns) {
        int bucket = (int)hashCode64 & this.indexMask;
        Entry entry = this.buckets[bucket];
        while (entry != null) {
            if (hashCode64 == entry.hashCode64) {
                return true;
            }
            entry = entry.next;
        }
        this.buckets[bucket] = entry = new Entry(hashCode64, columnsString, columnsFormattedString, columns, this.buckets[bucket]);
        return false;
    }

    public static final class Entry {
        public final long hashCode64;
        public final String columnsString;
        public final String columnsFormattedString;
        public final long columnsFormattedStringHash;
        public final List<SQLExpr> columns;
        public final Entry next;

        public Entry(long hashCode64, String columnsString, String columnsFormattedString, List<SQLExpr> columns, Entry next) {
            this.hashCode64 = hashCode64;
            this.columnsString = columnsString;
            this.columnsFormattedString = columnsFormattedString;
            this.columnsFormattedStringHash = FnvHash.fnv1a_64_lower(columnsFormattedString);
            this.columns = columns;
            this.next = next;
        }
    }
}

