/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.starrocks.visitor;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLIndexDefinition;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableSetOption;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDescribeStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDropMaterializedViewStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.RefreshSchemaDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksAlterAddRollup;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksAlterDropRollup;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksAlterTableAddPartition;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksBitmapDataType;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksBulkRangeDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksColumnIndexDefinition;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksDataSourceProperties;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksExternalTableDataDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksFilePathDataDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksFixedRangeDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksLessThanRangeDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksLoadProperties;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksMaxValue;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksObjectImpl;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksRollup;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksAlterLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksAlterMaterializedViewStmt;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksAlterRoutineLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksAnalyzeTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCancelAlterTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCancelExportStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCancelLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCancelRefreshViewStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCreateAnalyzeStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCreateMaterializeViewStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCreateRoutineLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksDropAnalyzeStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksDropStatsStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksExportTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksInsertStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksKillAnalyzeStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksLoadBrokerStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksPauseLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksRecoverPartitionStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksRecoverTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksRefreshMaterializedViewStmt;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksRefreshTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksResumeLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowAlterMaterializedViewStmt;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowAlterTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowAnalyzeStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowCreateMaterializedViewStmt;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowDataStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowDeleteStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowDynamicPartitionTablesStmt;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowExportStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowIndexStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowMaterializedViewStmt;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowPartitionsStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowRoutineStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowTabletStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowTransactionStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksSparkLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksStopRoutineLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksSubmitTaskStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.visitor.StarRocksASTVisitor;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.sql.visitor.ExportParameterVisitorUtils;
import com.alibaba.fastsql.sql.visitor.VisitorFeature;
import java.util.List;
import java.util.Locale;

public class StarRocksOutputVisitor
extends MySqlOutputVisitor
implements StarRocksASTVisitor {
    public StarRocksOutputVisitor(Appendable appender) {
        super(appender);
        this.dbType = DbType.starrocks;
        this.shardingSupport = true;
        this.quote = (char)96;
    }

    public StarRocksOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.starrocks;
        this.shardingSupport = true;
        this.quote = (char)96;
    }

    @Override
    protected void printCreateTable(SQLCreateTableStatement x, boolean printSelect) {
        SQLExpr storedAs;
        SQLCreateTableStatement.Type tableType;
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isExternal()) {
            this.print0(this.ucase ? "EXTERNAL " : "external ");
        }
        if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)(tableType = x.getType()))) {
            this.print0(this.ucase ? "GLOBAL TEMPORARY " : "global temporary ");
        } else if (SQLCreateTableStatement.Type.LOCAL_TEMPORARY.equals((Object)tableType)) {
            this.print0(this.ucase ? "LOCAL TEMPORARY " : "local temporary ");
        } else if (SQLCreateTableStatement.Type.SHADOW.equals((Object)tableType)) {
            this.print0(this.ucase ? "SHADOW " : "shadow ");
        }
        if (x.isDimension()) {
            this.print0(this.ucase ? "DIMENSION " : "dimension ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        this.printTableSourceExpr(x.getName());
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
            return;
        }
        this.printTableElements(x.getTableElementList());
        SQLExprTableSource inherits = x.getInherits();
        if (inherits != null) {
            this.print0(this.ucase ? " INHERITS (" : " inherits (");
            inherits.accept(this);
            this.print(')');
        }
        if ((storedAs = x.getStoredAs()) != null) {
            this.print0(this.ucase ? " STORE AS " : " store as ");
            this.printExpr(storedAs, this.parameterized);
        }
        SQLSelect select = x.getSelect();
        if (printSelect && select != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            this.visit(select);
        }
    }

    @Override
    public boolean visit(StarRocksCreateTableStatement x) {
        SQLExpr partitionBy;
        SQLName model;
        super.visit((SQLCreateTableStatement)x);
        SQLExpr engine = x.getEngine();
        if (engine != null) {
            this.print0(this.ucase ? " ENGINE = " : " engine = ");
            engine.accept(this);
        }
        if ((model = x.getModelKey()) != null) {
            String modelName;
            this.println();
            switch (modelName = model.getSimpleName().toLowerCase()) {
                case "duplicate": {
                    this.print0(this.ucase ? "DUPLICATE" : "duplicate");
                    break;
                }
                case "aggregate": {
                    this.print0(this.ucase ? "AGGREGATE" : "aggregate");
                    break;
                }
                case "unique": {
                    this.print0(this.ucase ? "UNIQUE" : "unique");
                    break;
                }
                case "primary": {
                    this.print0(this.ucase ? "PRIMARY" : "primary");
                    break;
                }
            }
            this.print(' ');
            this.print0(this.ucase ? "KEY (" : "key (");
            if (x.getModelKeyParameters().size() > 0) {
                for (int i = 0; i < x.getModelKeyParameters().size(); ++i) {
                    if (i != 0) {
                        this.print(", ");
                    }
                    x.getModelKeyParameters().get(i).accept(this);
                }
            }
            this.print(")");
        }
        if (x.getComment() != null) {
            this.println();
            this.print(this.ucase ? "COMMENT " : "comment ");
            x.getComment().accept(this);
        }
        if ((partitionBy = x.getPartitionBy()) != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            partitionBy.accept(this);
            if (!x.getLessThanRangeDescList().isEmpty()) {
                this.print0(" (");
                ++this.indentCount;
                this.println();
                this.printlnAndAccept(x.getLessThanRangeDescList(), ", ");
                --this.indentCount;
                this.println();
                this.print0(")");
            } else if (!x.getFixedRangeDescList().isEmpty()) {
                this.print0(" (");
                ++this.indentCount;
                this.println();
                this.printlnAndAccept(x.getFixedRangeDescList(), ", ");
                --this.indentCount;
                this.println();
                this.print0(")");
            } else if (x.getBulkRangeDesc() != null) {
                this.print0(" (");
                ++this.indentCount;
                this.println();
                x.getBulkRangeDesc().accept(this);
                --this.indentCount;
                this.println();
                this.print0(")");
            } else if (partitionBy instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)partitionBy).getMethodName().equalsIgnoreCase(Token.RANGE.name)) {
                this.print0(" ()");
            }
        }
        if (x.getDistributedBy() != null) {
            this.println();
            this.print0(this.ucase ? "DISTRIBUTED BY " : "distributed by ");
            x.getDistributedBy().accept(this);
            int buckets = x.getBuckets();
            if (buckets > 0) {
                this.print0(this.ucase ? " BUCKETS " : "buckets ");
                this.print0(String.valueOf(buckets));
            }
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (!x.getTblProperties().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "PROPERTIES " : "properties ");
            this.printAssignItemsNewLine(x.getTblProperties());
        }
        if (!x.getBrokerProperties().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "BROKER PROPERTIES " : "broker properties ");
            this.printAssignItemsNewLine(x.getBrokerProperties());
        }
        return false;
    }

    @Override
    protected void printAggType(SQLColumnDefinition x) {
        if (x.getAggType() != null) {
            this.print(' ');
            this.print0(this.ucase ? x.getAggType().getText().toUpperCase(Locale.ROOT) : x.getAggType().getText().toLowerCase(Locale.ROOT));
        }
    }

    @Override
    public boolean visit(StarRocksColumnIndexDefinition x) {
        this.print0(this.ucase ? "INDEX " : "index ");
        x.getName().accept(this);
        this.print(" (");
        if (x.getColumnList() != null) {
            this.printAndAccept(x.getColumnList(), ", ");
        }
        this.print(")");
        if (x.isUsingBitmap()) {
            this.print0(this.ucase ? " USING BITMAP" : " using bitmap");
        }
        if (x.getComment() != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            x.getComment().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRename x) {
        this.print0(this.ucase ? "RENAME " : "rename ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableSetOption x) {
        this.print0(this.ucase ? "SET (" : "set (");
        this.printAndAccept(x.getOptions(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLCreateIndexStatement x) {
        super.visit(x);
        SQLIndexDefinition index = x.getIndexDefinition();
        if (index.getUsingType() != null) {
            this.print(this.ucase ? " USING " : " using ");
            this.print(this.ucase ? index.getUsingType().name : index.getUsingType().name.toLowerCase());
        }
        if (index.getComment() != null) {
            this.print(this.ucase ? " COMMENT " : " comment ");
            index.getComment().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLIndexDefinition x) {
        super.visit(x);
        if (x.getUsingType() != null) {
            this.print(this.ucase ? " USING " : " using ");
            this.print(this.ucase ? x.getUsingType().name : x.getUsingType().name.toLowerCase());
        }
        if (x.getComment() != null) {
            this.print(this.ucase ? " COMMENT " : " comment ");
            x.getComment().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropMaterializedViewStatement x) {
        this.print0(this.ucase ? "DROP MATERIALIZED VIEW " : "drop materialized view ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksCancelRefreshViewStatement x) {
        this.print0(this.ucase ? "CANCEL REFRESH MATERIALIZED VIEW " : "cancel refresh materialized view ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksShowCreateMaterializedViewStmt x) {
        this.print0(this.ucase ? "SHOW CREATE MATERIALIZED VIEW " : "show create materialized view ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksShowAlterMaterializedViewStmt x) {
        this.print0(this.ucase ? "SHOW ALTER MATERIALIZED VIEW" : "show alter materialized view");
        if (x.getDbName() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDbName().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksShowDataStatement x) {
        this.print0(this.ucase ? "SHOW DATA" : "show data");
        if (x.getTableSource() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getTableSource().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksShowDeleteStatement x) {
        this.print0(this.ucase ? "SHOW DELETE" : "show delete");
        if (x.getDbName() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDbName().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksShowMaterializedViewStmt x) {
        this.print0(this.ucase ? "SHOW MATERIALIZED VIEWS" : "show materialized views");
        if (x.getDbName() != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getDbName().accept(this);
        }
        if (x.getCondition() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getCondition().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksShowTransactionStatement x) {
        this.print0(this.ucase ? "SHOW TRANSACTION" : "show transaction");
        if (x.getDbName() != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getDbName().accept(this);
        }
        if (x.getCondition() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getCondition().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksBulkRangeDesc x) {
        this.print0(this.ucase ? "START " : "start ");
        this.print0("(");
        x.getPartitionStart().accept(this);
        this.print0(")");
        if (x.getPartitionEnd() != null) {
            this.print0(" END (");
            x.getPartitionEnd().accept(this);
            this.print0(")");
        }
        if (x.getEveryInterval() != null) {
            this.print0(" EVERY (");
            x.getEveryInterval().accept(this);
            this.print0(")");
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksLessThanRangeDesc x) {
        this.print0(this.ucase ? "PARTITION " : "partition ");
        x.getPartitionName().accept(this);
        this.print0(this.ucase ? " VALUES LESS THAN " : " values less than ");
        if (x.getUpperList().size() == 1 && x.getUpperList().get(0) instanceof StarRocksMaxValue) {
            x.getUpperList().get(0).accept(this);
        } else {
            this.print0("(");
            this.printAndAccept(x.getUpperList(), ", ");
            this.print0(")");
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksFixedRangeDesc x) {
        this.print0(this.ucase ? "PARTITION " : "partition ");
        x.getPartitionName().accept(this);
        this.print0(this.ucase ? " VALUES " : " values ");
        this.print0("[(");
        this.printAndAccept(x.getLowerList(), ", ");
        this.print0("), ");
        this.print0("(");
        this.printAndAccept(x.getUpperList(), ", ");
        this.print0("))");
        return false;
    }

    @Override
    public boolean visit(StarRocksRefreshMaterializedViewStmt x) {
        this.print0(this.ucase ? "REFRESH MATERIALIZED VIEW " : "refresh materialized view ");
        x.getTableSource().accept(this);
        if (x.getRangeDesc() != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION " : "partition ");
            x.getRangeDesc().accept(this);
            if (x.isForce()) {
                this.print0(this.ucase ? " FORCE" : " force");
            }
        }
        if (x.getMode() != null) {
            this.print(this.ucase ? " WITH " : " with ");
            this.print(this.ucase ? x.getMode().name() : x.getMode().name().toLowerCase());
            this.print(this.ucase ? " MODE" : " mode");
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksInsertStatement x) {
        List<SQLInsertStatement.ValuesClause> valuesList;
        String columnsString;
        int partitionsSize;
        List<SQLExpr> temporaryPartitions;
        int partitionsSize2;
        List<SQLAssignItem> partitions;
        SQLWithSubqueryClause with;
        List<SQLCommentHint> headHints = x.getHeadHintsDirect();
        if (headHints != null) {
            for (SQLCommentHint hint : headHints) {
                hint.accept(this);
                this.println();
            }
        }
        if ((with = x.getWith()) != null) {
            this.visit(with);
            this.println();
        }
        this.print0(this.ucase ? "INSERT " : "insert ");
        int size = x.getHintsSize();
        for (int i = 0; i < size; ++i) {
            SQLCommentHint hint = x.getHints().get(i);
            hint.accept(this);
            this.print(' ');
        }
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "OVERWRITE " : "overwrite ");
        } else {
            this.print0(this.ucase ? "INTO " : "into ");
        }
        SQLExprTableSource tableSource = x.getTableSource();
        if (tableSource != null) {
            if (tableSource.getClass() == SQLExprTableSource.class) {
                this.visit(tableSource);
            } else {
                tableSource.accept(this);
            }
        }
        if ((partitions = x.getPartitions()) != null && (partitionsSize2 = partitions.size()) > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            for (int i = 0; i < partitionsSize2; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLAssignItem assign = partitions.get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print(assign.printToken());
                assign.getValue().accept(this);
            }
            this.print(')');
        }
        if ((temporaryPartitions = x.getTemporaryPartitions()) != null && (partitionsSize = temporaryPartitions.size()) > 0) {
            this.println();
            this.print0(this.ucase ? " TEMPORARY_PARTITION (" : " temporary_partition (");
            this.printAndAccept(temporaryPartitions, ", ");
            this.print(')');
        }
        if (x.getLabel() != null) {
            this.print(this.ucase ? " WITH LABEL " : " with label ");
            x.getLabel().accept(this);
        }
        if ((columnsString = x.getColumnsString()) != null) {
            if (!this.isEnabled(VisitorFeature.OutputSkipInsertColumnsString)) {
                this.print0(columnsString);
            }
        } else {
            List<SQLExpr> columns = x.getColumns();
            if (columns.size() > 0) {
                ++this.indentCount;
                this.print0(" (");
                int size2 = columns.size();
                for (int i = 0; i < size2; ++i) {
                    SQLExpr column;
                    if (i != 0) {
                        if (i % 5 == 0) {
                            this.println();
                        }
                        this.print0(", ");
                    }
                    if ((column = columns.get(i)) instanceof SQLIdentifierExpr) {
                        this.printName0(((SQLIdentifierExpr)column).getName());
                        continue;
                    }
                    this.printExpr(column, this.parameterized);
                }
                this.print(')');
                --this.indentCount;
            }
        }
        if (!(valuesList = x.getValuesList()).isEmpty()) {
            this.println();
            this.printValuesList(valuesList);
        }
        if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        SQLExpr where;
        SQLWithSubqueryClause with;
        List<SQLCommentHint> headHints = x.getHeadHintsDirect();
        if (headHints != null) {
            for (SQLCommentHint hint : headHints) {
                hint.accept(this);
                this.println();
            }
        }
        if ((with = x.getWith()) != null) {
            this.visit(with);
            this.println();
        }
        this.print0(this.ucase ? "UPDATE " : "update ");
        this.printTableSource(x.getTableSource());
        this.println();
        this.print0(this.ucase ? "SET " : "set ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            SQLUpdateSetItem item = x.getItems().get(i);
            this.visit(item);
        }
        SQLTableSource from = x.getFrom();
        if (from != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            this.printTableSource(from);
        }
        if ((where = x.getWhere()) != null) {
            this.println();
            ++this.indentCount;
            this.print0(this.ucase ? "WHERE " : "where ");
            this.printExpr(where, this.parameterized);
            --this.indentCount;
        }
        return false;
    }

    @Override
    public boolean visit(SQLDescribeStatement x) {
        this.print0(this.ucase ? "DESC " : "desc ");
        if (x.getObjectType() != null) {
            this.print0(x.getObjectType().name());
            this.print(' ');
        }
        if (x.getObject() != null) {
            x.getObject().accept(this);
        }
        if (x.isAll()) {
            this.print0(this.ucase ? " ALL" : " all");
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksCreateMaterializeViewStatement x) {
        this.print0(this.ucase ? "CREATE MATERIALIZED VIEW " : "create materialized view ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        x.getName().accept(this);
        if (x.getDistributedBy() != null) {
            this.println();
            this.print0(this.ucase ? "DISTRIBUTED BY " : "distributed by ");
            x.getDistributedBy().accept(this);
            int buckets = x.getBuckets();
            if (buckets > 0) {
                this.print0(this.ucase ? " BUCKETS " : "buckets ");
                this.print0(String.valueOf(buckets));
            }
        }
        if (x.getRefreshSchemaDesc() != null) {
            this.println();
            x.getRefreshSchemaDesc().accept(this);
        }
        if (x.getPartitionByExpr() != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            x.getPartitionByExpr().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getComment() != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getComment().accept(this);
        }
        if (x.getProperties() != null && !x.getProperties().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "PROPERTIES (" : "properties (");
            this.printAndAccept(x.getProperties(), ", ");
            this.print(')');
        }
        this.println();
        this.println(this.ucase ? "AS" : "as");
        x.getQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksAlterMaterializedViewStmt x) {
        this.print0(this.ucase ? "ALTER MATERIALIZED VIEW " : "alter materialized view ");
        x.getTableSource().accept(this);
        if (x.getRefreshSchemaDesc() != null) {
            this.print0(" ");
            x.getRefreshSchemaDesc().accept(this);
        } else if (x.getNewName() != null) {
            this.print0(this.ucase ? " RENAME " : " rename ");
            x.getNewName().accept(this);
        } else if (Boolean.TRUE.equals(x.getActive())) {
            this.print0(this.ucase ? " ACTIVE" : " active");
        } else if (Boolean.FALSE.equals(x.getActive())) {
            this.print0(this.ucase ? " INACTIVE" : " inactive");
        } else if (x.getItems() != null && !x.getItems().isEmpty()) {
            this.print0(this.ucase ? " SET " : " set ");
            this.printAssignItems(x.getItems());
        }
        return false;
    }

    @Override
    public boolean visit(RefreshSchemaDesc x) {
        this.print0(this.ucase ? "REFRESH" : "refresh");
        if (x.getRefreshMoment() != null) {
            this.print0(" ");
            this.print0(this.ucase ? x.getRefreshMoment().name() : x.getRefreshMoment().name().toLowerCase());
        }
        if (x.getRefreshType() != null) {
            this.print0(" ");
            this.print0(this.ucase ? x.getRefreshType().name() : x.getRefreshType().name().toLowerCase());
        }
        if (x.getStarTime() != null) {
            this.print0(this.ucase ? " START " : " start ");
            this.print0("(");
            x.getStarTime().accept(this);
            this.print0(")");
        }
        if (x.getIntervalExpr() != null) {
            this.print0(this.ucase ? " EVERY " : " every ");
            this.print0("(");
            x.getIntervalExpr().accept(this);
            this.print0(")");
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksShowLoadStatement x) {
        this.print0(this.ucase ? "SHOW LOAD" : "show load");
        if (x.getDbName() != null) {
            this.print(this.ucase ? " FROM " : " from ");
            x.getDbName().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksPauseLoadStatement x) {
        this.print0(this.ucase ? "PAUSE ROUTINE LOAD FOR " : "pause routine load for ");
        x.getJobName().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksCancelAlterTableStatement x) {
        this.print0(this.ucase ? "CANCEL ALTER TABLE " : "cancel alter table ");
        this.print0(this.ucase ? x.getAlterTableType().name() : x.getAlterTableType().name().toLowerCase());
        this.print0(this.ucase ? " FROM " : " from ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksShowAlterTableStatement x) {
        this.print0(this.ucase ? "SHOW ALTER TABLE " : "show alter table ");
        this.print0(this.ucase ? x.getAlterTableType().name() : x.getAlterTableType().name().toLowerCase());
        if (x.getDbName() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDbName().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksResumeLoadStatement x) {
        this.print0(this.ucase ? "RESUME ROUTINE LOAD FOR " : "resume routine load for ");
        x.getJobName().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksRecoverTableStatement x) {
        this.print0(this.ucase ? "RECOVER TABLE " : "recover table ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksRecoverPartitionStatement x) {
        this.print0(this.ucase ? "RECOVER PARTITION " : "recover partition ");
        x.getPartitionName().accept(this);
        this.print0(this.ucase ? " FROM " : " from ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksRefreshTableStatement x) {
        this.print0(this.ucase ? "REFRESH EXTERNAL TABLE " : "refresh external table ");
        x.getTableName().accept(this);
        if (x.getPartitionList() != null && !x.getPartitionList().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartitionList(), ", ");
            this.print0(")");
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksAnalyzeTableStatement x) {
        this.print0(this.ucase ? "ANALYZE " : "analyze ");
        if (x.getAnalyzeTableType() != null) {
            this.print0(this.ucase ? x.getAnalyzeTableType().name() : x.getAnalyzeTableType().name().toLowerCase());
            this.print0(" ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        x.getTableSource().accept(this);
        if (x.isUpdateHistogram()) {
            this.print0(this.ucase ? " UPDATE HISTOGRAM ON " : " update histogram on ");
            this.printAndAccept(x.getColumns(), ", ");
        } else {
            List<SQLExpr> columns = x.getColumns();
            if (columns != null && columns.size() > 0) {
                this.print0(" (");
                this.printAndAccept(x.getColumns(), ", ");
                this.print(')');
            }
        }
        if (x.getAnalyzeModeType() != null) {
            this.println();
            this.print0(this.ucase ? "WITH " : "with ");
            this.print0(this.ucase ? x.getAnalyzeModeType().name() : x.getAnalyzeModeType().name().toLowerCase());
            this.print0(this.ucase ? " MODE" : " mode");
        }
        if (x.getBuckets() != null) {
            this.println();
            this.print0(this.ucase ? "WITH " : "with ");
            x.getBuckets().accept(this);
            this.print0(this.ucase ? " BUCKETS" : " buckets");
        }
        if (x.getProperties() != null && !x.getProperties().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "PROPERTIES " : "properties ");
            this.printAssignItemsNewLine(x.getProperties());
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksAlterRoutineLoadStatement x) {
        this.print0(this.ucase ? "ALTER ROUTINE LOAD FOR " : "alter routine load for ");
        x.getJobName().accept(this);
        if (x.getLoadProperties() != null && x.getLoadProperties().isNotEmpty()) {
            this.println();
            x.getLoadProperties().accept(this);
        }
        if (x.getJobProperties() != null && !x.getJobProperties().isEmpty()) {
            this.println();
            this.println(this.ucase ? "PROPERTIES" : "properties");
            this.printAssignItemsNewLine(x.getJobProperties());
        }
        if (x.getDataSourceProperties() != null) {
            this.println();
            x.getDataSourceProperties().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksCreateRoutineLoadStatement x) {
        this.print0(this.ucase ? "CREATE ROUTINE LOAD " : "create routine load ");
        x.getJobName().accept(this);
        this.print0(this.ucase ? " ON " : " on ");
        x.getTableName().accept(this);
        if (x.getLoadProperties() != null && x.getLoadProperties().isNotEmpty()) {
            this.println();
            x.getLoadProperties().accept(this);
        }
        if (x.getJobProperties() != null && !x.getJobProperties().isEmpty()) {
            this.println();
            this.println(this.ucase ? "PROPERTIES" : "properties");
            this.printAssignItemsNewLine(x.getJobProperties());
        }
        if (x.getDataSourceProperties() != null) {
            this.println();
            x.getDataSourceProperties().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksExportTableStatement x) {
        this.print0(this.ucase ? "EXPORT TABLE " : "export table ");
        x.getTable().accept(this);
        if (x.getPartitionList() != null && !x.getPartitionList().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartitionList(), ", ");
            this.print0(")");
        }
        if (x.getColumnList() != null && !x.getColumnList().isEmpty()) {
            this.println();
            this.print0("(");
            this.printAndAccept(x.getPartitionList(), ", ");
            this.print0(")");
        }
        this.print0(this.ucase ? " TO " : " to ");
        if (x.getExportPath() != null) {
            x.getExportPath().accept(this);
        }
        if (x.getOptProperties() != null && !x.getOptProperties().isEmpty()) {
            this.println();
            this.println(this.ucase ? "PROPERTIES" : "properties");
            this.printAssignItemsNewLine(x.getOptProperties());
        }
        if (x.getBrokerProperties() != null && !x.getBrokerProperties().isEmpty()) {
            this.println();
            this.print(this.ucase ? "WITH BROKER" : "with broker");
            if (x.getBroker() != null) {
                this.print(" ");
                x.getBroker().accept(this);
            }
            this.println();
            this.printAssignItemsNewLine(x.getBrokerProperties());
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksCancelExportStatement x) {
        this.print0(this.ucase ? "CANCEL EXPORT" : "cancel export");
        if (x.getDbName() != null) {
            this.print(this.ucase ? " FROM " : " from ");
            x.getDbName().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksAlterLoadStatement x) {
        this.print0(this.ucase ? "ALTER LOAD FOR " : "alter load for ");
        x.getJobName().accept(this);
        if (x.getJobProperties() != null && !x.getJobProperties().isEmpty()) {
            this.println();
            this.println(this.ucase ? "PROPERTIES" : "properties");
            this.printAssignItemsNewLine(x.getJobProperties());
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksLoadProperties x) {
        boolean isFirstConfig = true;
        if (x.getColumnSeparator() != null) {
            this.print0(this.ucase ? "COLUMNS TERMINATED BY " : "columns terminated by ");
            x.getColumnSeparator().accept(this);
            isFirstConfig = false;
        }
        if (x.getRowSeparator() != null) {
            if (!isFirstConfig) {
                this.println(",");
            }
            this.print0(this.ucase ? "ROWS TERMINATED BY " : "rows terminated by ");
            x.getRowSeparator().accept(this);
            isFirstConfig = false;
        }
        if (x.getColumns() != null && !x.getColumns().isEmpty()) {
            if (!isFirstConfig) {
                this.println(",");
            }
            this.print0(this.ucase ? "COLUMNS " : "columns ");
            this.printList(x.getColumns(), ", ");
            isFirstConfig = false;
        }
        if (x.getWhere() != null) {
            if (!isFirstConfig) {
                this.println(",");
            }
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept(this);
            isFirstConfig = false;
        }
        if (x.getPartitions() != null && !x.getPartitions().isEmpty()) {
            if (!isFirstConfig) {
                this.println(",");
            }
            this.print0(this.ucase ? "PARTITION " : "partition ");
            this.printList(x.getPartitions(), ", ");
            isFirstConfig = false;
        }
        if (x.getTemporaryPartitions() != null && !x.getTemporaryPartitions().isEmpty()) {
            if (!isFirstConfig) {
                this.println(",");
            }
            this.print0(this.ucase ? "TEMPORARY PARTITION " : "temporary partition ");
            this.printList(x.getTemporaryPartitions(), ", ");
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksDataSourceProperties x) {
        if (x.getDataSource() != null) {
            this.print0(this.ucase ? "FROM " : "from ");
            x.getDataSource().accept(this);
        }
        if (x.getDataSourceProperties() != null && !x.getDataSourceProperties().isEmpty()) {
            this.println();
            this.printAssignItemsNewLine(x.getDataSourceProperties());
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksShowDynamicPartitionTablesStmt x) {
        this.print0(this.ucase ? "SHOW DYNAMIC PARTITION TABLES" : "show dynamic partition tables");
        if (x.getDbName() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDbName().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksShowExportStatement x) {
        this.print0(this.ucase ? "SHOW EXPORT" : "show export");
        if (x.getDbName() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDbName().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksShowPartitionsStatement x) {
        this.print0(this.ucase ? "SHOW " : "show ");
        if (x.isShowTemporaryPartitions()) {
            this.print0(this.ucase ? "TEMPORARY " : "temporary ");
        }
        this.print0(this.ucase ? "PARTITIONS " : "partitions ");
        this.print0(this.ucase ? "FROM " : "from ");
        x.getTableSource().accept(this);
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksShowIndexStatement x) {
        this.print0(this.ucase ? "SHOW " : "show ");
        if (x.isUseKey()) {
            if (x.isShowMulti()) {
                this.print0(this.ucase ? "KEYS " : "keys ");
            } else {
                this.print0(this.ucase ? "KEY " : "key ");
            }
        } else if (x.isShowMulti()) {
            this.print0(this.ucase ? "INDEXES " : "indexes ");
        } else {
            this.print0(this.ucase ? "INDEX " : "index ");
        }
        this.print0(this.ucase ? "FROM " : "from ");
        x.getTableSource().accept(this);
        if (x.getDbName() != null) {
            this.print0(" ");
            this.print0(this.ucase ? "FROM " : "from ");
            x.getDbName().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksFilePathDataDesc x) {
        this.print0(this.ucase ? "DATA INFILE" : "data infile");
        this.printList(x.getSourceFilePath(), ", ");
        if (x.isNegative()) {
            this.println();
            this.print(this.ucase ? "NEGATIVE" : "negative");
        }
        this.println();
        this.print0(this.ucase ? "INTO TABLE " : "into table ");
        x.getTargetTableName().accept(this);
        if (x.getPartitions() != null && !x.getPartitions().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "PARTITION " : "partition ");
            this.printList(x.getPartitions(), ", ");
        }
        if (x.getColumnSeparator() != null) {
            this.println();
            this.print0(this.ucase ? "COLUMNS TERMINATED BY " : "columns terminated by ");
            x.getColumnSeparator().accept(this);
        }
        if (x.getFileFormat() != null) {
            this.println();
            this.print0(this.ucase ? "FORMAT AS " : "format as ");
            x.getFileFormat().accept(this);
        }
        if (x.getFormatStrategys() != null && !x.getFormatStrategys().isEmpty()) {
            this.println();
            this.printListWithEnter(x.getFormatStrategys());
        }
        if (x.getColumnList() != null && !x.getColumnList().isEmpty()) {
            this.println();
            this.printList(x.getColumnList(), ", ");
        }
        if (x.getColumnFromPath() != null && !x.getColumnFromPath().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "COLUMNS FROM PATH AS " : "columns from path as ");
            this.printList(x.getColumnFromPath(), ", ");
        }
        if (x.getTransformFunction() != null && !x.getTransformFunction().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "SET " : "set ");
            this.printAssignItemsNewLine(x.getTransformFunction());
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksExternalTableDataDesc x) {
        this.print0(this.ucase ? "DATA FROM TABLE " : "data from table ");
        x.getExternalTable().accept(this);
        if (x.isNegative()) {
            this.println();
            this.print(this.ucase ? "NEGATIVE" : "negative");
        }
        this.println();
        this.print0(this.ucase ? "INTO TABLE " : "into table ");
        x.getTargetTableName().accept(this);
        if (x.getPartitions() != null && !x.getPartitions().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "PARTITION " : "partition ");
            this.printList(x.getPartitions(), ", ");
        }
        if (x.getTransformFunction() != null && !x.getTransformFunction().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "SET " : "set ");
            this.printAssignItemsNewLine(x.getTransformFunction());
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksSparkLoadStatement x) {
        this.print0(this.ucase ? "LOAD LABEL " : "load label ");
        x.getLoadLabel().accept(this);
        this.println();
        if (x.getDataDescList() != null && !x.getDataDescList().isEmpty()) {
            ++this.indentCount;
            this.println("(");
            this.printlnAndAccept(x.getDataDescList(), ", ");
            --this.indentCount;
            this.println();
            this.println(")");
        }
        this.print0(this.ucase ? "WITH RESOURCE " : "with resource ");
        x.getResourceName().accept(this);
        if (x.getResourceProperties() != null && !x.getResourceProperties().isEmpty()) {
            this.println();
            this.printAssignItemsNewLine(x.getResourceProperties());
        }
        if (x.getOptProperties() != null && !x.getOptProperties().isEmpty()) {
            this.println();
            this.println(this.ucase ? "PROPERTIES" : "properties");
            this.printAssignItemsNewLine(x.getOptProperties());
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksLoadBrokerStatement x) {
        this.print0(this.ucase ? "LOAD LABEL " : "load label ");
        x.getLoadLabel().accept(this);
        this.println();
        if (x.getDataDescList() != null && !x.getDataDescList().isEmpty()) {
            ++this.indentCount;
            this.println("(");
            this.printlnAndAccept(x.getDataDescList(), ", ");
            --this.indentCount;
            this.println();
            this.println(")");
        }
        this.print0(this.ucase ? "WITH BROKER " : "with broker ");
        if (x.getBrokerName() != null) {
            this.print(" ");
            x.getBrokerName().accept(this);
        }
        if (x.getResourceProperties() != null && !x.getResourceProperties().isEmpty()) {
            this.println();
            this.printAssignItemsNewLine(x.getResourceProperties());
        }
        if (x.getOptProperties() != null && !x.getOptProperties().isEmpty()) {
            this.println();
            this.println(this.ucase ? "PROPERTIES" : "properties");
            this.printAssignItemsNewLine(x.getOptProperties());
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksSubmitTaskStatement x) {
        this.print0(this.ucase ? "SUBMIT" : "submit");
        if (x.getHint() != null) {
            this.print0(" ");
            x.getHint().accept(this);
        }
        this.print0(this.ucase ? " TASK" : " task");
        if (x.getTaskName() != null) {
            this.print0(" ");
            x.getTaskName().accept(this);
        }
        this.println(this.ucase ? " AS" : " as");
        x.getEtlStatement().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksMaxValue x) {
        this.print0(this.ucase ? "MAXVALUE" : "maxvalue");
        return false;
    }

    @Override
    public boolean visit(StarRocksCancelLoadStatement x) {
        this.print0(this.ucase ? "CANCEL LOAD" : "cancel load");
        if (x.getDbName() != null) {
            this.print(this.ucase ? " FROM " : " from ");
            x.getDbName().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    private void printList(List<? extends SQLObject> exprList, String separator) {
        this.print0("(");
        this.printAndAccept(exprList, separator);
        this.print0(")");
    }

    private void printListWithEnter(List<? extends SQLObject> exprList) {
        this.print0("(");
        int size = exprList.size();
        for (int i = 0; i < size; ++i) {
            exprList.get(i).accept(this);
            this.println();
        }
        this.print0(")");
    }

    private void printAssignItemsNewLine(List<SQLAssignItem> partitions) {
        if (partitions == null) {
            return;
        }
        int partitionsSize = partitions.size();
        if (partitionsSize > 0) {
            ++this.indentCount;
            this.println("(");
            for (int i = 0; i < partitionsSize; ++i) {
                if (i != 0) {
                    this.println(", ");
                }
                SQLAssignItem assign = partitions.get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print(assign.printToken());
                assign.getValue().accept(this);
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
    }

    @Override
    public boolean visit(StarRocksBitmapDataType x) {
        this.print(this.ucase ? x.getName().toUpperCase() : x.getName().toLowerCase());
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if (x.isBracket()) {
            this.print("(");
            boolean result = super.visit(x);
            this.print(")");
            return result;
        }
        return super.visit(x);
    }

    @Override
    public boolean visit(StarRocksShowTabletStatement x) {
        this.print(this.ucase ? "SHOW TABLET" : "show tablet");
        if (x.getTabletId() != null) {
            this.print(" ");
            this.print(x.getTabletId());
            return false;
        }
        this.println();
        this.print(this.ucase ? "FROM " : "from ");
        x.getTableSource().accept(this);
        if (x.getPartitions() != null && !x.getPartitions().isEmpty()) {
            this.println();
            this.print(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartitions(), ", ");
            this.print(")");
        }
        if (x.getWhere() != null) {
            this.println();
            this.print(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksShowAnalyzeStatement x) {
        this.print(this.ucase ? "SHOW ANALYZE " : "show analyze ");
        this.print(this.ucase ? x.getType().name() : x.getType().name().toLowerCase());
        if (x.getWhere() != null) {
            this.println();
            this.print(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksShowRoutineStatement x) {
        this.print(this.ucase ? "SHOW" : "show");
        if (x.isAll()) {
            this.print(this.ucase ? " ALL" : " all");
        }
        this.print(this.ucase ? " ROUTINE LOAD" : " routine load");
        if (x.getName() != null) {
            this.print(this.ucase ? " FOR " : " for ");
            x.getName().accept(this);
        } else if (x.isShowTask()) {
            this.print(this.ucase ? " TASK" : " task");
            if (x.getWhere() != null) {
                this.print(this.ucase ? " WHERE " : " where ");
                x.getWhere().accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksStopRoutineLoadStatement x) {
        this.print(this.ucase ? "STOP ROUTINE LOAD FOR " : "stop routine load for ");
        x.getJobName().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksCreateAnalyzeStatement x) {
        this.print(this.ucase ? "CREATE ANALYZE " : "create analyze ");
        if (x.getAnalyzeType() != null) {
            this.print(this.ucase ? x.getAnalyzeType().name() : x.getAnalyzeType().name().toLowerCase());
            this.print(" ");
        }
        if (x.isAll()) {
            this.print(this.ucase ? "ALL" : " all");
        } else if (x.getDbName() != null) {
            this.print(this.ucase ? "DATABASE " : " database ");
            x.getDbName().accept(this);
        } else if (x.getTableSource() != null) {
            this.print(this.ucase ? "TABLE " : " table ");
            x.getTableSource().accept(this);
            this.print("(");
            if (x.getColumns() != null) {
                this.printAndAccept(x.getColumns(), ",");
            }
            this.print(")");
        }
        if (x.getProperties() != null && !x.getProperties().isEmpty()) {
            this.print(this.ucase ? " PROPERTIES " : " properties ");
            this.printAssignItemsNewLine(x.getProperties());
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksRollup x) {
        x.getRollupName().accept(this);
        if (x.getColumns() != null && !x.getColumns().isEmpty()) {
            this.print(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(")");
        }
        boolean first = true;
        ++this.indentCount;
        if (x.getFrom() != null) {
            this.print(this.ucase ? " FROM " : " from ");
            x.getFrom().accept(this);
            first = false;
        }
        if (x.getProperties() != null && !x.getProperties().isEmpty()) {
            if (!first) {
                this.println();
            } else {
                this.print(" ");
            }
            this.print(this.ucase ? "PROPERTIES (" : "properties (");
            this.printAndAccept(x.getProperties(), ", ");
            this.print(")");
        }
        --this.indentCount;
        return false;
    }

    @Override
    public boolean visit(StarRocksAlterDropRollup x) {
        this.print(this.ucase ? "DROP ROLLUP " : "drop rollup ");
        this.printlnAndAccept(x.getRollupDefinitions(), ",");
        return false;
    }

    @Override
    public boolean visit(StarRocksAlterAddRollup x) {
        this.print(this.ucase ? "ADD ROLLUP " : "add rollup ");
        this.printlnAndAccept(x.getRollupDefinitions(), ",");
        return false;
    }

    @Override
    public boolean visit(StarRocksDropAnalyzeStatement x) {
        this.print(this.ucase ? "DROP ANALYZE " : "drop analyze ");
        x.getAnalyzeId().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksDropStatsStatement x) {
        this.print(this.ucase ? "DROP STATS " : "drop stats ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public boolean visit(StarRocksKillAnalyzeStatement x) {
        this.print(this.ucase ? "KILL ANALYZE " : "kill analyze ");
        x.getAnalyzeId().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDropTableStatement x) {
        super.visit(x);
        if (x.isForce()) {
            this.print(this.ucase ? " FORCE" : " force");
        }
        return false;
    }

    @Override
    public boolean visit(StarRocksAlterTableAddPartition x) {
        this.print0(this.ucase ? "ADD PARTITION " : "add partition ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        if (x.getPartitionDesc() != null) {
            StarRocksObjectImpl partitionDesc;
            if (x.getPartitionDesc() instanceof StarRocksFixedRangeDesc) {
                partitionDesc = (StarRocksFixedRangeDesc)x.getPartitionDesc();
                ((StarRocksFixedRangeDesc)partitionDesc).getPartitionName().accept(this);
                this.print0(this.ucase ? " VALUES " : " values ");
                this.print0("[(");
                this.printAndAccept(((StarRocksFixedRangeDesc)partitionDesc).getLowerList(), ", ");
                this.print0("), ");
                this.print0("(");
                this.printAndAccept(((StarRocksFixedRangeDesc)partitionDesc).getUpperList(), ", ");
                this.print0("))");
            } else if (x.getPartitionDesc() instanceof StarRocksLessThanRangeDesc) {
                partitionDesc = (StarRocksLessThanRangeDesc)x.getPartitionDesc();
                ((StarRocksLessThanRangeDesc)partitionDesc).getPartitionName().accept(this);
                this.print0(this.ucase ? " VALUES LESS THAN " : " values less than ");
                if (((StarRocksLessThanRangeDesc)partitionDesc).getUpperList().size() == 1 && ((StarRocksLessThanRangeDesc)partitionDesc).getUpperList().get(0) instanceof StarRocksMaxValue) {
                    ((StarRocksLessThanRangeDesc)partitionDesc).getUpperList().get(0).accept(this);
                } else {
                    this.print0("(");
                    this.printAndAccept(((StarRocksLessThanRangeDesc)partitionDesc).getUpperList(), ", ");
                    this.print0(")");
                }
            }
        }
        if (x.getProperties() != null && !x.getProperties().isEmpty()) {
            this.println();
            this.print0(" (");
            this.printAndAccept(x.getProperties(), ", ");
            this.print0(")");
        }
        if (x.getDistributedBy() != null) {
            this.println();
            this.print0(this.ucase ? "DISTRIBUTED BY " : "distributed by ");
            x.getDistributedBy().accept(this);
            int buckets = x.getBuckets();
            if (buckets > 0) {
                this.print0(this.ucase ? " BUCKETS " : "buckets ");
                this.print0(String.valueOf(buckets));
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x, boolean parameterized) {
        if (parameterized) {
            this.print('?');
            this.incrementReplaceCunt();
            if (this.parameters != null) {
                ExportParameterVisitorUtils.exportParameter((List<Object>)this.parameters, x);
            }
            return false;
        }
        this.printChars(x);
        return false;
    }

    protected void printChars(SQLCharExpr x) {
        String text = x.getText();
        if (text == null) {
            this.print0(this.ucase ? "NULL" : "null");
        } else if (x.getQuoteType() == '\"') {
            this.print('\"');
            this.print0(text);
            this.print('\"');
        } else {
            this.print('\'');
            this.print0(text);
            this.print('\'');
        }
    }
}

