/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.starrocks.parser;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLPartitionBy;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableRenameColumn;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableRenameIndex;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableSetOption;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLDescribeStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDropMaterializedViewStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.RefreshSchemaDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksAlterAddRollup;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksAlterDropRollup;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksAlterTableAddPartition;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksBulkRangeDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksDataDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksDataSourceProperties;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksExternalTableDataDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksFilePathDataDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksLoadProperties;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksObjectImpl;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksPartitionDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksRollup;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksAlterLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksAlterMaterializedViewStmt;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksAlterRoutineLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksAnalyzeTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCancelAlterTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCancelExportStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCancelLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCancelRefreshViewStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCreateAnalyzeStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCreateMaterializeViewStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCreateRoutineLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksDropAnalyzeStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksDropStatsStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksInsertStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksKillAnalyzeStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksLoadBrokerStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksPauseLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksRecoverPartitionStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksRecoverTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksRefreshMaterializedViewStmt;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksRefreshTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksResumeLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowAlterMaterializedViewStmt;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowAlterTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowAnalyzeStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowCreateMaterializedViewStmt;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowDataStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowDeleteStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowDynamicPartitionTablesStmt;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowExportStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowIndexStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowMaterializedViewStmt;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowPartitionsStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowRoutineStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowTabletStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksShowTransactionStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksSparkLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksStatementImpl;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksStopRoutineLoadStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksSubmitTaskStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.parser.StarRocksCreateTableParser;
import com.alibaba.fastsql.sql.dialect.starrocks.parser.StarRocksExprParser;
import com.alibaba.fastsql.sql.parser.InsertColumnsCache;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLSelectParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.sql.repository.SchemaObject;
import com.alibaba.fastsql.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.fastsql.util.FnvHash;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class StarRocksStatementParser
extends MySqlStatementParser {
    public StarRocksStatementParser(String sql) {
        super(new StarRocksExprParser(sql));
    }

    public StarRocksStatementParser(String sql, SQLParserFeature ... features) {
        super(new StarRocksExprParser(sql, features));
    }

    public StarRocksStatementParser(String sql, boolean keepComments) {
        super(new StarRocksExprParser(sql, keepComments));
    }

    public StarRocksStatementParser(String sql, boolean skipComment, boolean keepComments) {
        super(new StarRocksExprParser(sql, skipComment, keepComments));
    }

    public StarRocksStatementParser(Lexer lexer) {
        super(new StarRocksExprParser(lexer));
    }

    @Override
    protected SQLStatement parseAlterTable(boolean ignore, boolean online, boolean offline) {
        this.lexer.nextToken();
        SQLAlterTableStatement stmt = new SQLAlterTableStatement(this.getDbType());
        stmt.setIgnore(ignore);
        stmt.setOnline(online);
        stmt.setOffline(offline);
        stmt.setName(this.exprParser.name());
        while (true) {
            boolean parsed;
            if (!(parsed = ((StarRocksExprParser)this.exprParser).parseTableOptions(stmt.getTableOptions(), stmt))) {
                parsed = this.parseAlterSpecification(stmt);
            }
            if (!parsed) break;
            if (this.lexer.token() != Token.COMMA) continue;
            this.lexer.nextToken();
        }
        if (Token.PARTITION == this.lexer.token()) {
            SQLPartitionBy partitionBy = this.getSQLCreateTableParser().parsePartitionBy();
            stmt.setPartition(partitionBy);
        }
        return stmt;
    }

    @Override
    protected void parseAlterTableSet(SQLAlterTableStatement stmt) {
        this.lexer.nextToken();
        SQLAlterTableSetOption setOption = new SQLAlterTableSetOption();
        this.accept(Token.LPAREN);
        while (true) {
            SQLAssignItem item = this.exprParser.parseAssignItem();
            setOption.addOption(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        stmt.addItem(setOption);
    }

    @Override
    protected boolean parseAlterSpecification(SQLAlterTableStatement stmt) {
        if (this.lexer.token() == Token.RENAME) {
            this.lexer.nextToken();
            switch (this.lexer.token()) {
                case INDEX: 
                case KEY: {
                    this.lexer.nextToken();
                    SQLName name = this.exprParser.name();
                    this.accept(Token.TO);
                    SQLName to = this.exprParser.name();
                    SQLAlterTableRenameIndex item = new SQLAlterTableRenameIndex(name, to);
                    stmt.addItem(item);
                    return true;
                }
                case COLUMN: {
                    this.lexer.nextToken();
                    SQLName columnName = this.exprParser.name();
                    this.accept(Token.TO);
                    SQLName toName = this.exprParser.name();
                    SQLAlterTableRenameColumn renameColumn = new SQLAlterTableRenameColumn();
                    renameColumn.setColumn(columnName);
                    renameColumn.setTo(toName);
                    stmt.addItem(renameColumn);
                    return true;
                }
                case TO: 
                case AS: {
                    this.lexer.nextToken();
                }
                case IDENTIFIER: {
                    SQLAlterTableRename item = new SQLAlterTableRename();
                    SQLName to = this.exprParser.name();
                    item.setTo(to);
                    stmt.addItem(item);
                    return true;
                }
            }
            return false;
        }
        return super.parseAlterSpecification(stmt);
    }

    @Override
    public StarRocksCreateTableParser getSQLCreateTableParser() {
        return new StarRocksCreateTableParser(this.exprParser);
    }

    @Override
    public SQLStatement parseDropMaterializedView(boolean acceptDrop) {
        if (this.lexer.token() == Token.DROP) {
            this.lexer.nextToken();
        }
        SQLDropMaterializedViewStatement stmt = new SQLDropMaterializedViewStatement();
        stmt.setDbType(this.dbType);
        this.acceptIdentifier("MATERIALIZED");
        this.accept(Token.VIEW);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    @Override
    public SQLStatement parseCreate() {
        Lexer.SavePoint mark = this.lexer.mark();
        this.accept(Token.CREATE);
        if (this.lexer.identifierEquals(FnvHash.Constants.MATERIALIZED)) {
            this.lexer.reset(mark);
            return this.parseCreateMaterializedView();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ROUTINE)) {
            this.lexer.nextToken();
            this.accept(Token.LOAD);
            return this.parseCreateRoutineLoad();
        }
        if (this.lexer.token() == Token.ANALYZE) {
            this.lexer.reset(mark);
            return this.parseCreateAnalyze();
        }
        if (this.lexer.token() == Token.LOGICALVIEW) {
            this.lexer.reset(mark);
            return this.parseCreateView();
        }
        if (this.lexer.token() == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            if (this.lexer.token() == Token.LOGICALVIEW) {
                this.lexer.reset(mark);
                return this.parseCreateView();
            }
        }
        this.lexer.reset(mark);
        return super.parseCreate();
    }

    @Override
    public SQLStatement parseDrop() {
        Lexer.SavePoint mark = this.lexer.mark();
        this.accept(Token.DROP);
        if (this.lexer.token() == Token.ANALYZE) {
            this.lexer.reset(mark);
            return this.parseDropAnalyze();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STATS)) {
            this.lexer.reset(mark);
            return this.parseDropStats();
        }
        this.lexer.reset(mark);
        return super.parseDrop();
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        int startLine = this.lexer.getPosLine();
        int startCol = this.lexer.getPosColumn();
        if (this.lexer.token() == Token.CANCEL) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.REFRESH)) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.MATERIALIZED)) {
                    this.lexer.nextToken();
                    this.accept(Token.VIEW);
                    StarRocksCancelRefreshViewStatement stmt = new StarRocksCancelRefreshViewStatement();
                    stmt.setTableSource(new SQLExprTableSource(this.exprParser.name()));
                    this.addToStatementList(statementList, stmt, startLine, startCol);
                    return true;
                }
            } else {
                if (this.lexer.token() == Token.ALTER) {
                    this.lexer.nextToken();
                    this.accept(Token.TABLE);
                    StarRocksCancelAlterTableStatement stmt = new StarRocksCancelAlterTableStatement();
                    if (this.lexer.token() == Token.COLUMN) {
                        this.lexer.nextToken();
                        stmt.setAlterTableType(StarRocksStatement.AlterTableType.COLUMN);
                    } else if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
                        this.lexer.nextToken();
                        stmt.setAlterTableType(StarRocksStatement.AlterTableType.ROLLUP);
                    }
                    this.accept(Token.FROM);
                    stmt.setTableSource(new SQLExprTableSource(this.exprParser.name()));
                    this.addToStatementList(statementList, stmt, startLine, startCol);
                    return true;
                }
                if (this.lexer.token() == Token.LOAD) {
                    this.accept(Token.LOAD);
                    StarRocksCancelLoadStatement stmt = new StarRocksCancelLoadStatement();
                    if (this.lexer.token() == Token.FROM) {
                        this.lexer.nextToken();
                        stmt.setDbName(this.exprParser.name());
                    }
                    if (this.lexer.token() == Token.WHERE) {
                        this.lexer.nextToken();
                        stmt.setWhere(this.exprParser.expr());
                    }
                    this.addToStatementList(statementList, stmt, startLine, startCol);
                    return true;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.EXPORT)) {
                    this.lexer.nextToken();
                    StarRocksCancelExportStatement stmt = new StarRocksCancelExportStatement();
                    if (this.lexer.token() == Token.FROM) {
                        this.lexer.nextToken();
                        stmt.setDbName(this.exprParser.name());
                    }
                    if (this.lexer.token() == Token.WHERE) {
                        this.lexer.nextToken();
                        stmt.setWhere(this.exprParser.expr());
                    }
                    this.addToStatementList(statementList, stmt, startLine, startCol);
                    return true;
                }
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.PAUSE)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.ROUTINE)) {
                this.lexer.nextToken();
                this.accept(Token.LOAD);
                this.accept(Token.FOR);
                StarRocksPauseLoadStatement stmt = new StarRocksPauseLoadStatement();
                stmt.setJobName(this.exprParser.name());
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RESUME)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.ROUTINE)) {
                this.lexer.nextToken();
                this.accept(Token.LOAD);
                this.accept(Token.FOR);
                StarRocksResumeLoadStatement stmt = new StarRocksResumeLoadStatement();
                stmt.setJobName(this.exprParser.name());
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RECOVER)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                StarRocksRecoverTableStatement stmt = new StarRocksRecoverTableStatement();
                stmt.setTableSource(new SQLExprTableSource(this.exprParser.name()));
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
            if (this.lexer.token() == Token.PARTITION) {
                this.accept(Token.PARTITION);
                StarRocksRecoverPartitionStatement stmt = new StarRocksRecoverPartitionStatement();
                stmt.setPartitionName(this.exprParser.name());
                this.accept(Token.FROM);
                stmt.setTableSource(new SQLExprTableSource(this.exprParser.name()));
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
        } else if (this.lexer.token() == Token.LOAD) {
            this.accept(Token.LOAD);
            if (this.lexer.identifierEquals(FnvHash.Constants.LABEL)) {
                this.lexer.nextToken();
                StarRocksStatementImpl stmt = this.parseSparkLoad();
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.SUBMIT)) {
            this.lexer.nextToken();
            StarRocksSubmitTaskStatement stmt = new StarRocksSubmitTaskStatement();
            if (this.lexer.token() == Token.HINT) {
                stmt.setHint(this.exprParser.parseHint());
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TASK)) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.AS) {
                    stmt.setTaskName(this.exprParser.name());
                }
                this.accept(Token.AS);
                if (this.lexer.token() == Token.CREATE) {
                    stmt.setEtlStatement(this.parseCreate());
                } else if (this.lexer.token() == Token.INSERT) {
                    stmt.setEtlStatement(this.parseInsert());
                }
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.STOP)) {
            this.lexer.nextToken();
            StarRocksStopRoutineLoadStatement stmt = new StarRocksStopRoutineLoadStatement();
            this.acceptIdentifier(Token.ROUTINE.name);
            this.accept(Token.LOAD);
            this.accept(Token.FOR);
            stmt.setJobName(this.exprParser.name());
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        return super.parseStatementListDialect(statementList);
    }

    private StarRocksCreateAnalyzeStatement parseCreateAnalyze() {
        this.accept(Token.CREATE);
        this.accept(Token.ANALYZE);
        StarRocksCreateAnalyzeStatement stmt = new StarRocksCreateAnalyzeStatement();
        if (this.lexer.token() == Token.FULL) {
            stmt.setAnalyzeType(StarRocksCreateAnalyzeStatement.AnalyzeType.FULL);
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals(FnvHash.Constants.SAMPLE)) {
            stmt.setAnalyzeType(StarRocksCreateAnalyzeStatement.AnalyzeType.SAMPLE);
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.ALL) {
            stmt.setAll(true);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.DATABASE) {
            this.lexer.nextToken();
            stmt.setDbName(this.exprParser.name());
        } else if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            stmt.setTableSource(new SQLExprTableSource(this.exprParser.name()));
            this.accept(Token.LPAREN);
            ArrayList<SQLName> columns = new ArrayList<SQLName>();
            while (true) {
                columns.add(this.exprParser.name());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            stmt.setColumns(columns);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PROPERTIES)) {
            this.lexer.nextToken();
            ArrayList<SQLAssignItem> properties = Lists.newArrayList();
            this.exprParser.parseAssignItem(properties, stmt);
            stmt.setProperties(properties);
        }
        return stmt;
    }

    private StarRocksStatementImpl parseSparkLoad() {
        StarRocksSparkLoadStatement stmt = new StarRocksSparkLoadStatement();
        stmt.setLoadLabel(this.exprParser.name());
        List<StarRocksDataDesc> dataDescList = this.parseDataDescList(stmt);
        stmt.setDataDescList(dataDescList);
        this.accept(Token.WITH);
        if (this.lexer.identifierEquals(FnvHash.Constants.RESOURCE)) {
            this.lexer.nextToken();
            stmt.setResourceName(this.exprParser.name());
            if (this.lexer.token() == Token.LPAREN) {
                ArrayList<SQLAssignItem> resourceProperties = Lists.newArrayList();
                this.exprParser.parseAssignItem(resourceProperties, stmt);
                stmt.setResourceProperties(resourceProperties);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.BROKER)) {
            return this.parseLoadBroker(stmt);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PROPERTIES)) {
            this.lexer.nextToken();
            ArrayList<SQLAssignItem> optProperties = Lists.newArrayList();
            this.exprParser.parseAssignItem(optProperties, stmt);
            stmt.setOptProperties(optProperties);
        }
        return stmt;
    }

    private StarRocksStatementImpl parseLoadBroker(StarRocksSparkLoadStatement stmt) {
        StarRocksLoadBrokerStatement stmtBroker = new StarRocksLoadBrokerStatement(stmt);
        this.lexer.nextToken();
        if (this.lexer.token() != Token.LPAREN) {
            stmtBroker.setBrokerName(this.exprParser.name());
        }
        if (this.lexer.token() == Token.LPAREN) {
            ArrayList<SQLAssignItem> resourceProperties = Lists.newArrayList();
            this.exprParser.parseAssignItem(resourceProperties, stmtBroker);
            stmtBroker.setResourceProperties(resourceProperties);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PROPERTIES)) {
            this.lexer.nextToken();
            ArrayList<SQLAssignItem> optProperties = Lists.newArrayList();
            this.exprParser.parseAssignItem(optProperties, stmtBroker);
            stmtBroker.setOptProperties(optProperties);
        }
        return stmtBroker;
    }

    private List<StarRocksDataDesc> parseDataDescList(StarRocksSparkLoadStatement parent) {
        this.accept(Token.LPAREN);
        ArrayList<StarRocksDataDesc> dataDescList = Lists.newArrayList();
        while (true) {
            StarRocksObjectImpl dataDesc;
            if (this.lexer.identifierEquals(FnvHash.Constants.DATA)) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.INFILE) {
                this.accept(Token.INFILE);
                dataDesc = this.parseInFileDataDesc();
                dataDesc.setParent(parent);
                dataDescList.add((StarRocksDataDesc)((Object)dataDesc));
            } else if (this.lexer.token() == Token.FROM) {
                this.accept(Token.FROM);
                this.accept(Token.TABLE);
                dataDesc = this.parseFromTableDataDesc();
                dataDesc.setParent(parent);
                dataDescList.add((StarRocksDataDesc)((Object)dataDesc));
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return dataDescList;
    }

    private StarRocksExternalTableDataDesc parseFromTableDataDesc() {
        StarRocksExternalTableDataDesc dataDesc = new StarRocksExternalTableDataDesc();
        dataDesc.setExternalTable(new SQLExprTableSource(this.exprParser.name()));
        if (this.lexer.identifierEquals(FnvHash.Constants.NEGATIVE)) {
            this.lexer.nextToken();
            dataDesc.setNegative(true);
        }
        this.accept(Token.INTO);
        this.accept(Token.TABLE);
        dataDesc.setTargetTableName(new SQLExprTableSource(this.exprParser.name()));
        if (this.lexer.token() == Token.PARTITION) {
            this.accept(Token.PARTITION);
            dataDesc.setPartitions(this.parseSqlExprList(dataDesc));
        }
        if (this.lexer.token() == Token.SET) {
            this.accept(Token.SET);
            ArrayList<SQLAssignItem> setFunctions = Lists.newArrayList();
            this.exprParser.parseAssignItem(setFunctions, dataDesc);
            dataDesc.setTransformFunction(setFunctions);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.accept(Token.WHERE);
            dataDesc.setWhere(this.exprParser.expr());
        }
        return dataDesc;
    }

    private StarRocksFilePathDataDesc parseInFileDataDesc() {
        StarRocksFilePathDataDesc dataDesc = new StarRocksFilePathDataDesc();
        dataDesc.setSourceFilePath(this.parseSqlExprList(dataDesc));
        if (this.lexer.identifierEquals(FnvHash.Constants.NEGATIVE)) {
            this.lexer.nextToken();
            dataDesc.setNegative(true);
        }
        this.accept(Token.INTO);
        this.accept(Token.TABLE);
        dataDesc.setTargetTableName(new SQLExprTableSource(this.exprParser.name()));
        if (this.lexer.token() == Token.PARTITION) {
            this.accept(Token.PARTITION);
            dataDesc.setPartitions(this.parseSqlExprList(dataDesc));
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.COLUMNS)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.TERMINATED) {
                this.accept(Token.TERMINATED);
                this.accept(Token.BY);
                dataDesc.setColumnSeparator(this.exprParser.name());
            } else if (this.lexer.token() == Token.FROM) {
                this.accept(Token.FROM);
                if (this.lexer.identifierEquals(FnvHash.Constants.PATH)) {
                    this.accept(Token.AS);
                    dataDesc.setColumnFromPath(this.parseSqlExprList(dataDesc));
                }
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.FORMAT)) {
            this.lexer.nextToken();
            this.accept(Token.AS);
            dataDesc.setFileFormat(this.exprParser.name());
        }
        if (this.lexer.token() == Token.LPAREN) {
            List<SQLExpr> dataDescList = this.parseSqlExprList(dataDesc);
            if (this.lexer.token() == Token.LPAREN) {
                dataDesc.setFormatStrategys(dataDescList);
                List<SQLExpr> columnList = this.parseSqlExprList(dataDesc);
                dataDesc.setColumnList(columnList);
            } else {
                dataDesc.setColumnList(dataDescList);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.COLUMNS)) {
            this.lexer.nextToken();
            this.accept(Token.FROM);
            if (this.lexer.identifierEquals(FnvHash.Constants.PATH)) {
                this.lexer.nextToken();
                this.accept(Token.AS);
                dataDesc.setColumnFromPath(this.parseSqlExprList(dataDesc));
            }
        }
        if (this.lexer.token() == Token.SET) {
            this.accept(Token.SET);
            ArrayList<SQLAssignItem> setFunctions = Lists.newArrayList();
            this.exprParser.parseAssignItem(setFunctions, dataDesc);
            dataDesc.setTransformFunction(setFunctions);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.accept(Token.WHERE);
            dataDesc.setWhere(this.exprParser.expr());
        }
        return dataDesc;
    }

    @Override
    public SQLStatement parseShow() {
        Lexer.SavePoint mark = this.lexer.mark();
        this.accept(Token.SHOW);
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.MATERIALIZED)) {
                this.lexer.nextToken();
                this.accept(Token.VIEW);
                StarRocksShowCreateMaterializedViewStmt stmt = new StarRocksShowCreateMaterializedViewStmt();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
        } else if (this.lexer.token() == Token.ALTER) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.MATERIALIZED)) {
                this.lexer.nextToken();
                this.accept(Token.VIEW);
                if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                }
                StarRocksShowAlterMaterializedViewStmt stmt = new StarRocksShowAlterMaterializedViewStmt();
                if (this.lexer.token() != Token.EOF && this.lexer.token() != Token.SEMI) {
                    stmt.setDbName(this.exprParser.name());
                }
                return stmt;
            }
            if (this.lexer.token() == Token.TABLE) {
                this.accept(Token.TABLE);
                StarRocksShowAlterTableStatement stmt = new StarRocksShowAlterTableStatement();
                if (this.lexer.token() == Token.COLUMN) {
                    this.lexer.nextToken();
                    stmt.setAlterTableType(StarRocksStatement.AlterTableType.COLUMN);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
                    this.lexer.nextToken();
                    stmt.setAlterTableType(StarRocksStatement.AlterTableType.ROLLUP);
                }
                if (this.lexer.token() == Token.FROM) {
                    this.accept(Token.FROM);
                    stmt.setDbName(this.exprParser.name());
                }
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    stmt.setWhere(this.exprParser.expr());
                }
                if (this.lexer.token() == Token.ORDER) {
                    stmt.setOrderBy(this.exprParser.parseOrderBy());
                }
                if (this.lexer.token() == Token.LIMIT) {
                    stmt.setLimit(this.exprParser.parseLimit());
                }
                return stmt;
            }
        } else {
            if (this.lexer.identifierEquals(FnvHash.Constants.DATA)) {
                this.lexer.nextToken();
                StarRocksShowDataStatement stmt = new StarRocksShowDataStatement();
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                    stmt.setTableSource(new SQLExprTableSource(this.exprParser.name()));
                }
                return stmt;
            }
            if (this.lexer.token() == Token.DELETE) {
                this.lexer.nextToken();
                StarRocksShowDeleteStatement stmt = new StarRocksShowDeleteStatement();
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                    stmt.setDbName(this.exprParser.name());
                }
                return stmt;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.MATERIALIZED)) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.VIEWS)) {
                    this.lexer.nextToken();
                    StarRocksShowMaterializedViewStmt stmt = new StarRocksShowMaterializedViewStmt();
                    if (this.lexer.token() == Token.FROM) {
                        this.lexer.nextToken();
                        stmt.setDbName(this.exprParser.name());
                    }
                    if (this.lexer.token() == Token.WHERE) {
                        this.lexer.nextToken();
                        stmt.setCondition(this.exprParser.expr());
                    }
                    return stmt;
                }
            } else {
                if (this.lexer.identifierEquals(FnvHash.Constants.TRANSACTION)) {
                    this.lexer.nextToken();
                    StarRocksShowTransactionStatement stmt = new StarRocksShowTransactionStatement();
                    if (this.lexer.token() == Token.FROM) {
                        this.lexer.nextToken();
                        stmt.setDbName(this.exprParser.name());
                    }
                    if (this.lexer.token() == Token.WHERE) {
                        this.lexer.nextToken();
                        stmt.setCondition(this.exprParser.expr());
                    }
                    return stmt;
                }
                if (this.lexer.token() == Token.LOAD) {
                    return this.parseShowLoad();
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.DYNAMIC)) {
                    this.lexer.nextToken();
                    this.accept(Token.PARTITION);
                    this.accept(Token.TABLES);
                    StarRocksShowDynamicPartitionTablesStmt stmt = new StarRocksShowDynamicPartitionTablesStmt();
                    if (this.lexer.token() == Token.FROM) {
                        this.lexer.nextToken();
                        stmt.setDbName(this.exprParser.name());
                    }
                    return stmt;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.EXPORT)) {
                    this.lexer.nextToken();
                    StarRocksShowExportStatement stmt = new StarRocksShowExportStatement();
                    if (this.lexer.token() == Token.FROM) {
                        this.lexer.nextToken();
                        stmt.setDbName(this.exprParser.name());
                    }
                    if (this.lexer.token() == Token.WHERE) {
                        this.lexer.nextToken();
                        stmt.setWhere(this.exprParser.expr());
                    }
                    if (this.lexer.token() == Token.ORDER) {
                        stmt.setOrderBy(this.exprParser.parseOrderBy());
                    }
                    if (this.lexer.token() == Token.LIMIT) {
                        stmt.setLimit(this.exprParser.parseLimit());
                    }
                    return stmt;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.TEMPORARY)) {
                    this.lexer.nextToken();
                    return this.parseStarRocksShowPartitionsStmt(true);
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
                    return this.parseStarRocksShowPartitionsStmt(false);
                }
                if (this.lexer.token() == Token.INDEX || this.lexer.identifierEquals(FnvHash.Constants.INDEXES) || this.lexer.token() == Token.KEY || this.lexer.token() == Token.KEYS) {
                    return this.parseStarRocksShowIndexStmt();
                }
                if (this.lexer.token() == Token.TABLES) {
                    this.lexer.nextToken();
                    SQLShowTablesStatement stmt = new SQLShowTablesStatement();
                    if (this.lexer.token() == Token.FROM) {
                        this.lexer.nextToken();
                        stmt.setDatabase(this.exprParser.name());
                    }
                    return stmt;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.TABLET)) {
                    return this.parseShowTablet();
                }
                if (this.lexer.token() == Token.ANALYZE) {
                    return this.parseShowAnalyzeJob();
                }
                if (this.lexer.token() == Token.ALL) {
                    Lexer.SavePoint sp = this.lexer.mark();
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals(FnvHash.Constants.ROUTINE)) {
                        this.lexer.reset(sp);
                        return this.parseShowRoutine();
                    }
                } else if (this.lexer.identifierEquals(FnvHash.Constants.ROUTINE)) {
                    return this.parseShowRoutine();
                }
            }
        }
        this.lexer.reset(mark);
        return super.parseShow();
    }

    private StarRocksShowRoutineStatement parseShowRoutine() {
        StarRocksShowRoutineStatement stmt = new StarRocksShowRoutineStatement();
        if (this.lexer.token() == Token.ALL) {
            this.lexer.nextToken();
            stmt.setAll(true);
        }
        this.acceptIdentifier(Token.ROUTINE.name);
        this.accept(Token.LOAD);
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            stmt.setName(this.exprParser.name());
        } else if (this.lexer.identifierEquals(FnvHash.Constants.TASK)) {
            this.lexer.nextToken();
            stmt.setShowTask(true);
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
        }
        return stmt;
    }

    private StarRocksShowAnalyzeStatement parseShowAnalyzeJob() {
        this.lexer.nextToken();
        StarRocksShowAnalyzeStatement stmt = new StarRocksShowAnalyzeStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.JOB)) {
            stmt.setType(StarRocksShowAnalyzeStatement.AnalyzeType.JOB);
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals(FnvHash.Constants.STATUS)) {
            stmt.setType(StarRocksShowAnalyzeStatement.AnalyzeType.STATUS);
            this.lexer.nextToken();
        } else {
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            stmt.setWhere(this.exprParser.expr());
        }
        return stmt;
    }

    private StarRocksShowIndexStatement parseStarRocksShowIndexStmt() {
        boolean showMulti = false;
        boolean useKey = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.INDEXES)) {
            showMulti = true;
        } else if (this.lexer.token() == Token.KEY) {
            useKey = true;
        } else if (this.lexer.token() == Token.KEYS) {
            useKey = true;
            showMulti = true;
        }
        this.lexer.nextToken();
        this.accept(Token.FROM);
        StarRocksShowIndexStatement statement = new StarRocksShowIndexStatement();
        statement.setShowMulti(showMulti);
        statement.setUseKey(useKey);
        statement.setTableSource(new SQLExprTableSource(this.exprParser.name()));
        if (this.lexer.token() == Token.FROM) {
            this.accept(Token.FROM);
            statement.setDbName(this.exprParser.name());
        }
        return statement;
    }

    private StarRocksShowTabletStatement parseShowTablet() {
        this.lexer.nextToken();
        StarRocksShowTabletStatement stmt = new StarRocksShowTabletStatement();
        if (this.lexer.token() == Token.LITERAL_INT) {
            stmt.setTabletId(this.lexer.integerValue().intValue());
            this.lexer.nextToken();
            return stmt;
        }
        this.accept(Token.FROM);
        stmt.setTableSource(new SQLExprTableSource(this.exprParser.name()));
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            ArrayList<SQLName> partitions = new ArrayList<SQLName>();
            this.accept(Token.LPAREN);
            while (true) {
                partitions.add(this.exprParser.name());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            stmt.setPartitions(partitions);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            stmt.setWhere(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.ORDER) {
            stmt.setOrderBy(this.exprParser.parseOrderBy());
        }
        if (this.lexer.token() == Token.LIMIT) {
            stmt.setLimit(this.exprParser.parseLimit());
        }
        return stmt;
    }

    private StarRocksShowPartitionsStatement parseStarRocksShowPartitionsStmt(boolean showTempPartition) {
        this.lexer.nextToken();
        this.accept(Token.FROM);
        StarRocksShowPartitionsStatement statement = new StarRocksShowPartitionsStatement();
        statement.setShowTemporaryPartitions(showTempPartition);
        statement.setTableSource(new SQLExprTableSource(this.exprParser.name()));
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            statement.setWhere(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.ORDER) {
            statement.setOrderBy(this.exprParser.parseOrderBy());
        }
        if (this.lexer.token() == Token.LIMIT) {
            statement.setLimit(this.exprParser.parseLimit());
        }
        return statement;
    }

    protected SQLStatement parseShowLoad() {
        this.accept(Token.LOAD);
        StarRocksShowLoadStatement stmt = new StarRocksShowLoadStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            stmt.setDbName(this.exprParser.name());
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            stmt.setWhere(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.ORDER) {
            stmt.setOrderBy(this.exprParser.parseOrderBy());
        }
        if (this.lexer.token() == Token.LIMIT) {
            stmt.setLimit(this.exprParser.parseLimit());
        }
        return stmt;
    }

    @Override
    protected SQLStatement parseRefresh() {
        this.acceptIdentifier("REFRESH");
        if (this.lexer.identifierEquals(FnvHash.Constants.MATERIALIZED)) {
            this.lexer.nextToken();
            this.accept(Token.VIEW);
            StarRocksRefreshMaterializedViewStmt stmt = new StarRocksRefreshMaterializedViewStmt();
            stmt.setTableSource(new SQLExprTableSource(this.exprParser.name()));
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                StarRocksBulkRangeDesc rangeDesc = new StarRocksBulkRangeDesc();
                this.acceptIdentifier("START");
                this.accept(Token.LPAREN);
                rangeDesc.setPartitionStart(this.exprParser.expr());
                this.accept(Token.RPAREN);
                this.accept(Token.END);
                this.accept(Token.LPAREN);
                rangeDesc.setPartitionEnd(this.exprParser.expr());
                this.accept(Token.RPAREN);
                stmt.setRangeDesc(rangeDesc);
                if (this.lexer.token() == Token.FORCE) {
                    this.lexer.nextToken();
                    stmt.setForce(true);
                }
            }
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.SYNC)) {
                    stmt.setMode(StarRocksRefreshMaterializedViewStmt.ModeType.SYNC);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.ASYNC)) {
                    stmt.setMode(StarRocksRefreshMaterializedViewStmt.ModeType.ASYNC);
                } else {
                    this.printError(Token.SYNC, Token.ASYNC);
                }
                this.lexer.nextToken();
                this.acceptIdentifier(Token.MODE.name);
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.nextToken();
            this.accept(Token.TABLE);
            StarRocksRefreshTableStatement stmt = new StarRocksRefreshTableStatement();
            stmt.setTableName(this.exprParser.name());
            if (this.lexer.token() == Token.PARTITION) {
                this.accept(Token.PARTITION);
                this.accept(Token.LPAREN);
                while (true) {
                    stmt.addPartition(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            return stmt;
        }
        return super.parseRefresh();
    }

    @Override
    public SQLInsertStatement parseInsert() {
        SQLSelect select;
        StarRocksInsertStatement stmt = new StarRocksInsertStatement();
        SQLName tableName = null;
        if (this.lexer.token() == Token.INSERT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.HINT) {
                List<SQLCommentHint> hints = this.exprParser.parseHints();
                stmt.setHints(hints);
            }
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TABLE) {
                    this.lexer.nextToken();
                }
            } else if (this.lexer.identifierEquals(FnvHash.Constants.OVERWRITE)) {
                this.lexer.nextToken();
                stmt.setOverwrite(true);
                if (this.lexer.token() == Token.TABLE) {
                    this.lexer.nextToken();
                } else if (this.lexer.token() == Token.INTO) {
                    this.lexer.nextToken();
                }
            }
            tableName = this.exprParser.name();
            stmt.setTableName(tableName);
            if (this.lexer.token() == Token.HINT) {
                String comment = "/*" + this.lexer.stringVal() + "*/";
                this.lexer.nextToken();
                stmt.getTableSource().addAfterComment(comment);
            }
            if (this.lexer.token() == Token.IDENTIFIER && !this.lexer.identifierEquals(FnvHash.Constants.VALUE) && !this.lexer.identifierEquals("TEMPORARY_PARTITION")) {
                stmt.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                while (true) {
                    SQLAssignItem ptExpr = new SQLAssignItem();
                    ptExpr.setTarget(this.exprParser.name());
                    if (this.lexer.token() == Token.EQ) {
                        this.lexer.nextToken();
                        SQLExpr ptValue = this.exprParser.expr();
                        ptExpr.setValue(ptValue);
                    }
                    stmt.addPartition(ptExpr);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TEMPORARY_PARTITION)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                while (true) {
                    SQLName tempPartition = this.exprParser.name();
                    stmt.addTemporaryPartitions(tempPartition);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.WITH) {
                Lexer.SavePoint sp = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.LABEL)) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.AS) {
                        stmt.setLabel(this.exprParser.name());
                    } else {
                        this.lexer.reset(sp);
                    }
                } else {
                    this.lexer.reset(sp);
                }
            }
        }
        int columnSize = 0;
        ArrayList<SQLColumnDefinition> columnDefinitionList = null;
        if (this.lexer.token() == Token.LPAREN) {
            boolean useInsertColumnsCache = this.lexer.isEnabled(SQLParserFeature.UseInsertColumnsCache);
            InsertColumnsCache insertColumnsCache = null;
            long tableNameHash = 0L;
            InsertColumnsCache.Entry cachedColumns = null;
            if (useInsertColumnsCache) {
                insertColumnsCache = this.insertColumnsCache;
                if (insertColumnsCache == null) {
                    insertColumnsCache = InsertColumnsCache.global;
                }
                if (tableName != null) {
                    tableNameHash = tableName.nameHashCode64();
                    cachedColumns = insertColumnsCache.get(tableNameHash);
                }
            }
            SchemaObject tableObject = null;
            int pos = this.lexer.pos();
            if (cachedColumns != null && this.lexer.text.startsWith(cachedColumns.columnsString, pos)) {
                if (!this.lexer.isEnabled(SQLParserFeature.OptimizedForParameterized)) {
                    List<SQLExpr> columns = stmt.getColumns();
                    List<SQLExpr> cachedColumns2 = cachedColumns.columns;
                    int size = cachedColumns2.size();
                    for (int i = 0; i < size; ++i) {
                        columns.add(cachedColumns2.get(i).clone());
                    }
                }
                stmt.setColumnsString(cachedColumns.columnsFormattedString, cachedColumns.columnsFormattedStringHash);
                int p2 = pos + cachedColumns.columnsString.length();
                this.lexer.reset(p2);
                this.lexer.nextToken();
            } else {
                Lexer.SavePoint mark = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.SELECT) {
                    this.lexer.reset(mark);
                    SQLSelect select2 = this.exprParser.createSelectParser().select();
                    select2.setParent(stmt);
                    stmt.setQuery(select2);
                } else {
                    if (this.repository != null && this.lexer.isEnabled(SQLParserFeature.InsertValueCheckType)) {
                        tableObject = this.repository.findTable(tableName.nameHashCode64());
                    }
                    if (tableObject != null) {
                        columnDefinitionList = new ArrayList<SQLColumnDefinition>();
                    }
                    List<SQLExpr> columns = stmt.getColumns();
                    if (this.lexer.token() != Token.RPAREN) {
                        while (true) {
                            long hash;
                            String identName;
                            Token token;
                            if ((token = this.lexer.token()) == Token.IDENTIFIER) {
                                identName = this.lexer.stringVal();
                                hash = this.lexer.hash_lower();
                            } else if (token == Token.LITERAL_CHARS) {
                                identName = this.lexer.isEnabled(SQLParserFeature.IgnoreNameQuotes) ? this.lexer.stringVal() : '\'' + this.lexer.stringVal() + '\'';
                                hash = 0L;
                            } else if (token == Token.LITERAL_ALIAS) {
                                identName = this.lexer.stringVal();
                                if (this.lexer.isEnabled(SQLParserFeature.IgnoreNameQuotes)) {
                                    identName = SQLUtils.normalize(identName, this.dbType);
                                }
                                hash = 0L;
                            } else {
                                identName = this.lexer.stringVal();
                                hash = 0L;
                            }
                            this.lexer.nextTokenComma();
                            SQLExprImpl expr = new SQLIdentifierExpr(identName, hash);
                            while (this.lexer.token() == Token.DOT) {
                                this.lexer.nextToken();
                                String propertyName = this.lexer.stringVal();
                                this.lexer.nextToken();
                                expr = new SQLPropertyExpr(expr, propertyName);
                            }
                            expr.setParent(stmt);
                            columns.add(expr);
                            ++columnSize;
                            if (tableObject != null) {
                                SQLColumnDefinition columnDefinition = tableObject.findColumn(hash);
                                columnDefinitionList.add(columnDefinition);
                            }
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextTokenIdent();
                        }
                        columnSize = stmt.getColumns().size();
                        if (insertColumnsCache != null && tableName != null) {
                            String columnsString = this.lexer.subString(pos, this.lexer.pos() - pos);
                            ArrayList<SQLExpr> clonedColumns = new ArrayList<SQLExpr>(columnSize);
                            for (int i = 0; i < columns.size(); ++i) {
                                clonedColumns.add(columns.get(i).clone());
                            }
                            StringBuilder buf = new StringBuilder();
                            SQLASTOutputVisitor outputVisitor = SQLUtils.createOutputVisitor(buf, this.dbType);
                            outputVisitor.printInsertColumns(columns);
                            String formattedColumnsString = buf.toString();
                            long columnsFormattedStringHash = FnvHash.fnv1a_64_lower(formattedColumnsString);
                            insertColumnsCache.put(tableName.hashCode64(), columnsString, formattedColumnsString, clonedColumns);
                            stmt.setColumnsString(formattedColumnsString, columnsFormattedStringHash);
                        }
                    }
                    this.accept(Token.RPAREN);
                }
            }
        }
        List<SQLCommentHint> commentHints = null;
        if (this.lexer.token() == Token.HINT) {
            commentHints = this.exprParser.parseHints();
        } else if (this.lexer.token() == Token.LINE_COMMENT) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.VALUES || this.lexer.identifierEquals(FnvHash.Constants.VALUE)) {
            this.lexer.nextTokenLParen();
            if (this.lexer.isEnabled(SQLParserFeature.InsertReader)) {
                return stmt;
            }
            if (this.lexer.isEnabled(SQLParserFeature.InsertValueNative)) {
                this.parseValueClauseNative(stmt.getValuesList(), columnDefinitionList, columnSize, stmt);
            } else {
                this.parseValueClause(stmt.getValuesList(), columnDefinitionList, columnSize, stmt);
            }
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
            stmt.addValueCause(values);
            while (true) {
                SQLName name = this.exprParser.name();
                stmt.addColumn(name);
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                } else {
                    this.accept(Token.COLONEQ);
                }
                values.addValue(this.exprParser.expr());
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT) {
            select = this.exprParser.createSelectParser().select();
            if (commentHints != null && !commentHints.isEmpty()) {
                select.setHeadHint(commentHints.get(0));
            }
            select.setParent(stmt);
            stmt.setQuery(select);
        } else if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            select = this.exprParser.createSelectParser().select();
            select.setParent(stmt);
            stmt.setQuery(select);
            this.accept(Token.RPAREN);
        } else if (this.lexer.token() == Token.WITH) {
            SQLSelect query = this.exprParser.createSelectParser().select();
            stmt.setQuery(query);
        }
        return stmt;
    }

    @Override
    public SQLStatement parseWith() {
        Lexer.SavePoint sp = this.lexer.mark();
        SQLWithSubqueryClause with = this.parseWithQuery();
        if (this.lexer.token() == Token.UPDATE) {
            SQLUpdateStatement stmt = this.parseUpdateStatement();
            stmt.setWith(with);
            return stmt;
        }
        this.lexer.reset(sp);
        return super.parseWith();
    }

    @Override
    public SQLUpdateStatement parseUpdateStatement() {
        this.accept(Token.UPDATE);
        SQLUpdateStatement updateStatement = new SQLUpdateStatement();
        SQLSelectParser selectParser = this.exprParser.createSelectParser();
        SQLTableSource tableSource = selectParser.parseTableSource();
        updateStatement.setTableSource(tableSource);
        this.parseUpdateSet(updateStatement);
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLTableSource from = selectParser.parseTableSource();
            updateStatement.setFrom(from);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            updateStatement.setWhere(this.exprParser.expr());
        }
        return updateStatement;
    }

    @Override
    public SQLStatement parseDescribe() {
        if (this.lexer.token() != Token.DESC && !this.lexer.identifierEquals("DESCRIBE")) {
            throw new ParserException("expect DESC/DESCRIBE, actual " + (Object)((Object)this.lexer.token()), this.lexer.getPosLine(), this.lexer.getPosColumn());
        }
        this.lexer.nextToken();
        SQLDescribeStatement stmt = new SQLDescribeStatement();
        stmt.setDbType(this.dbType);
        stmt.setObject(this.exprParser.name());
        if (this.lexer.token() == Token.ALL) {
            stmt.setAll(true);
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCreateMaterializedView() {
        this.accept(Token.CREATE);
        this.acceptIdentifier("MATERIALIZED");
        this.accept(Token.VIEW);
        StarRocksCreateMaterializeViewStatement stmt = new StarRocksCreateMaterializeViewStatement();
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        stmt.setName(this.exprParser.name());
        while (true) {
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                SQLExpr expr = this.exprParser.expr();
                stmt.setPartitionByExpr(expr);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.DISTRIBUTED)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                SQLExpr hash = this.exprParser.expr();
                stmt.setDistributedBy(hash);
                if (!this.lexer.identifierEquals(FnvHash.Constants.BUCKETS)) continue;
                this.lexer.nextToken();
                int bucket = this.lexer.integerValue().intValue();
                stmt.setBuckets(bucket);
                this.lexer.nextToken();
                continue;
            }
            if (!this.lexer.identifierEquals("REFRESH")) break;
            stmt.setRefreshSchemaDesc(this.parseRefreshSchemaDesc());
        }
        if (this.lexer.token() == Token.ORDER) {
            stmt.setOrderBy(this.getExprParser().parseOrderBy());
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            stmt.setComment(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PROPERTIES)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLAssignItem item = this.exprParser.parseAssignItem();
                stmt.addProperty(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        this.accept(Token.AS);
        SQLSelect select = this.createSQLSelectParser().select();
        stmt.setQuery(select);
        return stmt;
    }

    @Override
    public SQLStatement parseAlter() {
        Lexer.SavePoint mark = this.lexer.mark();
        this.accept(Token.ALTER);
        if (this.lexer.identifierEquals("MATERIALIZED")) {
            this.lexer.nextToken();
            this.accept(Token.VIEW);
            return this.parseAlterMaterializedView();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ROUTINE)) {
            this.lexer.nextToken();
            this.accept(Token.LOAD);
            this.accept(Token.FOR);
            return this.parseAlterRoutineLoad();
        }
        if (this.lexer.token() == Token.LOAD) {
            this.lexer.nextToken();
            this.accept(Token.FOR);
            return this.parseAlterLoadFor();
        }
        this.lexer.reset(mark);
        return super.parseAlter();
    }

    private SQLStatement parseAlterLoadFor() {
        StarRocksAlterLoadStatement stmt = new StarRocksAlterLoadStatement();
        stmt.setJobName(this.exprParser.name());
        if (this.lexer.identifierEquals(Token.PROPERTIES.name())) {
            this.lexer.nextToken();
            ArrayList<SQLAssignItem> jobProperties = Lists.newArrayList();
            this.exprParser.parseAssignItem(jobProperties, stmt);
            stmt.setJobProperties(jobProperties);
        }
        return stmt;
    }

    private SQLStatement parseAlterRoutineLoad() {
        StarRocksAlterRoutineLoadStatement stmt = new StarRocksAlterRoutineLoadStatement();
        stmt.setJobName(this.exprParser.name());
        stmt.setLoadProperties(this.buildLoadProperties());
        if (this.lexer.identifierEquals(Token.PROPERTIES.name())) {
            this.lexer.nextToken();
            ArrayList<SQLAssignItem> jobProperties = Lists.newArrayList();
            this.exprParser.parseAssignItem(jobProperties, stmt);
            stmt.setJobProperties(jobProperties);
        }
        if (this.lexer.token() == Token.FROM) {
            this.accept(Token.FROM);
            stmt.setDataSourceProperties(this.buildDataSourceProperties());
        }
        return stmt;
    }

    private SQLStatement parseCreateRoutineLoad() {
        StarRocksCreateRoutineLoadStatement stmt = new StarRocksCreateRoutineLoadStatement();
        stmt.setJobName(this.exprParser.name());
        this.accept(Token.ON);
        stmt.setTableName(this.exprParser.name());
        stmt.setLoadProperties(this.buildLoadProperties());
        if (this.lexer.identifierEquals(Token.PROPERTIES.name())) {
            this.lexer.nextToken();
            ArrayList<SQLAssignItem> jobProperties = Lists.newArrayList();
            this.exprParser.parseAssignItem(jobProperties, stmt);
            stmt.setJobProperties(jobProperties);
        }
        if (this.lexer.token() == Token.FROM) {
            this.accept(Token.FROM);
            stmt.setDataSourceProperties(this.buildDataSourceProperties());
        }
        return stmt;
    }

    private StarRocksDataSourceProperties buildDataSourceProperties() {
        StarRocksDataSourceProperties properties = new StarRocksDataSourceProperties();
        properties.setDataSource(this.exprParser.name());
        ArrayList<SQLAssignItem> dataSourceProperties = Lists.newArrayList();
        this.exprParser.parseAssignItem(dataSourceProperties, properties);
        properties.setDataSourceProperties(dataSourceProperties);
        return properties;
    }

    private StarRocksLoadProperties buildLoadProperties() {
        StarRocksLoadProperties loadProperties = new StarRocksLoadProperties();
        if (this.lexer.identifierEquals(Token.COLUMNS.name())) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.TERMINATED) {
                this.accept(Token.TERMINATED);
                this.accept(Token.BY);
                loadProperties.setColumnSeparator(this.exprParser.expr());
            }
        }
        if (this.lexer.token() == Token.COMMA) {
            this.accept(Token.COMMA);
        }
        if (this.lexer.token() == Token.ROWS) {
            this.accept(Token.ROWS);
            if (this.lexer.token() == Token.TERMINATED) {
                this.accept(Token.TERMINATED);
                this.accept(Token.BY);
                loadProperties.setRowSeparator(this.exprParser.expr());
            }
        }
        if (this.lexer.token() == Token.COMMA) {
            this.accept(Token.COMMA);
        }
        if (this.lexer.identifierEquals(Token.COLUMNS.name())) {
            this.lexer.nextToken();
            loadProperties.setColumns(this.parseSqlExprList(loadProperties));
        }
        if (this.lexer.token() == Token.COMMA) {
            this.accept(Token.COMMA);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.accept(Token.WHERE);
            loadProperties.setWhere(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.COMMA) {
            this.accept(Token.COMMA);
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.accept(Token.PARTITION);
            loadProperties.setPartitions(this.parseSqlExprList(loadProperties));
        }
        if (this.lexer.token() == Token.COMMA) {
            this.accept(Token.COMMA);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TEMPORARY)) {
            this.lexer.nextToken();
            this.accept(Token.PARTITION);
            loadProperties.setTemporaryPartitions(this.parseSqlExprList(loadProperties));
        }
        return loadProperties;
    }

    private List<SQLExpr> parseSqlExprList(SQLObject parent) {
        this.accept(Token.LPAREN);
        ArrayList<SQLExpr> partitions = Lists.newArrayList();
        while (true) {
            SQLExpr expr = this.exprParser.expr();
            expr.setParent(parent);
            partitions.add(expr);
            if (this.lexer.token() != Token.COMMA) {
                if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.ESCAPE) continue;
                break;
            }
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return partitions;
    }

    protected SQLStatement parseAlterMaterializedView() {
        StarRocksAlterMaterializedViewStmt stmt = new StarRocksAlterMaterializedViewStmt();
        stmt.setTableSource(new SQLExprTableSource(this.exprParser.name()));
        if (this.lexer.identifierEquals(FnvHash.Constants.REFRESH)) {
            stmt.setRefreshSchemaDesc(this.parseRefreshSchemaDesc());
        } else if (this.lexer.token() == Token.RENAME) {
            this.accept(Token.RENAME);
            stmt.setNewName(this.exprParser.name());
        } else if (this.lexer.identifierEquals(FnvHash.Constants.ACTIVE)) {
            this.lexer.nextToken();
            stmt.setActive(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.INACTIVE)) {
            this.lexer.nextToken();
            stmt.setActive(false);
        } else if (this.lexer.token() == Token.SET) {
            this.accept(Token.SET);
            ArrayList<SQLAssignItem> items = Lists.newArrayList();
            this.exprParser.parseAssignItem(items, stmt);
            stmt.setItems(items);
        }
        return stmt;
    }

    protected RefreshSchemaDesc parseRefreshSchemaDesc() {
        RefreshSchemaDesc desc = new RefreshSchemaDesc();
        if (this.lexer.identifierEquals(FnvHash.Constants.REFRESH)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IMMEDIATE) {
                desc.setRefreshMoment(RefreshSchemaDesc.RefreshMoment.IMMEDIATE);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DEFERRED) {
                desc.setRefreshMoment(RefreshSchemaDesc.RefreshMoment.DEFERRED);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ASYNC)) {
                desc.setRefreshType(RefreshSchemaDesc.RefreshType.ASYNC);
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.START)) {
                    this.lexer.nextToken();
                    desc.setStarTime(this.exprParser.expr());
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.EVERY)) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    desc.setIntervalExpr(((StarRocksExprParser)this.exprParser).parseInterval());
                    this.accept(Token.RPAREN);
                }
            } else if (this.lexer.identifierEquals(FnvHash.Constants.MANUAL)) {
                desc.setRefreshType(RefreshSchemaDesc.RefreshType.MANUAL);
                this.lexer.nextToken();
            }
        }
        return desc;
    }

    @Override
    public SQLStatement parseAnalyze() {
        this.accept(Token.ANALYZE);
        StarRocksAnalyzeTableStatement stmt = new StarRocksAnalyzeTableStatement();
        if (this.lexer.token() == Token.FULL) {
            stmt.setAnalyzeTableType(StarRocksStatement.AnalyzeTableType.FULL);
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals(FnvHash.Constants.SAMPLE)) {
            stmt.setAnalyzeTableType(StarRocksStatement.AnalyzeTableType.SAMPLE);
            this.lexer.nextToken();
        }
        this.accept(Token.TABLE);
        stmt.setTableSource(new SQLExprTableSource(this.exprParser.name()));
        if (this.lexer.token() == Token.LPAREN) {
            this.accept(Token.LPAREN);
            while (true) {
                stmt.addColumn(this.exprParser.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        } else if (this.lexer.token() == Token.UPDATE) {
            stmt.setUpdateHistogram(true);
            this.accept(Token.UPDATE);
            this.acceptIdentifier("HISTOGRAM");
            this.accept(Token.ON);
            while (true) {
                stmt.addColumn(this.exprParser.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.WITH) {
            this.accept(Token.WITH);
            if (this.lexer.identifierEquals(FnvHash.Constants.SYNC)) {
                stmt.setAnalyzeModeType(StarRocksStatement.AnalyzeModeType.SYNC);
                this.lexer.nextToken();
                this.acceptIdentifier("MODE");
            } else if (this.lexer.identifierEquals(FnvHash.Constants.ASYNC)) {
                stmt.setAnalyzeModeType(StarRocksStatement.AnalyzeModeType.ASYNC);
                this.lexer.nextToken();
                this.acceptIdentifier("MODE");
            } else if (this.lexer.token() == Token.LITERAL_INT) {
                stmt.setBuckets(this.exprParser.integerExpr());
                this.acceptIdentifier("BUCKETS");
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PROPERTIES)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLAssignItem item = this.exprParser.parseAssignItem();
                stmt.addProperty(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return stmt;
    }

    @Override
    public void parseAlterAdd(SQLAlterTableStatement stmt) {
        Lexer.SavePoint savePoint = this.lexer.mark();
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
            this.lexer.nextToken();
            StarRocksAlterAddRollup addRollup = new StarRocksAlterAddRollup();
            while (true) {
                StarRocksRollup rollup = this.parseRollup();
                addRollup.addRollupDefinition(rollup);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            stmt.addItem(addRollup);
        } else {
            this.lexer.reset(savePoint);
            super.parseAlterAdd(stmt);
        }
    }

    @Override
    public void parseAlterDrop(SQLAlterTableStatement stmt) {
        Lexer.SavePoint savePoint = this.lexer.mark();
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
            this.lexer.nextToken();
            StarRocksAlterDropRollup dropRollup = new StarRocksAlterDropRollup();
            while (true) {
                StarRocksRollup rollup = this.parseRollup();
                dropRollup.addRollupDefinition(rollup);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            stmt.addItem(dropRollup);
        } else {
            this.lexer.reset(savePoint);
            super.parseAlterDrop(stmt);
        }
    }

    protected StarRocksRollup parseRollup() {
        StarRocksRollup rollup = new StarRocksRollup();
        rollup.setRollupName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            ArrayList<SQLName> columns = new ArrayList<SQLName>();
            while (true) {
                columns.add(this.exprParser.name());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            rollup.setColumns(columns);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            rollup.setFrom(this.exprParser.name());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PROPERTIES)) {
            this.lexer.nextToken();
            ArrayList<SQLAssignItem> properties = new ArrayList<SQLAssignItem>();
            this.accept(Token.LPAREN);
            while (true) {
                SQLAssignItem item = this.exprParser.parseAssignItem();
                properties.add(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            rollup.setProperties(properties);
        }
        return rollup;
    }

    protected StarRocksDropAnalyzeStatement parseDropAnalyze() {
        this.accept(Token.DROP);
        this.accept(Token.ANALYZE);
        StarRocksDropAnalyzeStatement stmt = new StarRocksDropAnalyzeStatement();
        stmt.setAnalyzeId(this.exprParser.expr());
        return stmt;
    }

    protected StarRocksDropStatsStatement parseDropStats() {
        this.accept(Token.DROP);
        StarRocksDropStatsStatement stmt = new StarRocksDropStatsStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.STATS)) {
            this.lexer.nextToken();
            stmt.setTableSource(new SQLExprTableSource(this.exprParser.expr()));
        }
        return stmt;
    }

    @Override
    public SQLStatement parseKill() {
        this.accept(Token.KILL);
        if (this.lexer.token() == Token.ANALYZE) {
            this.lexer.nextToken();
            StarRocksKillAnalyzeStatement stmt = new StarRocksKillAnalyzeStatement();
            stmt.setAnalyzeId(this.exprParser.expr());
            return stmt;
        }
        return super.parseKill();
    }

    @Override
    protected SQLDropTableStatement parseDropTable(boolean acceptDrop) {
        SQLDropTableStatement stmt = super.parseDropTable(acceptDrop);
        if (this.lexer.token() == Token.FORCE) {
            this.lexer.nextToken();
            stmt.setForce(true);
        }
        return stmt;
    }

    @Override
    protected SQLAlterTableItem parseAlterAddPartition() {
        StarRocksAlterTableAddPartition addPartition = new StarRocksAlterTableAddPartition();
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            addPartition.setIfNotExists(true);
        }
        StarRocksPartitionDesc partitionDesc = this.getSQLCreateTableParser().parsePartitionDescHelper();
        addPartition.setPartitionDesc(partitionDesc);
        if (this.lexer.token() == Token.LPAREN) {
            this.exprParser.parseAssignItem(addPartition.getProperties(), addPartition);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DISTRIBUTED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLExpr hash = this.exprParser.expr();
            addPartition.setDistributedBy(hash);
            if (this.lexer.identifierEquals(FnvHash.Constants.BUCKETS)) {
                this.lexer.nextToken();
                int bucket = this.lexer.integerValue().intValue();
                addPartition.setBuckets(bucket);
                this.lexer.nextToken();
            }
        }
        return addPartition;
    }
}

