/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.starrocks.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLIndexDefinition;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksBitmapDataType;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksColumnIndexDefinition;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksMaxValue;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.expr.StarRocksCharExpr;
import com.alibaba.fastsql.sql.dialect.starrocks.parser.StarRocksLexer;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.Arrays;

public class StarRocksExprParser
extends MySqlExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;

    public StarRocksExprParser(String sql) {
        this(new StarRocksLexer(sql));
        this.lexer.nextToken();
    }

    public StarRocksExprParser(Lexer lexer) {
        super(lexer);
        this.dbType = DbType.starrocks;
    }

    public StarRocksExprParser(String sql, boolean keepComments) {
        this(new StarRocksLexer(sql, true, keepComments));
        this.dbType = DbType.starrocks;
        this.lexer.nextToken();
    }

    public StarRocksExprParser(String sql, boolean skipComment, boolean keepComments) {
        this(new StarRocksLexer(sql, skipComment, keepComments));
        this.dbType = DbType.starrocks;
        this.lexer.nextToken();
    }

    public StarRocksExprParser(String sql, SQLParserFeature ... features) {
        super(new StarRocksLexer(sql, features));
        this.dbType = DbType.starrocks;
        this.lexer.nextToken();
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        String text = this.lexer.stringVal();
        for (int i = 0; i < AGGREGATE_FUNCTIONS.length; ++i) {
            if (!text.equalsIgnoreCase(AGGREGATE_FUNCTIONS[i])) continue;
            StarRocksCharExpr aggType = new StarRocksCharExpr(text);
            column.setAggType(aggType);
            this.lexer.nextToken();
        }
        return super.parseColumnRest(column);
    }

    @Override
    protected SQLExpr parseAliasExpr(String alias) {
        if (this.isEnabled(SQLParserFeature.KeepNameQuotes)) {
            return new SQLIdentifierExpr(alias);
        }
        Lexer newLexer = new Lexer(alias);
        newLexer.nextTokenValue();
        SQLCharExpr expr = new SQLCharExpr(newLexer.stringVal());
        if (alias != null && alias.startsWith("\"")) {
            expr.setQuoteType('\"');
        }
        return expr;
    }

    protected StarRocksColumnIndexDefinition parseIndexDefinition() {
        this.accept(Token.INDEX);
        StarRocksColumnIndexDefinition index = this.createIndexDefinition();
        index.setName(this.name());
        this.accept(Token.LPAREN);
        ArrayList<SQLExpr> columns = new ArrayList<SQLExpr>();
        this.exprList(columns, index);
        index.setColumnList(columns);
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            this.accept(Token.BITMAP);
            index.setUsingBitmap(true);
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            SQLCharExpr indexComment = new SQLCharExpr(this.lexer.stringVal());
            index.setComment(indexComment);
            this.lexer.nextToken();
        }
        return index;
    }

    public StarRocksColumnIndexDefinition createIndexDefinition() {
        StarRocksColumnIndexDefinition column = new StarRocksColumnIndexDefinition();
        column.setDbType(this.dbType);
        return column;
    }

    @Override
    public SQLColumnDefinition parseColumn() {
        return this.parseColumn(null);
    }

    @Override
    public SQLExpr parseInterval() {
        return super.parseInterval();
    }

    @Override
    public SQLAssignItem parseAssignItem() {
        return super.parseAssignItem();
    }

    @Override
    public void parseIndex(SQLIndexDefinition indexDefinition) {
        super.parseIndex(indexDefinition);
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BITMAP) {
                indexDefinition.setUsingType(this.lexer.token());
                this.lexer.nextToken();
            } else {
                this.printError(Token.BITMAP);
            }
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            indexDefinition.setComment(this.expr());
        }
    }

    @Override
    public SQLExpr expr() {
        if (this.lexer.token() == Token.MAXVALUE) {
            this.lexer.nextToken();
            return StarRocksMaxValue.INSTANCE;
        }
        return super.expr();
    }

    @Override
    public SQLDataType parseDataType(boolean restrict) {
        if (this.lexer.token() == Token.BITMAP) {
            this.lexer.nextToken();
            StarRocksBitmapDataType dataType = new StarRocksBitmapDataType();
            dataType.setDbType(this.dbType);
            return dataType;
        }
        return super.parseDataType(restrict);
    }

    static {
        String[] strings = new String[]{"SUM", "MAX", "MIN", "REPLACE", "HLL_UNION", "BITMAP_UNION", "REPLACE_IF_NOT_NULL"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            StarRocksExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

