/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.starrocks.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLConstraint;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlCreateTableParser;
import com.alibaba.fastsql.sql.dialect.oracle.parser.OracleSelectParser;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksBulkRangeDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksColumnIndexDefinition;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksFixedRangeDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksLessThanRangeDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksMaxValue;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.StarRocksPartitionDesc;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.parser.StarRocksExprParser;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class StarRocksCreateTableParser
extends MySqlCreateTableParser {
    public StarRocksCreateTableParser(Lexer lexer) {
        super(new StarRocksExprParser(lexer));
    }

    public StarRocksCreateTableParser(String sql) {
        super(new StarRocksExprParser(sql));
    }

    public StarRocksCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public StarRocksCreateTableStatement parseCreateTable(boolean acceptCreate) {
        StarRocksCreateTableStatement createTable = this.newCreateStatement();
        if (acceptCreate) {
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                createTable.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.CREATE);
        }
        if (this.lexer.identifierEquals("GLOBAL")) {
            this.lexer.nextToken();
            if (!this.lexer.identifierEquals("TEMPORARY")) throw new ParserException("syntax error " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
        } else if (this.lexer.token() == Token.IDENTIFIER && this.lexer.stringVal().equalsIgnoreCase("LOCAL")) {
            this.lexer.nextToken();
            if (this.lexer.token() != Token.IDENTIFIER || !this.lexer.stringVal().equalsIgnoreCase("TEMPORAY")) throw new ParserException("syntax error. " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.LOCAL_TEMPORARY);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DIMENSION)) {
            this.lexer.nextToken();
            createTable.setDimension(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.nextToken();
            createTable.setExternal(true);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createTable.setIfNotExiists(true);
        }
        createTable.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLName name = this.exprParser.name();
            createTable.setLike(name);
            return createTable;
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            do {
                SQLColumnDefinition column;
                Token token = this.lexer.token();
                if (this.lexer.identifierEquals(FnvHash.Constants.SUPPLEMENTAL) && DbType.oracle == this.dbType) {
                    SQLTableElement element = this.parseCreateTableSupplementalLogingProps();
                    element.setParent(createTable);
                    createTable.getTableElementList().add(element);
                } else if (token == Token.IDENTIFIER || token == Token.LITERAL_ALIAS) {
                    column = this.exprParser.parseColumn();
                    column.setParent(createTable);
                    createTable.getTableElementList().add(column);
                } else if (token == Token.PRIMARY || token == Token.UNIQUE || token == Token.CHECK || token == Token.CONSTRAINT || token == Token.FOREIGN) {
                    SQLConstraint constraint = this.exprParser.parseConstaint();
                    constraint.setParent(createTable);
                    createTable.getTableElementList().add((SQLTableElement)((Object)constraint));
                } else {
                    if (token == Token.TABLESPACE) {
                        throw new ParserException("TODO " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
                    }
                    if (token == Token.INDEX) {
                        StarRocksColumnIndexDefinition index = this.getExprParser().parseIndexDefinition();
                        createTable.getTableElementList().add(index);
                    } else {
                        column = this.exprParser.parseColumn();
                        createTable.getTableElementList().add(column);
                    }
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token() != Token.RPAREN);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals(FnvHash.Constants.INHERITS)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLName inherits = this.exprParser.name();
                createTable.setInherits(new SQLExprTableSource(inherits));
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            SQLSelect select = DbType.oracle == this.dbType ? new OracleSelectParser(this.exprParser).select() : this.createSQLSelectParser().select();
            createTable.setSelect(select);
        }
        if (this.lexer.token() == Token.WITH && (DbType.postgresql == this.dbType || DbType.greenplum == this.dbType || DbType.adb_pg == this.dbType)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(createTable.getTableOptions(), createTable, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            this.lexer.nextToken();
            createTable.setTablespace(this.exprParser.name());
        }
        this.parseCreateTableRest(createTable);
        return createTable;
    }

    @Override
    public void parseCreateTableRest(SQLCreateTableStatement stmt) {
        StarRocksCreateTableStatement srStmt = (StarRocksCreateTableStatement)stmt;
        if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            srStmt.setEngine(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DUPLICATE) || this.lexer.identifierEquals(FnvHash.Constants.AGGREGATE) || this.lexer.token() == Token.UNIQUE || this.lexer.token() == Token.PRIMARY) {
            SQLName model;
            if (this.lexer.token() == Token.PRIMARY) {
                model = new SQLIdentifierExpr(Token.PRIMARY.name);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.UNIQUE) {
                model = new SQLIdentifierExpr(Token.UNIQUE.name);
                this.lexer.nextToken();
            } else {
                model = this.exprParser.name();
            }
            srStmt.setModelKey(model);
            this.accept(Token.KEY);
            this.accept(Token.LPAREN);
            this.exprParser.exprList(srStmt.getModelKeyParameters(), srStmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            srStmt.setComment(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLExpr expr = this.exprParser.expr();
            srStmt.setPartitionBy(expr);
            List<StarRocksLessThanRangeDesc> lessThanRangeDescList = srStmt.getLessThanRangeDescList();
            List<StarRocksFixedRangeDesc> fixedRangeDescList = srStmt.getFixedRangeDescList();
            if (this.lexer.token() == Token.LPAREN) {
                this.accept(Token.LPAREN);
                while (true) {
                    StarRocksPartitionDesc desc;
                    if ((desc = this.parsePartitionDesc()) instanceof StarRocksLessThanRangeDesc) {
                        lessThanRangeDescList.add((StarRocksLessThanRangeDesc)desc);
                    } else if (desc instanceof StarRocksFixedRangeDesc) {
                        fixedRangeDescList.add((StarRocksFixedRangeDesc)desc);
                    } else if (desc instanceof StarRocksBulkRangeDesc) {
                        srStmt.setBulkRangeDesc((StarRocksBulkRangeDesc)desc);
                    }
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DISTRIBUTED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLExpr hash = this.exprParser.expr();
            srStmt.setDistributedBy(hash);
            if (this.lexer.identifierEquals(FnvHash.Constants.BUCKETS)) {
                this.lexer.nextToken();
                int bucket = this.lexer.integerValue().intValue();
                stmt.setBuckets(bucket);
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.ORDER) {
            srStmt.setOrderBy(this.exprParser.parseOrderBy());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PROPERTIES)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(srStmt.getTblProperties(), srStmt, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.BROKER)) {
            this.lexer.nextToken();
            this.acceptIdentifier(Token.PROPERTIES.name);
            this.accept(Token.LPAREN);
            this.parseAssignItems(srStmt.getBrokerProperties(), srStmt, false);
            this.accept(Token.RPAREN);
        }
    }

    public StarRocksPartitionDesc parsePartitionDescHelper() {
        SQLExpr partitionName = this.exprParser.expr();
        this.accept(Token.VALUES);
        if (this.lexer.identifierEquals(FnvHash.Constants.LESS)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.THAN)) {
                this.lexer.nextToken();
                StarRocksLessThanRangeDesc desc = new StarRocksLessThanRangeDesc();
                desc.setPartitionName(partitionName);
                if (this.lexer.token() == Token.MAXVALUE) {
                    this.lexer.nextToken();
                    desc.getUpperList().add(StarRocksMaxValue.INSTANCE);
                } else {
                    desc.getUpperList().addAll(this.parseSqlExprList(desc));
                }
                return desc;
            }
        } else if (this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            StarRocksFixedRangeDesc desc = new StarRocksFixedRangeDesc();
            desc.setPartitionName(partitionName);
            desc.getLowerList().addAll(this.parseSqlExprList(desc));
            this.accept(Token.COMMA);
            desc.getUpperList().addAll(this.parseSqlExprList(desc));
            this.accept(Token.RPAREN);
            return desc;
        }
        return null;
    }

    public StarRocksPartitionDesc parsePartitionDesc() {
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            return this.parsePartitionDescHelper();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.START)) {
            StarRocksBulkRangeDesc rangeDesc = new StarRocksBulkRangeDesc();
            this.acceptIdentifier("START");
            this.accept(Token.LPAREN);
            rangeDesc.setPartitionStart(this.exprParser.expr());
            this.accept(Token.RPAREN);
            this.accept(Token.END);
            this.accept(Token.LPAREN);
            rangeDesc.setPartitionEnd(this.exprParser.expr());
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals(FnvHash.Constants.EVERY)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                rangeDesc.setEveryInterval(((StarRocksExprParser)this.exprParser).parseInterval());
                this.accept(Token.RPAREN);
            }
            return rangeDesc;
        }
        return null;
    }

    @Override
    protected StarRocksCreateTableStatement newCreateStatement() {
        return new StarRocksCreateTableStatement();
    }

    @Override
    public StarRocksExprParser getExprParser() {
        return (StarRocksExprParser)this.exprParser;
    }

    private List<SQLExpr> parseSqlExprList(SQLObject parent) {
        this.accept(Token.LPAREN);
        ArrayList<SQLExpr> partitions = Lists.newArrayList();
        while (true) {
            SQLExpr expr = this.exprParser.expr();
            expr.setParent(parent);
            partitions.add(expr);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return partitions;
    }
}

