/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.starrocks.ast.statement;

import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.ast.statement.StarRocksStatement;
import com.alibaba.fastsql.sql.dialect.starrocks.visitor.StarRocksASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class StarRocksInsertStatement
extends SQLInsertStatement
implements StarRocksStatement {
    protected List<SQLCommentHint> hints;
    protected List<SQLExpr> temporaryPartitions;
    protected SQLName label;

    @Override
    public void accept0(SQLASTVisitor v) {
        if (v instanceof StarRocksASTVisitor) {
            this.accept0((StarRocksASTVisitor)v);
        } else {
            super.accept0(v);
        }
    }

    @Override
    public void accept0(StarRocksASTVisitor v) {
        if (v.visit(this)) {
            this.acceptChild(v);
        }
        v.endVisit(this);
    }

    @Override
    protected void acceptChild(SQLASTVisitor visitor) {
        super.acceptChild(visitor);
        this.acceptChild(visitor, this.hints);
        this.acceptChild(visitor, this.temporaryPartitions);
        this.acceptChild(visitor, this.label);
    }

    public void cloneTo(StarRocksInsertStatement x) {
        super.cloneTo(x);
        if (this.hints != null) {
            x.setHints(this.hints.stream().map(hint -> hint == null ? null : hint.clone()).collect(Collectors.toList()));
        }
        if (this.temporaryPartitions != null) {
            for (SQLExpr temporaryPartition : this.temporaryPartitions) {
                x.addTemporaryPartitions(temporaryPartition == null ? null : temporaryPartition.clone());
            }
        }
        if (this.label != null) {
            x.setLabel(this.label.clone());
        }
    }

    @Override
    public SQLInsertStatement clone() {
        StarRocksInsertStatement x = new StarRocksInsertStatement();
        this.cloneTo(x);
        return x;
    }

    public List<SQLCommentHint> getHints() {
        return this.hints;
    }

    public void setHints(List<SQLCommentHint> x) {
        if (x != null) {
            for (int i = 0; i < x.size(); ++i) {
                x.get(i).setParent(this);
            }
        }
        this.hints = x;
    }

    public void addTemporaryPartitions(SQLExpr partition) {
        if (partition != null) {
            partition.setParent(this);
        }
        if (this.temporaryPartitions == null) {
            this.temporaryPartitions = new ArrayList<SQLExpr>();
        }
        this.temporaryPartitions.add(partition);
    }

    public List<SQLExpr> getTemporaryPartitions() {
        return this.temporaryPartitions;
    }

    public SQLName getLabel() {
        return this.label;
    }

    public void setLabel(SQLName label) {
        if (label != null) {
            label.setParent(this);
        }
        this.label = label;
    }

    public int getHintsSize() {
        if (this.hints == null) {
            return 0;
        }
        return this.hints.size();
    }
}

