/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.starrocks.ast;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.dialect.starrocks.visitor.StarRocksASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.List;
import java.util.stream.Collectors;

public class StarRocksColumnIndexDefinition
extends SQLColumnDefinition {
    protected boolean usingBitmap = false;
    protected List<SQLExpr> columnList;

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof StarRocksASTVisitor) {
            this.accept0((StarRocksASTVisitor)visitor);
        } else {
            super.accept0(visitor);
        }
    }

    protected void accept0(StarRocksASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.name);
            this.acceptChild((SQLASTVisitor)visitor, this.columnList);
            this.acceptChild((SQLASTVisitor)visitor, this.comment);
        }
        visitor.endVisit(this);
    }

    @Override
    public StarRocksColumnIndexDefinition clone() {
        StarRocksColumnIndexDefinition x = new StarRocksColumnIndexDefinition();
        x.setDbType(this.dbType);
        if (this.name != null) {
            x.setName(this.name.clone());
        }
        x.setUsingBitmap(this.usingBitmap);
        if (this.columnList != null) {
            x.setColumnList(this.columnList.stream().map(expr -> expr == null ? null : expr.clone()).collect(Collectors.toList()));
        }
        if (this.comment != null) {
            x.setComment(this.comment.clone());
        }
        return x;
    }

    public boolean isUsingBitmap() {
        return this.usingBitmap;
    }

    public void setUsingBitmap(boolean usingBitmap) {
        this.usingBitmap = usingBitmap;
    }

    public List<SQLExpr> getColumnList() {
        return this.columnList;
    }

    public void setColumnList(List<SQLExpr> columnList) {
        this.columnList = columnList;
    }
}

