/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.sqlserver.parser;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.statement.SQLExprHint;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.sqlserver.ast.SQLServerTop;
import com.alibaba.fastsql.sql.dialect.sqlserver.parser.SQLServerExprParser;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLSelectListCache;
import com.alibaba.fastsql.sql.parser.SQLSelectParser;
import com.alibaba.fastsql.sql.parser.Token;

public class SQLServerSelectParser
extends SQLSelectParser {
    public SQLServerSelectParser(String sql) {
        super(new SQLServerExprParser(sql));
    }

    public SQLServerSelectParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public SQLServerSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser, selectListCache);
    }

    @Override
    public SQLSelect select() {
        SQLSelect select;
        block17: {
            select = new SQLSelect();
            this.lexer.setStartPos(select);
            if (this.lexer.token() == Token.WITH) {
                SQLWithSubqueryClause with = this.parseWith();
                select.setWithSubQuery(with);
            }
            select.setQuery(this.query());
            select.setOrderBy(this.parseOrderBy());
            if (select.getOrderBy() == null) {
                select.setOrderBy(this.parseOrderBy());
            }
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("BROWSE")) {
                    this.lexer.nextToken();
                    select.setForBrowse(true);
                } else {
                    if (this.lexer.identifierEquals("XML")) {
                        this.lexer.nextToken();
                        while (true) {
                            if (this.lexer.identifierEquals("AUTO") || this.lexer.identifierEquals("TYPE") || this.lexer.identifierEquals("XMLSCHEMA")) {
                                select.getForXmlOptions().add(this.lexer.stringVal());
                                this.lexer.nextToken();
                            } else if (this.lexer.identifierEquals("ELEMENTS")) {
                                this.lexer.nextToken();
                                if (this.lexer.identifierEquals("XSINIL")) {
                                    this.lexer.nextToken();
                                    select.getForXmlOptions().add("ELEMENTS XSINIL");
                                } else {
                                    select.getForXmlOptions().add("ELEMENTS");
                                }
                            } else {
                                if (!this.lexer.identifierEquals("PATH")) break block17;
                                SQLExpr xmlPath = this.exprParser.expr();
                                select.setXmlPath(xmlPath);
                            }
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                            break block17;
                            break;
                        }
                    }
                    throw new ParserException("syntax error, not support option : " + (Object)((Object)this.lexer.token()) + ", " + this.lexer.info());
                }
            }
        }
        if (this.lexer.identifierEquals("OFFSET")) {
            this.lexer.nextToken();
            SQLExpr offset = this.expr();
            this.acceptIdentifier("ROWS");
            select.setOffset(offset);
            if (this.lexer.token() == Token.FETCH) {
                this.lexer.nextToken();
                this.acceptIdentifier("NEXT");
                SQLExpr rowCount = this.expr();
                this.acceptIdentifier("ROWS");
                this.acceptIdentifier("ONLY");
                select.setRowCount(rowCount);
            }
        }
        return select;
    }

    @Override
    public SQLSelectQuery query(SQLObject parent, boolean acceptUnion) {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select, acceptUnion);
        }
        SQLServerSelectQueryBlock queryBlock = new SQLServerSelectQueryBlock();
        if (this.lexer.token() == Token.SELECT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.DISTINCT) {
                queryBlock.setDistionOption(2);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.ALL) {
                queryBlock.setDistionOption(1);
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.TOP) {
                SQLServerTop top = this.createExprParser().parseTop();
                queryBlock.setTop(top);
            }
            this.parseSelectList(queryBlock);
        }
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            SQLTableSource into = this.parseTableSource();
            queryBlock.setInto((SQLExprTableSource)into);
        }
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        queryBlock.setOrderBy(this.exprParser.parseOrderBy());
        this.parseFetchClause(queryBlock);
        return this.queryRest(queryBlock, acceptUnion);
    }

    protected SQLServerExprParser createExprParser() {
        return new SQLServerExprParser(this.lexer);
    }

    @Override
    protected SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLExpr expr = this.expr();
                SQLExprHint hint = new SQLExprHint(expr);
                hint.setParent(tableSource);
                tableSource.getHints().add(hint);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return super.parseTableSourceRest(tableSource);
    }
}

