/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.spark.visitor;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLAdhocTableSource;
import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSampling;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveMsckRepairStatement;
import com.alibaba.fastsql.sql.dialect.hive.visitor.HiveOutputVisitor;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkCacheTableStatement;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkClearCacheStatement;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkExplainStatement;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkExprTableSource;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkInsertStatement;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkReplaceViewStatement;
import com.alibaba.fastsql.sql.dialect.spark.visitor.SparkASTVisitor;
import java.util.List;
import java.util.Map;

public class SparkOutputVisitor
extends HiveOutputVisitor
implements SparkASTVisitor {
    public SparkOutputVisitor(Appendable appender) {
        super(appender, DbType.spark);
    }

    public SparkOutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
    }

    public SparkOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.spark;
    }

    @Override
    public boolean visit(SQLAlterTableDropColumnItem x) {
        this.print0(this.ucase ? "DROP " : "drop ");
        if (x.isDropColumns()) {
            this.print0(this.ucase ? "COLUMNS " : "columns ");
        } else {
            this.print0(this.ucase ? "COLUMN " : "column ");
        }
        if (x.isBracket()) {
            this.print("(");
        }
        this.printAndAccept(x.getColumns(), ", ");
        if (x.isBracket()) {
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(SparkReplaceViewStatement x) {
        List<SQLAssignItem> tblProperties;
        SQLLiteralExpr comment;
        String sqlSecurity;
        SQLName definer;
        this.print0(this.ucase ? "REPLACE " : "replace ");
        if (SparkReplaceViewStatement.Type.GLOBAL_TEMPORARY == x.getType()) {
            this.print0(this.ucase ? "GLOBAL TEMPORARY " : "global temporary ");
        } else if (SparkReplaceViewStatement.Type.TEMPORARY == x.getType()) {
            this.print0(this.ucase ? "TEMPORARY " : "temporary ");
        }
        ++this.indentCount;
        String algorithm = x.getAlgorithm();
        if (algorithm != null && algorithm.length() > 0) {
            this.print0(this.ucase ? "ALGORITHM = " : "algorithm = ");
            this.print0(algorithm);
            this.println();
        }
        if ((definer = x.getDefiner()) != null) {
            this.print0(this.ucase ? "DEFINER = " : "definer = ");
            definer.accept(this);
            this.println();
        }
        if ((sqlSecurity = x.getSqlSecurity()) != null && sqlSecurity.length() > 0) {
            this.print0(this.ucase ? "SQL SECURITY = " : "sql security = ");
            this.print0(sqlSecurity);
            this.println();
        }
        --this.indentCount;
        if (x.isLogicalView()) {
            this.print0(this.ucase ? "LOGICALVIEW " : "logicalview ");
        } else {
            this.print0(this.ucase ? "VIEW " : "view ");
        }
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        x.getTableSource().accept(this);
        List<SQLTableElement> columns = x.getColumns();
        if (columns.size() > 0) {
            this.print0(" (");
            ++this.indentCount;
            this.println();
            for (int i = 0; i < columns.size(); ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                columns.get(i).accept(this);
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        if ((comment = x.getComment()) != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            comment.accept(this);
        }
        if ((tblProperties = x.getTblProperties()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "TBLPROPERTIES (" : "tblproperties (");
            this.incrementIndent();
            this.println();
            int i = 0;
            for (SQLAssignItem property : tblProperties) {
                char c0;
                if (i != 0) {
                    this.print(",");
                    this.println();
                }
                String key = property.getTarget().toString();
                boolean unquote = false;
                if (key.length() > 0 && (c0 = key.charAt(0)) != '\"' && c0 != '`' && c0 != '\'') {
                    unquote = true;
                }
                if (unquote) {
                    this.print('\'');
                }
                this.print0(key);
                if (unquote) {
                    this.print('\'');
                }
                this.print0(" = ");
                property.getValue().accept(this);
                ++i;
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        this.println();
        this.print0(this.ucase ? "AS" : "as");
        this.println();
        x.getSubQuery().accept(this);
        if (x.isWithCheckOption()) {
            this.println();
            this.print0(this.ucase ? "WITH CHECK OPTION" : "with check option");
        }
        return false;
    }

    @Override
    public boolean visit(HiveMsckRepairStatement x) {
        SQLIdentifierExpr optionType;
        SQLExprTableSource table;
        List<SQLCommentHint> headHints = x.getHeadHintsDirect();
        if (headHints != null) {
            for (SQLCommentHint hint : headHints) {
                hint.accept(this);
                this.println();
            }
        }
        if (x.isHasMsck()) {
            this.print0(this.ucase ? "MSCK REPAIR" : "msck repair");
        } else {
            this.print(this.ucase ? "REPAIR" : "repair");
        }
        SQLName database = x.getDatabase();
        if (database != null) {
            this.print0(this.ucase ? " DATABASE " : " database ");
            database.accept(this);
        }
        if ((table = x.getTable()) != null) {
            this.print0(this.ucase ? " TABLE " : " table ");
            table.accept(this);
        }
        if ((optionType = x.getOptionType()) != null) {
            this.print0(" ");
            this.print0(this.ucase ? optionType.getName().toUpperCase() : optionType.getLowerName());
            this.print0(this.ucase ? " PARTITIONS" : " partitions");
        }
        return false;
    }

    @Override
    public boolean visit(SparkInsertStatement x) {
        List<SQLExpr> columns;
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            this.visit(with);
            this.println();
        }
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
        } else {
            this.print0(this.ucase ? "INSERT INTO TABLE " : "insert into table ");
        }
        x.getTableSource().accept(this);
        List<SQLAssignItem> partitions = x.getPartitions();
        int partitionSize = partitions.size();
        if (partitionSize > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            for (int i = 0; i < partitionSize; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLAssignItem assign = partitions.get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print(assign.printToken());
                assign.getValue().accept(this);
            }
            this.print(')');
        }
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? " IF NOT EXISTS" : " if not exists");
        }
        if ((columns = x.getColumns()).size() > 0) {
            if (partitionSize > 0) {
                this.print(' ');
            }
            this.print("(");
            this.printAndAccept(columns, ", ");
            this.print(')');
        }
        if (x.getReplaceWhere() != null) {
            this.println();
            this.print0(this.ucase ? "REPLACE WHERE " : "replace where ");
            x.getReplaceWhere().accept(this);
        }
        this.println();
        SQLSelect select = x.getQuery();
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        if (select != null) {
            select.accept(this);
        } else if (!valuesList.isEmpty()) {
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(valuesList, ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SparkExplainStatement x) {
        this.print0(this.ucase ? "EXPLAIN" : "explain");
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        if (x.isExtended()) {
            this.print0(this.ucase ? " EXTENDED" : " extended");
        } else if (x.isCodegen()) {
            this.print0(this.ucase ? " CODEGEN" : " codegen");
        } else if (x.isCost()) {
            this.print0(this.ucase ? " COST" : " cost");
        } else if (x.isFormatted()) {
            this.print0(this.ucase ? " FORMATTED" : " formatted");
        }
        this.println();
        x.getStatement().accept(this);
        return false;
    }

    @Override
    public boolean visit(SparkExprTableSource x) {
        SQLExpr sqlExpr;
        SQLTableSampling sampling;
        this.printTableSourceExpr(x.getExpr());
        if (x.getTimestampAsOf() != null) {
            this.print(this.ucase ? " TIMESTAMP AS OF " : " timestamp as of ");
            x.getTimestampAsOf().accept(this);
        }
        if (x.getVersionAsOf() != null) {
            this.print(this.ucase ? " VERSION AS OF " : " version as of ");
            this.print(x.getVersionAsOf());
        }
        if ((sampling = x.getSampling()) != null) {
            this.print(' ');
            sampling.accept(this);
        }
        String alias = x.getAlias();
        List<SQLName> columns = x.getColumnsDirect();
        if (alias != null) {
            if (columns != null && columns.size() > 0 || x.hasAs()) {
                this.print0(this.ucase ? " AS " : " as ");
            } else {
                this.print(' ');
            }
            this.print0(alias);
        }
        if ((sqlExpr = x.getAliasExpr()) != null) {
            if (x.hasAs()) {
                this.print0(this.ucase ? " AS " : " as ");
            } else {
                this.print(' ');
            }
            sqlExpr.accept(this);
        }
        if (columns != null && columns.size() > 0) {
            this.print(" (");
            this.printAndAccept(columns, ", ");
            this.print(')');
        }
        if (this.isPrettyFormat() && x.hasAfterComment()) {
            this.print(' ');
            this.printlnComment(x.getAfterCommentsDirect());
        }
        return false;
    }

    @Override
    public boolean visit(SparkClearCacheStatement x) {
        this.print(this.ucase ? "CLEAR CACHE" : "clear cache");
        return false;
    }

    @Override
    public boolean visit(SparkCacheTableStatement x) {
        this.print(this.ucase ? "CACHE " : "cache ");
        if (x.isLazy()) {
            this.print(this.ucase ? "LAZY " : "lazy ");
        }
        this.print(this.ucase ? "TABLE " : "table ");
        x.getTableSource().accept(this);
        if (x.getOptions() != null && !x.getOptions().isEmpty()) {
            this.println();
            this.print(this.ucase ? "OPTIONS (" : "options (");
            this.printAndAccept(x.getOptions(), ", ");
            this.print(")");
        }
        if (x.getQuery() != null) {
            this.println();
            this.print(this.ucase ? "AS" : "as");
            this.println();
            x.getQuery().accept(this);
        }
        return false;
    }

    @Override
    protected void printCreateTable(HiveCreateTableStatement x, boolean printSelect) {
        SQLExpr metaLifeCycle;
        List<SQLAssignItem> tblProperties;
        SQLExpr location;
        List<SQLExpr> withSerdeproperties;
        SQLExpr storedBy;
        SQLExpr storedAs;
        int buckets;
        List<SQLSelectOrderByItem> sortedBy;
        Map<String, SQLObject> serdeProperties;
        SQLExternalRecordFormat format;
        List<SQLExpr> skewedBy;
        int partitionSize;
        List<SQLAssignItem> mappedBy;
        SQLExpr comment;
        List<SQLAssignItem> tableOptions;
        SQLExpr using;
        SQLExprTableSource like;
        SQLCreateTableStatement.Type tableType;
        SQLObject parent = x.getParent();
        if (!(parent instanceof SQLAdhocTableSource)) {
            this.print0(this.ucase ? "CREATE " : "create ");
        }
        if (x.isExternal()) {
            this.print0(this.ucase ? "EXTERNAL " : "external ");
        }
        if (SQLCreateTableStatement.Type.TEMPORARY.equals((Object)(tableType = x.getType()))) {
            this.print0(this.ucase ? "TEMPORARY " : "temporary ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        this.printTableSourceExpr(x.getName());
        this.printTableElements(x.getTableElementList());
        this.printPartitionBy(x);
        this.printCached(x);
        SQLExprTableSource inherits = x.getInherits();
        if (inherits != null) {
            this.print0(this.ucase ? " INHERITS (" : " inherits (");
            inherits.accept(this);
            this.print(')');
        }
        if ((like = x.getLike()) != null) {
            this.println();
            this.print0(this.ucase ? "LIKE " : "like ");
            like.accept(this);
        }
        if ((using = x.getUsing()) != null) {
            this.println();
            this.print0(this.ucase ? "USING " : "using ");
            using.accept(this);
        }
        if ((tableOptions = x.getTableOptions()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "OPTIONS (" : "options (");
            this.incrementIndent();
            this.println();
            int i = 0;
            for (SQLAssignItem option : tableOptions) {
                char c0;
                if (i != 0) {
                    this.print(",");
                    this.println();
                }
                String key = option.getTarget().toString();
                boolean unquote = false;
                if (key.length() > 0 && (c0 = key.charAt(0)) != '\"' && c0 != '`' && c0 != '\'') {
                    unquote = true;
                }
                if (unquote) {
                    this.print('\'');
                }
                this.print0(key);
                if (unquote) {
                    this.print('\'');
                }
                this.print0(" = ");
                option.getValue().accept(this);
                ++i;
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        if ((comment = x.getComment()) != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            comment.accept(this);
        }
        if ((mappedBy = x.getMappedBy()) != null && mappedBy.size() > 0) {
            this.println();
            this.print0(this.ucase ? "MAPPED BY (" : "mapped by (");
            this.printAndAccept(mappedBy, ", ");
            this.print0(this.ucase ? ")" : ")");
        }
        if ((partitionSize = x.getPartitionColumns().size()) > 0) {
            this.println();
            this.print0(this.ucase ? "PARTITIONED BY (" : "partitioned by (");
            ++this.indentCount;
            this.println();
            for (int i = 0; i < partitionSize; ++i) {
                SQLColumnDefinition column = x.getPartitionColumns().get(i);
                column.accept(this);
                if (i != partitionSize - 1) {
                    this.print(',');
                }
                if (this.isPrettyFormat() && column.hasAfterComment()) {
                    this.print(' ');
                    this.printlnComment(column.getAfterCommentsDirect());
                }
                if (i == partitionSize - 1) continue;
                this.println();
            }
            --this.indentCount;
            this.println();
            this.print(')');
        } else if (x.getPartitioning() != null) {
            this.println();
            this.print0(this.ucase ? "PARTITIONED BY " : "partitioned by ");
            x.getPartitioning().accept(this);
        }
        List<SQLSelectOrderByItem> clusteredBy = x.getClusteredBy();
        if (clusteredBy.size() > 0) {
            this.println();
            this.print0(this.ucase ? "CLUSTERED BY (" : "clustered by (");
            this.printAndAccept(clusteredBy, ",");
            this.print(')');
        }
        if ((skewedBy = x.getSkewedBy()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "SKEWED BY (" : "skewed by (");
            this.printAndAccept(skewedBy, ",");
            this.print(')');
            List<SQLExpr> skewedByOn = x.getSkewedByOn();
            if (skewedByOn.size() > 0) {
                this.print0(this.ucase ? " ON (" : " on (");
                this.printAndAccept(skewedByOn, ",");
                this.print(')');
            }
        }
        if ((format = x.getRowFormat()) != null) {
            this.println();
            this.print0(this.ucase ? "ROW FORMAT" : "row rowFormat");
            if (format.getSerde() == null) {
                this.print0(this.ucase ? " DELIMITED" : " delimited ");
            }
            this.visit(format);
        }
        if ((serdeProperties = x.getSerdeProperties()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "WITH SERDEPROPERTIES (" : "with serdeproperties (");
            this.incrementIndent();
            this.println();
            int i = 0;
            for (Map.Entry<String, SQLObject> option : serdeProperties.entrySet()) {
                char c0;
                if (i != 0) {
                    this.print(",");
                    this.println();
                }
                String key = option.getKey();
                boolean unquote = false;
                if (key.length() > 0 && (c0 = key.charAt(0)) != '\"' && c0 != '`' && c0 != '\'') {
                    unquote = true;
                }
                if (unquote) {
                    this.print('\'');
                }
                this.print0(key);
                if (unquote) {
                    this.print('\'');
                }
                this.print0(" = ");
                option.getValue().accept(this);
                ++i;
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        if ((sortedBy = x.getSortedBy()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "SORTED BY (" : "sorted by (");
            this.printAndAccept(sortedBy, ", ");
            this.print(')');
        }
        if ((buckets = x.getBuckets()) > 0) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            this.print(buckets);
            this.print0(this.ucase ? " BUCKETS" : " buckets");
        }
        if ((storedAs = x.getStoredAs()) != null) {
            this.printStoredAs(storedAs);
        }
        if ((storedBy = x.getStoredBy()) != null) {
            this.println();
            this.print0(this.ucase ? "STORED BY " : "stored by ");
            this.printExpr(storedBy);
        }
        if ((withSerdeproperties = x.getWithSerdeproperties()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "WITH SERDEPROPERTIES (" : "with serdeproperties (");
            this.printAndAccept(withSerdeproperties, ", ");
            this.print(')');
        }
        if ((location = x.getLocation()) != null) {
            this.println();
            this.print0(this.ucase ? "LOCATION " : "location ");
            this.printExpr(location, this.parameterized);
        }
        if ((tblProperties = x.getTblProperties()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "TBLPROPERTIES (" : "tblproperties (");
            this.incrementIndent();
            this.println();
            int i = 0;
            for (SQLAssignItem property : tblProperties) {
                char c0;
                if (i != 0) {
                    this.print(",");
                    this.println();
                }
                String key = property.getTarget().toString();
                boolean unquote = false;
                if (key.length() > 0 && (c0 = key.charAt(0)) != '\"' && c0 != '`' && c0 != '\'') {
                    unquote = true;
                }
                if (unquote) {
                    this.print('\'');
                }
                this.print0(key);
                if (unquote) {
                    this.print('\'');
                }
                this.print0(" = ");
                property.getValue().accept(this);
                ++i;
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        if ((metaLifeCycle = x.getMetaLifeCycle()) != null) {
            this.println();
            this.print0(this.ucase ? "META LIFECYCLE " : "meta lifecycle ");
            this.printExpr(metaLifeCycle);
        }
        SQLSelect select = x.getSelect();
        if (printSelect && select != null) {
            this.println();
            if (x.isLikeQuery()) {
                this.print0(this.ucase ? "LIKE" : "like");
            } else {
                this.print0(this.ucase ? "AS" : "as");
            }
            this.println();
            this.visit(select);
        }
    }
}

