/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.spark.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableReplaceColumn;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLAnalyzeTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLDescribeStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExplainStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLObjectType;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveInsertStatement;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveStatementParser;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveMsckRepairStatement;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkCacheTableStatement;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkClearCacheStatement;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkExplainStatement;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkInsertStatement;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkReplaceViewStatement;
import com.alibaba.fastsql.sql.dialect.spark.parser.SparkCreateTableParser;
import com.alibaba.fastsql.sql.dialect.spark.parser.SparkExprParser;
import com.alibaba.fastsql.sql.dialect.spark.parser.SparkSelectParser;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLCreateTableParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class SparkStatementParser
extends HiveStatementParser {
    public SparkStatementParser(SparkExprParser exprParser) {
        super(exprParser);
        this.dbType = DbType.spark;
    }

    public SparkStatementParser(String sql) {
        super(new SparkExprParser(sql));
        this.dbType = DbType.spark;
    }

    public SparkStatementParser(String sql, SQLParserFeature ... features) {
        super(new SparkExprParser(sql, features));
        this.dbType = DbType.spark;
    }

    public SparkStatementParser(Lexer lexer) {
        super(new SparkExprParser(lexer));
        this.dbType = DbType.spark;
    }

    @Override
    public SparkSelectParser createSQLSelectParser() {
        return new SparkSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new SparkCreateTableParser(this.exprParser);
    }

    @Override
    public void parseAlterDrop(SQLAlterTableStatement stmt) {
        Lexer.SavePoint sp = this.lexer.mark();
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.COLUMNS) || this.lexer.token() == Token.COLUMN) {
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            if (this.lexer.identifierEquals(FnvHash.Constants.COLUMNS)) {
                item.setDropColumns(true);
            }
            this.lexer.nextToken();
            boolean isBracket = false;
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                isBracket = true;
            }
            this.exprParser.names(item.getColumns(), item);
            if (isBracket) {
                this.accept(Token.RPAREN);
            }
            item.setBracket(isBracket);
            stmt.addItem(item);
        } else {
            this.lexer.reset(sp);
            super.parseAlterAdd(stmt);
        }
    }

    @Override
    protected SQLAlterTableAlterColumn parseAlterColumn() {
        this.lexer.nextToken();
        SQLColumnDefinition column = this.exprParser.createColumnDefinition();
        column.setName(this.exprParser.name());
        Token token = this.lexer.token();
        if (token != Token.SET && token != Token.DROP && token != Token.PRIMARY && token != Token.RPAREN && token != Token.COMMENT) {
            column.setDataType(this.exprParser.parseDataType());
        }
        if (this.lexer.token() == Token.COMMENT) {
            SQLExpr comment;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LITERAL_ALIAS) {
                String alias = this.lexer.stringVal();
                if (alias.length() > 2 && alias.charAt(0) == '\"' && alias.charAt(alias.length() - 1) == '\"') {
                    alias = alias.substring(1, alias.length() - 1);
                }
                comment = new SQLCharExpr(alias);
                this.lexer.nextToken();
            } else {
                comment = this.exprParser.primary();
            }
            column.setComment(comment);
        }
        SQLAlterTableAlterColumn alterColumn = new SQLAlterTableAlterColumn();
        alterColumn.setColumn(column);
        return alterColumn;
    }

    @Override
    protected SQLAlterTableItem parseAlterTablePartitionAndItem() {
        Lexer.SavePoint sp = this.lexer.mark();
        this.lexer.nextToken();
        ArrayList partitions = new ArrayList();
        this.accept(Token.LPAREN);
        this.parseAssignItems(partitions, null);
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.REPLACE) {
            SQLAlterTableReplaceColumn item = this.parseAlterTableReplaceColumn();
            for (SQLAssignItem condition : partitions) {
                item.getPartition().add(condition);
                condition.setParent(item);
            }
            return item;
        }
        if (this.lexer.token() == Token.SET) {
            SQLAlterTableItem setItem = this.parseAlterTableSetItem();
            for (SQLAssignItem condition : partitions) {
                setItem.getPartition().add(condition);
                condition.setParent(setItem);
            }
            return setItem;
        }
        this.lexer.reset(sp);
        return super.parseAlterTablePartitionAndItem();
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        int startLine = this.lexer.getPosLine();
        int startCol = this.lexer.getPosColumn();
        if (this.lexer.token() == Token.REPLACE) {
            this.lexer.nextToken();
            SparkReplaceViewStatement stmt = new SparkReplaceViewStatement();
            boolean global = false;
            if (this.lexer.identifierEquals(FnvHash.Constants.GLOBAL)) {
                this.lexer.nextToken();
                global = true;
            }
            boolean temporary = false;
            if (this.lexer.identifierEquals(FnvHash.Constants.TEMPORARY) || this.lexer.token() == Token.TEMPORARY) {
                this.lexer.nextToken();
                temporary = true;
            }
            this.parseCreateView(stmt);
            if (temporary) {
                if (global) {
                    stmt.setType(SparkReplaceViewStatement.Type.GLOBAL_TEMPORARY);
                } else {
                    stmt.setType(SparkReplaceViewStatement.Type.TEMPORARY);
                }
            }
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.REPAIR)) {
            SQLStatement msck = this.parseMsck();
            this.addToStatementList(statementList, msck, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CLEAR)) {
            SparkClearCacheStatement clear = new SparkClearCacheStatement();
            this.lexer.nextToken();
            this.acceptIdentifier(Token.CACHE.name);
            this.addToStatementList(statementList, clear, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CACHE)) {
            SQLStatement stmt = this.parseCache();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        return super.parseStatementListDialect(statementList);
    }

    protected SQLStatement parseCache() {
        SparkSelectParser selectParser;
        this.acceptIdentifier(Token.CACHE.name);
        SparkCacheTableStatement stmt = new SparkCacheTableStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.LAZY)) {
            stmt.setLazy(true);
            this.lexer.nextToken();
        }
        this.accept(Token.TABLE);
        stmt.setTableSource(new SQLExprTableSource(this.exprParser.expr()));
        if (this.lexer.identifierEquals(FnvHash.Constants.OPTIONS)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLCharExpr key = this.exprParser.charExpr();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr value = this.exprParser.primary();
                SQLAssignItem item = new SQLAssignItem(key, value);
                item.setParent(stmt);
                stmt.getOptions().add(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            selectParser = this.createSQLSelectParser();
            stmt.setQuery(selectParser.select());
        } else if (this.lexer.token() == Token.SELECT) {
            selectParser = this.createSQLSelectParser();
            stmt.setQuery(selectParser.select());
        }
        return stmt;
    }

    @Override
    protected SQLStatement parseMsck() {
        HiveMsckRepairStatement stmt = new HiveMsckRepairStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.MSCK)) {
            this.lexer.nextToken();
            this.acceptIdentifier("REPAIR");
        } else {
            this.acceptIdentifier("REPAIR");
            stmt.setHasMsck(false);
        }
        if (this.lexer.token() == Token.DATABASE || this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
            SQLName name = this.exprParser.name();
            stmt.setDatabase(name);
        }
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            SQLExpr tableExpr = this.exprParser.expr();
            stmt.setTable(tableExpr);
        }
        if (this.lexer.token() == Token.IDENTIFIER && (this.lexer.identifierEquals("SYNC") || this.lexer.identifierEquals("ADD")) || this.lexer.token() == Token.DROP) {
            stmt.setOptionType(new SQLIdentifierExpr(this.lexer.stringVal()));
            this.lexer.nextToken();
            this.acceptIdentifier("PARTITIONS");
        }
        return stmt;
    }

    @Override
    protected HiveInsertStatement createHiveInsertStatement() {
        return new SparkInsertStatement();
    }

    @Override
    protected void parseInsertReplace(HiveInsertStatement hiveInsertStatement) {
        SparkInsertStatement sparkInsertStatement = (SparkInsertStatement)hiveInsertStatement;
        this.accept(Token.REPLACE);
        this.accept(Token.WHERE);
        sparkInsertStatement.setReplaceWhere(this.exprParser.expr());
    }

    @Override
    public SQLExplainStatement parseExplain() {
        this.accept(Token.EXPLAIN);
        SparkExplainStatement explain = new SparkExplainStatement(this.dbType);
        if (this.lexer.token() == Token.HINT) {
            explain.setHints(this.exprParser.parseHints());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTENDED)) {
            this.lexer.nextToken();
            explain.setExtended(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.FORMATTED)) {
            this.lexer.nextToken();
            explain.setFormatted(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.COST)) {
            this.lexer.nextToken();
            explain.setCost(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.CODEGEN)) {
            this.lexer.nextToken();
            explain.setCodegen(true);
        }
        explain.setStatement(this.parseStatement());
        return explain;
    }

    @Override
    protected SQLStatement parseAnalyze() {
        this.lexer.nextToken();
        this.accept(Token.TABLE);
        SQLAnalyzeTableStatement stmt = new SQLAnalyzeTableStatement();
        SQLName table = this.exprParser.name();
        stmt.setTable(table);
        if (this.lexer.token() == Token.PARTITION) {
            stmt.setPartition(this.parsePartitionRef());
        }
        this.accept(Token.COMPUTE);
        this.acceptIdentifier("STATISTICS");
        stmt.setComputeStatistics(true);
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.COLUMNS)) {
                this.acceptIdentifier("COLUMNS");
                stmt.setForColums(true);
            } else {
                this.accept(Token.ALL);
                this.acceptIdentifier("COLUMNS");
                stmt.setForAllColums(true);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CACHE)) {
            this.lexer.nextToken();
            this.acceptIdentifier("METADATA");
            stmt.setCacheMetadata(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.NOSCAN)) {
            this.lexer.nextToken();
            stmt.setNoscan(true);
        }
        return stmt;
    }

    @Override
    public SQLStatement parseDescribe() {
        SQLName column;
        if (this.lexer.token() != Token.DESC && !this.lexer.identifierEquals("DESCRIBE")) {
            throw new ParserException("expect DESC, actual " + (Object)((Object)this.lexer.token()), this.lexer.getPosLine(), this.lexer.getPosColumn());
        }
        this.lexer.nextToken();
        SQLDescribeStatement stmt = new SQLDescribeStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token() == Token.DATABASE) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.DATABASE);
        } else if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.SCHEMA);
        } else if (this.lexer.identifierEquals("ROLE")) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.ROLE);
        } else if (this.lexer.identifierEquals("PACKAGE")) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.PACKAGE);
        } else if (this.lexer.identifierEquals("INSTANCE")) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.INSTANCE);
        } else if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.TABLE);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTENDED)) {
            this.lexer.nextToken();
            stmt.setExtended(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.FORMATTED)) {
            this.lexer.nextToken();
            stmt.setFormatted(true);
        }
        stmt.setObject(this.exprParser.name());
        if (this.lexer.token() == Token.IDENTIFIER) {
            column = this.exprParser.name();
            stmt.setColumn(column);
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                stmt.getPartition().add(this.exprParser.expr());
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                if (this.lexer.token() == Token.RPAREN) break;
            }
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.IDENTIFIER && stmt.getColumn() == null) {
            column = this.exprParser.name();
            stmt.setColumn(column);
        }
        return stmt;
    }
}

