/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.spark.parser;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveSelectParser;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkExprTableSource;
import com.alibaba.fastsql.sql.dialect.spark.parser.SparkExprParser;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLSelectListCache;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;

public class SparkSelectParser
extends HiveSelectParser {
    public SparkSelectParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public SparkSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser, selectListCache);
    }

    public SparkSelectParser(String sql) {
        this(new SparkExprParser(sql));
    }

    @Override
    protected SQLExprTableSource createExprTableSource() {
        return new SparkExprTableSource();
    }

    @Override
    protected SQLExprTableSource createExprTableSource(SQLExpr sqlExpr) {
        return new SparkExprTableSource(sqlExpr);
    }

    @Override
    protected SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        if (this.lexer.identifierEquals(FnvHash.Constants.TIMESTAMP) && tableSource instanceof SparkExprTableSource) {
            this.lexer.nextToken();
            this.accept(Token.AS);
            this.accept(Token.OF);
            SQLExpr sqlExpr = this.exprParser.primary();
            ((SparkExprTableSource)tableSource).setTimestampAsOf(sqlExpr);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.VERSION) && tableSource instanceof SparkExprTableSource) {
            this.lexer.nextToken();
            this.accept(Token.AS);
            this.accept(Token.OF);
            if (this.lexer.token() == Token.LITERAL_INT) {
                ((SparkExprTableSource)tableSource).setVersionAsOf(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
            } else {
                throw new ParserException("version must be integer. " + this.lexer.info());
            }
        }
        return super.parseTableSourceRest(tableSource);
    }
}

