/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.spark.parser;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveCreateTableParser;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.spark.parser.SparkExprParser;
import com.alibaba.fastsql.sql.dialect.spark.parser.SparkSelectParser;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLSelectParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;

public class SparkCreateTableParser
extends HiveCreateTableParser {
    public SparkCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public SparkCreateTableParser(Lexer lexer) {
        super(new SparkExprParser(lexer));
    }

    @Override
    protected void parseCreateTableRest(HiveCreateTableStatement stmt) {
        if (this.lexer.identifierEquals(FnvHash.Constants.USING) || this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            SQLExpr using = this.exprParser.expr();
            stmt.setUsing(using);
        }
        if (this.lexer.token() == Token.ROW || this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
            this.parseRowFormat(stmt);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
            String text;
            this.lexer.nextToken();
            this.accept(Token.AS);
            SQLExpr name = this.exprParser.expr();
            if (name instanceof SQLCharExpr && (text = ((SQLCharExpr)name).getText()) != null && text.length() > 1 && text.startsWith("'") && text.startsWith("'")) {
                ((SQLCharExpr)name).setText(text.substring(1, text.length() - 1));
            }
            stmt.setStoredAs(name);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(stmt.getTblProperties(), stmt, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
            this.lexer.nextToken();
            SQLExpr location = this.exprParser.primary();
            stmt.setLocation(location);
        }
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new SparkSelectParser(this.exprParser, this.selectListCache);
    }
}

