/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.spark.ast;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.dialect.spark.ast.SparkObject;
import com.alibaba.fastsql.sql.dialect.spark.visitor.SparkASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;

public class SparkExprTableSource
extends SQLExprTableSource
implements SparkObject {
    protected SQLExpr timestampAsOf;
    protected Integer versionAsOf;

    public SparkExprTableSource() {
    }

    public SparkExprTableSource(String tableName) {
        super(tableName);
    }

    public SparkExprTableSource(SQLExpr expr) {
        super(expr);
    }

    public SparkExprTableSource(SQLExpr expr, String alias) {
        super(expr, alias);
    }

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v instanceof SparkASTVisitor) {
            this.accept0((SparkASTVisitor)v);
        } else {
            super.accept0(v);
        }
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this, DbType.spark);
    }

    @Override
    public void accept0(SparkASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    protected void acceptChild(SQLASTVisitor visitor) {
        super.acceptChild(visitor);
        this.acceptChild(visitor, this.timestampAsOf);
    }

    @Override
    public SparkExprTableSource clone() {
        SparkExprTableSource x = new SparkExprTableSource();
        this.cloneTo(x);
        return x;
    }

    public void cloneTo(SparkExprTableSource x) {
        super.cloneTo(x);
        if (this.timestampAsOf != null) {
            x.setTimestampAsOf(this.timestampAsOf.clone());
        }
    }

    public SQLExpr getTimestampAsOf() {
        return this.timestampAsOf;
    }

    public void setTimestampAsOf(SQLExpr timestampAsOf) {
        if (timestampAsOf != null) {
            timestampAsOf.setParent(this);
        }
        this.timestampAsOf = timestampAsOf;
    }

    public Integer getVersionAsOf() {
        return this.versionAsOf;
    }

    public void setVersionAsOf(Integer versionAsOf) {
        this.versionAsOf = versionAsOf;
    }
}

