/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.oracle.visitor;

import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.dialect.oracle.visitor.OracleParameterizedOutputVisitor;
import com.alibaba.fastsql.sql.visitor.ExportParameterVisitor;
import com.alibaba.fastsql.sql.visitor.ExportParameterVisitorUtils;
import java.util.ArrayList;
import java.util.List;

public class OracleExportParameterVisitor
extends OracleParameterizedOutputVisitor
implements ExportParameterVisitor {
    private final boolean requireParameterizedOutput;

    public OracleExportParameterVisitor(List<Object> parameters, Appendable appender, boolean wantParameterizedOutput) {
        super(appender, false);
        this.parameters = parameters;
        this.requireParameterizedOutput = wantParameterizedOutput;
    }

    public OracleExportParameterVisitor() {
        this(new ArrayList<Object>());
    }

    public OracleExportParameterVisitor(List<Object> parameters) {
        this(parameters, new StringBuilder(), false);
    }

    public OracleExportParameterVisitor(Appendable appender) {
        this(new ArrayList<Object>(), appender, true);
    }

    @Override
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        return false;
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        ExportParameterVisitorUtils.exportParamterAndAccept(this.parameters, x.getArguments());
        return true;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        ExportParameterVisitorUtils.exportParamterAndAccept(this.parameters, x.getTargetList());
        return true;
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        ExportParameterVisitorUtils.exportParameter((List<Object>)this.parameters, x);
        return true;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        ExportParameterVisitorUtils.exportParameter((List<Object>)this.parameters, x);
        return true;
    }
}

