/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.odps.visitor;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.ClusteringType;
import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.SQLOver;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLGroupingSetExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableRenameColumn;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLShowStatisticStmt;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWhoamiStatement;
import com.alibaba.fastsql.sql.dialect.hive.visitor.HiveOutputVisitor;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddFileStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddStatisticStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddTableStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddUserStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAliasStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAlterTableChangeOwner;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAlterTableDropColumnsItem;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAlterTableMergePartition;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAlterTableSetChangeLogs;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCloneTableStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCostStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCountStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCreateParameterizedViewStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCubeExpr;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsGrantStmt;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsListStmt;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsLoadTableStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsOver;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsPAIStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsParameter;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsParameterizedViewTableSource;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsPivotDefinition;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsPivotTableSource;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsPredicateExpr;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsReadStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsRemoveStatisticStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsRemoveUserStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsRollupExpr;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsSQLZOrderBy;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsSetLabelStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsShowGrantsStmt;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsStarColumnName;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsStatisticClause;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsUDTFSQLSelectItem;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsUnpivotDefinition;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsUnpivotTableSource;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsUsingExpr;
import com.alibaba.fastsql.sql.dialect.odps.visitor.OdpsASTVisitor;
import com.alibaba.fastsql.util.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.Pair;

public class OdpsOutputVisitor
extends HiveOutputVisitor
implements OdpsASTVisitor {
    private Set<String> builtInFunctions = new HashSet<String>();

    public OdpsOutputVisitor(Appendable appender) {
        super(appender, DbType.odps);
        this.builtInFunctions.add("IF");
        this.builtInFunctions.add("COALESCE");
        this.builtInFunctions.add("TO_DATE");
        this.builtInFunctions.add("SUBSTR");
        this.builtInFunctions.add("INSTR");
        this.builtInFunctions.add("LENGTH");
        this.builtInFunctions.add("SPLIT");
        this.builtInFunctions.add("TOLOWER");
        this.builtInFunctions.add("TOUPPER");
        this.builtInFunctions.add("EXPLODE");
        this.builtInFunctions.add("LEAST");
        this.builtInFunctions.add("GREATEST");
        this.groupItemSingleLine = true;
    }

    @Override
    public boolean visit(OdpsCreateTableStatement x) {
        SQLSelect select;
        SQLExpr using;
        List<SQLAssignItem> tblProperties;
        SQLExpr location;
        List<SQLExpr> withSerdeproperties;
        SQLExpr storedAs;
        SQLExpr storedBy;
        Map<String, SQLObject> serdeProperties;
        SQLExternalRecordFormat format;
        int shards;
        int buckets;
        List<SQLSelectOrderByItem> sortedBy;
        List<SQLSelectOrderByItem> clusteredBy;
        int partitionSize;
        List<SQLTableElement> tableElementList;
        int size;
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isExternal()) {
            this.print0(this.ucase ? "EXTERNAL " : "external ");
        }
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "TABLE IF NOT EXISTS " : "table if not exists ");
        } else {
            this.print0(this.ucase ? "TABLE " : "table ");
        }
        x.getName().accept(this);
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if ((size = (tableElementList = x.getTableElementList()).size()) > 0) {
            this.print0(" (");
            if (this.isPrettyFormat() && x.hasBodyBeforeComment()) {
                this.print(' ');
                this.printlnComment(x.getBodyBeforeCommentsDirect());
            }
            ++this.indentCount;
            this.println();
            for (int i = 0; i < size; ++i) {
                SQLTableElement element = tableElementList.get(i);
                element.accept(this);
                if (i != size - 1) {
                    this.print(',');
                }
                if (this.isPrettyFormat() && element.hasAfterComment()) {
                    this.print(' ');
                    this.printlnComment(element.getAfterCommentsDirect());
                }
                if (i == size - 1) continue;
                this.println();
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        if (x.getComment() != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getComment().accept(this);
        }
        if ((partitionSize = x.getPartitionColumns().size()) > 0) {
            this.println();
            this.print0(this.ucase ? "PARTITIONED BY (" : "partitioned by (");
            ++this.indentCount;
            this.println();
            for (int i = 0; i < partitionSize; ++i) {
                SQLColumnDefinition column = x.getPartitionColumns().get(i);
                column.accept(this);
                if (i != partitionSize - 1) {
                    this.print(',');
                }
                if (this.isPrettyFormat() && column.hasAfterComment()) {
                    this.print(' ');
                    this.printlnComment(column.getAfterCommentsDirect());
                }
                if (i == partitionSize - 1) continue;
                this.println();
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        if ((clusteredBy = x.getClusteredBy()).size() > 0) {
            this.println();
            if (x.getClusteringType() == ClusteringType.Range) {
                this.print0(this.ucase ? "RANGE " : "range ");
            }
            this.print0(this.ucase ? "CLUSTERED BY (" : "clustered by (");
            this.printAndAccept(clusteredBy, ",");
            this.print(')');
        }
        if ((sortedBy = x.getSortedBy()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "SORTED BY (" : "sorted by (");
            this.printAndAccept(sortedBy, ", ");
            this.print(')');
        }
        if ((buckets = x.getBuckets()) > 0) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            this.print(buckets);
            this.print0(this.ucase ? " BUCKETS" : " buckets");
        }
        if ((shards = x.getShards()) > 0) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            this.print(shards);
            this.print0(this.ucase ? " SHARDS" : " shards");
        }
        if ((format = x.getRowFormat()) != null) {
            this.println();
            this.print0(this.ucase ? "ROW FORMAT" : "row rowFormat");
            if (format.getSerde() == null) {
                this.print0(this.ucase ? " DELIMITED" : " delimited ");
            }
            this.visit(format);
        }
        if ((serdeProperties = x.getSerdeProperties()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "WITH SERDEPROPERTIES (" : "with serdeproperties (");
            this.incrementIndent();
            this.println();
            int i = 0;
            for (Map.Entry<String, SQLObject> option : serdeProperties.entrySet()) {
                char c0;
                if (i != 0) {
                    this.print(",");
                    this.println();
                }
                String key = option.getKey();
                boolean unquote = false;
                if (key.length() > 0 && (c0 = key.charAt(0)) != '\"' && c0 != '`' && c0 != '\'') {
                    unquote = true;
                }
                if (unquote) {
                    this.print('\'');
                }
                this.print0(key);
                if (unquote) {
                    this.print('\'');
                }
                this.print0(" = ");
                option.getValue().accept(this);
                ++i;
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        if ((storedBy = x.getStoredBy()) != null) {
            this.println();
            this.print0(this.ucase ? "STORED BY " : "stored by ");
            storedBy.accept(this);
        }
        if ((storedAs = x.getStoredAs()) != null) {
            this.println();
            this.print0(this.ucase ? "STORED AS " : "stored as ");
            storedAs.accept(this);
        }
        if ((withSerdeproperties = x.getWithSerdeproperties()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "WITH SERDEPROPERTIES (" : "with serdeproperties (");
            this.printAndAccept(withSerdeproperties, ", ");
            this.print(')');
        }
        if ((location = x.getLocation()) != null) {
            this.println();
            this.print0(this.ucase ? "LOCATION " : "location ");
            location.accept(this);
        }
        if ((tblProperties = x.getTblProperties()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "TBLPROPERTIES (" : "tblproperties (");
            this.incrementIndent();
            this.println();
            int i = 0;
            for (SQLAssignItem property : tblProperties) {
                char c0;
                if (i != 0) {
                    this.print(",");
                    this.println();
                }
                String key = property.getTarget().toString();
                boolean unquote = false;
                if (key.length() > 0 && (c0 = key.charAt(0)) != '\"' && c0 != '`' && c0 != '\'') {
                    unquote = true;
                }
                if (unquote) {
                    this.print('\'');
                }
                this.print0(key);
                if (unquote) {
                    this.print('\'');
                }
                this.print0(" = ");
                property.getValue().accept(this);
                ++i;
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        if ((using = x.getUsing()) != null) {
            this.println();
            this.print0(this.ucase ? "USING " : "using ");
            using.accept(this);
        }
        if (x.getLifecycle() != null) {
            this.println();
            this.print0(this.ucase ? "LIFECYCLE " : "lifecycle ");
            x.getLifecycle().accept(this);
        }
        if ((select = x.getSelect()) != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            select.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsCreateTableStatement x) {
        super.endVisit((SQLCreateTableStatement)x);
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        this.print('(');
        ++this.indentCount;
        this.println();
        x.getSelect().accept(this);
        --this.indentCount;
        this.println();
        this.print(')');
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        x.getLeft().accept(this);
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print(',');
        } else {
            this.println();
            this.printJoinType(x.getJoinType());
        }
        this.print(' ');
        x.getRight().accept(this);
        if (x.getCondition() != null) {
            this.println();
            this.print0(this.ucase ? "ON " : "on ");
            ++this.indentCount;
            x.getCondition().accept(this);
            --this.indentCount;
        }
        if (x.getUsing().size() > 0) {
            this.print0(this.ucase ? " USING " : " using ");
            this.printAndAccept(x.getUsing(), ", ");
        }
        if (x.getAlias() != null) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(x.getAlias());
        }
        return false;
    }

    @Override
    public void endVisit(OdpsUDTFSQLSelectItem x) {
    }

    @Override
    public boolean visit(OdpsUDTFSQLSelectItem x) {
        x.getExpr().accept(this);
        this.println();
        this.print0(this.ucase ? "AS (" : "as (");
        int aliasSize = x.getAliasList().size();
        if (aliasSize > 5) {
            ++this.indentCount;
            this.println();
        }
        for (int i = 0; i < aliasSize; ++i) {
            if (i != 0) {
                if (aliasSize > 5) {
                    this.println(",");
                } else {
                    this.print0(", ");
                }
            }
            this.print0(x.getAliasList().get(i));
        }
        if (aliasSize > 5) {
            --this.indentCount;
            this.println();
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLShowStatisticStmt x) {
        this.print0(this.ucase ? "SHOW STATISTIC" : "show statistic");
        SQLExprTableSource tableSource = x.getTableSource();
        if (tableSource != null) {
            this.print(' ');
            tableSource.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsSetLabelStatement x) {
    }

    @Override
    public boolean visit(OdpsSetLabelStatement x) {
        this.print0(this.ucase ? "SET LABEL " : "set label ");
        this.print0(x.getLabel());
        this.print0(this.ucase ? " TO " : " to ");
        if (x.getUser() != null) {
            this.print0(this.ucase ? "USER " : "user ");
            x.getUser().accept(this);
        } else if (x.getTable() != null) {
            this.print0(this.ucase ? "TABLE " : "table ");
            x.getTable().accept(this);
            if (x.getColumns().size() > 0) {
                this.print('(');
                this.printAndAccept(x.getColumns(), ", ");
                this.print(')');
            }
        }
        return false;
    }

    @Override
    public void endVisit(OdpsSelectQueryBlock x) {
    }

    @Override
    public boolean visit(OdpsSelectQueryBlock x) {
        List<SQLSelectOrderByItem> clusterBy;
        List<SQLSelectOrderByItem> sortBy;
        List<SQLSelectOrderByItem> distributeBy;
        SQLExpr where;
        if (this.isPrettyFormat() && x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        this.print0(this.ucase ? "SELECT " : "select ");
        List<SQLCommentHint> hints = x.getHintsDirect();
        if (hints != null && !hints.isEmpty()) {
            this.printAndAccept(hints, " ");
            this.print(' ');
        }
        if (1 == x.getDistionOption()) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
        } else if (3 == x.getDistionOption()) {
            this.print0(this.ucase ? "UNIQUE " : "unique ");
        }
        this.printSelectList(x.getSelectList());
        SQLTableSource from = x.getFrom();
        if (from != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            from.accept(this);
        }
        if ((where = x.getWhere()) != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            if (where.hasBeforeComment() && this.isPrettyFormat()) {
                this.printlnComments(x.getWhere().getBeforeCommentsDirect());
            }
            where.accept(this);
            if (where.hasAfterComment() && this.isPrettyFormat()) {
                this.print(' ');
                this.printlnComment(x.getWhere().getAfterCommentsDirect());
            }
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        if (x.getQualify() != null) {
            this.println();
            this.print0(this.ucase ? "QUALIFY " : "qualify ");
            x.getQualify().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if ((distributeBy = x.getDistributeByDirect()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "DISTRIBUTE BY " : "distribute by ");
            this.printAndAccept(distributeBy, ", ");
        }
        if (!(sortBy = x.getSortByDirect()).isEmpty()) {
            this.println();
            this.print0(this.ucase ? "SORT BY " : "sort by ");
            this.printAndAccept(sortBy, ", ");
        }
        if ((clusterBy = x.getClusterByDirect()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "CLUSTER BY " : "cluster by ");
            this.printAndAccept(clusterBy, ", ");
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        int itemSize = x.getItems().size();
        if (itemSize > 0) {
            this.print0(this.ucase ? "ORDER BY " : "order by ");
            ++this.indentCount;
            for (int i = 0; i < itemSize; ++i) {
                if (i != 0) {
                    this.println(", ");
                }
                x.getItems().get(i).accept(this);
            }
            --this.indentCount;
        }
        return false;
    }

    @Override
    public void endVisit(OdpsAddStatisticStatement x) {
    }

    @Override
    public boolean visit(OdpsAddStatisticStatement x) {
        this.print0(this.ucase ? "ADD STATISTIC " : "add statistic ");
        x.getTable().accept(this);
        this.print(' ');
        x.getStatisticClause().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsRemoveStatisticStatement x) {
    }

    @Override
    public boolean visit(OdpsRemoveStatisticStatement x) {
        this.print0(this.ucase ? "REMOVE STATISTIC " : "remove statistic ");
        x.getTable().accept(this);
        this.print(' ');
        x.getStatisticClause().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.TableCount x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.TableCount x) {
        this.print0(this.ucase ? "TABLE_COUNT" : "table_count");
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.ExpressionCondition x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.ExpressionCondition x) {
        this.print0(this.ucase ? "EXPRESSION_CONDITION " : "expression_condition ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.NullValue x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.NullValue x) {
        this.print0(this.ucase ? "NULL_VALUE " : "null_value ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.ColumnSum x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.ColumnSum x) {
        this.print0(this.ucase ? "COLUMN_SUM " : "column_sum ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.ColumnMax x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.ColumnMax x) {
        this.print0(this.ucase ? "COLUMN_MAX " : "column_max ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.ColumnMin x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.ColumnMin x) {
        this.print0(this.ucase ? "COLUMN_MIN " : "column_min ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsReadStatement x) {
    }

    @Override
    public boolean visit(OdpsReadStatement x) {
        this.print0(this.ucase ? "READ " : "read ");
        x.getTable().accept(this);
        if (x.getColumns().size() > 0) {
            this.print0(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(')');
        }
        if (x.getPartition().size() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print(')');
        }
        if (x.getRowCount() != null) {
            this.print(' ');
            x.getRowCount().accept(this);
        }
        return false;
    }

    @Override
    protected void printMethodOwner(SQLExpr owner) {
        owner.accept(this);
        this.print(':');
    }

    @Override
    protected void printJoinType(SQLJoinTableSource.JoinType joinType) {
        if (joinType.equals((Object)SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN)) {
            this.print0(this.ucase ? "LEFT OUTER JOIN" : "left outer join");
        } else if (joinType.equals((Object)SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN)) {
            this.print0(this.ucase ? "RIGHT OUTER JOIN" : "right outer join");
        } else if (joinType.equals((Object)SQLJoinTableSource.JoinType.FULL_OUTER_JOIN)) {
            this.print0(this.ucase ? "FULL OUTER JOIN" : "full outer join");
        } else {
            this.print0(this.ucase ? joinType.name : joinType.name_lcase);
        }
    }

    @Override
    public boolean visit(SQLDataType x) {
        String dataTypeName = x.getName();
        this.print0(this.ucase ? dataTypeName.toUpperCase() : dataTypeName.toLowerCase());
        if (x.getArguments().size() > 0) {
            this.print('(');
            this.printAndAccept(x.getArguments(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    protected void printFunctionName(String name) {
        String upperName = name.toUpperCase();
        if (this.builtInFunctions.contains(upperName)) {
            this.print0(this.ucase ? upperName : name);
        } else {
            this.print0(name);
        }
    }

    @Override
    public void endVisit(OdpsShowGrantsStmt x) {
    }

    @Override
    public boolean visit(OdpsShowGrantsStmt x) {
        this.print0(this.ucase ? "SHOW GRANTS" : "show grants");
        if (x.getUser() != null) {
            this.print0(this.ucase ? " FOR " : " for ");
            x.getUser().accept(this);
        }
        if (x.getObjectType() != null) {
            this.print0(this.ucase ? " ON TYPE " : " on type ");
            x.getObjectType().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsListStmt x) {
    }

    @Override
    public boolean visit(OdpsListStmt x) {
        this.print0(this.ucase ? "LIST " : "list ");
        if (x.getObject() != null) {
            x.getObject().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsGrantStmt x) {
    }

    @Override
    public boolean visit(OdpsGrantStmt x) {
        this.print0(this.ucase ? "GRANT " : "grant ");
        if (x.isSuper()) {
            this.print0(this.ucase ? "SUPER " : "super ");
        }
        if (x.isLabel()) {
            this.print0(this.ucase ? "LABEL " : "label ");
            x.getLabel().accept(this);
        } else {
            this.printAndAccept(x.getPrivileges(), ", ");
        }
        if (x.getResource() != null) {
            this.print0(this.ucase ? " ON " : " on ");
            if (x.getResourceType() != null) {
                this.print0(this.ucase ? x.getResourceType().name() : x.getResourceType().name().toLowerCase());
                this.print(' ');
            }
            x.getResource().accept(this);
            if (x.getColumns().size() > 0) {
                this.print('(');
                this.printAndAccept(x.getColumns(), ", ");
                this.print(')');
            }
        }
        if (x.getUsers() != null) {
            this.print0(this.ucase ? " TO " : " to ");
            if (x.getSubjectType() != null) {
                this.print0(x.getSubjectType().name());
                this.print(' ');
            }
            this.printAndAccept(x.getUsers(), ",");
        }
        if (x.getExpire() != null) {
            this.print0(this.ucase ? " WITH EXP " : " with exp ");
            x.getExpire().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x, boolean parameterized) {
        String text = x.getText();
        if (text == null) {
            this.print0(this.ucase ? "NULL" : "null");
        } else {
            StringBuilder buf = new StringBuilder(text.length() + 2);
            buf.append('\'');
            block3: for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '\'': {
                        if (x.getQuoteType() == '\"') {
                            buf.append("\\'");
                            continue block3;
                        }
                        buf.append("'");
                        continue block3;
                    }
                    default: {
                        buf.append(ch);
                    }
                }
            }
            buf.append('\'');
            this.print0(buf.toString());
        }
        return false;
    }

    @Override
    public boolean visit(OdpsAlterTableDropColumnsItem x) {
        this.print0(this.ucase ? "DROP COLUMNS " : "drop columns ");
        this.printAndAccept(x.getColumns(), ", ");
        return false;
    }

    @Override
    public boolean visit(OdpsOver x) {
        this.print0("(");
        if (x.getDistributeBy() != null && x.getDistributeBy().size() > 0) {
            this.print0(this.ucase ? "DISTRIBUTE BY " : "distribute by ");
            this.printAndAccept(x.getDistributeBy(), ",");
            if (x.getSortBy() != null && x.getSortBy().size() > 0) {
                this.print0(this.ucase ? " SORT BY " : " sort by ");
                this.printAndAccept(x.getSortBy(), ",");
            }
        } else {
            if (x.getPartitionBy().size() > 0) {
                this.print0(this.ucase ? "PARTITION BY " : "partition by ");
                this.printAndAccept(x.getPartitionBy(), ", ");
                this.print(' ');
            }
            if (x.getOrderBy() != null) {
                x.getOrderBy().accept(this);
            }
            if (x.getOf() != null) {
                this.print0(this.ucase ? " OF " : " of ");
                x.getOf().accept(this);
            }
        }
        SQLExpr windowingBetweenBegin = x.getWindowingBetweenBegin();
        SQLExpr windowingBetweenEnd = x.getWindowingBetweenEnd();
        SQLOver.WindowingBound beginBound = x.getWindowingBetweenBeginBound();
        SQLOver.WindowingBound endBound = x.getWindowingBetweenEndBound();
        SQLOver.WindowingType windowingType = x.getWindowingType();
        if (windowingBetweenEnd != null || endBound != null) {
            if (windowingType != null) {
                this.print(' ');
                this.print0(this.ucase ? windowingType.name : windowingType.name_lower);
            }
            this.print0(this.ucase ? " BETWEEN" : " between");
            this.printWindowingExpr(windowingBetweenBegin);
            if (beginBound != null) {
                this.print(' ');
                this.print0(this.ucase ? beginBound.name : beginBound.name_lower);
            }
            this.print0(this.ucase ? " AND" : " and");
            this.printWindowingExpr(windowingBetweenEnd);
            if (endBound != null) {
                this.print(' ');
                this.print0(this.ucase ? endBound.name : endBound.name_lower);
            }
        } else {
            if (windowingType != null) {
                this.print(' ');
                this.print0(this.ucase ? windowingType.name : windowingType.name_lower);
            }
            this.printWindowingExpr(windowingBetweenBegin);
            if (beginBound != null) {
                this.print(' ');
                this.print0(this.ucase ? beginBound.name : beginBound.name_lower);
            }
            if (windowingType == null && x.getWindowName() != null) {
                this.print(' ');
                x.getWindowName().accept(this);
                this.print(' ');
            }
        }
        if (x.getExcludeType() != null) {
            this.print0(this.ucase ? " EXCLUDE " : " exclude ");
            this.print0(this.ucase ? x.getExcludeType().name : x.getExcludeType().name_lower);
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRenameColumn x) {
        this.print0(this.ucase ? "CHANGE COLUMN " : "change column ");
        x.getColumn().accept(this);
        this.print0(this.ucase ? " RENAME TO " : " rename to ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public boolean visit(OdpsAddTableStatement x) {
        SQLExpr comment;
        this.print0(this.ucase ? "ADD TABLE " : "add table ");
        x.getTable().accept(this);
        List<SQLAssignItem> partitoins = x.getPartitoins();
        if (partitoins.size() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(partitoins, ", ");
            this.print(')');
        }
        if ((comment = x.getComment()) != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            this.printExpr(comment);
        }
        if (x.isForce()) {
            this.print0(" -f");
        }
        return false;
    }

    @Override
    public void endVisit(OdpsAddTableStatement x) {
    }

    @Override
    public void endVisit(OdpsAddFileStatement x) {
    }

    @Override
    public boolean visit(OdpsAddUserStatement x) {
        this.print0(this.ucase ? "ADD USER " : "add user ");
        this.printExpr(x.getUser());
        return false;
    }

    @Override
    public void endVisit(OdpsAddUserStatement x) {
    }

    @Override
    public boolean visit(OdpsRemoveUserStatement x) {
        this.print0(this.ucase ? "REMOVE USER " : "remove user ");
        this.printExpr(x.getUser());
        return false;
    }

    @Override
    public boolean visit(SQLWhoamiStatement x) {
        this.print0(this.ucase ? "WHOAMI" : "whoami");
        return false;
    }

    @Override
    public void endVisit(OdpsRemoveUserStatement x) {
    }

    @Override
    public boolean visit(OdpsAlterTableSetChangeLogs x) {
        this.print0(this.ucase ? "SET CHANGELOGS " : "set changelogs ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsAlterTableSetChangeLogs x) {
    }

    @Override
    public boolean visit(OdpsCountStatement x) {
        this.print0(this.ucase ? "COUNT " : "count ");
        x.getTable().accept(this);
        List<SQLAssignItem> partitoins = x.getPartitoins();
        if (partitoins.size() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(partitoins, ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public void endVisit(OdpsCountStatement x) {
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        boolean paren = x.isParen();
        List<SQLExpr> items = x.getItems();
        int itemSize = items.size();
        if (itemSize > 0) {
            this.print0(this.ucase ? "GROUP BY " : "group by ");
            if (x.isDistinct()) {
                this.print0(this.ucase ? "DISTINCT " : "distinct ");
            }
            ++this.indentCount;
            for (int i = 0; i < itemSize; ++i) {
                SQLExpr item = items.get(i);
                if (i != 0) {
                    if (item instanceof SQLGroupingSetExpr) {
                        if (((SQLGroupingSetExpr)item).getHasComma().booleanValue()) {
                            this.println(", ");
                        } else {
                            this.println();
                        }
                    } else if (this.groupItemSingleLine) {
                        this.println(", ");
                    } else {
                        this.print(", ");
                    }
                }
                if (item instanceof SQLIntegerExpr) {
                    this.printInteger((SQLIntegerExpr)item, false);
                } else {
                    item.accept(this);
                }
                SQLCommentHint hint = null;
                if (item instanceof SQLExprImpl) {
                    hint = ((SQLExprImpl)item).getHint();
                }
                if (hint == null) continue;
                hint.accept(this);
            }
            --this.indentCount;
        }
        if (x.isWithRollUp() && !paren) {
            this.print0(this.ucase ? " WITH ROLLUP" : " with rollup");
        }
        if (x.isWithCube() && !paren) {
            this.print0(this.ucase ? " WITH CUBE" : " with cube");
        }
        if (x.getHaving() != null) {
            this.println();
            this.print0(this.ucase ? "HAVING " : "having ");
            x.getHaving().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OdpsRollupExpr x) {
        this.print0(this.ucase ? "ROLLUP" : "rollup");
        this.print0(" (");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(OdpsRollupExpr x) {
    }

    @Override
    public boolean visit(OdpsCubeExpr x) {
        this.print0(this.ucase ? "CUBE" : "cube");
        this.print0(" (");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(OdpsCubeExpr x) {
    }

    @Override
    public boolean visit(OdpsLoadTableStatement x) {
        List<SQLExpr> withSerdeproperties;
        SQLExpr storedBy;
        SQLExpr storedAs;
        SQLExternalRecordFormat format;
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "LOAD OVERWRITE TABLE " : "load overwrite table ");
        } else {
            this.print0(this.ucase ? "LOAD INTO TABLE " : "load into table ");
        }
        x.getTableSource().accept(this);
        if (x.getPartitions().size() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(x.getPartitions(), ", ");
            this.print(')');
        }
        this.println();
        this.print0(this.ucase ? " FROM " : " from ");
        SQLExpr location = x.getLocation();
        if (location != null) {
            this.println();
            this.print0(this.ucase ? "LOCATION " : "location ");
            location.accept(this);
        }
        if ((format = x.getRowFormat()) != null) {
            this.println();
            this.print0(this.ucase ? "ROW FORMAT" : "row format");
            SQLExpr serde = format.getSerde();
            if (serde != null) {
                this.print0(this.ucase ? " SERDE " : " serde ");
                serde.accept(this);
            }
        }
        if ((storedAs = x.getStoredAs()) != null) {
            this.println();
            this.print0(this.ucase ? " STORED AS " : " stored as ");
            storedAs.accept(this);
        }
        if ((storedBy = x.getStoredBy()) != null) {
            this.println();
            this.print0(this.ucase ? " STORED BY " : " stored by ");
            storedBy.accept(this);
        }
        if ((withSerdeproperties = x.getWithSerdeproperties()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "WITH SERDEPROPERTIES (" : "with serdeproperties (");
            this.printAndAccept(withSerdeproperties, ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public void endVisit(OdpsLoadTableStatement x) {
    }

    @Override
    public void endVisit(OdpsParameterizedViewTableSource x) {
    }

    @Override
    public boolean visit(OdpsParameterizedViewTableSource x) {
        this.printTableSourceExpr(x.getExpr());
        List<SQLExpr> arguments = x.getArguments();
        this.print("(");
        if (arguments != null && arguments.size() > 0) {
            this.printAndAccept(arguments, ", ");
        }
        this.print(')');
        String alias = x.getAlias();
        List<SQLName> columns = x.getColumnsDirect();
        if (alias != null) {
            if (columns != null && columns.size() > 0 || x.hasAs()) {
                this.print0(this.ucase ? " AS " : " as ");
            } else {
                this.print(' ');
            }
            this.print0(alias);
        }
        return false;
    }

    @Override
    public boolean visit(OdpsCloneTableStatement x) {
        this.print0(this.ucase ? "CLONE TABLE " : "clone table ");
        x.getSourceTable().accept(this);
        List<SQLAssignItem> partitions = x.getPartitions();
        int partitionSize = partitions.size();
        if (partitionSize > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            for (int i = 0; i < partitionSize; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLAssignItem assign = partitions.get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print(assign.printToken());
                assign.getValue().accept(this);
            }
            this.print(')');
        }
        this.print0(this.ucase ? " TO " : " to ");
        x.getTargetTable().accept(this);
        if (!StringUtils.isEmpty(x.getOverwriteType())) {
            this.print0(this.ucase ? String.format(" IF EXISTS %s", x.getOverwriteType().toUpperCase()) : String.format("if exists %s", x.getOverwriteType().toLowerCase()));
        }
        return false;
    }

    @Override
    public void endVisit(OdpsCloneTableStatement x) {
    }

    @Override
    public boolean visit(OdpsAlterTableChangeOwner x) {
        this.print0(this.ucase ? "CHANGEOWNER TO " : "changeowner to ");
        if (x.getUser() != null) {
            x.getUser().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsAlterTableChangeOwner x) {
    }

    @Override
    public boolean visit(OdpsAlterTableMergePartition x) {
        boolean printMerge = true;
        if (x.getParent() instanceof SQLAlterTableStatement) {
            SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
            int p = stmt.getChildren().indexOf(x);
            SQLObject sqlObject = stmt.getChildren().get(p - 1);
            if (p > 0 && sqlObject instanceof OdpsAlterTableMergePartition) {
                printMerge = false;
            }
        }
        if (printMerge) {
            this.print0(this.ucase ? "MERGE " : "merge ");
            if (x.isIfExists()) {
                this.print0(this.ucase ? "IF EXISTS " : "if exists ");
            }
        } else {
            this.print('\t');
            ++this.indentCount;
        }
        if (x.getPartitions().size() != 0) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartitions(), ", ");
            this.print0(") ");
        }
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "OVERWRITE " : "overwrite ");
        }
        if (x.isPurge()) {
            this.print0(this.ucase ? "PURGE " : "purge ");
        }
        return false;
    }

    @Override
    public void endVisit(OdpsAlterTableMergePartition x) {
    }

    @Override
    public boolean visit(OdpsAliasStatement x) {
        this.print0(this.ucase ? "ALIAS " : "alias ");
        if (x.getKey() != null) {
            x.getKey().accept(this);
        }
        this.print0(" = ");
        if (x.getValue() != null) {
            x.getValue().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsAliasStatement x) {
    }

    @Override
    public boolean visit(OdpsCreateParameterizedViewStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "OR REPLACE " : "or replace ");
        }
        this.print0(this.ucase ? "VIEW " : "view ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        x.getTableSource().accept(this);
        List<OdpsParameter> parameters = x.getParameters();
        this.print0(" (");
        if (parameters != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                parameters.get(i).accept(this);
                if (i == parameters.size() - 1) continue;
                this.print0(", ");
            }
        }
        this.print0(")");
        SQLLiteralExpr comment = x.getComment();
        if (comment != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            comment.accept(this);
        }
        this.println();
        this.print0(this.ucase ? "AS" : "as");
        this.println();
        x.getSubQuery().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsCreateParameterizedViewStatement x) {
    }

    @Override
    public boolean visit(OdpsParameter x) {
        x.getName().accept(this);
        this.print0(" ");
        x.getType().accept(this);
        List<SQLTableElement> elements = x.getTableElementList();
        if (elements != null && elements.size() != 0) {
            this.print0("(");
            for (int i = 0; i < elements.size(); ++i) {
                elements.get(i).accept(this);
                if (i == elements.size() - 1) continue;
                this.print0(", ");
            }
            this.print0(")");
        }
        return false;
    }

    @Override
    public void endVisit(OdpsParameter x) {
    }

    @Override
    public boolean visit(OdpsStarColumnName x) {
        this.print0("*");
        return false;
    }

    @Override
    public void endVisit(OdpsStarColumnName x) {
    }

    @Override
    public boolean visit(OdpsUsingExpr x) {
        x.getUsingUdj().accept(this);
        if (!StringUtils.isEmpty(x.getAlias())) {
            this.print0(" ");
            this.print0(x.getAlias());
        }
        this.print0(this.ucase ? " AS (" : " as (");
        this.printAndAccept(x.getResultColumns(), ",");
        this.print0(")");
        return false;
    }

    @Override
    public void endVisit(OdpsUsingExpr x) {
    }

    @Override
    public boolean visit(OdpsSQLZOrderBy x) {
        int itemSize = x.getItems().size();
        if (itemSize > 0) {
            this.print0(this.ucase ? "ZORDER BY " : "zorder by ");
            ++this.indentCount;
            for (int i = 0; i < itemSize; ++i) {
                if (i != 0) {
                    this.println(", ");
                }
                x.getItems().get(i).accept(this);
            }
            --this.indentCount;
        }
        return false;
    }

    @Override
    public void endVisit(OdpsSQLZOrderBy x) {
    }

    @Override
    public boolean visit(OdpsCostStatement x) {
        if (x.getStatement() != null) {
            this.print0(this.ucase ? "COST SQL " : "cost sql ");
            x.getStatement().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsCostStatement x) {
        OdpsASTVisitor.super.endVisit(x);
    }

    @Override
    public boolean visit(OdpsPAIStatement x) {
        String values;
        this.print0(this.ucase ? "PAI " : "pai ");
        if (x.getName() != null) {
            this.print0("-name ");
            this.print0(x.getName());
        }
        ++this.indentCount;
        if (x.getProject() != null) {
            this.println();
            this.print0("-project ");
            this.print0(x.getProject());
        }
        if (x.getInputTables() != null) {
            for (String parameter : x.getInputTables().keySet()) {
                this.println();
                this.print0("-" + parameter + "=");
                if (x.getInputTables().get(parameter) == null) continue;
                values = x.getInputTables().get(parameter).stream().map(Object::toString).collect(Collectors.joining(","));
                this.print0(values);
            }
        }
        if (x.getOutputTables() != null) {
            for (String parameter : x.getOutputTables().keySet()) {
                this.println();
                this.print0("-" + parameter + "=");
                if (x.getOutputTables().get(parameter) == null) continue;
                values = x.getOutputTables().get(parameter).stream().map(Object::toString).collect(Collectors.joining(","));
                this.print0(values);
            }
        }
        if (x.getOutputPartitions() != null) {
            for (String parameter : x.getOutputPartitions().keySet()) {
                this.println();
                this.print0("-" + parameter + "=");
                if (x.getOutputPartitions().get(parameter) == null) continue;
                values = String.join((CharSequence)",", x.getOutputPartitions().get(parameter));
                this.print0(values);
            }
        }
        if (x.getOtherParameters() != null) {
            for (String parameter : x.getOtherParameters().keySet()) {
                this.println();
                this.print0("-" + parameter + "=");
                this.print0(x.getOtherParameters().get(parameter));
            }
        }
        --this.indentCount;
        return false;
    }

    @Override
    public void endVisit(OdpsPAIStatement x) {
        OdpsASTVisitor.super.endVisit(x);
    }

    @Override
    public boolean visit(OdpsPredicateExpr x) {
        if (x.getParameters() != null) {
            x.getParameters().accept(this);
        }
        this.print0(" -> ");
        if (x.getPredicate() != null) {
            x.getPredicate().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OdpsPivotTableSource x) {
        SQLExpr sqlExpr;
        String alias;
        if (x.getTableSource() != null) {
            x.getTableSource().accept(this);
        }
        if (x.getPivotDefinition() != null) {
            this.println();
            x.getPivotDefinition().accept0(this);
        }
        if ((alias = x.getAlias()) != null) {
            if (x.hasAs()) {
                this.print0(this.ucase ? " AS " : " as ");
            } else {
                this.print(' ');
            }
            this.print0(alias);
        }
        if ((sqlExpr = x.getAliasExpr()) != null) {
            if (x.hasAs()) {
                this.print0(this.ucase ? " AS " : " as ");
            } else {
                this.print(' ');
            }
            sqlExpr.accept(this);
        }
        if (this.isPrettyFormat() && x.hasAfterComment()) {
            this.print(' ');
            this.printlnComment(x.getAfterCommentsDirect());
        }
        return false;
    }

    @Override
    public boolean visit(OdpsPivotDefinition x) {
        Object pair;
        int i;
        this.print(this.ucase ? "PIVOT (" : "pivot (");
        ++this.indentCount;
        this.println();
        for (i = 0; i < x.getAggFunctionAndAlias().size(); ++i) {
            pair = x.getAggFunctionAndAlias().get(i);
            ((SQLMethodInvokeExpr)pair.getKey()).accept(this);
            if (pair.getValue() != null) {
                this.print(this.ucase ? " AS " : " as ");
                ((SQLName)pair.getValue()).accept(this);
            }
            if (i >= x.getAggFunctionAndAlias().size() - 1) continue;
            this.print(", ");
        }
        this.println();
        this.print(this.ucase ? "FOR " : "for ");
        x.getColumns().accept(this);
        this.println();
        this.print(this.ucase ? "IN (" : "in (");
        ++this.indentCount;
        this.println();
        for (i = 0; i < x.getValuesAndNewColumn().size(); ++i) {
            pair = x.getValuesAndNewColumn().get(i);
            ((SQLListExpr)pair.getKey()).accept(this);
            if (pair.getValue() != null) {
                this.print(this.ucase ? " AS " : " as ");
                ((SQLName)pair.getValue()).accept(this);
            }
            if (i >= x.getValuesAndNewColumn().size() - 1) continue;
            this.print(",");
            this.println();
        }
        --this.indentCount;
        this.println();
        this.print(")");
        --this.indentCount;
        this.println();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(OdpsUnpivotTableSource x) {
        SQLExpr sqlExpr;
        String alias;
        if (x.getTableSource() != null) {
            x.getTableSource().accept(this);
        }
        if (x.getUnpivotDefinition() != null) {
            this.println();
            x.getUnpivotDefinition().accept0(this);
        }
        if ((alias = x.getAlias()) != null) {
            if (x.hasAs()) {
                this.print0(this.ucase ? " AS " : " as ");
            } else {
                this.print(' ');
            }
            this.print0(alias);
        }
        if ((sqlExpr = x.getAliasExpr()) != null) {
            if (x.hasAs()) {
                this.print0(this.ucase ? " AS " : " as ");
            } else {
                this.print(' ');
            }
            sqlExpr.accept(this);
        }
        if (this.isPrettyFormat() && x.hasAfterComment()) {
            this.print(' ');
            this.printlnComment(x.getAfterCommentsDirect());
        }
        return false;
    }

    @Override
    public boolean visit(OdpsUnpivotDefinition x) {
        this.print(this.ucase ? "UNPIVOT (" : "unpivot (");
        ++this.indentCount;
        this.println();
        x.getNewColumnValues().accept(this);
        this.println();
        this.print(this.ucase ? "FOR " : "for ");
        x.getNewColumnNames().accept(this);
        this.println();
        this.print(this.ucase ? "IN (" : "in (");
        ++this.indentCount;
        this.println();
        for (int i = 0; i < x.getColumnsAndValues().size(); ++i) {
            Pair<SQLListExpr, SQLListExpr> pair = x.getColumnsAndValues().get(i);
            ((SQLListExpr)pair.getKey()).accept(this);
            if (pair.getValue() != null) {
                this.print(this.ucase ? " AS " : " as ");
                ((SQLListExpr)pair.getValue()).accept(this);
            }
            if (i >= x.getColumnsAndValues().size() - 1) continue;
            this.print(",");
            this.println();
        }
        --this.indentCount;
        this.println();
        this.print(")");
        --this.indentCount;
        this.println();
        this.print(")");
        return false;
    }
}

