/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.odps.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLAnyDataType;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.SQLTableDataType;
import com.alibaba.fastsql.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableDropPartition;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableDropPrimaryKey;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLErrorLoggingClause;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLMergeStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLObjectType;
import com.alibaba.fastsql.sql.ast.statement.SQLPrivilegeItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSetStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowCreateViewStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowFunctionsStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowPartitionsStmt;
import com.alibaba.fastsql.sql.ast.statement.SQLShowStatisticStmt;
import com.alibaba.fastsql.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowUsersStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.fastsql.sql.ast.statement.SQLWhoamiStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableDropPartition;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveMergeUpdateClause;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlKillStatement;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddFileStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddStatisticStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddTableStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddUserStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAlterTableDropColumnsItem;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCloneTableStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCostStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCountStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCreateParameterizedViewStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsGrantStmt;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsListStmt;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsLoadTableStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsPAIStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsParameter;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsReadStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsRemoveStatisticStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsRemoveUserStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsSetAssignItem;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsSetLabelStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsShowGrantsStmt;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsStarColumnName;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsStatisticClause;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsCreateTableParser;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsSelectParser;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLCreateTableParser;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLSelectParser;
import com.alibaba.fastsql.sql.parser.SQLStatementParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.List;

public class OdpsStatementParser
extends SQLStatementParser {
    public OdpsStatementParser(String sql) {
        super(new OdpsExprParser(sql, new SQLParserFeature[0]));
    }

    public OdpsStatementParser(String sql, SQLParserFeature ... features) {
        super(new OdpsExprParser(sql, features));
    }

    public OdpsStatementParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLSelectStatement parseSelect() {
        SQLSelectQueryBlock queryBlock;
        SQLSelect select = new OdpsSelectParser(this.exprParser).select();
        if (select.getWithSubQuery() == null && select.getQuery() instanceof SQLSelectQueryBlock && (queryBlock = (SQLSelectQueryBlock)select.getQuery()).getFrom() == null && queryBlock.getWhere() != null) {
            throw new ParserException("none from query not support where clause.");
        }
        return new SQLSelectStatement(select, DbType.odps);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        OdpsCreateTableParser parser = new OdpsCreateTableParser(this.exprParser);
        return parser.parseCreateTable();
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new OdpsCreateTableParser(this.exprParser);
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        int startLine = this.lexer.getPosLine();
        int startCol = this.lexer.getPosColumn();
        if (this.lexer.token() == Token.FROM) {
            SQLStatement stmt = this.parseInsert();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.token() == Token.CLONE) {
            SQLStatement stmt = this.parseClone();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("ANALYZE")) {
            SQLStatement stmt = this.parseAnalyze();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("ADD")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("STATISTIC")) {
                this.lexer.nextToken();
                OdpsAddStatisticStatement stmt = new OdpsAddStatisticStatement();
                stmt.setTable(this.exprParser.name());
                stmt.setStatisticClause(this.parseStaticClause());
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                OdpsAddUserStatement stmt = new OdpsAddUserStatement();
                stmt.setUser((SQLIdentifierExpr)this.exprParser.name());
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
            if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                OdpsAddTableStatement stmt = new OdpsAddTableStatement();
                stmt.setTable(this.exprParser.name());
                if (this.lexer.token() == Token.PARTITION) {
                    this.lexer.nextToken();
                    this.exprParser.parseAssignItem(stmt.getPartitoins(), stmt);
                }
                if (this.lexer.token() == Token.AS) {
                    this.lexer.nextToken();
                    SQLName name = this.exprParser.name();
                    stmt.getTable().setAlias(name.toString());
                }
                if (this.lexer.token() == Token.COMMENT) {
                    this.lexer.nextToken();
                    stmt.setComment(this.exprParser.primary());
                }
                if (this.lexer.token() == Token.SUB) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("f");
                    stmt.setForce(true);
                }
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.FILE) || this.lexer.identifierEquals(FnvHash.Constants.JAR) || this.lexer.identifierEquals(FnvHash.Constants.PY) || this.lexer.identifierEquals(FnvHash.Constants.ARCHIVE)) {
                OdpsAddFileStatement stmt = new OdpsAddFileStatement();
                long hash = this.lexer.hash_lower();
                if (hash == FnvHash.Constants.JAR) {
                    stmt.setType(OdpsAddFileStatement.FileType.JAR);
                } else if (hash == FnvHash.Constants.PY) {
                    stmt.setType(OdpsAddFileStatement.FileType.PY);
                } else if (hash == FnvHash.Constants.ARCHIVE) {
                    stmt.setType(OdpsAddFileStatement.FileType.ARCHIVE);
                }
                this.lexer.nextPath();
                String path = this.lexer.stringVal();
                this.lexer.nextToken();
                stmt.setFile(path);
                if (this.lexer.token() == Token.AS) {
                    this.lexer.nextToken();
                    SQLName name = this.exprParser.name();
                    stmt.setAlias(name.toString());
                }
                if (this.lexer.token() == Token.COMMENT) {
                    this.lexer.nextToken();
                    stmt.setComment(this.exprParser.primary());
                }
                if (this.lexer.token() == Token.SUB) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("f");
                    stmt.setForce(true);
                }
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals("REMOVE")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("STATISTIC")) {
                this.lexer.nextToken();
                OdpsRemoveStatisticStatement stmt = new OdpsRemoveStatisticStatement();
                stmt.setTable(this.exprParser.name());
                stmt.setStatisticClause(this.parseStaticClause());
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                OdpsRemoveUserStatement stmt = new OdpsRemoveUserStatement();
                stmt.setUser((SQLIdentifierExpr)this.exprParser.name());
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals("READ")) {
            OdpsReadStatement stmt = new OdpsReadStatement();
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                stmt.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.lexer.nextToken();
            stmt.setTable(this.exprParser.name());
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(stmt.getColumns(), stmt);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseAssignItems(stmt.getPartition(), stmt);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.LITERAL_INT) {
                stmt.setRowCount(this.exprParser.primary());
            }
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("LIST")) {
            OdpsListStmt stmt = new OdpsListStmt();
            this.lexer.nextToken();
            stmt.setObject(this.exprParser.expr());
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.token() == Token.DESC || this.lexer.identifierEquals("DESCRIBE")) {
            SQLStatement stmt = this.parseDescribe();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("WHOAMI")) {
            this.lexer.nextToken();
            SQLWhoamiStatement stmt = new SQLWhoamiStatement();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("COUNT")) {
            this.lexer.nextToken();
            OdpsCountStatement stmt = new OdpsCountStatement();
            stmt.setTable(this.exprParser.name());
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.exprParser.parseAssignItem(stmt.getPartitoins(), stmt);
            }
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("MSCK")) {
            SQLStatement stmt = this.parseMsck();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.KILL)) {
            SQLStatement stmt = this.parseKill();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("LOAD")) {
            SQLStatement stmt = this.parseLoadTable();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.MERGE)) {
            SQLStatement stmt = this.parseMerge();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("COST")) {
            OdpsCostStatement stmt = this.parseCost();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("PAI")) {
            OdpsPAIStatement stmt = this.parsePai();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        return false;
    }

    public OdpsPAIStatement parsePai() {
        this.acceptIdentifier("PAI");
        OdpsPAIStatement stmt = new OdpsPAIStatement();
        this.accept(Token.SUB);
        this.acceptIdentifier("name");
        stmt.setName(this.exprParser.name().toString());
        Lexer.SavePoint sp = this.lexer.mark();
        if (this.lexer.token() == Token.SUB) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("PROJECT")) {
                this.lexer.nextToken();
                stmt.setProject(this.exprParser.name().toString());
            } else {
                this.lexer.reset(sp);
            }
        }
        while (this.lexer.token() != Token.EOF && this.lexer.token() != Token.SEMI) {
            this.accept(Token.SUB);
            SQLName parameterKey = this.exprParser.name();
            this.accept(Token.EQ);
            String curValue = this.parseParameterValue();
            stmt.addParameter(parameterKey.toString(), curValue);
        }
        return stmt;
    }

    public String parseParameterValue() {
        Lexer.SavePoint itemStart = this.lexer.mark();
        while (!this.isParameter() && this.lexer.token() != Token.SEMI && this.lexer.token() != Token.EOF) {
            boolean isEnd;
            boolean bl = isEnd = this.lexer.ch() == '\t' || this.lexer.ch() == '\n' || this.lexer.ch() == '\r';
            if (isEnd) {
                String curValue = this.lexer.cutStringFromEnd(itemStart);
                this.lexer.nextToken();
                return curValue;
            }
            this.lexer.nextToken();
        }
        return this.lexer.cutStringFromStart(itemStart);
    }

    public boolean isParameter() {
        return this.lexer.token() == Token.SUB && this.lexer.ch() == 'D';
    }

    public OdpsCostStatement parseCost() {
        this.acceptIdentifier("COST");
        this.acceptIdentifier("SQL");
        OdpsCostStatement costStatement = new OdpsCostStatement();
        costStatement.setStatement(this.parseStatement());
        return costStatement;
    }

    private void parseMergeUpdateSet(SQLMergeStatement.MergeUpdateClause updateClause) {
        while (true) {
            SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
            updateClause.addItem(item);
            item.setParent(updateClause);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    @Override
    public SQLStatement parseMerge() {
        this.acceptIdentifier(Token.MERGE.name);
        SQLMergeStatement stmt = new SQLMergeStatement();
        stmt.setDbType(this.dbType);
        this.accept(Token.INTO);
        stmt.setInto(this.exprParser.name());
        stmt.getInto().setAlias(this.tableAlias());
        this.acceptIdentifier("USING");
        SQLTableSource using = this.createSQLSelectParser().parseTableSource();
        stmt.setUsing(using);
        this.accept(Token.ON);
        stmt.setOn(this.exprParser.expr());
        boolean insertFlag = false;
        if (this.lexer.token() == Token.WHEN) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(Token.MATCHED.name)) {
                HiveMergeUpdateClause updateClause = new HiveMergeUpdateClause();
                this.lexer.nextToken();
                SQLExpr firstWhere = null;
                if (this.lexer.token() == Token.AND) {
                    this.lexer.nextToken();
                    firstWhere = this.exprParser.expr();
                }
                this.accept(Token.THEN);
                if (this.lexer.token() == Token.UPDATE) {
                    this.accept(Token.UPDATE);
                    this.accept(Token.SET);
                    this.parseMergeUpdateSet(updateClause);
                    updateClause.setWhere(firstWhere);
                    SQLExpr deleteWhere = null;
                    if (this.lexer.token() == Token.WHEN) {
                        this.lexer.nextToken();
                        if (this.lexer.identifierEquals(Token.MATCHED.name)) {
                            this.lexer.nextToken();
                            if (this.lexer.token() == Token.AND) {
                                this.lexer.nextToken();
                                deleteWhere = this.exprParser.expr();
                            }
                            this.accept(Token.THEN);
                            this.accept(Token.DELETE);
                            updateClause.setDeleteWhere(deleteWhere);
                            updateClause.setHasDelete(true);
                        }
                    }
                } else {
                    this.accept(Token.DELETE);
                    updateClause.setHasDelete(true);
                    updateClause.setDeleteWhere(firstWhere);
                    updateClause.setDeleteFirst(true);
                    SQLExpr updateWhere = null;
                    if (this.lexer.token() == Token.WHEN) {
                        this.lexer.nextToken();
                        if (this.lexer.identifierEquals(Token.MATCHED.name)) {
                            this.lexer.nextToken();
                            if (this.lexer.token() == Token.AND) {
                                this.lexer.nextToken();
                                updateWhere = this.exprParser.expr();
                            }
                            this.accept(Token.THEN);
                            this.accept(Token.UPDATE);
                            this.accept(Token.SET);
                            this.parseMergeUpdateSet(updateClause);
                            updateClause.setWhere(updateWhere);
                        }
                    }
                }
                stmt.setUpdateClause(updateClause);
            } else if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                insertFlag = true;
            }
        }
        if (!insertFlag) {
            if (this.lexer.token() == Token.WHEN) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                insertFlag = true;
            }
        }
        if (insertFlag) {
            SQLMergeStatement.MergeInsertClause insertClause = new SQLMergeStatement.MergeInsertClause();
            this.acceptIdentifier(Token.MATCHED.name);
            if (this.lexer.token() == Token.AND) {
                this.lexer.nextToken();
                insertClause.setWhere(this.exprParser.expr());
            }
            this.accept(Token.THEN);
            this.accept(Token.INSERT);
            if (this.lexer.token() == Token.LPAREN) {
                this.accept(Token.LPAREN);
                this.exprParser.exprList(insertClause.getColumns(), insertClause);
                this.accept(Token.RPAREN);
            }
            this.accept(Token.VALUES);
            this.accept(Token.LPAREN);
            this.exprParser.exprList(insertClause.getValues(), insertClause);
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                insertClause.setWhere(this.exprParser.expr());
            }
            stmt.setInsertClause(insertClause);
        }
        SQLErrorLoggingClause errorClause = this.parseErrorLoggingClause();
        stmt.setErrorLoggingClause(errorClause);
        return stmt;
    }

    private SQLStatement parseClone() {
        SQLName tableName;
        this.accept(Token.CLONE);
        this.accept(Token.TABLE);
        OdpsCloneTableStatement cloneTableStatement = new OdpsCloneTableStatement();
        if (this.lexer.token() == Token.IDENTIFIER) {
            tableName = this.exprParser.name();
            SQLExprTableSource sourceTable = new SQLExprTableSource(tableName);
            cloneTableStatement.setSourceTable(sourceTable);
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLAssignItem ptExpr = new SQLAssignItem();
                ptExpr.setTarget(this.exprParser.name());
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextTokenValue();
                    SQLExpr ptValue = this.exprParser.expr();
                    ptExpr.setValue(ptValue);
                }
                cloneTableStatement.addPartition(ptExpr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        this.accept(Token.TO);
        if (this.lexer.token() == Token.IDENTIFIER) {
            tableName = this.exprParser.name();
            SQLExprTableSource targetTable = new SQLExprTableSource(tableName);
            cloneTableStatement.setTargetTable(targetTable);
        }
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            cloneTableStatement.setOverwriteType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        return cloneTableStatement;
    }

    @Override
    public SQLStatement parseKill() {
        this.acceptIdentifier("KILL");
        MySqlKillStatement stmt = new MySqlKillStatement();
        SQLExpr instanceId = this.exprParser.primary();
        stmt.setThreadId(instanceId);
        return stmt;
    }

    public SQLStatement parseLoadTable() {
        this.lexer.nextToken();
        OdpsLoadTableStatement stmt = new OdpsLoadTableStatement();
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.OVERWRITE) {
            this.accept(Token.OVERWRITE);
            stmt.setOverwrite(true);
        }
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            stmt.setTableSource(this.exprParser.name());
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.exprParser.parseAssignItem(stmt.getPartitions(), stmt);
        }
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
            this.lexer.nextToken();
            SQLExpr location = this.exprParser.expr();
            stmt.setLocation(location);
        }
        if (this.lexer.token() == Token.ROW || this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
            this.lexer.nextToken();
            this.acceptIdentifier("FORMAT");
            SQLExternalRecordFormat format = new SQLExternalRecordFormat();
            if (this.lexer.identifierEquals(FnvHash.Constants.SERDE)) {
                this.lexer.nextToken();
                format.setSerde(this.exprParser.expr());
                stmt.setRowFormat(format);
            }
        }
        this.tokenWithSerdeproperties(stmt);
        while (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
                SQLName storedAs = this.exprParser.name();
                stmt.setStoredAs(storedAs);
                continue;
            }
            this.accept(Token.BY);
            SQLExpr storedBy = this.exprParser.expr();
            stmt.setStoredBy(storedBy);
        }
        this.tokenWithSerdeproperties(stmt);
        return stmt;
    }

    private void tokenWithSerdeproperties(OdpsLoadTableStatement stmt) {
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("SERDEPROPERTIES");
            this.accept(Token.LPAREN);
            this.exprParser.exprList(stmt.getWithSerdeproperties(), stmt);
            this.accept(Token.RPAREN);
        }
    }

    protected OdpsStatisticClause parseStaticClause() {
        if (this.lexer.identifierEquals("TABLE_COUNT")) {
            this.lexer.nextToken();
            return new OdpsStatisticClause.TableCount();
        }
        if (this.lexer.identifierEquals("NULL_VALUE")) {
            this.lexer.nextToken();
            OdpsStatisticClause.NullValue null_value = new OdpsStatisticClause.NullValue();
            null_value.setColumn(this.exprParser.name());
            return null_value;
        }
        if (this.lexer.identifierEquals("COLUMN_SUM")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnSum column_sum = new OdpsStatisticClause.ColumnSum();
            column_sum.setColumn(this.exprParser.name());
            return column_sum;
        }
        if (this.lexer.identifierEquals("COLUMN_MAX")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnMax column_max = new OdpsStatisticClause.ColumnMax();
            column_max.setColumn(this.exprParser.name());
            return column_max;
        }
        if (this.lexer.identifierEquals("COLUMN_MIN")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnMin column_min = new OdpsStatisticClause.ColumnMin();
            column_min.setColumn(this.exprParser.name());
            return column_min;
        }
        if (this.lexer.identifierEquals("EXPRESSION_CONDITION")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ExpressionCondition expr_condition = new OdpsStatisticClause.ExpressionCondition();
            expr_condition.setExpr(this.exprParser.expr());
            return expr_condition;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    public SQLStatement parseInsert() {
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            HiveMultiInsertStatement stmt = new HiveMultiInsertStatement();
            if (this.lexer.token() == Token.IDENTIFIER) {
                SQLName tableName = this.exprParser.name();
                SQLExprTableSource from = new SQLExprTableSource(tableName);
                stmt.setFrom(this.parseTableSourceRest(from));
            } else {
                this.accept(Token.LPAREN);
                SQLSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect select = selectParser.select();
                this.accept(Token.RPAREN);
                SQLSubqueryTableSource from = new SQLSubqueryTableSource(select);
                if (this.lexer.token() == Token.AS) {
                    this.lexer.nextToken();
                    from.hasAs(true);
                }
                if (this.lexer.token() == Token.IDENTIFIER) {
                    String alias = this.lexer.stringVal();
                    this.accept(Token.IDENTIFIER);
                    from.setAlias(alias);
                }
                stmt.setFrom(from);
            }
            do {
                HiveInsert insert = this.parseHiveInsert();
                stmt.addItem(insert);
            } while (this.lexer.token() == Token.INSERT);
            return stmt;
        }
        return this.parseHiveInsertStmt();
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new OdpsSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLStatement parseShow() {
        this.accept(Token.SHOW);
        if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
            this.lexer.nextToken();
            SQLShowPartitionsStmt stmt = new SQLShowPartitionsStmt();
            SQLExpr expr = this.exprParser.expr();
            stmt.setTableSource(new SQLExprTableSource(expr));
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STATISTIC)) {
            this.lexer.nextToken();
            SQLShowStatisticStmt stmt = new SQLShowStatisticStmt();
            SQLExpr expr = this.exprParser.expr();
            stmt.setTableSource(new SQLExprTableSource(expr));
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TABLES)) {
            this.lexer.nextToken();
            SQLShowTablesStatement stmt = new SQLShowTablesStatement();
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setDatabase(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.GRANTS)) {
            this.lexer.nextToken();
            OdpsShowGrantsStmt stmt = new OdpsShowGrantsStmt();
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                stmt.setUser(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                this.acceptIdentifier("type");
                stmt.setObjectType(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.USERS)) {
            this.lexer.nextToken();
            SQLShowUsersStatement stmt = new SQLShowUsersStatement();
            return stmt;
        }
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                SQLShowCreateTableStatement sqlShowCreateTableStatement = new SQLShowCreateTableStatement();
                sqlShowCreateTableStatement.setName(this.exprParser.name());
                return sqlShowCreateTableStatement;
            }
            if (this.lexer.token() == Token.VIEW) {
                this.lexer.nextToken();
                SQLShowCreateViewStatement sqlShowCreateViewStatement = new SQLShowCreateViewStatement();
                sqlShowCreateViewStatement.setName(this.exprParser.name());
                return sqlShowCreateViewStatement;
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.FUNCTIONS)) {
            this.lexer.nextToken();
            SQLShowFunctionsStatement stmt = new SQLShowFunctionsStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                SQLExpr like = this.exprParser.expr();
                stmt.setLike(like);
            }
            return stmt;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    public SQLStatement parseSet() {
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        this.accept(Token.SET);
        if (this.lexer.identifierEquals("LABEL")) {
            OdpsSetLabelStatement stmt = new OdpsSetLabelStatement();
            if (comments != null) {
                stmt.addBeforeComment(comments);
            }
            this.lexer.nextToken();
            stmt.setLabel(this.lexer.stringVal());
            this.lexer.nextToken();
            this.accept(Token.TO);
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                SQLName name = this.exprParser.name();
                stmt.setUser(name);
                return stmt;
            }
            this.accept(Token.TABLE);
            SQLName expr = this.exprParser.name();
            stmt.setTable(new SQLExprTableSource(expr));
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(stmt.getColumns(), stmt);
                this.accept(Token.RPAREN);
            }
            return stmt;
        }
        SQLSetStatement stmt = new SQLSetStatement(this.dbType);
        stmt.putAttribute("parser.set", Boolean.TRUE);
        if (comments != null) {
            stmt.addBeforeComment(comments);
        }
        this.parseSetAssignItem(stmt.getItems(), stmt);
        return stmt;
    }

    public void parseSetAssignItem(List<? super SQLAssignItem> items, SQLObject parent) {
        this.parseSetAssignItem(items, parent, true);
    }

    public void parseSetAssignItem(List<? super SQLAssignItem> items, SQLObject parent, boolean variant) {
        OdpsSetAssignItem item = new OdpsSetAssignItem();
        SQLExpr var = this.exprParser.primary();
        if (variant && var instanceof SQLIdentifierExpr) {
            var = new SQLVariantRefExpr(((SQLIdentifierExpr)var).getName());
        }
        item.setTarget(var);
        this.accept(Token.EQ);
        item.setToken(Token.EQ);
        SQLExpr expr = this.parseSetAssignValue();
        if (this.lexer.token() == Token.COMMA) {
            SQLListExpr listExpr = new SQLListExpr();
            listExpr.addItem(expr);
            expr.setParent(listExpr);
            do {
                this.lexer.nextToken();
                SQLExpr listItem = this.parseSetAssignValue();
                listItem.setParent(listExpr);
                listExpr.addItem(listItem);
            } while (this.lexer.token() == Token.COMMA);
            item.setValue(listExpr);
        } else {
            item.setValue(expr);
        }
        items.add(item);
    }

    @Override
    public OdpsGrantStmt parseGrant() {
        this.accept(Token.GRANT);
        OdpsGrantStmt stmt = new OdpsGrantStmt();
        if (this.lexer.identifierEquals("LABEL")) {
            stmt.setLabel(true);
            this.lexer.nextToken();
            stmt.setLabel(this.exprParser.expr());
        } else {
            if (this.lexer.identifierEquals("SUPER")) {
                stmt.setSuper(true);
                this.lexer.nextToken();
            }
            this.parsePrivileages(stmt.getPrivileges(), stmt);
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("PROJECT")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.PROJECT);
            } else if (this.lexer.identifierEquals("PACKAGE")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.PACKAGE);
            } else if (this.lexer.token() == Token.FUNCTION) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.FUNCTION);
            } else if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.TABLE);
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.names(stmt.getColumns(), stmt);
                    this.accept(Token.RPAREN);
                }
            } else if (this.lexer.identifierEquals("RESOURCE")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.RESOURCE);
            } else if (this.lexer.identifierEquals("INSTANCE")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.INSTANCE);
            } else if (this.lexer.identifierEquals("JOB")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.JOB);
            } else if (this.lexer.identifierEquals("VOLUME")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.VOLUME);
            } else if (this.lexer.identifierEquals("OfflineModel")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.OfflineModel);
            } else if (this.lexer.identifierEquals("XFLOW")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.XFLOW);
            }
            stmt.setResource(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                stmt.setSubjectType(SQLObjectType.USER);
            } else if (this.lexer.identifierEquals("ROLE")) {
                this.lexer.nextToken();
                stmt.setSubjectType(SQLObjectType.ROLE);
            }
            stmt.getUsers().add(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("EXP");
            stmt.setExpire(this.exprParser.expr());
        }
        return stmt;
    }

    @Override
    protected void parsePrivileages(List<SQLPrivilegeItem> privileges, SQLObject parent) {
        while (true) {
            String privilege = null;
            if (this.lexer.token() == Token.ALL) {
                this.lexer.nextToken();
                privilege = "ALL";
            } else if (this.lexer.token() == Token.SELECT) {
                privilege = "SELECT";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.UPDATE) {
                privilege = "UPDATE";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DELETE) {
                privilege = "DELETE";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.INSERT) {
                privilege = "INSERT";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                privilege = "DROP";
            } else if (this.lexer.token() == Token.ALTER) {
                this.lexer.nextToken();
                privilege = "ALTER";
            } else if (this.lexer.identifierEquals("DESCRIBE")) {
                privilege = "DESCRIBE";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("READ")) {
                privilege = "READ";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("WRITE")) {
                privilege = "WRITE";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("EXECUTE")) {
                this.lexer.nextToken();
                privilege = "EXECUTE";
            } else if (this.lexer.identifierEquals("LIST")) {
                this.lexer.nextToken();
                privilege = "LIST";
            } else if (this.lexer.identifierEquals("CreateTable")) {
                this.lexer.nextToken();
                privilege = "CreateTable";
            } else if (this.lexer.identifierEquals("CreateInstance")) {
                this.lexer.nextToken();
                privilege = "CreateInstance";
            } else if (this.lexer.identifierEquals("CreateFunction")) {
                this.lexer.nextToken();
                privilege = "CreateFunction";
            } else if (this.lexer.identifierEquals("CreateResource")) {
                this.lexer.nextToken();
                privilege = "CreateResource";
            } else if (this.lexer.identifierEquals("CreateJob")) {
                this.lexer.nextToken();
                privilege = "CreateJob";
            } else if (this.lexer.identifierEquals("CreateVolume")) {
                this.lexer.nextToken();
                privilege = "CreateVolume";
            } else if (this.lexer.identifierEquals("CreateOfflineModel")) {
                this.lexer.nextToken();
                privilege = "CreateOfflineModel";
            } else if (this.lexer.identifierEquals("CreateXflow")) {
                this.lexer.nextToken();
                privilege = "CreateXflow";
            }
            SQLExpr expr = null;
            expr = privilege != null ? new SQLIdentifierExpr(privilege) : this.exprParser.expr();
            SQLPrivilegeItem privilegeItem = new SQLPrivilegeItem();
            privilegeItem.setAction(expr);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                while (true) {
                    privilegeItem.getColumns().add(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            expr.setParent(parent);
            privileges.add(privilegeItem);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    @Override
    public SQLCreateViewStatement parseCreateView() {
        Lexer.SavePoint savePoint = this.lexer.mark();
        OdpsCreateParameterizedViewStatement createView = new OdpsCreateParameterizedViewStatement();
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            createView.setOrReplace(true);
        }
        if (this.lexer.identifierEquals("ALGORITHM")) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            String algorithm = this.lexer.stringVal();
            createView.setAlgorithm(algorithm);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DEFINER)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLName definer = ((MySqlExprParser)this.exprParser).userName();
            createView.setDefiner(definer);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SQL)) {
            this.lexer.nextToken();
            this.acceptIdentifier("SECURITY");
            String sqlSecurity = this.lexer.stringVal();
            createView.setSqlSecurity(sqlSecurity);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
            this.lexer.nextToken();
            createView.setForce(true);
        }
        if (this.lexer.token() == Token.LOGICALVIEW) {
            this.lexer.nextToken();
            createView.setLogicalView(true);
        } else {
            this.accept(Token.VIEW);
        }
        if (this.lexer.token() == Token.IF || this.lexer.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createView.setIfNotExists(true);
        }
        createView.setName(this.exprParser.name());
        if (this.lexer.token() != Token.LPAREN) {
            this.lexer.reset(savePoint);
            return super.parseCreateView();
        }
        this.accept(Token.LPAREN);
        if (this.lexer.token() != Token.VARIANT) {
            this.lexer.reset(savePoint);
            return super.parseCreateView();
        }
        while (true) {
            OdpsParameter parameter;
            SQLDataType type;
            int startLine = this.lexer.getPosLine();
            int startColumn = this.lexer.getPosColumn();
            SQLName name = this.exprParser.name();
            if (this.lexer.token() == Token.TABLE) {
                type = this.parseParameterType();
                parameter = new OdpsParameter(name, type);
                parameter.setStartLine(startLine);
                parameter.setStartColumn(startColumn);
                this.accept(Token.LPAREN);
                do {
                    SQLColumnDefinition column = this.parseTableParameterColumn();
                    parameter.addTableElement(column);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                } while (this.lexer.token() != Token.RPAREN);
                this.accept(Token.RPAREN);
                createView.addParameter(parameter);
            } else {
                type = this.parseParameterType();
                parameter = new OdpsParameter(name, type);
                parameter.setStartColumn(startColumn);
                parameter.setStartLine(startLine);
                createView.addParameter(parameter);
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            SQLCharExpr comment = (SQLCharExpr)this.exprParser.primary();
            createView.setComment(comment);
        }
        this.accept(Token.AS);
        SQLSelectParser selectParser = this.createSQLSelectParser();
        createView.setSubQuery(selectParser.select());
        return createView;
    }

    public SQLDataType parseParameterType() {
        Token token = this.lexer.token();
        if (token == Token.TABLE) {
            this.lexer.nextToken();
            return new SQLTableDataType();
        }
        if (token == Token.ANY) {
            this.lexer.nextToken();
            return new SQLAnyDataType();
        }
        return this.exprParser.parseDataType();
    }

    public SQLColumnDefinition parseTableParameterColumn() {
        SQLColumnDefinition column = this.exprParser.createColumnDefinition();
        column.setName(this.parseTableParameterColumnName());
        column.setDataType(this.parseParameterType());
        return column;
    }

    public SQLName parseTableParameterColumnName() {
        if (this.lexer.token() == Token.STAR) {
            OdpsStarColumnName star = new OdpsStarColumnName();
            this.lexer.setStartPos(star);
            this.lexer.nextToken();
            return star;
        }
        return this.exprParser.name();
    }

    @Override
    public SQLStatement parseWith() {
        SQLWithSubqueryClause with = this.parseWithQuery();
        if (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.LPAREN) {
            SQLSelectParser selectParser = this.createSQLSelectParser();
            SQLSelect select = selectParser.select();
            select.setWithSubQuery(with);
            return new SQLSelectStatement(select, this.dbType);
        }
        if (this.lexer.token() == Token.INSERT) {
            SQLInsertStatement insert = (SQLInsertStatement)this.parseInsert();
            insert.setWith(with);
            return insert;
        }
        if (this.lexer.token() == Token.FROM) {
            HiveMultiInsertStatement insert = (HiveMultiInsertStatement)this.parseInsert();
            insert.setWith(with);
            return insert;
        }
        this.printError(Token.SELECT, Token.INSERT, Token.FROM);
        throw new ParserException("TODO. " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
    }

    @Override
    protected SQLAlterTableItem parseAlterTableDropPartition(boolean ifExists) {
        this.lexer.nextToken();
        SQLAlterTableDropPartition dropPartition = new SQLAlterTableDropPartition();
        dropPartition.setIfExists(ifExists);
        if (this.lexer.token() == Token.LPAREN) {
            this.accept(Token.LPAREN);
            this.parsePartitionConditions(dropPartition.getPartitions(), dropPartition, false);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals("PURGE")) {
                this.lexer.nextToken();
                dropPartition.setPurge(true);
            }
        } else {
            while (true) {
                SQLExpr partition = this.exprParser.expr();
                dropPartition.addPartition(partition);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            dropPartition.getAttributes().put("SIMPLE", true);
        }
        return dropPartition;
    }

    public void parsePartitionConditions(List<? super SQLObject> items, SQLObject parent, boolean variant) {
        while (true) {
            SQLObject item = this.parsePartitionCondition(variant);
            item.setParent(parent);
            items.add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    public SQLObject parsePartitionCondition(boolean variant) {
        SQLAssignItem item = new SQLAssignItem();
        SQLExpr var = this.exprParser.primary();
        if (variant && var instanceof SQLIdentifierExpr) {
            var = new SQLVariantRefExpr(((SQLIdentifierExpr)var).getName());
        }
        item.setTarget(var);
        if (this.lexer.token() == Token.COLONEQ) {
            this.lexer.nextToken();
        } else {
            if (this.lexer.token() == Token.TRUE || this.lexer.identifierEquals(FnvHash.Constants.TRUE)) {
                this.lexer.nextToken();
                item.setValue(new SQLBooleanExpr(true));
                return item;
            }
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                item.setValue(new SQLIdentifierExpr("ON"));
                return item;
            }
            if (this.lexer.token() == Token.RPAREN || this.lexer.token() == Token.COMMA) {
                return item;
            }
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            } else if (this.dbType != DbType.db2 && this.lexer.token() != Token.QUES && this.lexer.token() != Token.LITERAL_CHARS && this.lexer.token() != Token.LITERAL_ALIAS) {
                if (this.lexer.token() == Token.GT) {
                    item.setToken(Token.GT);
                    this.accept(Token.GT);
                } else if (this.lexer.token() == Token.LT) {
                    item.setToken(Token.LT);
                    this.accept(Token.LT);
                } else if (this.lexer.token() == Token.LTEQ) {
                    item.setToken(Token.LTEQ);
                    this.accept(Token.LTEQ);
                } else if (this.lexer.token() == Token.GTEQ) {
                    item.setToken(Token.GTEQ);
                    this.accept(Token.GTEQ);
                } else if (this.lexer.token() == Token.LTGT) {
                    item.setToken(Token.LTGT);
                    this.accept(Token.LTGT);
                } else if (this.lexer.token() == Token.IS) {
                    item.setToken(Token.IS);
                } else if (this.lexer.token() == Token.LIKE) {
                    item.setToken(Token.LIKE);
                    this.accept(Token.LIKE);
                } else if (this.lexer.token() == Token.RLIKE) {
                    item.setToken(Token.RLIKE);
                    this.accept(Token.RLIKE);
                } else if (this.lexer.token() == Token.IN) {
                    item.setToken(Token.IN);
                    this.accept(Token.IN);
                } else if (this.lexer.token() == Token.BETWEEN || this.lexer.token() == Token.NOT) {
                    item.setToken(Token.BETWEEN);
                } else {
                    this.accept(Token.EQ);
                }
            }
        }
        if (this.lexer.token() == Token.ON) {
            item.setValue(new SQLIdentifierExpr(this.lexer.stringVal()));
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.ALL) {
            item.setValue(new SQLIdentifierExpr(this.lexer.stringVal()));
            this.lexer.nextToken();
        } else {
            if (item.getToken() == Token.BETWEEN || item.getToken() == Token.IS) {
                return this.exprParser.exprRest(item.getTarget());
            }
            SQLExpr expr = this.exprParser.expr();
            if (item.getToken() == Token.IN && !(expr instanceof SQLListExpr)) {
                expr = new SQLListExpr(expr);
            }
            if (this.lexer.token() == Token.COMMA && DbType.postgresql == this.dbType) {
                SQLListExpr listExpr = new SQLListExpr();
                listExpr.addItem(expr);
                expr.setParent(listExpr);
                do {
                    this.lexer.nextToken();
                    SQLExpr listItem = this.exprParser.expr();
                    listItem.setParent(listExpr);
                    listExpr.addItem(listItem);
                } while (this.lexer.token() == Token.COMMA);
                item.setValue(listExpr);
            } else {
                item.setValue(expr);
            }
        }
        return item;
    }

    @Override
    public void parseAlterDrop(SQLAlterTableStatement stmt) {
        this.lexer.nextToken();
        boolean ifExists = false;
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            ifExists = true;
        }
        if (this.lexer.token() == Token.CONSTRAINT) {
            this.lexer.nextToken();
            SQLAlterTableDropConstraint item = new SQLAlterTableDropConstraint();
            if (this.lexer.token() == Token.IF) {
                this.lexer.nextToken();
                this.accept(Token.EXISTS);
                item.setIfExists(true);
            }
            item.setConstraintName(this.exprParser.name());
            if (this.lexer.token() == Token.RESTRICT) {
                this.lexer.nextToken();
                item.setRestrict(true);
            }
            if (this.lexer.token() == Token.CASCADE) {
                this.lexer.nextToken();
                item.setCascade(true);
            }
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.COLUMN) {
            this.lexer.nextToken();
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            SQLName sqlName = this.exprParser.name();
            sqlName.setParent(item);
            item.getColumns().add(sqlName);
            while (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.IDENTIFIER) break;
                sqlName = this.exprParser.name();
                sqlName.setParent(item);
                item.getColumns().add(sqlName);
            }
            if (this.lexer.token() == Token.CASCADE) {
                item.setCascade(true);
                this.lexer.nextToken();
            }
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.LITERAL_ALIAS) {
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            this.exprParser.names(item.getColumns());
            if (this.lexer.token() == Token.CASCADE) {
                item.setCascade(true);
                this.lexer.nextToken();
            }
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.DEFAULT && (DbType.adb_pg == this.dbType || DbType.greenplum == this.dbType)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.PARTITION) {
                GreenplumAlterTableDropPartition dropPartition = (GreenplumAlterTableDropPartition)this.parseAlterTableDropPartition(ifExists);
                dropPartition.setDefault(true);
                stmt.addItem(dropPartition);
            }
        } else if (this.lexer.token() == Token.PARTITION) {
            SQLAlterTableItem dropPartition = this.parseAlterTableDropPartition(ifExists);
            stmt.addItem(dropPartition);
            while (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                Lexer.SavePoint mark = this.lexer.mark();
                if (this.lexer.token() == Token.PARTITION) {
                    SQLAlterTableItem dropPartition2 = this.parseAlterTableDropPartition(ifExists);
                    stmt.addItem(dropPartition2);
                    continue;
                }
                this.lexer.reset(mark);
            }
        } else if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
            SQLName indexName = this.exprParser.name();
            SQLAlterTableDropIndex item = new SQLAlterTableDropIndex();
            item.setIndexName(indexName);
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.PRIMARY) {
            this.lexer.nextToken();
            this.accept(Token.KEY);
            SQLAlterTableDropPrimaryKey item = new SQLAlterTableDropPrimaryKey();
            stmt.addItem(item);
        } else if (this.lexer.identifierEquals(Token.COLUMNS.name)) {
            this.lexer.nextToken();
            OdpsAlterTableDropColumnsItem item = new OdpsAlterTableDropColumnsItem();
            SQLName sqlName = this.exprParser.name();
            sqlName.setParent(item);
            item.getColumns().add(sqlName);
            while (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.IDENTIFIER) break;
                sqlName = this.exprParser.name();
                sqlName.setParent(item);
                item.getColumns().add(sqlName);
            }
            stmt.addItem(item);
        } else {
            throw new ParserException("TODO " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
        }
    }
}

