/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.odps.parser;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLGroupingSetExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLRealExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLSizeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQualifyClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSampling;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCubeExpr;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsParameterizedViewTableSource;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsPivotDefinition;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsPivotTableSource;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsRollupExpr;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsUnpivotDefinition;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsUnpivotTableSource;
import com.alibaba.fastsql.sql.parser.EOFParserException;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLSelectListCache;
import com.alibaba.fastsql.sql.parser.SQLSelectParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class OdpsSelectParser
extends SQLSelectParser {
    public OdpsSelectParser(SQLExprParser exprParser) {
        super(exprParser.getLexer());
        this.exprParser = exprParser;
    }

    public OdpsSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser.getLexer());
        this.exprParser = exprParser;
        this.selectListCache = selectListCache;
    }

    @Override
    public SQLSelectQuery query(SQLObject parent, boolean acceptUnion) {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select, acceptUnion);
        }
        OdpsSelectQueryBlock queryBlock = new OdpsSelectQueryBlock();
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            queryBlock.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.SELECT);
        if (this.lexer.token() == Token.HINT) {
            this.exprParser.parseHints(queryBlock.getHints());
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.DISTINCT) {
            queryBlock.setDistionOption(2);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.UNIQUE) {
            queryBlock.setDistionOption(3);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.ALL) {
            queryBlock.setDistionOption(1);
            this.lexer.nextToken();
        }
        this.parseSelectList(queryBlock);
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        this.parseQualify(queryBlock);
        queryBlock.setOrderBy(this.exprParser.parseOrderBy());
        if (this.lexer.token() == Token.DISTRIBUTE) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem distributeByItem = this.exprParser.parseSelectOrderByItem();
                queryBlock.addDistributeBy(distributeByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SORT)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem sortByItem = this.exprParser.parseSelectOrderByItem();
                queryBlock.addSortBy(sortByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTER)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem clusterByItem = this.exprParser.parseSelectOrderByItem();
                queryBlock.addClusterBy(clusterByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.LIMIT) {
            SQLLimit limit = this.exprParser.parseLimit();
            queryBlock.setLimit(limit);
        }
        return this.queryRest(queryBlock, acceptUnion);
    }

    public void parseQualify(OdpsSelectQueryBlock queryBlock) {
        if (this.lexer.identifierEquals(Token.QUALIFY.name)) {
            SQLExpr qualify;
            this.lexer.nextTokenIdent();
            List<String> beforeComments = null;
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                beforeComments = this.lexer.readAndResetComments();
            }
            if (this.lexer.token() == Token.IDENTIFIER) {
                SQLExpr identExpr;
                String ident = this.lexer.stringVal();
                long hash_lower = this.lexer.hash_lower();
                this.lexer.nextTokenEq();
                int startLine = this.lexer.getPosLine();
                int startCol = this.lexer.getPosColumn();
                if (this.lexer.token() == Token.LITERAL_CHARS) {
                    String literal = this.lexer.stringVal();
                    if (hash_lower == FnvHash.Constants.TIMESTAMP) {
                        identExpr = new SQLTimestampExpr(literal);
                        this.lexer.nextToken();
                    } else if (hash_lower == FnvHash.Constants.DATE) {
                        identExpr = new SQLDateExpr(literal);
                        this.lexer.nextToken();
                    } else if (hash_lower == FnvHash.Constants.REAL) {
                        identExpr = new SQLRealExpr(Float.parseFloat(literal));
                        this.lexer.nextToken();
                    } else if (hash_lower == FnvHash.Constants.TIME) {
                        identExpr = new SQLTimeExpr(this.lexer.stringVal());
                        this.lexer.nextToken();
                    } else {
                        identExpr = new SQLIdentifierExpr(ident, hash_lower);
                    }
                } else {
                    identExpr = new SQLIdentifierExpr(ident, hash_lower);
                }
                if (this.lexer.token() == Token.DOT) {
                    identExpr = this.exprParser.primaryRest(identExpr);
                }
                identExpr.setStartLine(startLine);
                identExpr.setStartColumn(startCol);
                if (this.lexer.token() == Token.EQ) {
                    SQLExpr rightExp;
                    this.lexer.nextToken();
                    try {
                        rightExp = this.exprParser.bitOr();
                    }
                    catch (EOFParserException e) {
                        throw new ParserException("EOF, " + ident + "=", this.lexer.getPosLine(), this.lexer.getPosColumn());
                    }
                    qualify = new SQLBinaryOpExpr(identExpr, SQLBinaryOperator.Equality, rightExp, this.dbType);
                    switch (this.lexer.token()) {
                        case BETWEEN: 
                        case IS: 
                        case EQ: 
                        case IN: 
                        case CONTAINS: 
                        case BANG_TILDE_STAR: 
                        case TILDE_EQ: 
                        case LT: 
                        case LTEQ: 
                        case LTEQGT: 
                        case GT: 
                        case GTEQ: 
                        case LTGT: 
                        case BANGEQ: 
                        case LIKE: 
                        case NOT: {
                            qualify = this.exprParser.relationalRest(qualify);
                            break;
                        }
                    }
                    qualify = this.exprParser.andRest(qualify);
                    qualify = this.exprParser.xorRest(qualify);
                    qualify = this.exprParser.orRest(qualify);
                } else {
                    identExpr = this.exprParser.primaryRest(identExpr);
                    qualify = this.exprParser.exprRest(identExpr);
                }
            } else {
                while (this.lexer.token() == Token.HINT) {
                    this.lexer.nextToken();
                }
                qualify = this.exprParser.expr();
                while (this.lexer.token() == Token.HINT) {
                    this.lexer.nextToken();
                }
            }
            if (beforeComments != null) {
                qualify.addBeforeComment(beforeComments);
            }
            if (this.lexer.hasComment() && this.lexer.isKeepComments() && this.lexer.token() != Token.INSERT) {
                qualify.addAfterComment(this.lexer.readAndResetComments());
            }
            SQLSelectQualifyClause qualifyClause = new SQLSelectQualifyClause();
            qualifyClause.setQualify(qualify);
            queryBlock.setQualify(qualifyClause);
        }
    }

    @Override
    public SQLTableSource parseTableSource(boolean isFirst) {
        return this.parseTableSource();
    }

    @Override
    public SQLTableSource parseTableSource() {
        if (this.lexer.token() == Token.NULL) {
            String str = this.lexer.stringVal();
            this.lexer.nextToken();
            int startCol = this.lexer.getPosLine();
            int startLine = this.lexer.getPosColumn();
            SQLExprTableSource sqlExprTableSource = new SQLExprTableSource(new SQLIdentifierExpr(str));
            sqlExprTableSource.setStartColumn(startCol);
            sqlExprTableSource.setStartLine(startLine);
            return sqlExprTableSource;
        }
        return super.parseTableSource(false);
    }

    @Override
    protected SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        if (this.isParameterizedView(tableSource)) {
            tableSource = this.parseParameterizedViewTableSource(tableSource);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TABLESAMPLE) && tableSource instanceof SQLExprTableSource) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                SQLTableSampling sampling = new SQLTableSampling();
                if (this.lexer.identifierEquals(FnvHash.Constants.BUCKET)) {
                    this.lexer.nextToken();
                    SQLExpr bucket = this.exprParser.primary();
                    sampling.setBucket(bucket);
                    if (this.lexer.token() == Token.OUT) {
                        this.lexer.nextToken();
                        this.acceptIdentifier(Token.OF.name);
                        SQLExpr outOf = this.exprParser.primary();
                        sampling.setOutOf(outOf);
                    }
                    if (this.lexer.token() == Token.ON) {
                        this.lexer.nextToken();
                        ArrayList<SQLExpr> on = new ArrayList<SQLExpr>();
                        this.exprParser.exprList(on, sampling);
                        sampling.setOn(on);
                    }
                }
                if (this.lexer.token() == Token.LITERAL_INT || this.lexer.token() == Token.LITERAL_FLOAT) {
                    SQLExpr val = this.exprParser.primary();
                    if (this.lexer.identifierEquals(FnvHash.Constants.ROWS)) {
                        this.lexer.nextToken();
                        sampling.setRows(val);
                    } else {
                        this.acceptIdentifier("PERCENT");
                        sampling.setPercent(val);
                    }
                }
                if (this.lexer.token() == Token.IDENTIFIER) {
                    String strVal = this.lexer.stringVal();
                    char first = strVal.charAt(0);
                    char last = strVal.charAt(strVal.length() - 1);
                    if (last >= 'a' && last <= 'z') {
                        last = (char)(last - 32);
                    }
                    boolean match = false;
                    if (first == '.' || first >= '0' && first <= '9') {
                        switch (last) {
                            case 'B': 
                            case 'G': 
                            case 'K': 
                            case 'M': 
                            case 'P': 
                            case 'T': {
                                match = true;
                                break;
                            }
                        }
                    }
                    SQLSizeExpr size = new SQLSizeExpr(strVal.substring(0, strVal.length() - 1), last);
                    sampling.setByteLength(size);
                    this.lexer.nextToken();
                }
                SQLExprTableSource table = (SQLExprTableSource)tableSource;
                table.setSampling(sampling);
                this.accept(Token.RPAREN);
            } else {
                this.lexer.reset(mark);
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.PIVOT)) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                OdpsPivotTableSource pivotTableSource = this.parsePivot(tableSource);
                return super.parseTableSourceRest(pivotTableSource);
            }
            this.lexer.reset(mark);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.UNPIVOT)) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                OdpsUnpivotTableSource unpivotTableSource = this.parseUnpivot(tableSource);
                return super.parseTableSourceRest(unpivotTableSource);
            }
            this.lexer.reset(mark);
        }
        return super.parseTableSourceRest(tableSource);
    }

    protected OdpsPivotTableSource parsePivot(SQLTableSource tableSource) {
        this.accept(Token.LPAREN);
        OdpsPivotDefinition pivot = new OdpsPivotDefinition();
        while (true) {
            SQLMethodInvokeExpr agg = (SQLMethodInvokeExpr)this.exprParser.expr();
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
            }
            SQLName alias = null;
            if (this.lexer.token() == Token.IDENTIFIER) {
                alias = this.exprParser.name();
            }
            pivot.addAggFunctionAndAlias(agg, alias);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.FOR);
        SQLListExpr list = this.parseNameListExpr();
        pivot.setColumns(list);
        this.accept(Token.IN);
        this.accept(Token.LPAREN);
        while (true) {
            SQLListExpr values = new SQLListExpr();
            if (this.lexer.token() != Token.LPAREN) {
                values.setNoParen(true);
                SQLExpr value = this.exprParser.expr();
                values.addItem(value);
            } else {
                this.lexer.nextToken();
                this.exprParser.exprList(values.getItems(), values);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
            }
            SQLName alias = null;
            if (this.lexer.token() == Token.IDENTIFIER) {
                alias = this.exprParser.name();
            }
            pivot.addValuesAndNewColumn(values, alias);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        OdpsPivotTableSource pivotTableSource = new OdpsPivotTableSource();
        pivotTableSource.setPivotDefinition(pivot);
        pivotTableSource.setTableSource(tableSource);
        this.accept(Token.RPAREN);
        return pivotTableSource;
    }

    protected OdpsUnpivotTableSource parseUnpivot(SQLTableSource tableSource) {
        this.accept(Token.LPAREN);
        OdpsUnpivotDefinition unpivot = new OdpsUnpivotDefinition();
        SQLListExpr list = this.parseNameListExpr();
        unpivot.setNewColumnValues(list);
        this.accept(Token.FOR);
        SQLListExpr names = this.parseNameListExpr();
        unpivot.setNewColumnNames(names);
        this.accept(Token.IN);
        this.accept(Token.LPAREN);
        while (true) {
            SQLListExpr columns = new SQLListExpr();
            if (this.lexer.token() != Token.LPAREN) {
                columns.setNoParen(true);
                SQLName value = this.exprParser.name();
                columns.addItem(value);
            } else {
                columns = this.parseNameListExpr();
            }
            SQLListExpr values = null;
            if (this.lexer.token() == Token.AS) {
                values = new SQLListExpr();
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LPAREN) {
                    values.setNoParen(true);
                    SQLExpr value = this.exprParser.expr();
                    OdpsSelectParser.charExprNormalize(value);
                    values.addItem(value);
                } else {
                    this.lexer.nextToken();
                    this.exprParser.exprList(values.getItems(), values);
                    this.accept(Token.RPAREN);
                }
            }
            unpivot.addColumnsAndValues(columns, values);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        OdpsUnpivotTableSource unpivotTable = new OdpsUnpivotTableSource();
        unpivotTable.setUnpivotDefinition(unpivot);
        unpivotTable.setTableSource(tableSource);
        this.accept(Token.RPAREN);
        return unpivotTable;
    }

    private static void charExprNormalize(SQLExpr expr) {
        if (!(expr instanceof SQLCharExpr)) {
            return;
        }
        SQLCharExpr sqlCharExpr = (SQLCharExpr)expr;
        String text = sqlCharExpr.getText();
        if (text != null && text.length() >= 2 && text.startsWith("'") && text.endsWith("'") && sqlCharExpr.getQuoteType() == '\'') {
            text = text.substring(1, text.length() - 1);
            sqlCharExpr.setText(text);
        }
    }

    protected SQLListExpr parseNameListExpr() {
        SQLListExpr list = new SQLListExpr();
        if (this.lexer.token() != Token.LPAREN) {
            list.setNoParen(true);
        } else {
            this.lexer.nextToken();
        }
        while (true) {
            list.addItem(this.exprParser.name());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (!list.isNoParen()) {
            this.accept(Token.RPAREN);
        }
        return list;
    }

    @Override
    protected SQLExpr tableAlias(boolean must) {
        boolean hasLifecycle = this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE);
        Lexer.SavePoint savePoint = this.lexer.mark();
        this.lexer.nextToken();
        if (hasLifecycle && this.lexer.token() == Token.LITERAL_INT) {
            this.lexer.reset(savePoint);
            return null;
        }
        this.lexer.reset(savePoint);
        return super.tableAlias(must);
    }

    private boolean isParameterizedView(SQLTableSource tableSource) {
        return tableSource instanceof SQLExprTableSource && ((SQLExprTableSource)tableSource).getExpr() instanceof SQLMethodInvokeExpr;
    }

    private OdpsParameterizedViewTableSource parseParameterizedViewTableSource(SQLTableSource tableSource) {
        int startLine = this.lexer.getPosLine();
        int startCol = this.lexer.getPosColumn();
        SQLMethodInvokeExpr invokeExpr = (SQLMethodInvokeExpr)((SQLExprTableSource)tableSource).getExpr();
        SQLExprImpl expr = invokeExpr.getOwner() != null ? new SQLPropertyExpr(invokeExpr.getOwner(), invokeExpr.getMethodName(), invokeExpr.methodNameHashCode64()) : new SQLIdentifierExpr(invokeExpr.getMethodName(), invokeExpr.methodNameHashCode64());
        OdpsParameterizedViewTableSource pv = new OdpsParameterizedViewTableSource(expr);
        if (Token.IDENTIFIER.name().equalsIgnoreCase(this.lexer.token().name())) {
            pv.setAlias(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (StringUtils.isNotEmpty(tableSource.getAlias())) {
            pv.setAlias(tableSource.getAlias());
        }
        for (SQLExpr arg : invokeExpr.getArguments()) {
            SQLExpr c = arg.clone();
            c.setParent(pv);
            pv.addArgument(c);
        }
        int endLine = this.lexer.getPosLine();
        int endCol = this.lexer.getPosColumn();
        pv.setStartColumn(startCol);
        pv.setStartLine(startLine);
        return pv;
    }

    @Override
    protected void parseGroupBy(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token() == Token.GROUP) {
            SQLExpr having;
            this.lexer.nextTokenBy();
            this.accept(Token.BY);
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            if (this.lexer.token() == Token.HINT) {
                groupBy.setHint(this.exprParser.parseHint());
            }
            if (this.lexer.token() == Token.ALL) {
                this.lexer.nextToken();
                if (!this.lexer.identifierEquals(FnvHash.Constants.GROUPING)) {
                    throw new ParserException("group by all syntax error. " + this.lexer.info());
                }
            } else if (this.lexer.token() == Token.DISTINCT) {
                this.lexer.nextToken();
                groupBy.setDistinct(true);
            }
            boolean hasComma = false;
            while (true) {
                SQLExpr item = this.parseGroupByItem();
                item.setParent(groupBy);
                groupBy.addItem(item);
                if (hasComma && item instanceof SQLGroupingSetExpr) {
                    ((SQLGroupingSetExpr)item).setHasComma(true);
                }
                if (item instanceof OdpsCubeExpr) {
                    groupBy.setParen(true);
                    groupBy.setWithCube(true);
                }
                if (item instanceof OdpsRollupExpr) {
                    groupBy.setParen(true);
                    groupBy.setWithRollUp(true);
                }
                hasComma = false;
                if (this.lexer.token() == Token.COMMA) {
                    hasComma = true;
                    this.lexer.nextToken();
                    continue;
                }
                if (!this.lexer.identifierEquals(FnvHash.Constants.GROUPING)) break;
            }
            if (this.lexer.token() == Token.HAVING) {
                this.lexer.nextToken();
                having = this.exprParser.expr();
                groupBy.setHaving(having);
            }
            if (this.lexer.token() == Token.WITH) {
                Lexer.SavePoint mark = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.CUBE)) {
                    this.lexer.nextToken();
                    groupBy.setWithCube(true);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
                    this.lexer.nextToken();
                    groupBy.setWithRollUp(true);
                } else {
                    this.lexer.reset(mark);
                }
            }
            if (groupBy.getHaving() == null && this.lexer.token() == Token.HAVING) {
                this.lexer.nextToken();
                having = this.exprParser.expr();
                groupBy.setHaving(having);
            }
            queryBlock.setGroupBy(groupBy);
        } else if (this.lexer.token() == Token.HAVING) {
            this.lexer.nextToken();
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            groupBy.setHaving(this.exprParser.expr());
            if (this.lexer.token() == Token.GROUP) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                while (true) {
                    SQLExpr item = this.parseGroupByItem();
                    item.setParent(groupBy);
                    groupBy.addItem(item);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                this.acceptIdentifier("ROLLUP");
                groupBy.setWithRollUp(true);
            }
            queryBlock.setGroupBy(groupBy);
        }
    }
}

