/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.odps.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.expr.SQLNumberExpr;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsBigDecimalExpr;
import com.alibaba.fastsql.sql.parser.CharTypes;
import com.alibaba.fastsql.sql.parser.Keywords;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.StringUtils;
import java.util.HashMap;

public class OdpsLexer
extends Lexer {
    public static final Keywords DEFAULT_ODPS_KEYWORDS;

    public OdpsLexer(String input, SQLParserFeature ... features) {
        super(input);
        this.dbType = DbType.odps;
        this.keywods = DEFAULT_ODPS_KEYWORDS;
        this.skipComment = true;
        this.keepComments = false;
        for (SQLParserFeature feature : features) {
            this.config(feature, true);
        }
    }

    public OdpsLexer(String input, boolean skipComment, boolean keepComments) {
        super(input, skipComment);
        this.dbType = DbType.odps;
        this.skipComment = skipComment;
        this.keepComments = keepComments;
        this.keywods = DEFAULT_ODPS_KEYWORDS;
    }

    public OdpsLexer(String input, Lexer.CommentHandler commentHandler) {
        super(input, commentHandler);
        this.dbType = DbType.odps;
        this.keywods = DEFAULT_ODPS_KEYWORDS;
    }

    @Override
    public void scanComment() {
        this.scanHiveComment();
    }

    @Override
    public void scanIdentifier() {
        char ch;
        this.hash_lower = 0L;
        this.hash = 0L;
        char first = this.ch;
        if (first == '`') {
            char ch2;
            this.mark = this.pos;
            this.bufPos = 1;
            while (true) {
                if ((ch2 = this.charAt(++this.pos)) == '`') {
                    ++this.bufPos;
                    break;
                }
                if (ch2 == '\u001a') {
                    throw new ParserException("illegal identifier. " + this.info());
                }
                ++this.bufPos;
            }
            ch2 = this.charAt(++this.pos);
            this.ch = this.charAt(this.pos);
            this.stringVal = this.subString(this.mark, this.bufPos);
            this.token = Token.IDENTIFIER;
            return;
        }
        boolean firstFlag = CharTypes.isFirstIdentifierChar(first);
        if (!firstFlag) {
            throw new ParserException("illegal identifier. " + this.info());
        }
        this.mark = this.pos;
        this.bufPos = 1;
        while (true) {
            if (!CharTypes.isIdentifierChar(ch = this.charAt(++this.pos))) {
                int endIndex;
                if (ch == '{' && this.charAt(this.pos - 1) == '$' && (endIndex = this.text.indexOf(125, this.pos)) != -1) {
                    this.bufPos += endIndex - this.pos + 1;
                    this.pos = endIndex;
                    continue;
                }
                if (ch != '-' || this.bufPos <= 7 || !this.text.regionMatches(false, this.mark, "ALIYUN$", 0, 7)) break;
                continue;
            }
            ++this.bufPos;
        }
        this.ch = this.charAt(this.pos);
        if (ch == '@') {
            ++this.bufPos;
            while ((ch = this.charAt(++this.pos)) == '-' || ch == '.' || CharTypes.isIdentifierChar(ch)) {
                ++this.bufPos;
            }
        }
        this.ch = this.charAt(this.pos);
        this.stringVal = this.addSymbol();
        Token tok = this.keywods.getKeyword(this.stringVal);
        this.token = tok != null ? tok : Token.IDENTIFIER;
    }

    @Override
    public void scanVariable() {
        if (this.ch == ':') {
            this.token = Token.COLON;
            this.ch = this.charAt(++this.pos);
            return;
        }
        super.scanVariable();
    }

    @Override
    protected final void scanString() {
        this.scanString2();
    }

    @Override
    public void scanNumber() {
        super.scanNumber();
        if (!(this.ch != 'B' && this.ch != 'b' || this.charAt(this.pos + 1) != 'D' && this.charAt(this.pos + 1) != 'd')) {
            this.pos += 2;
            this.bufPos += 2;
            this.ch = this.charAt(this.pos);
        }
    }

    @Override
    public SQLNumberExpr numberExpr() {
        char[] value;
        char[] numberValue = value = this.sub_chars(this.mark, this.bufPos);
        boolean isBigDecimal = false;
        if (!(value.length <= 2 || value[value.length - 2] != 'B' && value[value.length - 2] != 'b' || value[value.length - 1] != 'D' && value[value.length - 1] != 'd')) {
            numberValue = this.sub_chars(this.mark, this.bufPos - 2);
            isBigDecimal = true;
        }
        if (!StringUtils.isNumber(numberValue)) {
            throw new ParserException(value + " is not a number! " + this.info(), this.posLine, this.posColumn);
        }
        if (isBigDecimal) {
            return new OdpsBigDecimalExpr(value);
        }
        return new SQLNumberExpr(value);
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
        map.put("SHOW", Token.SHOW);
        map.put("PARTITION", Token.PARTITION);
        map.put("PARTITIONED", Token.PARTITIONED);
        map.put("OVERWRITE", Token.OVERWRITE);
        map.put("OVER", Token.OVER);
        map.put("ZORDER", Token.ZORDER);
        map.put("LIMIT", Token.LIMIT);
        map.put("IF", Token.IF);
        map.put("DISTRIBUTE", Token.DISTRIBUTE);
        map.put("TRUE", Token.TRUE);
        map.put("FALSE", Token.FALSE);
        map.put("RLIKE", Token.RLIKE);
        map.put("REGEXP", Token.REGEXP);
        map.put("CLONE", Token.CLONE);
        map.put("CHANGEOWNER", Token.CHANGEOWNER);
        DEFAULT_ODPS_KEYWORDS = new Keywords(map);
    }
}

