/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.odps.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLOver;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLArrayExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLGroupingSetExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCubeExpr;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsOver;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsPredicateExpr;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsRollupExpr;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsUDTFSQLSelectItem;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsLexer;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsSelectParser;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.Arrays;

public class OdpsExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;

    public OdpsExprParser(Lexer lexer) {
        super(lexer, DbType.odps);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    public OdpsExprParser(String sql, SQLParserFeature ... features) {
        this(new OdpsLexer(sql, features));
        this.lexer.nextToken();
    }

    public OdpsExprParser(String sql, boolean skipComments, boolean keepComments) {
        this(new OdpsLexer(sql, skipComments, keepComments));
        this.lexer.nextToken();
    }

    @Override
    protected SQLExpr parseAliasExpr(String alias) {
        String chars = alias.substring(1, alias.length() - 1);
        return new SQLCharExpr(chars);
    }

    @Override
    public SQLSelectItem parseSelectItem() {
        SQLExpr expr;
        int startLine = this.lexer.getPosLine();
        int startCol = this.lexer.getPosColumn();
        if (this.lexer.identifierEquals(Token.TIMESTAMP.name) || this.lexer.identifierEquals(Token.DATE.name) || this.lexer.identifierEquals("DATETIME")) {
            expr = this.expr();
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            expr = new SQLIdentifierExpr(this.lexer.stringVal());
            this.lexer.nextTokenComma();
            if (this.lexer.token() != Token.COMMA) {
                expr = this.primaryRest(expr);
                expr = this.exprRest(expr);
            }
        } else {
            expr = this.expr();
        }
        String alias = null;
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                OdpsUDTFSQLSelectItem selectItem = new OdpsUDTFSQLSelectItem();
                selectItem.setExpr(expr);
                while (true) {
                    alias = this.lexer.stringVal();
                    this.lexer.nextToken();
                    selectItem.getAliasList().add(alias);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                return selectItem;
            }
            alias = this.alias();
        } else {
            alias = this.as();
        }
        expr.setStartLine(startLine);
        expr.setStartColumn(startCol);
        SQLSelectItem item = new SQLSelectItem(expr, alias);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            item.addAfterComment(this.lexer.readAndResetComments());
        }
        return item;
    }

    @Override
    protected void over(SQLAggregateExpr aggregateExpr) {
        this.lexer.nextToken();
        if (this.lexer.token() != Token.LPAREN) {
            SQLName overRef = this.name();
            aggregateExpr.setOverRef(overRef);
            return;
        }
        OdpsOver over = new OdpsOver();
        this.over(over);
        aggregateExpr.setOver(over);
    }

    protected void over(OdpsOver over) {
        this.lexer.nextToken();
        if (this.lexer.token() == Token.DISTRIBUTE || this.lexer.identifierEquals("DISTRIBUTE")) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem distributeByItem = this.parseSelectOrderByItem();
                over.addDistributeBy(distributeByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SORT)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                while (true) {
                    SQLSelectOrderByItem sortByItem = this.parseSelectOrderByItem();
                    over.addSortBy(sortByItem);
                    if (this.lexer.token() == Token.COMMA) {
                        this.lexer.nextToken();
                        continue;
                    }
                    break;
                }
            }
        } else {
            if (this.lexer.token() == Token.PARTITION || this.lexer.identifierEquals("PARTITION")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprList(over.getPartitionBy(), over);
                    this.accept(Token.RPAREN);
                    if (over.getPartitionBy().size() == 1 && this.lexer.token() == Token.COMMA) {
                        this.lexer.nextToken();
                        this.exprList(over.getPartitionBy(), over);
                    }
                } else {
                    this.exprList(over.getPartitionBy(), over);
                }
            }
            over.setOrderBy(this.parseOrderBy());
            if (this.lexer.token() == Token.OF) {
                this.lexer.nextToken();
                SQLName of = this.name();
                over.setOf(of);
            }
        }
        SQLOver.WindowingType windowingType = null;
        if (this.lexer.identifierEquals(FnvHash.Constants.ROWS) || this.lexer.token() == Token.ROWS) {
            windowingType = SQLOver.WindowingType.ROWS;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
            windowingType = SQLOver.WindowingType.RANGE;
        } else if (this.lexer.identifierEquals(Token.GROUPS.name)) {
            windowingType = SQLOver.WindowingType.GROUPS;
        }
        if (windowingType != null) {
            over.setWindowingType(windowingType);
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BETWEEN) {
                long hash;
                long hash2;
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LITERAL_INT || this.lexer.token() == Token.LITERAL_FLOAT || this.lexer.token() == Token.LITERAL_CHARS) {
                    SQLExpr betweenBegin = this.primary();
                    over.setWindowingBetweenBegin(betweenBegin);
                } else if ((this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.INTERVAL) && (hash2 = this.lexer.hash_lower()) != FnvHash.Constants.PRECEDING && hash2 != FnvHash.Constants.FOLLOWING && hash2 != FnvHash.Constants.CURRENT && hash2 != FnvHash.Constants.UNBOUNDED) {
                    SQLExpr betweenBegin = this.expr();
                    over.setWindowingBetweenBegin(betweenBegin);
                }
                SQLOver.WindowingBound beginBound = this.parseWindowingBound();
                if (beginBound != null) {
                    over.setWindowingBetweenBeginBound(beginBound);
                }
                this.accept(Token.AND);
                if (this.lexer.token() == Token.LITERAL_INT || this.lexer.token() == Token.LITERAL_FLOAT || this.lexer.token() == Token.LITERAL_CHARS) {
                    SQLExpr betweenEnd = this.primary();
                    over.setWindowingBetweenEnd(betweenEnd);
                } else if ((this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.INTERVAL) && (hash = this.lexer.hash_lower()) != FnvHash.Constants.PRECEDING && hash != FnvHash.Constants.FOLLOWING && hash != FnvHash.Constants.CURRENT && hash != FnvHash.Constants.UNBOUNDED) {
                    SQLExpr betweenBegin = this.expr();
                    over.setWindowingBetweenEnd(betweenBegin);
                }
                SQLOver.WindowingBound endBound = this.parseWindowingBound();
                if (endBound != null) {
                    over.setWindowingBetweenEndBound(endBound);
                }
            } else {
                long hash;
                if (this.lexer.token() == Token.LITERAL_INT || this.lexer.token() == Token.LITERAL_FLOAT || this.lexer.token() == Token.LITERAL_CHARS) {
                    SQLExpr betweenBegin = this.primary();
                    over.setWindowingBetweenBegin(betweenBegin);
                } else if (this.lexer.token() == Token.IDENTIFIER && (hash = this.lexer.hash_lower()) != FnvHash.Constants.PRECEDING && hash != FnvHash.Constants.FOLLOWING && hash != FnvHash.Constants.CURRENT && hash != FnvHash.Constants.UNBOUNDED) {
                    SQLExpr betweenBegin = this.primary();
                    over.setWindowingBetweenBegin(betweenBegin);
                }
                SQLOver.WindowingBound beginBound = this.parseWindowingBound();
                if (beginBound != null) {
                    over.setWindowingBetweenBeginBound(beginBound);
                }
            }
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            this.lexer.nextToken();
            over.setWindowName(new SQLIdentifierExpr(this.lexer.stringVal()));
        }
        if (this.lexer.identifierEquals(Token.EXCLUDE.name)) {
            over.setExcludeType(this.parseExcludeType());
        }
        this.accept(Token.RPAREN);
    }

    private OdpsOver.ExcludeType parseExcludeType() {
        this.acceptIdentifier(Token.EXCLUDE.name);
        if (this.lexer.identifierEquals(Token.NO.name)) {
            this.lexer.nextToken();
            this.acceptIdentifier(Token.OTHERS.name);
            return OdpsOver.ExcludeType.NO_OTHERS;
        }
        if (this.lexer.identifierEquals(Token.CURRENT.name)) {
            this.lexer.nextToken();
            this.acceptIdentifier(Token.ROW.name);
            return OdpsOver.ExcludeType.CURRENT_ROW;
        }
        if (this.lexer.token() == Token.GROUP) {
            this.lexer.nextToken();
            return OdpsOver.ExcludeType.GROUP;
        }
        if (this.lexer.identifierEquals(Token.TIES.name)) {
            this.lexer.nextToken();
            return OdpsOver.ExcludeType.TIES;
        }
        return null;
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        String cube = "cube";
        String rollup = "rollup";
        if (this.lexer.token() == Token.COLON) {
            this.lexer.nextToken();
            expr = this.dotRest(expr);
            return expr;
        }
        if (this.lexer.token() == Token.LBRACKET) {
            SQLArrayExpr array = new SQLArrayExpr();
            array.setExpr(expr);
            this.lexer.nextToken();
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        if (expr.getClass() == SQLIdentifierExpr.class && (cube.equalsIgnoreCase(((SQLIdentifierExpr)expr).getName()) || rollup.equalsIgnoreCase(((SQLIdentifierExpr)expr).getName()))) {
            SQLGroupingSetExpr groupingSets = null;
            if (cube.equalsIgnoreCase(((SQLIdentifierExpr)expr).getName())) {
                groupingSets = new OdpsCubeExpr();
            }
            if (rollup.equalsIgnoreCase(((SQLIdentifierExpr)expr).getName())) {
                groupingSets = new OdpsRollupExpr();
            }
            this.accept(Token.LPAREN);
            while (true) {
                SQLExpr item;
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    SQLListExpr listExpr = new SQLListExpr();
                    this.exprList(listExpr.getItems(), listExpr);
                    item = listExpr;
                    this.accept(Token.RPAREN);
                } else {
                    item = this.expr();
                }
                item.setParent(groupingSets);
                groupingSets.addParameter(item);
                if (this.lexer.token() == Token.RPAREN) break;
                this.accept(Token.COMMA);
            }
            this.exprList(groupingSets.getParameters(), groupingSets);
            this.accept(Token.RPAREN);
            return groupingSets;
        }
        if (this.lexer.token() == Token.SUBGT) {
            OdpsPredicateExpr predicateExpr = new OdpsPredicateExpr();
            predicateExpr.setParameters(expr);
            this.lexer.nextToken();
            SQLExpr predicate = this.expr();
            predicateExpr.setPredicate(predicate);
            return predicateExpr;
        }
        return super.primaryRest(expr);
    }

    @Override
    public SQLExpr relationalRest(SQLExpr expr) {
        if (this.lexer.identifierEquals("REGEXP")) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.RegExp, rightExp, this.dbType);
        }
        return super.relationalRest(expr);
    }

    @Override
    public OdpsSelectParser createSelectParser() {
        return new OdpsSelectParser(this);
    }

    public SQLExternalRecordFormat parseRowFormat() {
        this.lexer.nextToken();
        this.acceptIdentifier("FORMAT");
        if (this.lexer.identifierEquals(FnvHash.Constants.DELIMITED)) {
            this.lexer.nextToken();
        }
        SQLExternalRecordFormat format = new SQLExternalRecordFormat();
        if (this.lexer.identifierEquals(FnvHash.Constants.FIELDS)) {
            this.lexer.nextToken();
            this.acceptIdentifier("TERMINATED");
            this.accept(Token.BY);
            format.setTerminatedBy(this.expr());
        } else if (this.lexer.identifierEquals("FIELD")) {
            throw new ParserException("syntax error, expect FIELDS, " + this.lexer.info());
        }
        if (this.lexer.token() == Token.ESCAPE || this.lexer.identifierEquals(FnvHash.Constants.ESCAPED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            format.setEscapedBy(this.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LINES)) {
            this.lexer.nextToken();
            this.acceptIdentifier("TERMINATED");
            this.accept(Token.BY);
            format.setLinesTerminatedBy(this.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.COLLECTION)) {
            this.lexer.nextToken();
            this.acceptIdentifier("ITEMS");
            this.acceptIdentifier("TERMINATED");
            this.accept(Token.BY);
            format.setCollectionItemsTerminatedBy(this.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.MAP)) {
            this.lexer.nextToken();
            this.acceptIdentifier("KEYS");
            this.acceptIdentifier("TERMINATED");
            this.accept(Token.BY);
            format.setMapKeysTerminatedBy(this.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SERDE)) {
            this.lexer.nextToken();
            format.setSerde(this.expr());
        }
        return format;
    }

    static {
        String[] strings = new String[]{"AVG", "ANY_VALUE", "APPROX_DISTINCT", "ARG_MAX", "ARG_MIN", "COUNT", "COUNT_IF", "COVAR_POP", "COVAR_SAMP", "LAG", "LEAD", "MAX", "MIN", "MEDIAN", "NUMERIC_HISTOGRAM", "STDDEV", "STDDEV_SAMP", "SUM", "PERCENTILE", "PERCENTILE_APPROX", "VARIANCE", "VAR_POP", "VAR_SAMP", "ROW_NUMBER", "WM_CONCAT"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            OdpsExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

