/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.odps.parser;

import com.alibaba.fastsql.sql.ast.ClusteringType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveInputOutputFormat;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsSelectParser;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLCreateTableParser;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;

public class OdpsCreateTableParser
extends SQLCreateTableParser {
    public OdpsCreateTableParser(String sql) {
        super(new OdpsExprParser(sql, new SQLParserFeature[0]));
    }

    public OdpsCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable(boolean acceptCreate) {
        SQLSelectOrderByItem item;
        SQLColumnDefinition column;
        OdpsCreateTableStatement stmt = new OdpsCreateTableStatement();
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.nextToken();
            stmt.setExternal(true);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.lexer.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExiists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
            this.lexer.nextToken();
            stmt.setLifecycle(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLName name = this.exprParser.name();
            stmt.setLike(name);
        } else if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            OdpsSelectParser selectParser = new OdpsSelectParser(this.exprParser);
            SQLSelect select = selectParser.select();
            stmt.setSelect(select);
        } else {
            this.accept(Token.LPAREN);
            if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                stmt.addBodyBeforeComment(this.lexer.readAndResetComments());
            }
            while (true) {
                switch (this.lexer.token()) {
                    case IDENTIFIER: 
                    case KEY: 
                    case SEQUENCE: 
                    case GROUP: {
                        column = this.exprParser.parseColumn();
                        break;
                    }
                    default: {
                        throw new ParserException("expect identifier. " + this.lexer.info());
                    }
                }
                stmt.getTableElementList().add(column);
                if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                    column.addAfterComment(this.lexer.readAndResetComments());
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
                if (!this.lexer.isKeepComments() || !this.lexer.hasComment()) continue;
                column.addAfterComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            stmt.setComment(this.exprParser.primary());
        }
        if (this.lexer.token() == Token.PARTITIONED) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                if (this.lexer.token() != Token.IDENTIFIER) {
                    throw new ParserException("expect identifier. " + this.lexer.info());
                }
                column = this.exprParser.parseColumn();
                stmt.addPartitionColumn(column);
                if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                    column.addAfterComment(this.lexer.readAndResetComments());
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
                if (!this.lexer.isKeepComments() || !this.lexer.hasComment()) continue;
                column.addAfterComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED)) {
                stmt.setClusteringType(ClusteringType.Range);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                item = this.exprParser.parseSelectOrderByItem();
                stmt.addClusteredByItem(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SORTED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                item = this.exprParser.parseSelectOrderByItem();
                stmt.addSortedByItem(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (stmt.getClusteredBy().size() > 0 || stmt.getSortedBy().size() > 0) {
            this.accept(Token.INTO);
            if (this.lexer.token() != Token.LITERAL_INT) {
                throw new ParserException("into buckets must be integer. " + this.lexer.info());
            }
            stmt.setBuckets(this.lexer.integerValue().intValue());
            this.lexer.nextToken();
            this.acceptIdentifier("BUCKETS");
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LITERAL_INT) {
                    throw new ParserException("into shards must be integer. " + this.lexer.info());
                }
                stmt.setShards(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
                this.acceptIdentifier("SHARDS");
            }
        }
        block7: while (true) {
            if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
                this.lexer.nextToken();
                stmt.setLifecycle(this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.ROW || this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
                this.parseRowFormat(stmt);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
                while (true) {
                    if (!this.lexer.identifierEquals(FnvHash.Constants.STORED)) continue block7;
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.AS) {
                        this.lexer.nextToken();
                        if (this.lexer.identifierEquals(FnvHash.Constants.INPUTFORMAT)) {
                            HiveInputOutputFormat format = new HiveInputOutputFormat();
                            this.lexer.nextToken();
                            format.setInput(this.exprParser.primary());
                            if (this.lexer.identifierEquals(FnvHash.Constants.OUTPUTFORMAT)) {
                                this.lexer.nextToken();
                                format.setOutput(this.exprParser.primary());
                            }
                            stmt.setStoredAs(format);
                            continue;
                        }
                        SQLName storedAs = this.exprParser.name();
                        stmt.setStoredAs(storedAs);
                        continue;
                    }
                    this.accept(Token.BY);
                    SQLExpr storedBy = this.exprParser.expr();
                    stmt.setStoredBy(storedBy);
                }
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseAssignItems(stmt.getTblProperties(), stmt, false);
                this.accept(Token.RPAREN);
                continue;
            }
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                this.acceptIdentifier("SERDEPROPERTIES");
                this.accept(Token.LPAREN);
                this.exprParser.exprList(stmt.getWithSerdeproperties(), stmt);
                this.accept(Token.RPAREN);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
                this.lexer.nextToken();
                SQLExpr location = this.exprParser.expr();
                stmt.setLocation(location);
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.USING)) break;
            this.lexer.nextToken();
            SQLExpr using = this.exprParser.expr();
            stmt.setUsing(using);
        }
        return stmt;
    }

    protected void parseRowFormat(OdpsCreateTableStatement stmt) {
        SQLExternalRecordFormat format = this.getExprParser().parseRowFormat();
        stmt.setRowFormat(format);
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("SERDEPROPERTIES");
            this.accept(Token.LPAREN);
            while (true) {
                String name = this.lexer.stringVal();
                this.lexer.nextToken();
                this.accept(Token.EQ);
                SQLExpr value = this.exprParser.primary();
                stmt.getSerdeProperties().put(name, value);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
    }

    @Override
    public OdpsExprParser getExprParser() {
        return (OdpsExprParser)this.exprParser;
    }
}

