/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.odps.ast;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.dialect.odps.visitor.OdpsASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OdpsParameterizedViewTableSource
extends SQLExprTableSource {
    protected List<SQLExpr> arguments = new ArrayList<SQLExpr>();

    public OdpsParameterizedViewTableSource() {
    }

    public OdpsParameterizedViewTableSource(SQLExpr expr) {
        this();
        this.setExpr(expr);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof OdpsASTVisitor) {
            this.accept0((OdpsASTVisitor)visitor);
        } else {
            super.accept0(visitor);
        }
    }

    private void accept0(OdpsASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.expr);
            this.acceptChild((SQLASTVisitor)visitor, this.arguments);
        }
        visitor.endVisit(this);
    }

    @Override
    public void setExpr(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.expr = x;
        this.setStartColumn(this.expr.getStartColumn());
        this.setStartLine(this.expr.getStartLine());
    }

    @Override
    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setArguments(List<SQLExpr> arguments) {
        this.arguments = arguments;
    }

    public void addArgument(SQLExpr argument) {
        this.arguments.add(argument);
    }

    public List<SQLExpr> getArguments() {
        return this.arguments;
    }

    @Override
    public OdpsParameterizedViewTableSource clone() {
        OdpsParameterizedViewTableSource x = new OdpsParameterizedViewTableSource(this.getExpr());
        this.cloneTo(x);
        for (SQLExpr e : this.arguments) {
            SQLExpr e2 = e.clone();
            e2.setParent(x);
            x.addArgument(e2);
        }
        return x;
    }

    public void cloneTo(OdpsParameterizedViewTableSource x) {
        x.alias = this.alias;
        if (this.expr != null) {
            x.setExpr(this.expr);
        }
        if (this.partitions != null) {
            for (SQLName p : this.partitions) {
                SQLName p1 = p.clone();
                x.addPartition(p1);
            }
        }
        if (this.schemaObject != null) {
            x.setSchemaObject(this.schemaObject);
        }
        if (this.columns != null) {
            x.columns = new ArrayList(this.columns.size());
            for (SQLName column : this.columns) {
                SQLName clonedColumn = column.clone();
                clonedColumn.setParent(x);
                x.columns.add(clonedColumn);
            }
        }
        if (this.aliasExpr != null) {
            x.setAliasExpr(this.aliasExpr.clone());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OdpsParameterizedViewTableSource that = (OdpsParameterizedViewTableSource)o;
        if (this.expr != null ? !this.expr.equals(that.expr) : that.expr != null) {
            return false;
        }
        return this.arguments != null ? this.arguments.equals(that.arguments) : that.arguments == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.expr != null ? this.expr.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        return result;
    }
}

