/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.odps.ast;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsStatementImpl;
import com.alibaba.fastsql.sql.dialect.odps.visitor.OdpsASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OdpsPAIStatement
extends OdpsStatementImpl
implements SQLReplaceable {
    private String name;
    private String project;
    private LinkedHashMap<String, String> otherParameters = new LinkedHashMap();
    private Map<String, List<SQLExpr>> inputTables = new HashMap<String, List<SQLExpr>>();
    private Map<String, List<SQLExpr>> outputTables = new HashMap<String, List<SQLExpr>>();
    private Map<String, String> outputPartitions = new HashMap<String, String>();
    private static final Set<String> INPUT_TABLE_PARAMETERS = new HashSet<String>(Arrays.asList("inputTableName", "xTableName", "yTableName", "dictTableName", "predictInputTableName", "indexInputTableName", "inputTable", "mapTableName", "noiseTableName", "idTableName", "inVocabularyTableName", "inputEdgeTableName", "inputBinTableName", "inputConstraintTableName", "inputModelTableName", "inputBaseTableName", "inputTestTableName", "trainTableName"));
    private static final Set<String> OUTPUT_TABLE_PARAMETERS = new HashSet<String>(Arrays.asList("outputTableName", "eigOutputTableName", "princompOutputTableName", "outputTable\uff1a", "predictOutputTableName", "predictTableName", "outputImportanceTableName", "mapTable", "idxTableName", "clusterCountTableName", "centerTableName", "outputMetricTableName", "outputDetailTableName", "indexOutputTableName", "residualOutputTableName", "outputDetailTableName", "outputPredictTableName", "countTableName", "vocabTableName", "outputTableNameMulti", "outputTableNameTriple", "topicWordTableName", "pwzTableName", "pzwTableName", "pdzTableName", "pzdTableName", "pzTableName", "dictTableName", "outVocabularyTableName", "outputWordTableName", "outputDocTableName", "positiveLabel"));
    private static final Set<String> OUTPUT_PT_PARAMETERS = new HashSet<String>(Arrays.asList("outputTablePartition", "idxTablePartition"));

    public OdpsPAIStatement() {
        this.dbType = DbType.odps;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof OdpsASTVisitor) {
            this.accept0((OdpsASTVisitor)visitor);
        }
    }

    @Override
    protected void accept0(OdpsASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.inputTables.values().forEach(tableList -> this.acceptChild((SQLASTVisitor)visitor, (List<? extends SQLObject>)tableList));
            this.outputTables.values().forEach(tableList -> this.acceptChild((SQLASTVisitor)visitor, (List<? extends SQLObject>)tableList));
        }
        visitor.endVisit(this);
    }

    public void addParameter(String parameter, String value) {
        if (INPUT_TABLE_PARAMETERS.contains(parameter.substring(1))) {
            List<SQLExpr> exprs = this.parseExprs(value);
            exprs.forEach(expr -> {
                if (expr != null) {
                    expr.setParent(this);
                }
            });
            this.inputTables.put(parameter, exprs);
        } else if (OUTPUT_TABLE_PARAMETERS.contains(parameter.substring(1))) {
            List<SQLExpr> exprs = this.parseExprs(value);
            exprs.forEach(expr -> {
                if (expr != null) {
                    expr.setParent(this);
                }
            });
            this.outputTables.put(parameter, exprs);
        } else if (OUTPUT_PT_PARAMETERS.contains(parameter.substring(1))) {
            this.outputPartitions.put(parameter, value);
        } else {
            this.otherParameters.put(parameter, value);
        }
    }

    private List<SQLExpr> parseExprs(String value) {
        if ((value = StringUtils.strip(value)).startsWith("\"") || value.startsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        return Arrays.asList(value.split(",")).stream().map(name -> SQLUtils.toSQLExpr(name, this.dbType)).collect(Collectors.toList());
    }

    private List<String> parseValues(String value) {
        value = StringUtils.strip(value);
        return Arrays.asList(value.split(","));
    }

    public LinkedHashMap<String, String> getOtherParameters() {
        return this.otherParameters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, List<SQLExpr>> getInputTables() {
        return this.inputTables;
    }

    public void setInputTables(Map<String, List<SQLExpr>> inputTables) {
        this.inputTables = inputTables;
    }

    public Map<String, List<SQLExpr>> getOutputTables() {
        return this.outputTables;
    }

    public void setOutputTables(Map<String, List<SQLExpr>> outputTables) {
        this.outputTables = outputTables;
    }

    public Map<String, String> getOutputPartitions() {
        return this.outputPartitions;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        boolean found = false;
        for (List<SQLExpr> tables : this.inputTables.values()) {
            for (SQLExpr table : tables) {
                if (table != expr) continue;
                found = true;
                break;
            }
            if (!found) continue;
            tables.remove(expr);
            tables.add(target);
            if (target != null) {
                target.setParent(this);
            }
            return true;
        }
        for (List<SQLExpr> tables : this.outputTables.values()) {
            for (SQLExpr table : tables) {
                if (table != expr) continue;
                found = true;
                break;
            }
            if (!found) continue;
            tables.remove(expr);
            tables.add(target);
            if (target != null) {
                target.setParent(this);
            }
            return true;
        }
        return false;
    }
}

