/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.mysql.ast.expr;

import com.alibaba.fastsql.FastsqlException;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.dialect.mysql.ast.expr.MySqlExpr;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.io.IOException;

public class MySqlCharExpr
extends SQLCharExpr
implements MySqlExpr {
    private String charset;
    private String collate;
    private String type;

    public MySqlCharExpr() {
    }

    public MySqlCharExpr(String text) {
        super(text);
    }

    public MySqlCharExpr(String text, String charset) {
        super(text);
        this.charset = charset;
    }

    public MySqlCharExpr(String text, String charset, String collate) {
        super(text);
        this.charset = charset;
        this.collate = collate;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCollate() {
        return this.collate;
    }

    public void setCollate(String collate) {
        this.collate = collate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void output(Appendable buf) {
        try {
            if (this.charset != null) {
                buf.append(this.charset);
                buf.append(' ');
            }
            if (this.text != null) {
                super.output(buf);
            }
            if (this.collate != null) {
                buf.append(" COLLATE ");
                buf.append(this.collate);
            }
        }
        catch (IOException ex) {
            throw new FastsqlException("output error", ex);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof MySqlASTVisitor) {
            this.accept0((MySqlASTVisitor)visitor);
        } else {
            visitor.visit(this);
            visitor.endVisit(this);
        }
    }

    public void accept0(MySqlASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.output(buf);
        return buf.toString();
    }

    @Override
    public MySqlCharExpr clone() {
        MySqlCharExpr x = new MySqlCharExpr(this.text);
        x.collate = this.collate;
        x.charset = this.charset;
        x.type = this.type;
        return x;
    }
}

