/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.impala.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableAddPartition;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveSelectParser;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveStatementParser;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterTableAddRangePartition;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterTableAlterColumn;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterTableChangeColumnStats;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterTableDropRangePartition;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterTableSetCache;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterTableSetRowFormat;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterViewRenameTo;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterViewSetOwner;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterViewSetProperty;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterViewStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterViewUnsetProperty;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaCacheSpec;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaComputeIncrementalStatsStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaComputeStatsStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaInvalidateMetadataStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaObjectImpl;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaRefreshAuthStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaRefreshFunctionsStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaRefreshPartitionStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaRefreshTableStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaShowPartitionsStatement;
import com.alibaba.fastsql.sql.dialect.impala.parser.ImpalaCreateTableParser;
import com.alibaba.fastsql.sql.dialect.impala.parser.ImpalaExprParser;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLCreateTableParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLSelectParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.List;

public class ImpalaStatementParser
extends HiveStatementParser {
    public ImpalaStatementParser(String sql, SQLParserFeature ... features) {
        super(new ImpalaExprParser(sql, features));
        this.dbType = DbType.impala;
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        ImpalaCreateTableParser parser = new ImpalaCreateTableParser(this.exprParser);
        return parser.parseCreateTable();
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new ImpalaCreateTableParser(this.exprParser);
    }

    @Override
    protected void parseAlterAdd(SQLAlterTableStatement stmt) {
        Lexer.SavePoint sp = this.lexer.mark();
        this.lexer.nextToken();
        boolean ifNotExists = false;
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            ifNotExists = true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
            this.lexer.nextToken();
            ImpalaAlterTableAddRangePartition addRangePartition = new ImpalaAlterTableAddRangePartition();
            this.accept(Token.PARTITION);
            addRangePartition.setKuduPartition(this.getExprParser().parsePartitionValue());
            addRangePartition.setIfNotExists(ifNotExists);
            stmt.addItem(addRangePartition);
        } else {
            this.lexer.reset(sp);
            super.parseAlterAdd(stmt);
        }
    }

    @Override
    public void parseAlterDrop(SQLAlterTableStatement stmt) {
        Lexer.SavePoint sp = this.lexer.mark();
        this.lexer.nextToken();
        boolean ifExists = false;
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            ifExists = true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
            this.lexer.nextToken();
            ImpalaAlterTableDropRangePartition addRangePartition = new ImpalaAlterTableDropRangePartition();
            this.accept(Token.PARTITION);
            addRangePartition.setKuduPartition(this.getExprParser().parsePartitionValue());
            addRangePartition.setIfExists(ifExists);
            stmt.addItem(addRangePartition);
        } else {
            this.lexer.reset(sp);
            super.parseAlterDrop(stmt);
        }
    }

    @Override
    protected SQLAlterTableItem parseAlterTableSetItem() {
        ImpalaObjectImpl alterTableItem;
        Lexer.SavePoint sp = this.lexer.mark();
        this.lexer.nextToken();
        if (this.lexer.token() == Token.ROW) {
            SQLExternalRecordFormat format = this.getExprParser().parseRowFormat();
            ImpalaAlterTableSetRowFormat setRowFormat = new ImpalaAlterTableSetRowFormat();
            setRowFormat.setRowFormat(format);
            alterTableItem = setRowFormat;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.CACHED)) {
            ImpalaAlterTableSetCache setCacheItem = new ImpalaAlterTableSetCache();
            setCacheItem.setCacheSpec(this.buildCached());
            alterTableItem = setCacheItem;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.UNCACHED)) {
            ImpalaAlterTableSetCache setCacheItem = new ImpalaAlterTableSetCache();
            setCacheItem.setCacheSpec(this.buildUnCached());
            alterTableItem = setCacheItem;
        } else {
            this.lexer.reset(sp);
            return super.parseAlterTableSetItem();
        }
        return alterTableItem;
    }

    @Override
    protected SQLAlterTableAlterColumn parseAlterColumn() {
        this.lexer.nextToken();
        SQLColumnDefinition column = this.exprParser.parseColumn();
        ImpalaAlterTableAlterColumn alterColumn = new ImpalaAlterTableAlterColumn();
        alterColumn.setColumn(column);
        if (this.lexer.token() == Token.DROP) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DEFAULT) {
                this.accept(Token.DEFAULT);
                alterColumn.setDropDefault(true);
            }
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            alterColumn.setKuduStorageAttr(this.exprParser.name());
            alterColumn.setAttrValue(this.exprParser.expr());
        }
        return alterColumn;
    }

    @Override
    public ImpalaExprParser getExprParser() {
        return (ImpalaExprParser)this.exprParser;
    }

    @Override
    public SQLStatement parseInvalidate() {
        this.lexer.nextToken();
        if (!this.lexer.identifierEquals("METADATA")) {
            throw new ParserException("TODO " + this.lexer.info());
        }
        SQLStatement stmt = this.parseInvalidateMetadata();
        return stmt;
    }

    @Override
    protected SQLAlterTableItem parseDialectAlterItem() {
        if (this.lexer.token() == Token.IDENTIFIER) {
            SQLName columnName = this.exprParser.name();
            ImpalaAlterTableChangeColumnStats columnStats = new ImpalaAlterTableChangeColumnStats();
            columnStats.setColumn(columnName);
            this.accept(Token.LPAREN);
            while (true) {
                SQLCharExpr left = this.exprParser.charExpr();
                this.accept(Token.EQ);
                SQLCharExpr right = this.exprParser.charExpr();
                columnStats.set(left, right);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            return columnStats;
        }
        return null;
    }

    @Override
    protected SQLAlterTableAddPartition parseAlterTableAddPartition() {
        SQLAlterTableAddPartition addPartition = super.parseAlterTableAddPartition();
        if (this.lexer.identifierEquals(FnvHash.Constants.CACHED)) {
            addPartition.setCacheSpec(this.buildCached());
        } else if (this.lexer.identifierEquals(FnvHash.Constants.UNCACHED)) {
            addPartition.setCacheSpec(this.buildUnCached());
        }
        return addPartition;
    }

    private ImpalaCacheSpec buildCached() {
        ImpalaCacheSpec cacheSpec = new ImpalaCacheSpec();
        cacheSpec.setCached(true);
        this.lexer.nextToken();
        this.accept(Token.IN);
        cacheSpec.setPoolName((SQLCharExpr)this.exprParser.expr());
        if (this.lexer.token() == Token.WITH) {
            cacheSpec.setWithReplication(true);
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.REPLICATION)) {
                this.lexer.nextToken();
                this.accept(Token.EQ);
                cacheSpec.setReplicationCount(this.exprParser.acceptInteger());
            } else {
                throw new ParserException("expect REPLICATION");
            }
        }
        return cacheSpec;
    }

    private ImpalaCacheSpec buildUnCached() {
        this.lexer.nextToken();
        ImpalaCacheSpec cacheSpec = new ImpalaCacheSpec();
        cacheSpec.setCached(false);
        return cacheSpec;
    }

    private SQLStatement parseInvalidateMetadata() {
        ImpalaInvalidateMetadataStatement stmt = new ImpalaInvalidateMetadataStatement(DbType.impala);
        this.lexer.nextToken();
        if (this.lexer.token() != null && this.lexer.token() != Token.SEMI) {
            stmt.setTable(new SQLExprTableSource(this.exprParser.expr()));
        }
        return stmt;
    }

    @Override
    protected SQLStatement parseAlterView() {
        Lexer.SavePoint sp = this.lexer.mark();
        this.lexer.nextToken();
        SQLName viewName = this.exprParser.name();
        SQLExprTableSource exprTableSource = new SQLExprTableSource(viewName);
        ImpalaAlterViewStatement alterViewStatement = new ImpalaAlterViewStatement(this.dbType);
        alterViewStatement.setTableSource(exprTableSource);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                SQLColumnDefinition column = this.getExprParser().parseAlterViewColumn();
                alterViewStatement.addColumn(column);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
                HiveSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect select = selectParser.select();
                alterViewStatement.setSubQuery(select);
            }
        } else if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            HiveSelectParser selectParser = this.createSQLSelectParser();
            SQLSelect select = selectParser.select();
            alterViewStatement.setSubQuery(select);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RENAME)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            ImpalaAlterViewRenameTo renameTo = new ImpalaAlterViewRenameTo();
            renameTo.setTo(this.exprParser.name());
            alterViewStatement.setItem(renameTo);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.UNSET)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
                this.lexer.nextToken();
                ImpalaAlterViewUnsetProperty unsetProperty = new ImpalaAlterViewUnsetProperty();
                this.accept(Token.LPAREN);
                while (true) {
                    unsetProperty.addProperty(this.exprParser.charExpr());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                alterViewStatement.setItem(unsetProperty);
            }
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.OWNER)) {
                this.lexer.nextToken();
                this.accept(Token.USER);
                ImpalaAlterViewSetOwner setOwner = new ImpalaAlterViewSetOwner();
                setOwner.setOwner(this.exprParser.name());
                alterViewStatement.setItem(setOwner);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
                this.lexer.nextToken();
                ImpalaAlterViewSetProperty setProperty = new ImpalaAlterViewSetProperty();
                this.accept(Token.LPAREN);
                this.parseAssignItems(setProperty.getProperties(), setProperty, false);
                this.accept(Token.RPAREN);
                alterViewStatement.setItem(setProperty);
            }
        } else {
            this.lexer.reset(sp);
            return super.parseAlterView();
        }
        return alterViewStatement;
    }

    @Override
    protected SQLStatement parseRefresh() {
        this.acceptIdentifier("REFRESH");
        if (this.lexer.token() == Token.IDENTIFIER) {
            if (this.lexer.identifierEquals(FnvHash.Constants.AUTHORIZATION)) {
                this.lexer.nextToken();
                return new ImpalaRefreshAuthStatement();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.FUNCTIONS)) {
                this.lexer.nextToken();
                SQLName dbName = this.exprParser.name();
                return new ImpalaRefreshFunctionsStatement(dbName);
            }
            SQLExpr expr = this.exprParser.expr();
            if (this.lexer.token() == Token.PARTITION) {
                ImpalaRefreshPartitionStatement stmt = new ImpalaRefreshPartitionStatement();
                stmt.setTableSource(new SQLExprTableSource(expr));
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseAssignItems(stmt.getPartition(), stmt, false);
                this.accept(Token.RPAREN);
                return stmt;
            }
            ImpalaRefreshTableStatement stmt = new ImpalaRefreshTableStatement();
            stmt.setTableSource(new SQLExprTableSource(expr));
            return stmt;
        }
        return super.parseRefresh();
    }

    @Override
    protected SQLStatement parseShowRangePartition() {
        this.acceptIdentifier("RANGE");
        if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
            this.lexer.nextToken();
            ImpalaShowPartitionsStatement stmt = new ImpalaShowPartitionsStatement();
            stmt.setDbType(this.dbType);
            SQLExpr expr = this.exprParser.expr();
            stmt.setTableSource(new SQLExprTableSource(expr));
            return stmt;
        }
        return super.parseShowRangePartition();
    }

    @Override
    public SQLUpdateStatement parseUpdateStatement() {
        this.accept(Token.UPDATE);
        SQLUpdateStatement updateStatement = new SQLUpdateStatement();
        SQLSelectParser selectParser = this.exprParser.createSelectParser();
        SQLTableSource tableSource = selectParser.parseTableSource();
        updateStatement.setTableSource(tableSource);
        this.parseUpdateSet(updateStatement);
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLTableSource from = selectParser.parseTableSource();
            updateStatement.setFrom(from);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            updateStatement.setWhere(this.exprParser.expr());
        }
        return updateStatement;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        int startLine = this.lexer.getPosLine();
        int startCol = this.lexer.getPosColumn();
        if (this.lexer.token() == Token.COMPUTE) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.INCREMENTAL)) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.STATS)) {
                    this.lexer.nextToken();
                    ImpalaComputeIncrementalStatsStatement stmt = new ImpalaComputeIncrementalStatsStatement();
                    stmt.setTableSource(new SQLExprTableSource(this.exprParser.expr()));
                    if (this.lexer.token() == Token.PARTITION) {
                        this.lexer.nextToken();
                        this.accept(Token.LPAREN);
                        while (true) {
                            SQLAssignItem ptExpr = new SQLAssignItem();
                            ptExpr.setTarget(this.exprParser.name());
                            ptExpr.setToken(this.lexer.token());
                            this.lexer.nextToken();
                            SQLExpr ptValue = this.exprParser.expr();
                            ptExpr.setValue(ptValue);
                            stmt.addPartition(ptExpr);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        this.accept(Token.RPAREN);
                    }
                    this.addToStatementList(statementList, stmt, startLine, startCol);
                    return true;
                }
            } else if (this.lexer.identifierEquals(FnvHash.Constants.STATS)) {
                this.lexer.nextToken();
                ImpalaComputeStatsStatement stmt = new ImpalaComputeStatsStatement();
                stmt.setTableSource(new SQLExprTableSource(this.exprParser.expr()));
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.exprList(stmt.getColumns(), stmt);
                    this.accept(Token.RPAREN);
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.TABLESAMPLE)) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals(FnvHash.Constants.SYSTEM)) {
                        this.lexer.nextToken();
                        this.accept(Token.LPAREN);
                        stmt.setTableSample(this.exprParser.expr());
                        this.accept(Token.RPAREN);
                    }
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.REPEATABLE)) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    stmt.setRepeatable(this.exprParser.expr());
                    this.accept(Token.RPAREN);
                }
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
        }
        return super.parseStatementListDialect(statementList);
    }
}

