/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.impala.parser;

import com.alibaba.fastsql.sql.ast.SQLPartitionBy;
import com.alibaba.fastsql.sql.ast.SQLPartitionByHash;
import com.alibaba.fastsql.sql.ast.SQLPartitionByRange;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveExprParser;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaKuduPartitionValue;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaPartitionByRange;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;

public class ImpalaExprParser
extends HiveExprParser {
    public ImpalaExprParser(String sql) {
        super(sql);
    }

    public ImpalaExprParser(String sql, SQLParserFeature ... features) {
        super(sql, features);
    }

    public ImpalaExprParser(Lexer lexer) {
        super(lexer);
    }

    protected void partitionClauseRest(SQLPartitionBy clause) {
        if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
            this.lexer.nextToken();
            SQLIntegerExpr countExpr = this.integerExpr();
            clause.setPartitionsCount(countExpr);
        }
    }

    protected SQLPartitionByHash partitionByHash() {
        this.acceptIdentifier("HASH");
        SQLPartitionByHash partitionByHash = new SQLPartitionByHash();
        if (this.lexer.token() == Token.LPAREN) {
            this.accept(Token.LPAREN);
            this.exprList(partitionByHash.getColumns(), partitionByHash);
            this.accept(Token.RPAREN);
        }
        return partitionByHash;
    }

    protected SQLPartitionByRange partitionByRange() {
        this.acceptIdentifier(Token.RANGE.name);
        ImpalaPartitionByRange impalaPartitionByRange = new ImpalaPartitionByRange();
        Lexer.SavePoint savePoint = this.lexer.mark();
        this.accept(Token.LPAREN);
        if (this.lexer.token() != Token.PARTITION) {
            this.exprList(impalaPartitionByRange.getColumns(), impalaPartitionByRange);
            this.accept(Token.RPAREN);
        } else {
            this.lexer.reset(savePoint);
        }
        this.accept(Token.LPAREN);
        while (true) {
            this.accept(Token.PARTITION);
            impalaPartitionByRange.addPartitionExpr(this.parsePartitionValue());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return impalaPartitionByRange;
    }

    public ImpalaKuduPartitionValue parsePartitionValue() {
        ImpalaKuduPartitionValue kuduPartitionValue = new ImpalaKuduPartitionValue();
        if (this.lexer.identifierEquals(FnvHash.Constants.VALUE)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            kuduPartitionValue.setSingleOperator(Token.EQ);
            kuduPartitionValue.setSingleValue(this.expr());
        } else if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            if (this.lexer.token() != Token.LT && this.lexer.token() != Token.LTEQ) {
                this.printError(Token.LT, Token.LTEQ);
            }
            kuduPartitionValue.setUpperOperator(this.lexer.token());
            this.lexer.nextToken();
            kuduPartitionValue.setUpperBound(this.primary());
        } else {
            kuduPartitionValue.setLowerBound(this.primary());
            if (this.lexer.token() != Token.LT && this.lexer.token() != Token.LTEQ) {
                this.printError(Token.LT, Token.LTEQ);
            }
            kuduPartitionValue.setLowerOperator(this.lexer.token());
            this.lexer.nextToken();
            this.accept(Token.VALUES);
            if (this.lexer.token() == Token.LT || this.lexer.token() == Token.LTEQ) {
                kuduPartitionValue.setUpperOperator(this.lexer.token());
                this.lexer.nextToken();
                kuduPartitionValue.setUpperBound(this.primary());
            }
        }
        return kuduPartitionValue;
    }

    public SQLColumnDefinition parseAlterViewColumn() {
        SQLColumnDefinition column = this.createColumnDefinition();
        column.setName(this.name());
        return this.parseColumnRest(column);
    }
}

