/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.impala.parser;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLPartitionByHash;
import com.alibaba.fastsql.sql.ast.SQLPartitionByRange;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveCreateTableParser;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaCacheSpec;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaLikeParquet;
import com.alibaba.fastsql.sql.dialect.impala.parser.ImpalaExprParser;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;

public class ImpalaCreateTableParser
extends HiveCreateTableParser {
    public ImpalaCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public ImpalaCreateTableParser(Lexer lexer) {
        super(lexer);
    }

    @Override
    public void parsePartitionBy(HiveCreateTableStatement stmt) {
        this.accept(Token.PARTITION);
        this.accept(Token.BY);
        while (true) {
            if (this.lexer.identifierEquals("HASH")) {
                SQLPartitionByHash partitionByHash = this.getExprParser().partitionByHash();
                this.getExprParser().partitionClauseRest(partitionByHash);
                ((ImpalaCreateTableStatement)stmt).addKuduPartition(partitionByHash);
            } else if (this.lexer.identifierEquals("RANGE")) {
                SQLPartitionByRange partitionByRange = this.getExprParser().partitionByRange();
                ((ImpalaCreateTableStatement)stmt).addKuduPartition(partitionByRange);
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    @Override
    public void parseCached(HiveCreateTableStatement stmt) {
        ImpalaCacheSpec cacheSpec = this.buildCached();
        ((ImpalaCreateTableStatement)stmt).setCacheSpec(cacheSpec);
    }

    @Override
    public void parseUnCached(HiveCreateTableStatement stmt) {
        ImpalaCacheSpec cacheSpec = this.buildUnCached();
        ((ImpalaCreateTableStatement)stmt).setCacheSpec(cacheSpec);
    }

    private ImpalaCacheSpec buildCached() {
        ImpalaCacheSpec cacheSpec = new ImpalaCacheSpec();
        cacheSpec.setCached(true);
        this.lexer.nextToken();
        this.accept(Token.IN);
        cacheSpec.setPoolName((SQLCharExpr)this.exprParser.expr());
        if (this.lexer.token() == Token.WITH) {
            cacheSpec.setWithReplication(true);
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.REPLICATION)) {
                this.lexer.nextToken();
                this.accept(Token.EQ);
                cacheSpec.setReplicationCount(this.exprParser.acceptInteger());
            } else {
                throw new ParserException("expect REPLICATION");
            }
        }
        return cacheSpec;
    }

    private ImpalaCacheSpec buildUnCached() {
        this.lexer.nextToken();
        ImpalaCacheSpec cacheSpec = new ImpalaCacheSpec();
        cacheSpec.setCached(false);
        return cacheSpec;
    }

    @Override
    protected ImpalaCreateTableStatement newCreateStatement() {
        return new ImpalaCreateTableStatement();
    }

    @Override
    public ImpalaExprParser getExprParser() {
        return (ImpalaExprParser)this.exprParser;
    }

    @Override
    protected void parseParquetLike(HiveCreateTableStatement stmt) {
        if (this.lexer.token() == Token.LIKE && stmt instanceof ImpalaCreateTableStatement) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.PARQUET)) {
                this.lexer.nextToken();
                SQLExpr like = this.exprParser.primary();
                ((ImpalaCreateTableStatement)stmt).setParquetLike(new ImpalaLikeParquet(like));
            }
        }
    }
}

