/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.impala.ast;

import com.alibaba.fastsql.sql.ast.SQLPartitionBy;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.impala.ImpalaASTVisitor;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaCacheSpec;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaLikeParquet;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ImpalaCreateTableStatement
extends HiveCreateTableStatement {
    protected List<SQLPartitionBy> kuduPartitions = new ArrayList<SQLPartitionBy>();
    protected ImpalaCacheSpec cacheSpec;
    protected ImpalaLikeParquet parquetLike;

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v instanceof ImpalaASTVisitor) {
            this.accept0((ImpalaASTVisitor)v);
        } else {
            super.accept0(v);
        }
    }

    protected void accept0(ImpalaASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    protected void acceptChild(SQLASTVisitor v) {
        super.acceptChild(v);
        this.acceptChild(v, this.kuduPartitions);
        this.acceptChild(v, this.cacheSpec);
        this.acceptChild(v, this.parquetLike);
    }

    public List<SQLPartitionBy> getKuduPartitions() {
        return this.kuduPartitions;
    }

    public void setKuduPartitions(List<SQLPartitionBy> kuduPartitions) {
        if (kuduPartitions != null) {
            for (SQLPartitionBy kuduPartition : kuduPartitions) {
                if (kuduPartition == null) continue;
                kuduPartition.setParent(this);
            }
        }
        this.kuduPartitions = kuduPartitions;
    }

    public void cloneTo(ImpalaCreateTableStatement x) {
        this.cloneTo((HiveCreateTableStatement)x);
        if (this.kuduPartitions != null) {
            x.setKuduPartitions(this.kuduPartitions.stream().map(SQLPartitionBy::clone).collect(Collectors.toList()));
        }
        if (this.cacheSpec != null) {
            x.setCacheSpec(this.cacheSpec);
        }
    }

    @Override
    public ImpalaCreateTableStatement clone() {
        ImpalaCreateTableStatement x = new ImpalaCreateTableStatement();
        this.cloneTo(x);
        return x;
    }

    public void addKuduPartition(SQLPartitionBy partition) {
        if (this.kuduPartitions == null) {
            this.kuduPartitions = new ArrayList<SQLPartitionBy>();
        }
        if (partition != null) {
            partition.setParent(this);
        }
        this.kuduPartitions.add(partition);
    }

    public ImpalaCacheSpec getCacheSpec() {
        return this.cacheSpec;
    }

    public void setCacheSpec(ImpalaCacheSpec cacheSpec) {
        if (cacheSpec != null) {
            cacheSpec.setParent(this);
        }
        this.cacheSpec = cacheSpec;
    }

    public ImpalaLikeParquet getParquetLike() {
        return this.parquetLike;
    }

    public void setParquetLike(ImpalaLikeParquet parquetLike) {
        this.parquetLike = parquetLike;
    }
}

