/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.impala;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLPartitionByHash;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveInsertStatement;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.hive.visitor.HiveOutputVisitor;
import com.alibaba.fastsql.sql.dialect.impala.ImpalaASTVisitor;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterTableAddRangePartition;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterTableAlterColumn;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterTableChangeColumnStats;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterTableDropRangePartition;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterTableSetCache;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterTableSetRowFormat;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterViewRenameTo;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterViewSetOwner;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterViewSetProperty;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterViewStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaAlterViewUnsetProperty;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaCacheSpec;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaComputeIncrementalStatsStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaComputeStatsStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaDropStatsStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaInvalidateMetadataStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaKuduPartitionValue;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaLikeParquet;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaPartitionByRange;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaRefreshAuthStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaRefreshFunctionsStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaRefreshPartitionStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaRefreshTableStatement;
import com.alibaba.fastsql.sql.dialect.impala.ast.ImpalaShowPartitionsStatement;
import java.util.List;

public class ImpalaOutputVisitor
extends HiveOutputVisitor
implements ImpalaASTVisitor {
    public ImpalaOutputVisitor(Appendable appender) {
        super(appender, DbType.impala);
    }

    public ImpalaOutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
    }

    public ImpalaOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
    }

    @Override
    public boolean visit(SQLLimit x) {
        SQLExpr offset;
        this.print0(this.ucase ? "LIMIT " : "limit ");
        SQLExpr rowCount = x.getRowCount();
        if (rowCount != null) {
            this.printExpr(rowCount, this.parameterized);
        }
        if ((offset = x.getOffset()) != null) {
            this.print0(this.ucase ? " OFFSET " : " offset ");
            this.printExpr(offset, this.parameterized);
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaAlterTableAddRangePartition x) {
        this.print(this.ucase ? "ADD " : "add ");
        if (x.isIfNotExists()) {
            this.print(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        this.print(this.ucase ? "RANGE PARTITION " : "range partition ");
        if (x.getKuduPartition() != null) {
            x.getKuduPartition().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaAlterTableDropRangePartition x) {
        this.print(this.ucase ? "DROP " : "drop ");
        if (x.isIfExists()) {
            this.print(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.print(this.ucase ? "RANGE PARTITION " : "range partition ");
        if (x.getKuduPartition() != null) {
            x.getKuduPartition().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaAlterTableSetRowFormat x) {
        this.print0(this.ucase ? "SET ROW FORMAT DELIMITED " : "set row format delimited ");
        if (x.getRowFormat() != null) {
            x.getRowFormat().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaKuduPartitionValue x) {
        if (x.getSingleValue() != null) {
            this.print(this.ucase ? "VALUE " : "value ");
            this.print(x.getSingleOperator().name);
            this.print(" ");
            x.getSingleValue().accept(this);
        } else {
            if (x.getLowerBound() != null) {
                x.getLowerBound().accept(this);
                this.print(" " + x.getLowerOperator().name + " ");
            }
            this.print(this.ucase ? "VALUES" : "values");
            if (x.getUpperBound() != null) {
                this.print(" " + x.getUpperOperator().name + " ");
                x.getUpperBound().accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByHash x) {
        if (x.isLinear()) {
            this.print0(this.ucase ? "LINEAR HASH" : "linear hash");
        } else if (x.isUnique()) {
            this.print0(this.ucase ? "UNI_HASH" : "uni_hash");
        } else {
            this.print0(this.ucase ? "HASH" : "hash");
        }
        if (x.isKey()) {
            this.print0(this.ucase ? " KEY" : " key");
        }
        if (x.getColumns() != null && !x.getColumns().isEmpty()) {
            this.print(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(')');
        }
        this.printPartitionsCountAndSubPartitions(x);
        this.printSQLPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(ImpalaPartitionByRange x) {
        this.print(this.ucase ? "RANGE " : "range ");
        if (x.getColumns() != null && !x.getColumns().isEmpty()) {
            this.print("(");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(") ");
        }
        this.print("(");
        if (x.getPartitionExprs() != null && !x.getPartitionExprs().isEmpty()) {
            ++this.indentCount;
            for (int i = 0; i < x.getPartitionExprs().size(); ++i) {
                ImpalaKuduPartitionValue partitionExpr = x.getPartitionExprs().get(i);
                this.println();
                this.print(this.ucase ? "PARTITION " : "partition ");
                partitionExpr.accept(this);
                if (i == x.getPartitionExprs().size() - 1) continue;
                this.print(",");
            }
            --this.indentCount;
        }
        this.print(")");
        return false;
    }

    @Override
    protected void printPartitionBy(HiveCreateTableStatement x) {
        if (!(x instanceof ImpalaCreateTableStatement)) {
            return;
        }
        if (((ImpalaCreateTableStatement)x).getKuduPartitions() != null && !((ImpalaCreateTableStatement)x).getKuduPartitions().isEmpty()) {
            this.println();
            this.print(this.ucase ? "PARTITION BY " : "partition by ");
            this.printAndAccept(((ImpalaCreateTableStatement)x).getKuduPartitions(), ",\n");
        }
    }

    @Override
    protected void printCached(HiveCreateTableStatement x) {
        if (!(x instanceof ImpalaCreateTableStatement)) {
            return;
        }
        if (((ImpalaCreateTableStatement)x).getCacheSpec() != null) {
            ((ImpalaCreateTableStatement)x).getCacheSpec().accept(this);
        }
        if (((ImpalaCreateTableStatement)x).getParquetLike() != null) {
            ((ImpalaCreateTableStatement)x).getParquetLike().accept(this);
        }
    }

    @Override
    public boolean visit(ImpalaDropStatsStatement x) {
        this.print0(this.ucase ? "DROP " : "drop ");
        if (x.isIncremental()) {
            this.print0(this.ucase ? "INCREMENTAL " : "incremental ");
        }
        this.print0(this.ucase ? "STATS " : "stats ");
        x.getName().accept(this);
        if (x.isIncremental()) {
            this.print0(this.ucase ? " PARTITION " : " partition ");
            this.print0("(");
            x.getPartitionName().accept(this);
            this.print0("=");
            x.getPartitionValue().accept(this);
            this.print0(")");
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaInvalidateMetadataStatement x) {
        this.print0(this.ucase ? "INVALIDATE " : "invalidate ");
        this.print0(this.ucase ? "METADATA" : "metadata");
        if (x.getTable() != null) {
            this.print0(" ");
            x.getTable().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaAlterTableAlterColumn x) {
        super.visit(x);
        if (x.getKuduStorageAttr() != null) {
            this.print0(" ");
            this.print0(this.ucase ? "SET " : "set ");
            x.getKuduStorageAttr().accept(this);
        }
        if (x.getAttrValue() != null) {
            this.print0(" ");
            x.getAttrValue().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaAlterTableChangeColumnStats x) {
        x.getColumn().accept(this);
        this.print0("(");
        this.printAndAccept(x.getItems(), ", ");
        this.print0(")");
        return false;
    }

    @Override
    public boolean visit(ImpalaCacheSpec x) {
        this.print0(" ");
        if (x.getCached().booleanValue()) {
            this.print0(this.ucase ? "CACHED IN" : "cached in");
            this.print0(" ");
            x.getPoolName().accept(this);
            if (Boolean.TRUE.equals(x.getWithReplication())) {
                this.print0(" ");
                this.print0(this.ucase ? "WITH REPLICATION = " : "with replication = ");
                this.print0(x.getReplicationCount().toString());
            }
        } else {
            this.print0(this.ucase ? "UNCACHED" : "uncached");
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaRefreshAuthStatement x) {
        this.print0(this.ucase ? "REFRESH" : "refresh");
        this.print0(" ");
        this.print0(this.ucase ? "AUTHORIZATION" : "authorization");
        return false;
    }

    @Override
    public boolean visit(ImpalaRefreshFunctionsStatement x) {
        this.print0(this.ucase ? "REFRESH FUNCTIONS " : "refresh functions ");
        x.getDbName().accept(this);
        return false;
    }

    @Override
    public boolean visit(ImpalaShowPartitionsStatement x) {
        this.print0(this.ucase ? "SHOW RANGE PARTITIONS " : "show range partitions ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public boolean visit(ImpalaRefreshTableStatement x) {
        this.print0(this.ucase ? "REFRESH " : "refresh ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public boolean visit(ImpalaRefreshPartitionStatement x) {
        this.print0(this.ucase ? "REFRESH " : "refresh ");
        x.getTableSource().accept(this);
        if (x.getPartition().size() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print0(")");
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaAlterViewStatement x) {
        this.print0(this.ucase ? "ALTER VIEW " : "alter view ");
        x.getTableSource().accept(this);
        List<SQLTableElement> columns = x.getColumns();
        if (columns.size() > 0) {
            this.print0(" (");
            ++this.indentCount;
            this.println();
            for (int i = 0; i < columns.size(); ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                columns.get(i).accept(this);
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        if (x.getSubQuery() != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            x.getSubQuery().accept(this);
        }
        if (x.getItem() != null) {
            this.print0(" ");
            x.getItem().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaAlterViewRenameTo x) {
        this.print0(this.ucase ? "RENAME TO " : "rename to ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public boolean visit(ImpalaAlterViewSetOwner x) {
        this.print0(this.ucase ? "SET OWNER USER " : "set owner user ");
        x.getOwner().accept(this);
        return false;
    }

    @Override
    public boolean visit(ImpalaAlterViewSetProperty x) {
        this.print0(this.ucase ? "SET TBLPROPERTIES (" : "set tblproperties (");
        this.printAndAccept(x.getProperties(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(ImpalaAlterViewUnsetProperty x) {
        this.print0(this.ucase ? "UNSET TBLPROPERTIES (" : "unset tblproperties (");
        this.printAndAccept(x.getProperties(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(ImpalaAlterTableSetCache x) {
        this.print0(this.ucase ? "SET" : "set");
        if (x.getCacheSpec() != null) {
            x.getCacheSpec().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaLikeParquet x) {
        this.println();
        this.print0(this.ucase ? "LIKE PARQUET " : "like parquet ");
        x.getLocation().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        SQLExpr where;
        this.print0(this.ucase ? "UPDATE " : "update ");
        this.printTableSource(x.getTableSource());
        this.println();
        this.print0(this.ucase ? "SET " : "set ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            SQLUpdateSetItem item = x.getItems().get(i);
            this.visit(item);
        }
        SQLTableSource from = x.getFrom();
        if (from != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            this.printTableSource(from);
        }
        if ((where = x.getWhere()) != null) {
            this.println();
            ++this.indentCount;
            this.print0(this.ucase ? "WHERE " : "where ");
            this.printExpr(where);
            --this.indentCount;
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaComputeIncrementalStatsStatement x) {
        int partitionsSize;
        this.print0(this.ucase ? "COMPUTE INCREMENTAL STATS " : "compute incremental stats ");
        x.getTableSource().accept(this);
        List<SQLAssignItem> partitions = x.getPartitions();
        if (partitions != null && (partitionsSize = partitions.size()) > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            for (int i = 0; i < partitionsSize; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLAssignItem assign = partitions.get(i);
                assign.getTarget().accept(this);
                this.print0(" ");
                this.print(assign.printToken());
                this.print0(" ");
                assign.getValue().accept(this);
            }
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(ImpalaComputeStatsStatement x) {
        this.print0(this.ucase ? "COMPUTE STATS " : "compute stats ");
        x.getTableSource().accept(this);
        List<SQLExpr> columns = x.getColumns();
        if (columns.size() > 0) {
            this.print("(");
            this.printAndAccept(columns, ", ");
            this.print(')');
        }
        if (x.getTableSample() != null) {
            this.print0(" ");
            this.print0(this.ucase ? "TABLESAMPLE SYSTEM" : "tablesample system");
            this.print("(");
            x.getTableSample().accept(this);
            this.print(')');
        }
        if (x.getRepeatable() != null) {
            this.print0(" ");
            this.print0(this.ucase ? "REPEATABLE" : "repeatable");
            this.print("(");
            x.getRepeatable().accept(this);
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(HiveInsertStatement x) {
        List<SQLAssignItem> partitions;
        int partitionSize;
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            this.visit(with);
            this.println();
        }
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
        } else {
            this.print0(this.ucase ? "INSERT INTO TABLE " : "insert into table ");
        }
        x.getTableSource().accept(this);
        List<SQLExpr> columns = x.getColumns();
        if (columns.size() > 0) {
            this.print("(");
            this.printAndAccept(columns, ", ");
            this.print(')');
        }
        if ((partitionSize = (partitions = x.getPartitions()).size()) > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            for (int i = 0; i < partitionSize; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLAssignItem assign = partitions.get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print(assign.printToken());
                assign.getValue().accept(this);
            }
            this.print(')');
        }
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? " IF NOT EXISTS" : " if not exists");
        }
        this.println();
        SQLSelect select = x.getQuery();
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        if (select != null) {
            select.accept(this);
        } else if (!valuesList.isEmpty()) {
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(valuesList, ", ");
        }
        return false;
    }
}

