/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.hologres.vistor;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLStartTransactionStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.fastsql.sql.dialect.hologres.ast.SqlOption;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresAnalyzeTableStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresCreateCastStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresCreateExtensionStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresCreateSchemaStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresCreateServerStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresDeleteStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresDropCastStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresDropMaterializedViewStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresDropServerStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresEndTransactionStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresImportSchemaStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresInvalidateStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresVacuumTableStatement;
import com.alibaba.fastsql.sql.dialect.hologres.vistor.HologresASTVisitor;
import com.alibaba.fastsql.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.fastsql.sql.dialect.postgresql.visitor.PGOutputVisitor;
import java.util.List;

public class HologresOutputVisitor
extends PGOutputVisitor
implements HologresASTVisitor {
    public HologresOutputVisitor(Appendable appender) {
        super(appender);
        this.dbType = DbType.hologres;
    }

    public HologresOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.hologres;
    }

    @Override
    public boolean visit(HologresInvalidateStatement x) {
        this.print0(this.ucase ? "INVALIDATE METADATA" : "invalidate metadata");
        if (x.getInvalidateTables() != null && x.getInvalidateTables().size() > 0) {
            this.print0(" ");
            int invalidateTalbesSize = x.getInvalidateTables().size();
            for (int i = 0; i < invalidateTalbesSize; ++i) {
                SQLName sqlName = x.getInvalidateTables().get(i);
                sqlName.accept(this);
                if (i != invalidateTalbesSize - 1) {
                    this.print(',');
                }
                if (!this.isPrettyFormat() || !sqlName.hasAfterComment()) continue;
                this.print(' ');
                this.printlnComment(sqlName.getAfterCommentsDirect());
            }
        }
        return true;
    }

    @Override
    public boolean visit(HologresCreateSchemaStatement x) {
        this.print0(this.ucase ? "CREATE SCHEMA " : "create schema ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        x.getName().accept(this);
        return false;
    }

    protected void printCreateTable(HologresCreateTableStatement x, boolean printSelect) {
        SQLExpr storedAs;
        SQLCreateTableStatement.Type tableType;
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isExternal()) {
            this.print0(this.ucase ? "EXTERNAL " : "external ");
        }
        if (x.isForeignTable()) {
            this.print0(this.ucase ? "FOREIGN " : "foreign ");
        }
        if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)(tableType = x.getType()))) {
            this.print0(this.ucase ? "GLOBAL TEMPORARY " : "global temporary ");
        } else if (SQLCreateTableStatement.Type.LOCAL_TEMPORARY.equals((Object)tableType)) {
            this.print0(this.ucase ? "LOCAL TEMPORARY " : "local temporary ");
        } else if (SQLCreateTableStatement.Type.SHADOW.equals((Object)tableType)) {
            this.print0(this.ucase ? "SHADOW " : "shadow ");
        }
        if (x.isDimension()) {
            this.print0(this.ucase ? "DIMENSION " : "dimension ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        this.printTableSourceExpr(x.getName());
        if (x.getParentTable() != null) {
            this.print0(this.ucase ? " PARTITION OF " : " partition of ");
            x.getParentTable().accept(this);
            if (x.getPartitionValues() != null) {
                this.println();
                this.print0(this.ucase ? "FOR VALUES IN (" : "for values in (");
                this.printAndAccept(x.getPartitionValues(), ", ");
                this.print0(")");
            }
        }
        this.printTableElements(x.getTableElementList());
        SQLExprTableSource inherits = x.getInherits();
        if (inherits != null) {
            this.print0(this.ucase ? " INHERITS (" : " inherits (");
            inherits.accept(this);
            this.print(')');
        }
        if ((storedAs = x.getStoredAs()) != null) {
            this.print0(this.ucase ? " STORE AS " : " store as ");
            this.printExpr(storedAs, this.parameterized);
        }
        SQLSelect select = x.getSelect();
        if (printSelect && select != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            this.visit(select);
        }
        if (x.getPartitionColumn() != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION BY LIST(" : "partition by list(");
            x.getPartitionColumn().accept(this);
            this.print0(")");
        }
        if (x.getServer() != null) {
            this.println();
            this.print0(this.ucase ? "SERVER " : "server ");
            x.getServer().accept(this);
            if (x.getServerOptions().size() != 0) {
                this.println();
                this.print0(this.ucase ? "OPTIONS ( " : "options ( ");
                for (int i = 0; i < x.getServerOptions().size(); ++i) {
                    SQLAssignItem item = x.getServerOptions().get(i);
                    item.getTarget().accept(this);
                    this.print0(" ");
                    item.getValue().accept(this);
                    if (i == x.getServerOptions().size() - 1) continue;
                    this.print0(", ");
                }
                this.print0(")");
            }
        }
    }

    @Override
    public boolean visit(HologresCreateTableStatement x) {
        SQLName tablespace;
        List<SQLAssignItem> options;
        this.printCreateTable(x, true);
        if (x.getSourceTable() != null) {
            this.print0(this.ucase ? " AS TABLE " : " as table ");
            x.getSourceTable().accept(this);
        }
        if ((options = x.getTableOptions()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "WITH (" : "with (");
            this.printAndAccept(options, ", ");
            this.print(')');
        }
        if ((tablespace = x.getTablespace()) != null) {
            this.println();
            this.print0(this.ucase ? "TABLESPACE " : "tablespace ");
            tablespace.accept(this);
        }
        if (x.getWithDataEnum() != null) {
            if (x.getWithDataEnum() == HologresCreateTableStatement.WithDataEnum.WITH_DATA) {
                this.print0(this.ucase ? " WITH DATA" : " with data ");
            } else if (x.getWithDataEnum() == HologresCreateTableStatement.WithDataEnum.WITH_NO_DATA) {
                this.print0(this.ucase ? " WITH NO DATA" : " with no data ");
            }
        }
        return false;
    }

    @Override
    public boolean visit(HologresImportSchemaStatement x) {
        this.print0(this.ucase ? "IMPORT FOREIGN SCHEMA " : "import foreign schema ");
        x.getRemote_schema().accept(this);
        this.print0(" ");
        if (x.getLimitTables() != null && x.getLimitTables().size() > 0) {
            this.print0(this.ucase ? "LIMIT TO " : "limit to ");
            this.print0("(");
            this.printList(x.getLimitTables());
            this.print0(")");
            this.print0(" ");
        }
        if (x.getExceptTables() != null && x.getExceptTables().size() > 0) {
            this.print0(this.ucase ? "EXCEPT " : "except ");
            this.print0("(");
            this.printList(x.getExceptTables());
            this.print0(")");
            this.print0(" ");
        }
        this.print0(this.ucase ? "FROM SERVER " : "from server ");
        x.getFrom_server().accept(this);
        this.print0(" ");
        this.print0(this.ucase ? "INTO " : "into ");
        x.getInto().accept(this);
        if (x.getOptions() != null && x.getOptions().size() > 0) {
            this.println(this.ucase ? " OPTIONS " : " option ");
            this.print0("(");
            for (int i = 0; i < x.getOptions().size(); ++i) {
                x.getOptions().get(i).accept(this);
            }
            this.print0(")");
        }
        return false;
    }

    @Override
    public boolean visit(SqlOption x) {
        x.getOption().accept(this);
        this.print0(" ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(HologresAnalyzeTableStatement x) {
        this.print0(this.ucase ? "ANALYZE " : "analyze ");
        this.printAndAccept(x.getTables(), ", ");
        if (!x.getColumns().isEmpty()) {
            this.print0("(");
            this.printList(x.getColumns());
            this.print0(")");
        }
        return false;
    }

    @Override
    public boolean visit(HologresVacuumTableStatement x) {
        this.print0(this.ucase ? "VACUUM " : "vacuum ");
        this.printAndAccept(x.getTables(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLStartTransactionStatement x) {
        this.print0(this.ucase ? "BEGIN " : "begin ");
        return false;
    }

    @Override
    public boolean visit(HologresCreateCastStatement x) {
        this.print0(this.ucase ? "CREATE CAST " : "create cast ");
        this.print0("(");
        this.print0(x.getSourceType().getName());
        this.print0(this.ucase ? " AS " : " as ");
        this.print0(x.getTargetType().getName());
        this.print0(")");
        this.print0(this.ucase ? " WITH INOUT AS " : " with inout as ");
        this.print0(this.ucase ? x.getTransformModeEnum().name().toUpperCase() : x.getTransformModeEnum().name().toLowerCase());
        return false;
    }

    @Override
    public boolean visit(HologresCreateExtensionStatement x) {
        this.print0(this.ucase ? "CREATE EXTENSION IF NOT EXISTS " : "create extension if not exists ");
        this.print0(x.getExtensionName().getSimpleName());
        if (x.getSchemaName() != null) {
            this.print0(this.ucase ? " SCHEMA " : " schema ");
            this.print0(x.getSchemaName().getSimpleName());
        }
        return false;
    }

    @Override
    public boolean visit(HologresDropCastStatement x) {
        this.print0(this.ucase ? "DROP CAST " : "drop cast ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.print0("(");
        this.print0(x.getSourceType().getName());
        this.print0(this.ucase ? " AS " : " as ");
        this.print0(x.getTargetType().getName());
        this.print0(")");
        return false;
    }

    @Override
    public boolean visit(HologresDropMaterializedViewStatement x) {
        this.print0(this.ucase ? "DROP MATERIALIZED VIEW " : "drop materialized view ");
        this.print0(x.getSourceView().getSimpleName());
        return false;
    }

    @Override
    public boolean visit(HologresCreateServerStatement x) {
        SQLExpr port;
        SQLExpr database;
        this.print0(this.ucase ? "CREATE SERVER " : "create server ");
        x.getName().accept(this);
        this.print0(this.ucase ? " FOREIGN DATA WRAPPER " : " foreign data wrapper ");
        this.printExpr(x.getForeignDataWrapper(), this.parameterized);
        this.print(" OPTIONS(");
        int cnt = 0;
        SQLExpr host = x.getHost();
        if (host != null) {
            this.print0(this.ucase ? "HOST " : "host ");
            this.printExpr(host, this.parameterized);
            ++cnt;
        }
        if ((database = x.getDatabase()) != null) {
            if (cnt++ > 0) {
                this.print(", ");
            }
            this.print0(this.ucase ? "DBNAME " : "dbname ");
            this.printExpr(database, this.parameterized);
        }
        if ((port = x.getPort()) != null) {
            if (cnt++ > 0) {
                this.print(", ");
            }
            this.print0(this.ucase ? "PORT " : "port ");
            this.printExpr(port);
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(HologresDeleteStatement x) {
        this.print0(this.ucase ? "DELETE FROM " : "delete from ");
        this.printTableSourceExpr(x.getTableName());
        if (x.getAlias() != null) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(x.getAlias());
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            ++this.indentCount;
            x.getWhere().accept(this);
            --this.indentCount;
        }
        return false;
    }

    @Override
    public void endVisit(HologresDeleteStatement x) {
    }

    @Override
    public boolean visit(HologresEndTransactionStatement x) {
        this.print0(this.ucase ? "END" : "end");
        return false;
    }

    @Override
    public boolean visit(PGInsertStatement x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
            this.println();
        }
        this.print0(this.ucase ? "INSERT INTO " : "insert into ");
        x.getTableSource().accept(this);
        this.printInsertColumns(x.getColumns());
        if (x.getValues() != null) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printlnAndAccept(x.getValuesList(), ", ");
        } else if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        List<SQLExpr> onConflictTarget = x.getOnConflictTarget();
        List<SQLUpdateSetItem> onConflictUpdateSetItems = x.getOnConflictUpdateSetItems();
        boolean onConflictDoNothing = x.isOnConflictDoNothing();
        if (onConflictDoNothing || onConflictTarget != null && onConflictTarget.size() > 0 || onConflictUpdateSetItems != null && onConflictUpdateSetItems.size() > 0) {
            SQLName onConflictConstraint;
            this.println();
            this.print0(this.ucase ? "ON CONFLICT" : "on conflict");
            if (onConflictTarget != null && onConflictTarget.size() > 0) {
                this.print0(" (");
                this.printAndAccept(onConflictTarget, ", ");
                this.print(')');
            }
            if ((onConflictConstraint = x.getOnConflictConstraint()) != null) {
                this.print0(this.ucase ? " ON CONSTRAINT " : " on constraint ");
                this.printExpr(onConflictConstraint);
            }
            if (onConflictDoNothing) {
                this.print0(this.ucase ? " DO NOTHING" : " do nothing");
            } else if (onConflictUpdateSetItems != null && onConflictUpdateSetItems.size() > 0) {
                this.print0(this.ucase ? " DO UPDATE SET " : " do update set ");
                this.printAndAccept(onConflictUpdateSetItems, ", ");
            }
            SQLExpr onConflictWhere = x.getOnConflictWhere();
            if (onConflictWhere != null) {
                this.print0(this.ucase ? " WHERE " : " where ");
                this.printExpr(onConflictWhere);
            }
        }
        if (x.getReturning() != null) {
            this.println();
            this.print0(this.ucase ? "RETURNING " : "returning ");
            x.getReturning().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLTruncateStatement x) {
        this.print0(this.ucase ? "TRUNCATE TABLE " : "truncate table ");
        if (x.isOnly()) {
            this.print0(this.ucase ? "ONLY " : "only ");
        }
        this.printlnAndAccept(x.getTableSources(), ", ");
        if (x.getRestartIdentity() != null) {
            if (x.getRestartIdentity().booleanValue()) {
                this.print0(this.ucase ? " RESTART IDENTITY" : " restart identity");
            } else {
                this.print0(this.ucase ? " CONTINUE IDENTITY" : " continue identity");
            }
        }
        if (x.getCascade() != null) {
            if (x.getCascade().booleanValue()) {
                this.print0(this.ucase ? " CASCADE" : " cascade");
            } else {
                this.print0(this.ucase ? " RESTRICT" : " restrict");
            }
        }
        if (x.isContinueIdentity()) {
            this.print0(this.ucase ? " CONTINUE IDENTITY" : " continue identity");
        }
        return false;
    }

    @Override
    public boolean visit(HologresDropServerStatement x) {
        this.print0(this.ucase ? "DROP SERVER " : "drop server ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getName().accept(this);
        if (x.isCascade()) {
            this.print0(this.ucase ? " CASCADE" : " cascade");
        }
        if (x.isRestrict()) {
            this.print0(this.ucase ? " RESTRICT" : " restrict");
        }
        return false;
    }

    private void printList(List<SQLName> items) {
        if (items != null && items.size() > 0) {
            int itemSize = items.size();
            for (int i = 0; i < itemSize; ++i) {
                SQLName sqlName = items.get(i);
                sqlName.accept(this);
                if (i != itemSize - 1) {
                    this.print(',');
                }
                if (!this.isPrettyFormat() || !sqlName.hasAfterComment()) continue;
                this.print(' ');
                this.printlnComment(sqlName.getAfterCommentsDirect());
            }
        }
    }
}

