/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.hologres.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLQueryExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLStartTransactionStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.fastsql.sql.dialect.hologres.ast.SqlOption;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresAnalyzeTableStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresCreateCastStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresCreateExtensionStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresCreateSchemaStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresCreateServerStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresDeleteStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresDropCastStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresDropMaterializedViewStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresDropServerStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresEndTransactionStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresImportSchemaStatement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresVacuumTableStatement;
import com.alibaba.fastsql.sql.dialect.hologres.parser.HologresCreateTableParser;
import com.alibaba.fastsql.sql.dialect.hologres.parser.HologresExprParser;
import com.alibaba.fastsql.sql.dialect.hologres.parser.HologresInvalidateParser;
import com.alibaba.fastsql.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.fastsql.sql.dialect.postgresql.parser.PGSQLStatementParser;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLCreateTableParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class HologresStatementParser
extends PGSQLStatementParser {
    public HologresStatementParser(String sql, SQLParserFeature ... features) {
        super(new HologresExprParser(sql, features));
        this.dbType = DbType.hologres;
    }

    @Override
    public SQLStatement parseCreateSchema() {
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
        }
        HologresCreateSchemaStatement stmt = new HologresCreateSchemaStatement(this.dbType);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    @Override
    public SQLStatement parseInvalidate() {
        this.accept(Token.INVALIDATE);
        Token token = this.lexer.token();
        switch (token) {
            case METADATA: {
                HologresInvalidateParser invalidateParser = new HologresInvalidateParser(this.exprParser);
                return invalidateParser.parseInvalidateMetadata();
            }
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    public SQLStatement parseImportSchema() {
        SQLName column;
        this.accept(Token.IMPORT);
        HologresImportSchemaStatement stmt = new HologresImportSchemaStatement(this.dbType);
        this.accept(Token.FOREIGN);
        this.accept(Token.SCHEMA);
        stmt.setRemote_schema(this.exprParser.name());
        boolean flag = true;
        if (this.lexer.token() == Token.LIMIT) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            this.accept(Token.LPAREN);
            while (true) {
                column = this.exprParser.name();
                stmt.addLimitTable(column);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            flag = false;
        }
        if (flag && this.lexer.token() == Token.EXCEPT) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                column = this.exprParser.name();
                stmt.addExceptTables(column);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        this.accept(Token.FROM);
        this.accept(Token.SERVER);
        stmt.setFrom_server(this.exprParser.name());
        this.accept(Token.INTO);
        stmt.setInto(this.exprParser.name());
        if (this.lexer.token() == Token.OPTIONS) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLName option = this.exprParser.name();
                SQLName value = this.exprParser.name();
                stmt.addSqlOption(new SqlOption(option, value));
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return stmt;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.identifierEquals("ANALYZE")) {
            SQLStatement stmt = this.parseAnalyze();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.BEGIN) {
            this.accept(Token.BEGIN);
            SQLStartTransactionStatement stmt = new SQLStartTransactionStatement(this.dbType);
            stmt.setBegin(true);
            statementList.add(stmt);
            return true;
        }
        return super.parseStatementListDialect(statementList);
    }

    @Override
    protected SQLStatement parseAnalyze() {
        this.lexer.nextToken();
        HologresAnalyzeTableStatement stmt = new HologresAnalyzeTableStatement();
        SQLName table = this.exprParser.name();
        stmt.setTable(table);
        stmt.setDbType(DbType.hologres);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.names(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        return stmt;
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new HologresCreateTableParser(this.exprParser);
    }

    @Override
    protected SQLStatement parseCreateCast() {
        this.accept(Token.CREATE);
        this.accept(Token.CAST);
        this.accept(Token.LPAREN);
        SQLDataType sourceDataType = this.exprParser.parseDataType();
        this.accept(Token.AS);
        SQLDataType targetDataType = this.exprParser.parseDataType();
        this.accept(Token.RPAREN);
        this.accept(Token.WITH);
        this.accept(Token.INOUT);
        this.accept(Token.AS);
        HologresCreateCastStatement stmt = new HologresCreateCastStatement(this.dbType);
        if (this.lexer.identifierEquals(HologresCreateCastStatement.TransformModeEnum.ASSIGNMENT.name())) {
            stmt.setTransformModeEnum(HologresCreateCastStatement.TransformModeEnum.ASSIGNMENT);
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals(HologresCreateCastStatement.TransformModeEnum.IMPLICIT.name())) {
            stmt.setTransformModeEnum(HologresCreateCastStatement.TransformModeEnum.IMPLICIT);
            this.lexer.nextToken();
        } else {
            throw new ParserException("syntax error , " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal() + ", pos " + this.lexer.pos());
        }
        stmt.setSourceType(sourceDataType);
        stmt.setTargetType(targetDataType);
        return stmt;
    }

    @Override
    protected SQLStatement parseCreateExtension() {
        this.accept(Token.CREATE);
        if (!this.lexer.identifierEquals(FnvHash.Constants.EXTENSION)) {
            throw new ParserException("syntax error , " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal() + ", pos " + this.lexer.pos());
        }
        this.lexer.nextToken();
        this.accept(Token.IF);
        this.accept(Token.NOT);
        this.accept(Token.EXISTS);
        HologresCreateExtensionStatement stmt = new HologresCreateExtensionStatement(this.dbType);
        stmt.setExtensionName(this.exprParser.name());
        if (this.lexer.token() == Token.SCHEMA) {
            this.accept(Token.SCHEMA);
            stmt.setSchemaName(this.exprParser.name());
        }
        return stmt;
    }

    @Override
    protected SQLStatement parseVacuum() {
        if (this.lexer.identifierEquals("VACUUM")) {
            this.lexer.nextToken();
            HologresVacuumTableStatement stmt = new HologresVacuumTableStatement();
            SQLName table = this.exprParser.name();
            stmt.setTable(table);
            stmt.setDbType(DbType.hologres);
            return stmt;
        }
        throw new ParserException("syntax error , " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal() + ", pos " + this.lexer.pos());
    }

    @Override
    protected SQLStatement parseDropCast(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        HologresDropCastStatement stmt = new HologresDropCastStatement(this.getDbType());
        this.accept(Token.CAST);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        this.accept(Token.LPAREN);
        stmt.setSourceType(this.exprParser.parseDataType());
        this.accept(Token.AS);
        stmt.setTargetType(this.exprParser.parseDataType());
        this.accept(Token.RPAREN);
        return stmt;
    }

    @Override
    protected SQLStatement parseDropMaterializedView(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        HologresDropMaterializedViewStatement stmt = new HologresDropMaterializedViewStatement(this.getDbType());
        this.lexer.nextToken();
        this.accept(Token.VIEW);
        stmt.setSourceView(this.exprParser.name());
        return stmt;
    }

    @Override
    public SQLStatement parseCreateServer() {
        if (this.lexer.token() == Token.CREATE) {
            this.accept(Token.CREATE);
        }
        HologresCreateServerStatement stmt = new HologresCreateServerStatement();
        stmt.setDbType(DbType.hologres);
        this.accept(Token.SERVER);
        stmt.setName(this.exprParser.name());
        this.accept(Token.FOREIGN);
        this.acceptIdentifier("DATA");
        this.acceptIdentifier("WRAPPER");
        stmt.setForeignDataWrapper(this.exprParser.name());
        this.accept(Token.OPTIONS);
        this.accept(Token.LPAREN);
        while (true) {
            if (this.lexer.identifierEquals(FnvHash.Constants.HOST)) {
                this.lexer.nextToken();
                SQLExpr host = this.exprParser.expr();
                stmt.setHost(host);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.DBNAME)) {
                this.lexer.nextToken();
                SQLExpr db = this.exprParser.expr();
                stmt.setDatabase(db);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.PORT)) {
                this.lexer.nextToken();
                SQLExpr port = this.exprParser.expr();
                stmt.setPort(port);
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return stmt;
    }

    @Override
    public HologresDeleteStatement parseDeleteStatement() {
        this.lexer.nextToken();
        HologresDeleteStatement deleteStatement = new HologresDeleteStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
        }
        SQLName tableName = this.exprParser.name();
        deleteStatement.setTableName(tableName);
        if (this.lexer.token() == Token.AS) {
            this.accept(Token.AS);
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            deleteStatement.setAlias(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.CURRENT) {
                this.lexer.nextToken();
                this.accept(Token.OF);
                SQLName cursorName = this.exprParser.name();
                SQLCurrentOfCursorExpr where = new SQLCurrentOfCursorExpr(cursorName);
                deleteStatement.setWhere(where);
            } else {
                SQLExpr where = this.exprParser.expr();
                deleteStatement.setWhere(where);
            }
        }
        return deleteStatement;
    }

    @Override
    public PGInsertStatement parseInsert() {
        PGInsertStatement stmt = new PGInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.lexer.nextToken();
            this.accept(Token.INTO);
            SQLName tableName = this.exprParser.name();
            stmt.setTableName(tableName);
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
                stmt.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.IDENTIFIER) {
                stmt.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
            this.accept(Token.VALUES);
            stmt.setDefaultValues(true);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                SQLInsertStatement.ValuesClause valuesCaluse = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(valuesCaluse.getValues(), valuesCaluse);
                stmt.addValueCause(valuesCaluse);
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr.getSubQuery());
        } else if (this.lexer.token() == Token.WITH) {
            SQLSelectStatement withStmt = (SQLSelectStatement)this.parseWith();
            stmt.setQuery(withStmt.getSelect());
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.CONFLICT)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    ArrayList<SQLExpr> onConflictTarget = new ArrayList<SQLExpr>();
                    this.exprParser.exprList(onConflictTarget, stmt);
                    stmt.setOnConflictTarget(onConflictTarget);
                    this.accept(Token.RPAREN);
                }
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    this.accept(Token.CONSTRAINT);
                    SQLName constraintName = this.exprParser.name();
                    stmt.setOnConflictConstraint(constraintName);
                }
                if (this.lexer.token() == Token.DO) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals(FnvHash.Constants.NOTHING)) {
                        this.lexer.nextToken();
                        stmt.setOnConflictDoNothing(true);
                    } else {
                        this.accept(Token.UPDATE);
                        this.accept(Token.SET);
                        while (true) {
                            SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
                            stmt.addConflicUpdateItem(item);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                    }
                }
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    SQLExpr where = this.exprParser.expr();
                    stmt.setOnConflictWhere(where);
                }
            }
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            SQLExpr returning = this.exprParser.expr();
            if (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                SQLListExpr list = new SQLListExpr();
                list.addItem(returning);
                this.exprParser.exprList(list.getItems(), list);
                returning = list;
            }
            stmt.setReturning(returning);
        }
        return stmt;
    }

    private HologresEndTransactionStatement parseEnd() {
        HologresEndTransactionStatement stmt = new HologresEndTransactionStatement();
        this.accept(Token.END);
        if (this.lexer.identifierEquals("WORK")) {
            stmt.setWork(true);
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals("TRANSACTION")) {
            stmt.setTransaction(true);
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public boolean parseStatementEnd(List<SQLStatement> statementList) {
        int startLine = this.lexer.getPosLine();
        int startCol = this.lexer.getPosColumn();
        HologresEndTransactionStatement stmt = this.parseEnd();
        this.addToStatementList(statementList, stmt, startLine, startCol);
        return true;
    }

    @Override
    public SQLStatement parseDropServer() {
        this.accept(Token.SERVER);
        HologresDropServerStatement stmt = new HologresDropServerStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        if (this.lexer.token() == Token.RESTRICT) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        } else if (this.lexer.token() == Token.CASCADE) {
            this.lexer.nextToken();
            stmt.setCascade(true);
        }
        return stmt;
    }
}

