/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.hologres.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLConstraint;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.dialect.hologres.ast.stmt.HologresCreateTableStatement;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLCreateTableParser;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;

public class HologresCreateTableParser
extends SQLCreateTableParser {
    public HologresCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SQLCreateTableStatement parseCreateTable(boolean acceptCreate) {
        HologresCreateTableStatement createTable = new HologresCreateTableStatement();
        if (acceptCreate) {
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                createTable.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.CREATE);
        }
        if (this.lexer.identifierEquals("GLOBAL")) {
            this.lexer.nextToken();
            if (!this.lexer.identifierEquals("TEMPORARY")) throw new ParserException("syntax error " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
        } else if (this.lexer.token() == Token.IDENTIFIER && this.lexer.stringVal().equalsIgnoreCase("LOCAL")) {
            this.lexer.nextToken();
            if (this.lexer.token() != Token.IDENTIFIER || !this.lexer.stringVal().equalsIgnoreCase("TEMPORAY")) throw new ParserException("syntax error. " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.LOCAL_TEMPORARY);
        } else if (this.lexer.token() == Token.FOREIGN) {
            this.lexer.nextToken();
            createTable.setForeignTable(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DIMENSION)) {
            this.lexer.nextToken();
            createTable.setDimension(true);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createTable.setIfNotExiists(true);
        }
        createTable.setName(this.exprParser.name());
        if (this.lexer.identifierEquals(FnvHash.Constants.PARTITION)) {
            this.lexer.nextToken();
            this.accept(Token.OF);
            SQLName parentName = this.exprParser.name();
            createTable.setParentTable(new SQLExprTableSource(parentName));
            this.accept(Token.FOR);
            this.accept(Token.VALUES);
            this.accept(Token.IN);
            this.accept(Token.LPAREN);
            do {
                SQLCharExpr value = this.exprParser.charExpr();
                createTable.addPartitionValues(value);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token() != Token.RPAREN);
            this.accept(Token.RPAREN);
            return createTable;
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            do {
                SQLColumnDefinition column;
                Token token = this.lexer.token();
                if (this.lexer.identifierEquals(FnvHash.Constants.SUPPLEMENTAL) && DbType.oracle == this.dbType) {
                    SQLTableElement element = this.parseCreateTableSupplementalLogingProps();
                    element.setParent(createTable);
                    createTable.getTableElementList().add(element);
                } else if (token == Token.IDENTIFIER || token == Token.LITERAL_ALIAS) {
                    column = this.exprParser.parseColumn();
                    column.setParent(createTable);
                    createTable.getTableElementList().add(column);
                } else if (token == Token.PRIMARY || token == Token.UNIQUE || token == Token.CHECK || token == Token.CONSTRAINT || token == Token.FOREIGN) {
                    SQLConstraint constraint = this.exprParser.parseConstaint();
                    constraint.setParent(createTable);
                    createTable.getTableElementList().add((SQLTableElement)((Object)constraint));
                } else {
                    if (token == Token.TABLESPACE) {
                        throw new ParserException("TODO " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
                    }
                    column = this.exprParser.parseColumn();
                    createTable.getTableElementList().add(column);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token() != Token.RPAREN);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals(Token.PARTITION.name())) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                this.acceptIdentifier("LIST");
                this.accept(Token.LPAREN);
                if (this.lexer.token() != Token.IDENTIFIER && this.lexer.token() != Token.LITERAL_ALIAS) {
                    this.printError(Token.IDENTIFIER, Token.LITERAL_ALIAS);
                }
                String partitionCol = this.lexer.stringVal();
                createTable.setPartitionColumn(new SQLIdentifierExpr(partitionCol));
                this.lexer.nextToken();
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.SERVER) {
                this.lexer.nextToken();
                SQLName serverName = this.exprParser.name();
                createTable.setServer(serverName);
                if (this.lexer.token() == Token.OPTIONS) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.LPAREN) {
                        this.lexer.nextToken();
                        do {
                            SQLName option = this.exprParser.name();
                            SQLCharExpr value = this.exprParser.charExpr();
                            createTable.addOption(option, value);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        } while (this.lexer.token() != Token.RPAREN);
                        this.accept(Token.RPAREN);
                    }
                }
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.INHERITS)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLName inherits = this.exprParser.name();
                createTable.setInherits(new SQLExprTableSource(inherits));
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                SQLName sourceTable = this.exprParser.name();
                createTable.setSourceTable(new SQLExprTableSource(sourceTable));
            } else {
                SQLSelect select = this.createSQLSelectParser().select();
                createTable.setSelect(select);
            }
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(Token.DATA.name())) {
                this.lexer.nextToken();
                createTable.setWithDataEnum(HologresCreateTableStatement.WithDataEnum.WITH_DATA);
            } else if (this.lexer.identifierEquals(Token.NO.name())) {
                this.lexer.nextToken();
                this.acceptIdentifier(Token.DATA.name());
                createTable.setWithDataEnum(HologresCreateTableStatement.WithDataEnum.WITH_NO_DATA);
            }
        }
        if (this.lexer.token() != Token.TABLESPACE) return createTable;
        this.lexer.nextToken();
        createTable.setTablespace(this.exprParser.name());
        return createTable;
    }
}

