/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.hologres.ast;

import com.alibaba.fastsql.FastsqlException;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.dialect.hologres.vistor.HologresASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.io.IOException;

public class SqlOption
extends SQLObjectImpl
implements SQLReplaceable {
    private SQLExpr option;
    private SQLExpr value;

    public SqlOption() {
    }

    public SqlOption(SQLExpr option, SQLExpr value) {
        this.option = option;
        this.value = value;
    }

    public SQLExpr getOption() {
        return this.option;
    }

    public void setOption(SQLExpr option) {
        if (option != null) {
            option.setParent(this);
        }
        this.option = option;
    }

    public SQLExpr getValue() {
        return this.value;
    }

    public void setValue(SQLExpr value) {
        if (value != null) {
            value.setParent(this);
        }
        this.value = value;
    }

    @Override
    public void output(Appendable buf) {
        try {
            this.option.output(buf);
            buf.append(" ");
            this.value.output(buf);
        }
        catch (IOException ex) {
            throw new FastsqlException("output error", ex);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (((HologresASTVisitor)visitor).visit(this)) {
            if (this.option != null) {
                this.acceptChild(visitor, this.option);
            }
            if (this.value != null) {
                this.acceptChild(visitor, this.option);
            }
        }
        ((HologresASTVisitor)visitor).endVisit(this);
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.option == expr) {
            this.setOption(target);
            return true;
        }
        if (this.value == expr) {
            this.setValue(target);
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlOption that = (SqlOption)o;
        if (this.option != null ? !this.option.equals(that.option) : that.option != null) {
            return false;
        }
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        int result = this.option != null ? this.option.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

