/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.hive.visitor;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLIndexDefinition;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLPartitionBy;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableExchangePartition;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableReplaceColumn;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableSetLocation;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLMergeStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.hive.ast.ArgodbAlterTableDeleteColumnItem;
import com.alibaba.fastsql.sql.dialect.hive.ast.ArgodbAlterTableDropIndex;
import com.alibaba.fastsql.sql.dialect.hive.ast.ArgodbPartitionByRange;
import com.alibaba.fastsql.sql.dialect.hive.ast.ArgodbRebuildIndexStatement;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterTableCompactItem;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterTablePartitionItem;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterTableSetFileformat;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterTableSetSerde;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterTableSetSerdeproperties;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterTableUnsetProperty;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterViewSetProperty;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterViewUnsetProperty;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveCreateMaterializedViewStatement;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveInputOutputFormat;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveInsertStatement;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveLockTableStatement;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveMergeUpdateClause;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveShowLocksStatement;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveCreateFunctionStatement;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveLoadDataStatement;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveMsckRepairStatement;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveReloadStatement;
import com.alibaba.fastsql.sql.dialect.hive.visitor.HiveASTVisitor;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddFileStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsSetAssignItem;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class HiveOutputVisitor
extends SQLASTOutputVisitor
implements HiveASTVisitor {
    public HiveOutputVisitor(Appendable appender) {
        super(appender, DbType.hive);
        this.quote = (char)96;
    }

    public HiveOutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
        this.quote = (char)96;
    }

    public HiveOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.quote = (char)96;
        this.dbType = DbType.hive;
    }

    @Override
    public boolean visit(HiveInsert x) {
        if (x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
        } else {
            this.print0(this.ucase ? "INSERT INTO TABLE " : "insert into table ");
        }
        x.getTableSource().accept(this);
        List<SQLAssignItem> partitions = x.getPartitions();
        if (partitions != null) {
            int partitionsSize = partitions.size();
            if (partitionsSize > 0) {
                this.print0(this.ucase ? " PARTITION (" : " partition (");
                for (int i = 0; i < partitionsSize; ++i) {
                    if (i != 0) {
                        this.print0(", ");
                    }
                    SQLAssignItem assign = partitions.get(i);
                    assign.getTarget().accept(this);
                    if (assign.getValue() == null) continue;
                    this.print(assign.printToken());
                    assign.getValue().accept(this);
                }
                this.print(')');
            }
            this.println();
        }
        SQLSelect select = x.getQuery();
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        if (select != null) {
            select.accept(this);
        } else if (!valuesList.isEmpty()) {
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(valuesList, ", ");
        }
        return false;
    }

    @Override
    public void endVisit(HiveInsert x) {
    }

    @Override
    public boolean visit(SQLExternalRecordFormat x) {
        return this.hiveVisit(x);
    }

    @Override
    public void endVisit(HiveMultiInsertStatement x) {
    }

    @Override
    public boolean visit(HiveMultiInsertStatement x) {
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            this.visit(with);
            this.println();
        }
        SQLTableSource from = x.getFrom();
        if (x.getFrom() != null) {
            if (from instanceof SQLSubqueryTableSource) {
                SQLSelect select = ((SQLSubqueryTableSource)from).getSelect();
                this.print0(this.ucase ? "FROM (" : "from (");
                ++this.indentCount;
                this.println();
                select.accept(this);
                --this.indentCount;
                this.println();
                this.print0(") ");
                if (x.getFrom().getAlias() != null) {
                    this.print0(x.getFrom().getAlias());
                }
            } else {
                this.print0(this.ucase ? "FROM " : "from ");
                from.accept(this);
            }
            this.println();
        }
        for (int i = 0; i < x.getItems().size(); ++i) {
            HiveInsert insert = x.getItems().get(i);
            if (i != 0) {
                this.println();
            }
            insert.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(HiveInsertStatement x) {
    }

    @Override
    public boolean visit(HiveInsertStatement x) {
        List<SQLExpr> columns;
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            this.visit(with);
            this.println();
        }
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
        } else {
            this.print0(this.ucase ? "INSERT INTO TABLE " : "insert into table ");
        }
        x.getTableSource().accept(this);
        List<SQLAssignItem> partitions = x.getPartitions();
        int partitionSize = partitions.size();
        if (partitionSize > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            for (int i = 0; i < partitionSize; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLAssignItem assign = partitions.get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print(assign.printToken());
                assign.getValue().accept(this);
            }
            this.print(')');
        }
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? " IF NOT EXISTS" : " if not exists");
        }
        if ((columns = x.getColumns()).size() > 0) {
            if (partitionSize > 0) {
                this.print(' ');
            }
            this.print("(");
            this.printAndAccept(columns, ", ");
            this.print(')');
        }
        this.println();
        SQLSelect select = x.getQuery();
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        if (select != null) {
            select.accept(this);
        } else if (!valuesList.isEmpty()) {
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(valuesList, ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLMergeStatement.MergeInsertClause x) {
        this.print0(this.ucase ? "WHEN NOT MATCHED" : "when not matched");
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " AND " : " and ");
            x.getWhere().accept(this);
        }
        this.print0(this.ucase ? " THEN INSERT" : " then insert");
        if (x.getColumns().size() > 0) {
            this.print(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(')');
        }
        this.print0(this.ucase ? " VALUES (" : " values (");
        this.printAndAccept(x.getValues(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLMergeStatement.MergeUpdateClause x) {
        this.print0(this.ucase ? "WHEN MATCHED " : "when matched ");
        ++this.indentCount;
        SQLExpr where = x.getWhere();
        if (where != null) {
            ++this.indentCount;
            if (SQLBinaryOpExpr.isAnd(where)) {
                this.println();
            }
            this.print0(this.ucase ? "AND " : "and ");
            this.printExpr(where, this.parameterized);
            --this.indentCount;
            this.println();
        }
        this.print0(this.ucase ? "THEN UPDATE SET " : "then update set ");
        this.printAndAccept(x.getItems(), ", ");
        --this.indentCount;
        SQLExpr deleteWhere = x.getDeleteWhere();
        if (deleteWhere != null) {
            this.println();
            this.print0(this.ucase ? "WHEN MATCHED AND " : "when matched and ");
            this.printExpr(deleteWhere, this.parameterized);
            this.print0(this.ucase ? " THEN DELETE" : " then delete");
        }
        return false;
    }

    @Override
    public boolean visit(HiveMergeUpdateClause x) {
        if (x.isDeleteFirst()) {
            this.print0(this.ucase ? "WHEN MATCHED" : "when matched");
            SQLExpr deleteWhere = x.getDeleteWhere();
            if (deleteWhere != null) {
                this.print0(this.ucase ? " AND " : "AND ");
                this.printExpr(deleteWhere, this.parameterized);
            }
            this.print0(this.ucase ? " THEN DELETE" : " then delete");
            if (x.getItems() != null && !x.getItems().isEmpty()) {
                this.println();
                this.print0(this.ucase ? "WHEN MATCHED " : "when matched ");
                ++this.indentCount;
                SQLExpr where = x.getWhere();
                if (where != null) {
                    ++this.indentCount;
                    if (SQLBinaryOpExpr.isAnd(where)) {
                        this.println();
                    }
                    this.print0(this.ucase ? "AND " : "and ");
                    this.printExpr(where, this.parameterized);
                    --this.indentCount;
                    this.println();
                }
                this.print0(this.ucase ? "THEN UPDATE SET " : "then update set ");
                this.printAndAccept(x.getItems(), ", ");
                --this.indentCount;
            }
        } else {
            this.print0(this.ucase ? "WHEN MATCHED " : "when matched ");
            ++this.indentCount;
            SQLExpr where = x.getWhere();
            if (where != null) {
                ++this.indentCount;
                if (SQLBinaryOpExpr.isAnd(where)) {
                    this.println();
                }
                this.print0(this.ucase ? "AND " : "and ");
                this.printExpr(where, this.parameterized);
                --this.indentCount;
                this.println();
            }
            this.print0(this.ucase ? "THEN UPDATE SET " : "then update set ");
            this.printAndAccept(x.getItems(), ", ");
            --this.indentCount;
            if (x.isHasDelete()) {
                this.println();
                this.print0(this.ucase ? "WHEN MATCHED" : "when matched");
                SQLExpr deleteWhere = x.getDeleteWhere();
                if (deleteWhere != null) {
                    this.print0(this.ucase ? " AND " : " and ");
                    this.printExpr(deleteWhere, this.parameterized);
                }
                this.print0(this.ucase ? " THEN DELETE" : " then delete");
            }
        }
        return false;
    }

    @Override
    public boolean visit(HiveCreateFunctionStatement x) {
        SQLExpr symbol;
        if (x.isTemporary()) {
            this.print0(this.ucase ? "CREATE TEMPORARY FUNCTION " : "create temporary function ");
        } else {
            this.print0(this.ucase ? "CREATE FUNCTION " : "create function ");
        }
        x.getName().accept(this);
        SQLExpr className = x.getClassName();
        if (className != null) {
            this.print0(this.ucase ? " AS " : " as ");
            className.accept(this);
        }
        ++this.indentCount;
        SQLExpr location = x.getLocationn();
        if (location != null) {
            this.println();
            this.print0(this.ucase ? "LOCATION " : "location ");
            location.accept(this);
        }
        if ((symbol = x.getSymbol()) != null) {
            this.println();
            this.print0(this.ucase ? "SYMBOL = " : "symbol = ");
            symbol.accept(this);
        }
        if (x.getResources() != null && !x.getResources().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "USING " : "using ");
            for (int i = 0; i < x.getResources().size(); ++i) {
                HiveCreateFunctionStatement.ResourceItem resource = x.getResources().get(i);
                if (resource.getResourceType() != null) {
                    this.print0(resource.getResourceType().name());
                    this.print(' ');
                }
                if (resource.getResource() != null) {
                    resource.getResource().accept(this);
                }
                if (i == x.getResources().size() - 1) continue;
                this.print(",");
                this.println();
            }
        }
        --this.indentCount;
        return false;
    }

    @Override
    public void endVisit(HiveCreateFunctionStatement x) {
    }

    @Override
    public boolean visit(HiveLoadDataStatement x) {
        this.print0(this.ucase ? "LOAD DATA " : "load data ");
        if (x.isLocal()) {
            this.print0(this.ucase ? "LOCAL " : "local ");
        }
        this.print0(this.ucase ? "INPATH " : "inpath ");
        x.getInpath().accept(this);
        if (x.isOverwrite()) {
            this.print0(this.ucase ? " OVERWRITE INTO TABLE " : " overwrite into table ");
        } else {
            this.print0(this.ucase ? " INTO TABLE " : " into table ");
        }
        x.getInto().accept(this);
        if (x.getPartition().size() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public void endVisit(HiveLoadDataStatement x) {
    }

    @Override
    public void endVisit(HiveInputOutputFormat x) {
    }

    @Override
    public boolean visit(HiveMsckRepairStatement x) {
        SQLIdentifierExpr optionType;
        SQLExprTableSource table;
        List<SQLCommentHint> headHints = x.getHeadHintsDirect();
        if (headHints != null) {
            for (SQLCommentHint hint : headHints) {
                hint.accept(this);
                this.println();
            }
        }
        this.print0(this.ucase ? "MSCK REPAIR" : "msck repair");
        SQLName database = x.getDatabase();
        if (database != null) {
            this.print0(this.ucase ? " DATABASE " : " database ");
            database.accept(this);
        }
        if ((table = x.getTable()) != null) {
            this.print0(this.ucase ? " TABLE " : " table ");
            table.accept(this);
        }
        if ((optionType = x.getOptionType()) != null) {
            this.print0(" ");
            this.print0(this.ucase ? optionType.getName().toUpperCase() : optionType.getLowerName());
            this.print0(this.ucase ? " PARTITIONS" : " partitions");
        }
        return false;
    }

    @Override
    public void endVisit(HiveMsckRepairStatement x) {
    }

    @Override
    public boolean visit(SQLAlterTableExchangePartition x) {
        this.print0(this.ucase ? "EXCHANGE PARTITION (" : "exchange partition (");
        this.printAndAccept(x.getPartitions(), ", ");
        this.print0(this.ucase ? ") WITH TABLE " : ") with table ");
        x.getTable().accept(this);
        Boolean validation = x.getValidation();
        if (validation != null) {
            if (validation.booleanValue()) {
                this.print0(this.ucase ? " WITH VALIDATION" : " with validation");
            } else {
                this.print0(this.ucase ? " WITHOUT VALIDATION" : " without validation");
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateIndexStatement x) {
        SQLName storedAs;
        SQLExternalRecordFormat format;
        SQLTableSource in;
        SQLExpr comment;
        String using;
        this.print0(this.ucase ? "CREATE " : "create ");
        this.print0(this.ucase ? "INDEX " : "index ");
        x.getName().accept(this);
        this.print0(this.ucase ? " ON TABLE " : " on table ");
        x.getTable().accept(this);
        this.print0(" (");
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        String type = x.getType();
        if (type != null) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(type);
        }
        if (x.isDeferedRebuild()) {
            this.print0(this.ucase ? " WITH DEFERRED REBUILD" : " with deferred rebuild");
        }
        if (x.getProperties().size() > 0) {
            this.print0(this.ucase ? " IDXPROPERTIES (" : " idxproperties (");
            this.printAndAccept(x.getProperties(), ", ");
            this.print(')');
        }
        if ((using = x.getUsing()) != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(using);
        }
        if ((comment = x.getComment()) != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            comment.accept(this);
        }
        if ((in = x.getIn()) != null) {
            this.print0(this.ucase ? " IN TABLE " : " in table ");
            in.accept(this);
        }
        if ((format = x.getRowFormat()) != null) {
            this.println();
            this.print0(this.ucase ? "ROW FORMAT DELIMITED " : "row rowFormat delimited ");
            this.visit(format);
        }
        if ((storedAs = x.getStoredAs()) != null) {
            this.print0(this.ucase ? " STORED BY " : " stored by ");
            storedAs.accept(this);
        }
        if (x.getTableProperties().size() > 0) {
            this.print0(this.ucase ? " TBLPROPERTIES (" : " tblproperties (");
            this.printAndAccept(x.getTableProperties(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x, boolean parameterized) {
        String text = x.getText();
        if (text == null) {
            this.print0(this.ucase ? "NULL" : "null");
        } else {
            StringBuilder buf = new StringBuilder(text.length() + 2);
            buf.append('\'');
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    default: 
                }
                if (ch == '\u2605') {
                    buf.append("\\u2605");
                    continue;
                }
                if (ch == '\u25bc') {
                    buf.append("\\u25bc");
                    continue;
                }
                buf.append(ch);
            }
            buf.append('\'');
            this.print0(buf.toString());
        }
        return false;
    }

    @Override
    public boolean visit(OdpsAddFileStatement x) {
        this.print0(this.ucase ? "ADD " : "add ");
        OdpsAddFileStatement.FileType type = x.getType();
        switch (type) {
            case JAR: {
                this.print0(this.ucase ? "JAR " : "jar ");
                break;
            }
            case ARCHIVE: {
                this.print0(this.ucase ? "ARCHIVE " : "archive ");
                break;
            }
            case PY: {
                this.print0(this.ucase ? "PY " : "py ");
                break;
            }
            default: {
                this.print0(this.ucase ? "FILE " : "file ");
            }
        }
        this.print0(x.getFile());
        SQLExpr comment = x.getComment();
        if (comment != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            this.printExpr(comment);
        }
        if (x.isForce()) {
            this.print0(" -f");
        }
        return false;
    }

    @Override
    public void endVisit(OdpsAddFileStatement x) {
    }

    @Override
    public boolean visit(OdpsSetAssignItem x) {
        x.getTarget().accept(this);
        SQLExpr value = x.getValue();
        if (value != null) {
            if (x.getToken() == Token.EQ || x.getToken() == null) {
                this.print0(" = ");
            } else {
                this.print(x.printToken());
            }
            if (value instanceof SQLListExpr) {
                this.printAndAccept(((SQLListExpr)value).getItems(), ", ");
            } else {
                value.accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(OdpsSetAssignItem x) {
    }

    @Override
    public boolean visit(HiveShowLocksStatement x) {
        this.print0(this.ucase ? "SHOW LOCKS" : "show locks");
        if (x.getTable() != null) {
            this.print0(" ");
            x.getTable().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(HiveShowLocksStatement x) {
    }

    @Override
    public boolean visit(HiveLockTableStatement x) {
        if (x.isUnlock()) {
            this.print0(this.ucase ? "UNLOCK TABLE " : "unlock table ");
        } else {
            this.print0(this.ucase ? "LOCK TABLE " : "lock table ");
        }
        x.getTable().accept(this);
        if (x.getPartitions() != null && !x.getPartitions().isEmpty()) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(x.getPartitions(), ", ");
            this.print0(")");
        }
        if (!x.isUnlock()) {
            this.print0(" ");
            this.print0(this.ucase ? x.getLockType().name().toUpperCase() : x.getLockType().name().toLowerCase());
        }
        return false;
    }

    @Override
    public void endVisit(HiveLockTableStatement x) {
    }

    @Override
    public boolean visit(HiveReloadStatement x) {
        this.print0(this.ucase ? "RELOAD " : "reload ");
        if (x.getReloadType() != null) {
            this.print0(this.ucase ? x.getReloadType().name() : x.getReloadType().name().toLowerCase());
        }
        return false;
    }

    @Override
    public void endVisit(HiveReloadStatement x) {
    }

    @Override
    public boolean visit(HiveCreateMaterializedViewStatement x) {
        Boolean enableQueryRewrite;
        Boolean parallel;
        SQLPartitionBy partitionBy;
        this.print0(this.ucase ? "CREATE MATERIALIZED VIEW " : "create materialized view ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        x.getName().accept(this);
        if (x.isDisableRewrite()) {
            this.println();
            this.print0(this.ucase ? "DISABLE REWRITE" : "disable rewrite");
        }
        if ((partitionBy = x.getPartitionBy()) != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            partitionBy.accept(this);
        }
        this.printOracleSegmentAttributes(x);
        this.println();
        Boolean cache = x.getCache();
        if (cache != null) {
            this.print(cache != false ? "CACHE" : "NOCACHE");
            this.println();
        }
        if ((parallel = x.getParallel()) != null) {
            if (parallel.booleanValue()) {
                this.print(this.ucase ? "PARALLEL" : "parallel");
                Integer parallelValue = x.getParallelValue();
                if (parallelValue != null) {
                    this.print(' ');
                    this.print(parallelValue);
                }
            } else {
                this.print(this.ucase ? "NOPARALLEL" : "noparallel");
            }
            this.println();
        }
        if (x.isBuildImmediate()) {
            this.println(this.ucase ? "BUILD IMMEDIATE" : "build immediate");
        }
        if (x.isRefresh()) {
            this.print(this.ucase ? "REFRESH" : "refresh");
            if (x.isRefreshFast()) {
                this.print(this.ucase ? " FAST" : " fast");
            } else if (x.isRefreshComlete()) {
                this.print(this.ucase ? " COMPLETE" : " complete");
            } else if (x.isRefreshForce()) {
                this.print(this.ucase ? " FORCE" : " force");
            }
            if (x.isRefreshOnCommit()) {
                this.print(this.ucase ? " ON COMMIT" : " on commit");
            } else if (x.isRefreshOnDemand()) {
                this.print(this.ucase ? " ON DEMAND" : " on demand");
            }
            this.println();
        }
        if ((enableQueryRewrite = x.getEnableQueryRewrite()) != null) {
            if (enableQueryRewrite.booleanValue()) {
                this.print(this.ucase ? "ENABLE QUERY REWRITE" : "enable query rewrite");
            } else {
                this.print(this.ucase ? "DISABLE QUERY REWRITE" : "disable query rewrite");
            }
            this.println();
        }
        this.println(this.ucase ? "AS" : "as");
        x.getQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(ArgodbAlterTableDropIndex x) {
        this.print0(this.ucase ? "DROP " : "drop ");
        if (x.getIndexDefinition() != null) {
            x.getIndexDefinition().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ArgodbRebuildIndexStatement x) {
        this.print0(this.ucase ? "REBUILD " : "rebuild ");
        if (x.getIndexDefinition() != null) {
            SQLIndexDefinition index = x.getIndexDefinition();
            if (index.isGlobal()) {
                this.print0(this.ucase ? "GLOBAL " : "global ");
            } else if (index.isLocal()) {
                this.print0(this.ucase ? "LOCAL " : "local ");
            }
            if (index.isIndex()) {
                this.print0(this.ucase ? "INDEX " : "index ");
            }
            if (index.getName() != null) {
                index.getName().accept(this);
                this.print(' ');
            }
            if (index.getTable() != null) {
                this.print0(this.ucase ? "ON " : "on ");
                index.getTable().accept(this);
            }
            this.print('(');
            this.printAndAccept(index.getColumns(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(ArgodbAlterTableDeleteColumnItem x) {
        this.print0(this.ucase ? "DELETE COLUMNS " : "delete columns ");
        this.print('(');
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(HiveAlterTableCompactItem x) {
        if (x.getPartition() != null && !x.getPartition().isEmpty()) {
            this.print0(this.ucase ? "PARTITION " : "partition ");
            this.printAssignItems(x.getPartition());
        }
        this.print0(this.ucase ? "COMPACT " : "compact ");
        if (x.getCompactType() != null) {
            this.print(x.getCompactType().getValue());
        } else if (x.getCompactExpr() != null) {
            x.getCompactExpr().accept(this);
        }
        if (x.isAndWait()) {
            this.print0(this.ucase ? " AND WAIT" : " and wait");
        }
        if (x.getBuckets() != null) {
            this.println();
            this.print(this.ucase ? "CLUSTERED INTO " : "clustered into ");
            this.print(x.getBuckets());
            this.print0(this.ucase ? " BUCKETS" : " buckets");
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getPoolName() != null) {
            this.println();
            this.print0(this.ucase ? "POOL " : "pool ");
            x.getPoolName().accept(this);
        }
        if (!x.getOverwriteProperties().isEmpty()) {
            this.println();
            this.print(this.ucase ? "WITH OVERWRITE TBLPROPERTIES(" : "with overwrite tblproperties(");
            this.printAndAccept(x.getOverwriteProperties(), ", ");
            this.print0(")");
        }
        return false;
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        SQLExpr where;
        SQLTableSource from = x.getFrom();
        String alias = x.getAlias();
        if (from == null) {
            this.print0(this.ucase ? "DELETE FROM " : "delete from ");
            this.printTableSourceExpr(x.getTableName());
            if (alias != null) {
                this.print(' ');
                this.print0(alias);
            }
        } else {
            this.print0(this.ucase ? "DELETE " : "delete ");
            this.printTableSourceExpr(x.getTableName());
            this.print0(this.ucase ? " FROM " : " from ");
            from.accept(this);
        }
        if (x.getPartitions() != null && !x.getPartitions().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "PARTITION " : "partition ");
            this.printAssignItems(x.getPartitions());
        }
        if ((where = x.getWhere()) != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            ++this.indentCount;
            where.accept(this);
            --this.indentCount;
        }
        return false;
    }

    @Override
    public boolean visit(HiveAlterTableSetSerdeproperties x) {
        if (x.getPartition().size() != 0) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print0(") ");
        }
        this.print0(this.ucase ? "SET SERDEPROPERTIES (" : "set serdeproperties (");
        this.printAndAccept(x.getOptions(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(HiveAlterTableSetFileformat x) {
        if (x.getPartition().size() != 0) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print0(") ");
        }
        this.print0(this.ucase ? "SET FILEFORMAT " : "set fileformat ");
        if (x.getFileFormat() != null) {
            x.getFileFormat().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(HiveAlterTablePartitionItem x) {
        if (!x.getPartitions().isEmpty()) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartitions(), ", ");
            this.print(") ");
        }
        x.getItem().accept(this);
        return false;
    }

    @Override
    public boolean visit(ArgodbPartitionByRange x) {
        this.print0(this.ucase ? "RANGE (" : "range (");
        this.printAndAccept(x.getColumnDefinitions(), ", ");
        this.print(") (");
        this.println();
        this.printlnAndAccept(x.getPartitions(), ",");
        this.println();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableReplaceColumn x) {
        if (x.getPartition().size() != 0) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print0(") ");
        }
        this.print0(this.ucase ? "REPLACE COLUMNS (" : "replace columns (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(HiveAlterTableUnsetProperty x) {
        this.print0(this.ucase ? "UNSET TBLPROPERTIES (" : "unset tblproperties (");
        this.printAndAccept(x.getProperties(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(HiveAlterViewUnsetProperty x) {
        this.print0(this.ucase ? "UNSET TBLPROPERTIES (" : "unset tblproperties (");
        this.printAndAccept(x.getProperties(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(HiveAlterViewSetProperty x) {
        this.print0(this.ucase ? "SET TBLPROPERTIES (" : "set tblproperties (");
        this.printAndAccept(x.getProperties(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableSetLocation x) {
        if (x.getPartition().size() != 0) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print0(") ");
        }
        this.print0(this.ucase ? "SET LOCATION " : "set location ");
        x.getLocation().accept(this);
        return false;
    }

    @Override
    public boolean visit(HiveAlterTableSetSerde x) {
        if (x.getPartition().size() != 0) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print0(") ");
        }
        this.print0(this.ucase ? "SET SERDE " : "set serde ");
        x.getSerdeClassName().accept(this);
        if (!x.getOptions().isEmpty()) {
            this.print0(this.ucase ? " WITH SERDEPROPERTIES (" : " with serdeproperties (");
            this.printAndAccept(x.getOptions(), ", ");
            this.print(')');
        }
        return false;
    }
}

