/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.hive.stmt;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HiveCreateTableStatement
extends SQLCreateTableStatement {
    protected List<SQLExpr> skewedBy = new ArrayList<SQLExpr>();
    protected List<SQLExpr> skewedByOn = new ArrayList<SQLExpr>();
    protected SQLExpr storedBy;
    protected Map<String, SQLObject> serdeProperties = new LinkedHashMap<String, SQLObject>();
    protected SQLExpr metaLifeCycle;
    protected boolean likeQuery = false;
    protected List<SQLAssignItem> mappedBy = new ArrayList<SQLAssignItem>(1);
    protected SQLExpr intoBuckets;
    protected SQLExpr using;
    protected final List<SQLExpr> withSerdeproperties = new ArrayList<SQLExpr>();

    public HiveCreateTableStatement() {
        this.dbType = DbType.hive;
    }

    public HiveCreateTableStatement(DbType dbType) {
        this.dbType = dbType;
    }

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v.visit(this)) {
            this.acceptChild(v);
        }
        v.endVisit(this);
    }

    @Override
    protected void acceptChild(SQLASTVisitor v) {
        super.acceptChild(v);
        this.acceptChild(v, this.skewedBy);
        this.acceptChild(v, this.skewedByOn);
        this.acceptChild(v, this.storedBy);
        for (SQLObject item : this.serdeProperties.values()) {
            this.acceptChild(v, item);
        }
        this.acceptChild(v, this.metaLifeCycle);
        this.acceptChild(v, this.intoBuckets);
    }

    public void cloneTo(HiveCreateTableStatement x) {
        super.cloneTo(x);
        for (SQLExpr sQLExpr : this.skewedBy) {
            x.addSkewedBy(sQLExpr.clone());
        }
        for (SQLExpr sQLExpr : this.skewedByOn) {
            x.addSkewedByOn(sQLExpr.clone());
        }
        x.setStoredBy(x.getStoredBy());
        for (Map.Entry entry : this.serdeProperties.entrySet()) {
            SQLObject entryValue = ((SQLObject)entry.getValue()).clone();
            entryValue.setParent(x);
            x.serdeProperties.put((String)entry.getKey(), entryValue);
        }
        if (this.metaLifeCycle != null) {
            x.setMetaLifeCycle(this.metaLifeCycle.clone());
        }
        x.setLikeQuery(this.likeQuery);
        if (this.mappedBy != null) {
            for (SQLAssignItem sQLAssignItem : this.mappedBy) {
                SQLAssignItem item2 = sQLAssignItem.clone();
                item2.setParent(this);
                x.mappedBy.add(item2);
            }
        }
        if (this.intoBuckets != null) {
            x.intoBuckets = this.intoBuckets.clone();
        }
        if (this.using != null) {
            x.setUsing(this.using.clone());
        }
    }

    @Override
    public HiveCreateTableStatement clone() {
        HiveCreateTableStatement x = new HiveCreateTableStatement();
        this.cloneTo(x);
        return x;
    }

    public List<SQLExpr> getSkewedBy() {
        return this.skewedBy;
    }

    public void addSkewedBy(SQLExpr item) {
        item.setParent(this);
        this.skewedBy.add(item);
    }

    public List<SQLExpr> getSkewedByOn() {
        return this.skewedByOn;
    }

    public void addSkewedByOn(SQLExpr item) {
        item.setParent(this);
        this.skewedByOn.add(item);
    }

    public Map<String, SQLObject> getSerdeProperties() {
        return this.serdeProperties;
    }

    public SQLExpr getMetaLifeCycle() {
        return this.metaLifeCycle;
    }

    public void setMetaLifeCycle(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.metaLifeCycle = x;
    }

    public boolean isLikeQuery() {
        return this.likeQuery;
    }

    public void setLikeQuery(boolean likeQuery) {
        this.likeQuery = likeQuery;
    }

    public List<SQLAssignItem> getMappedBy() {
        return this.mappedBy;
    }

    public SQLExpr getIntoBuckets() {
        return this.intoBuckets;
    }

    public void setIntoBuckets(SQLExpr intoBuckets) {
        this.intoBuckets = intoBuckets;
    }

    public SQLExpr getUsing() {
        return this.using;
    }

    public void setUsing(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.using = x;
    }

    public List<SQLExpr> getWithSerdeproperties() {
        return this.withSerdeproperties;
    }

    public SQLExpr getStoredBy() {
        return this.storedBy;
    }

    public void setStoredBy(SQLExpr storedBy) {
        if (storedBy != null) {
            storedBy.setParent(this);
        }
        this.storedBy = storedBy;
    }
}

