/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.hive.stmt;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateStatement;
import com.alibaba.fastsql.sql.dialect.hive.visitor.HiveASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class HiveCreateFunctionStatement
extends SQLCreateFunctionStatement
implements SQLCreateStatement {
    protected SQLExpr className;
    protected SQLExpr locationn;
    protected List<ResourceItem> resources = new ArrayList<ResourceItem>();
    protected SQLExpr symbol;

    @Override
    public void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof HiveASTVisitor) {
            this.accept0((HiveASTVisitor)visitor);
        } else {
            super.accept0(visitor);
        }
    }

    protected void accept0(HiveASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.name);
            this.acceptChild((SQLASTVisitor)visitor, this.className);
            this.acceptChild((SQLASTVisitor)visitor, this.locationn);
            this.acceptChild((SQLASTVisitor)visitor, this.symbol);
            for (ResourceItem resource : this.resources) {
                this.acceptChild((SQLASTVisitor)visitor, resource.getResource());
            }
        }
        visitor.endVisit(this);
    }

    public SQLExpr getClassName() {
        return this.className;
    }

    public void setClassName(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.className = x;
    }

    public SQLExpr getLocationn() {
        return this.locationn;
    }

    public void setLocationn(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.locationn = x;
    }

    public List<ResourceItem> getResources() {
        return this.resources;
    }

    public void addResources(ResourceType resourceType, SQLExpr resource) {
        if (resource != null) {
            resource.setParent(this);
        }
        ResourceItem resourceItem = new ResourceItem(resourceType, resource);
        this.resources.add(resourceItem);
    }

    public SQLExpr getSymbol() {
        return this.symbol;
    }

    public void setSymbol(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.symbol = x;
    }

    public static class ResourceItem {
        private ResourceType resourceType;
        private SQLExpr resource;

        public ResourceItem(ResourceType resourceType, SQLExpr resource) {
            this.resourceType = resourceType;
            this.resource = resource;
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
        }

        public SQLExpr getResource() {
            return this.resource;
        }

        public void setResource(SQLExpr resource) {
            this.resource = resource;
        }
    }

    public static enum ResourceType {
        JAR,
        FILE,
        ARCHIVE;

    }
}

