/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.hive.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLPartitionBy;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.SQLStatementImpl;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterDatabaseStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableReplaceColumn;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterViewStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLErrorLoggingClause;
import com.alibaba.fastsql.sql.ast.statement.SQLExportTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.fastsql.sql.ast.statement.SQLImportTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLMergeStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSetStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowColumnsStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowDatabasesStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowFunctionsStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowIndexesStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowPartitionsStmt;
import com.alibaba.fastsql.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowViewsStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.fastsql.sql.dialect.hive.ast.ArgodbAlterTableDeleteColumnItem;
import com.alibaba.fastsql.sql.dialect.hive.ast.ArgodbAlterTableDropIndex;
import com.alibaba.fastsql.sql.dialect.hive.ast.ArgodbRebuildIndexStatement;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterTableCompactItem;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterTableSetFileformat;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterTableSetSerde;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterTableSetSerdeproperties;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterTableUnsetProperty;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterViewSetProperty;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveAlterViewUnsetProperty;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveCreateMaterializedViewStatement;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveLockTableStatement;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveMergeUpdateClause;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveShowLocksStatement;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveCreateTableParser;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveExprParser;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveSelectParser;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveCreateFunctionStatement;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveLoadDataStatement;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveReloadStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddFileStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsSetAssignItem;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLCreateTableParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLStatementParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class HiveStatementParser
extends SQLStatementParser {
    public HiveStatementParser(HiveExprParser exprParser) {
        super(exprParser);
        this.dbType = DbType.hive;
    }

    public HiveStatementParser(String sql) {
        super(new HiveExprParser(sql));
        this.dbType = DbType.hive;
    }

    public HiveStatementParser(String sql, SQLParserFeature ... features) {
        super(new HiveExprParser(sql, features));
        this.dbType = DbType.hive;
    }

    public HiveStatementParser(Lexer lexer) {
        super(new HiveExprParser(lexer));
        this.dbType = DbType.hive;
    }

    @Override
    public HiveSelectParser createSQLSelectParser() {
        return new HiveSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new HiveCreateTableParser(this.exprParser);
    }

    @Override
    public SQLStatement parseInsert() {
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            HiveMultiInsertStatement stmt = new HiveMultiInsertStatement();
            if (this.lexer.token() == Token.IDENTIFIER) {
                SQLName tableName = this.exprParser.name();
                SQLExprTableSource from = new SQLExprTableSource(tableName);
                SQLTableSource tableSource = this.createSQLSelectParser().parseTableSourceRest(from);
                stmt.setFrom(tableSource);
                if (this.lexer.token() == Token.IDENTIFIER) {
                    from.setAlias(this.lexer.stringVal());
                    this.lexer.nextToken();
                }
            } else {
                this.accept(Token.LPAREN);
                HiveSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect select = selectParser.select();
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.AS) {
                    this.lexer.nextToken();
                }
                String alias = this.lexer.stringVal();
                this.accept(Token.IDENTIFIER);
                SQLSubqueryTableSource from = new SQLSubqueryTableSource(select, alias);
                stmt.setFrom(from);
            }
            do {
                HiveInsert insert = this.parseHiveInsert();
                stmt.addItem(insert);
            } while (this.lexer.token() == Token.INSERT);
            return stmt;
        }
        return this.parseHiveInsertStmt();
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        SQLStatement stmt;
        int startLine = this.lexer.getPosLine();
        int startCol = this.lexer.getPosColumn();
        if (this.lexer.token() == Token.HINT) {
            List<SQLCommentHint> hints = this.exprParser.parseHints();
            boolean tddlHints = false;
            boolean accept = false;
            boolean acceptHint = false;
            switch (this.lexer.token()) {
                case SELECT: 
                case WITH: 
                case DELETE: 
                case UPDATE: 
                case INSERT: 
                case SHOW: 
                case REPLACE: 
                case TRUNCATE: 
                case DROP: 
                case ALTER: 
                case CREATE: 
                case CHECK: 
                case SET: 
                case DESC: 
                case OPTIMIZE: 
                case ANALYZE: 
                case KILL: 
                case EXPLAIN: 
                case LPAREN: {
                    acceptHint = true;
                }
            }
            if (this.lexer.identifierEquals("MSCK")) {
                acceptHint = true;
            }
            if (acceptHint) {
                SQLStatementImpl stmt2 = (SQLStatementImpl)this.parseStatement();
                stmt2.setHeadHints(hints);
                this.addToStatementList(statementList, stmt2, startLine, startCol);
                return true;
            }
        }
        if (this.lexer.token() == Token.FROM) {
            stmt = this.parseInsert();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOAD)) {
            this.lexer.nextToken();
            this.acceptIdentifier("DATA");
            stmt = new HiveLoadDataStatement();
            if (this.lexer.identifierEquals(FnvHash.Constants.LOCAL)) {
                this.lexer.nextToken();
                ((HiveLoadDataStatement)stmt).setLocal(true);
            }
            this.acceptIdentifier("INPATH");
            SQLExpr inpath = this.exprParser.expr();
            ((HiveLoadDataStatement)stmt).setInpath(inpath);
            if (this.lexer.token() == Token.OVERWRITE) {
                this.lexer.nextToken();
                ((HiveLoadDataStatement)stmt).setOverwrite(true);
            }
            this.accept(Token.INTO);
            this.accept(Token.TABLE);
            SQLExpr table = this.exprParser.expr();
            ((HiveLoadDataStatement)stmt).setInto(table);
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.exprParser.exprList(((HiveLoadDataStatement)stmt).getPartition(), stmt);
                this.accept(Token.RPAREN);
            }
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ANALYZE)) {
            stmt = this.parseAnalyze();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXPORT)) {
            stmt = this.parseExport();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.IMPORT)) {
            stmt = this.parseImport();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("MSCK")) {
            stmt = this.parseMsck();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("ADD")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.JAR)) {
                stmt = new OdpsAddFileStatement();
                long hash = this.lexer.hash_lower();
                if (hash == FnvHash.Constants.JAR) {
                    ((OdpsAddFileStatement)stmt).setType(OdpsAddFileStatement.FileType.JAR);
                }
                this.lexer.nextPath();
                String path = this.lexer.stringVal();
                this.lexer.nextToken();
                ((OdpsAddFileStatement)stmt).setFile(path);
                this.addToStatementList(statementList, stmt, startLine, startCol);
                return true;
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SHOW)) {
            Lexer.SavePoint savePoint = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.VIEWS)) {
                this.lexer.nextToken();
                SQLShowViewsStatement stmt3 = new SQLShowViewsStatement();
                if (this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName db = this.exprParser.name();
                    stmt3.setDatabase(db);
                }
                if (this.lexer.token() == Token.LIKE) {
                    this.lexer.nextToken();
                    SQLExpr pattern = this.exprParser.expr();
                    stmt3.setLike(pattern);
                }
                this.addToStatementList(statementList, stmt3, startLine, startCol);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TABLES)) {
                this.lexer.reset(savePoint);
                SQLShowTablesStatement stmt4 = this.parseShowTables();
                this.addToStatementList(statementList, stmt4, startLine, startCol);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.DATABASES)) {
                this.lexer.nextToken();
                SQLShowDatabasesStatement stmt5 = this.parseShowDatabases(false);
                this.addToStatementList(statementList, stmt5, startLine, startCol);
                return true;
            }
            if (this.lexer.token() == Token.INDEX) {
                this.lexer.nextToken();
                SQLShowIndexesStatement stmt6 = new SQLShowIndexesStatement();
                stmt6.setType("INDEX");
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    SQLName table = this.exprParser.name();
                    stmt6.setTable(table);
                }
                if (this.lexer.token() == Token.HINT) {
                    stmt6.setHints(this.exprParser.parseHints());
                }
                this.addToStatementList(statementList, stmt6, startLine, startCol);
                return true;
            }
            if (this.lexer.token() == Token.CREATE) {
                this.lexer.nextToken();
                this.accept(Token.TABLE);
                SQLShowCreateTableStatement stmt7 = new SQLShowCreateTableStatement();
                stmt7.setDbType(this.dbType);
                stmt7.setName(this.exprParser.name());
                if (this.lexer.token() == Token.LIKE) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals(FnvHash.Constants.MAPPING)) {
                        this.lexer.nextToken();
                        this.accept(Token.LPAREN);
                        SQLName name = this.exprParser.name();
                        stmt7.setLikeMapping(name);
                        this.accept(Token.RPAREN);
                    }
                }
                this.addToStatementList(statementList, stmt7, startLine, startCol);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
                this.lexer.nextToken();
                SQLShowPartitionsStmt stmt8 = new SQLShowPartitionsStmt();
                stmt8.setDbType(this.dbType);
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                }
                SQLExpr expr = this.exprParser.expr();
                stmt8.setTableSource(new SQLExprTableSource(expr));
                if (this.lexer.token() == Token.PARTITION) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(stmt8.getPartition(), stmt8, false);
                    this.accept(Token.RPAREN);
                }
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    stmt8.setWhere(this.exprParser.expr());
                }
                this.addToStatementList(statementList, stmt8, startLine, startCol);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.COLUMNS)) {
                this.lexer.nextToken();
                SQLShowColumnsStatement stmt9 = new SQLShowColumnsStatement();
                if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName table = this.exprParser.name();
                    if (this.lexer.token() == Token.SUB && table instanceof SQLIdentifierExpr) {
                        this.lexer.mark();
                        this.lexer.nextToken();
                        String strVal = this.lexer.stringVal();
                        this.lexer.nextToken();
                        if (table instanceof SQLIdentifierExpr) {
                            SQLIdentifierExpr ident = (SQLIdentifierExpr)table;
                            table = new SQLIdentifierExpr(ident.getName() + "-" + strVal);
                        }
                    }
                    stmt9.setTable(table);
                }
                if (this.lexer.token() == Token.LIKE) {
                    this.lexer.nextToken();
                    SQLExpr like = this.exprParser.expr();
                    stmt9.setLike(like);
                }
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    SQLExpr where = this.exprParser.expr();
                    stmt9.setWhere(where);
                }
                this.addToStatementList(statementList, stmt9, startLine, startCol);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.FUNCTIONS)) {
                this.lexer.nextToken();
                SQLShowFunctionsStatement stmt10 = new SQLShowFunctionsStatement();
                if (this.lexer.token() == Token.LIKE) {
                    this.lexer.nextToken();
                    SQLExpr like = this.exprParser.expr();
                    stmt10.setLike(like);
                }
                this.addToStatementList(statementList, stmt10, startLine, startCol);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.LOCKS)) {
                this.lexer.nextToken();
                HiveShowLocksStatement stmt11 = new HiveShowLocksStatement();
                if (this.lexer.token() != Token.EOF && this.lexer.token() != Token.SEMI) {
                    SQLName table = this.exprParser.name();
                    stmt11.setTable(table);
                }
                this.addToStatementList(statementList, stmt11, startLine, startCol);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
                SQLStatement stmt12 = this.parseShowRangePartition();
                this.addToStatementList(statementList, stmt12, startLine, startCol);
                return true;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.token() == Token.LOCK || this.lexer.identifierEquals(FnvHash.Constants.UNLOCK)) {
            stmt = this.parseLockTable();
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("RELOAD")) {
            this.lexer.nextToken();
            HiveReloadStatement reloadStatement = new HiveReloadStatement(this.dbType);
            if (this.lexer.token() == Token.FUNCTION) {
                reloadStatement.setReloadType(HiveReloadStatement.ReloadTypeEnum.FUNCTION);
            } else if (this.lexer.identifierEquals("FUNCTIONS")) {
                reloadStatement.setReloadType(HiveReloadStatement.ReloadTypeEnum.FUNCTIONS);
            } else {
                throw new ParserException("TODO " + this.lexer.info());
            }
            this.lexer.nextToken();
            this.addToStatementList(statementList, reloadStatement, startLine, startCol);
            return true;
        }
        if (this.lexer.identifierEquals("REBUILD")) {
            this.lexer.nextToken();
            stmt = new ArgodbRebuildIndexStatement();
            this.exprParser.parseIndex(((ArgodbRebuildIndexStatement)stmt).getIndexDefinition());
            this.addToStatementList(statementList, stmt, startLine, startCol);
            return true;
        }
        return false;
    }

    public HiveLockTableStatement parseLockTable() {
        HiveLockTableStatement stmt = new HiveLockTableStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.UNLOCK)) {
            stmt.setUnlock(true);
        }
        this.lexer.nextToken();
        this.accept(Token.TABLE);
        SQLName table = this.exprParser.name();
        stmt.setTable(table);
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(stmt.getPartitions(), stmt, false);
            this.accept(Token.RPAREN);
        }
        if (!stmt.isUnlock()) {
            if (this.lexer.identifierEquals(FnvHash.Constants.SHARED)) {
                stmt.setLockType(HiveLockTableStatement.LockType.SHARED);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.EXCLUSIVE)) {
                stmt.setLockType(HiveLockTableStatement.LockType.EXCLUSIVE);
            } else {
                throw new ParserException("syntax error. " + this.lexer.info());
            }
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        HiveCreateTableParser parser = new HiveCreateTableParser(this.exprParser);
        return parser.parseCreateTable();
    }

    @Override
    public SQLCreateFunctionStatement parseCreateFunction() {
        HiveCreateFunctionStatement stmt = new HiveCreateFunctionStatement();
        stmt.setDbType(this.dbType);
        this.accept(Token.CREATE);
        if (this.lexer.identifierEquals(FnvHash.Constants.TEMPORARY)) {
            this.lexer.nextToken();
            stmt.setTemporary(true);
        }
        this.accept(Token.FUNCTION);
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        if (this.lexer.token() == Token.AS) {
            this.lexer.setToken(Token.IDENTIFIER);
            this.lexer.nextToken();
            SQLExpr className = this.exprParser.expr();
            stmt.setClassName(className);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
            this.lexer.nextToken();
            SQLExpr location = this.exprParser.primary();
            stmt.setLocationn(location);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SYMBOL)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLExpr symbol = this.exprParser.primary();
            stmt.setSymbol(symbol);
        }
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            while (true) {
                HiveCreateFunctionStatement.ResourceType resourceType = null;
                if (this.lexer.identifierEquals(FnvHash.Constants.JAR)) {
                    this.lexer.nextToken();
                    resourceType = HiveCreateFunctionStatement.ResourceType.JAR;
                } else if (this.lexer.identifierEquals(FnvHash.Constants.ARCHIVE)) {
                    this.lexer.nextToken();
                    resourceType = HiveCreateFunctionStatement.ResourceType.ARCHIVE;
                } else if (this.lexer.identifierEquals(FnvHash.Constants.FILE)) {
                    this.lexer.nextToken();
                    resourceType = HiveCreateFunctionStatement.ResourceType.FILE;
                }
                SQLExpr location = this.exprParser.primary();
                stmt.addResources(resourceType, location);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCreateMaterializedView() {
        this.accept(Token.CREATE);
        this.acceptIdentifier("MATERIALIZED");
        this.accept(Token.VIEW);
        HiveCreateMaterializedViewStatement stmt = new HiveCreateMaterializedViewStatement();
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.DISABLE) {
            this.lexer.nextToken();
            this.acceptIdentifier("REWRITE");
            stmt.setDisableRewrite(true);
        }
        if (this.lexer.token() == Token.PARTITION) {
            SQLPartitionBy partitionBy = this.exprParser.parsePartitionBy();
            stmt.setPartitionBy(partitionBy);
        }
        block0: while (true) {
            if (this.lexer.identifierEquals("REFRESH")) {
                this.lexer.nextToken();
                while (true) {
                    if (this.lexer.identifierEquals("FAST")) {
                        this.lexer.nextToken();
                        stmt.setRefreshFast(true);
                        continue;
                    }
                    if (this.lexer.identifierEquals("COMPLETE")) {
                        this.lexer.nextToken();
                        stmt.setRefreshComlete(true);
                        continue;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
                        this.lexer.nextToken();
                        stmt.setRefreshForce(true);
                        continue;
                    }
                    if (this.lexer.token() != Token.ON) continue block0;
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.COMMIT) {
                        this.lexer.nextToken();
                        stmt.setRefreshOnCommit(true);
                        continue;
                    }
                    this.acceptIdentifier("DEMAND");
                    stmt.setRefreshOnDemand(true);
                }
            }
            if (this.lexer.identifierEquals("BUILD")) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("IMMEDIATE") || this.lexer.token() == Token.IMMEDIATE) {
                    this.lexer.nextToken();
                    stmt.setBuildImmediate(true);
                    continue;
                }
                this.accept(Token.DEFERRED);
                stmt.setBuildDeferred(true);
                continue;
            }
            if (this.lexer.identifierEquals("PARALLEL")) {
                this.lexer.nextToken();
                stmt.setParallel(true);
                if (this.lexer.token() != Token.LITERAL_INT) continue;
                stmt.setParallelValue(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.NOCACHE) || this.lexer.token() == Token.NOCACHE) {
                this.lexer.nextToken();
                stmt.setCache(false);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.NOPARALLEL)) {
                this.lexer.nextToken();
                stmt.setParallel(false);
                continue;
            }
            if (this.lexer.token() != Token.WITH) break;
            this.lexer.nextToken();
            this.acceptIdentifier("ROWID");
            stmt.setWithRowId(true);
        }
        if (this.lexer.token() == Token.ENABLE) {
            this.lexer.nextToken();
            this.acceptIdentifier("QUERY");
            this.acceptIdentifier("REWRITE");
            stmt.setEnableQueryRewrite(true);
        }
        this.accept(Token.AS);
        SQLSelect select = this.createSQLSelectParser().select();
        stmt.setQuery(select);
        return stmt;
    }

    @Override
    public SQLCreateIndexStatement parseCreateIndex(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        this.accept(Token.INDEX);
        SQLCreateIndexStatement stmt = new SQLCreateIndexStatement(this.dbType);
        stmt.setName(this.exprParser.name());
        this.accept(Token.ON);
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
        }
        stmt.setTable(this.exprParser.name());
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            item.setParent(stmt);
            stmt.addItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            String indexType = this.lexer.stringVal();
            this.accept(Token.LITERAL_CHARS);
            stmt.setType(indexType);
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("DEFERRED");
            this.acceptIdentifier("REBUILD");
            stmt.setDeferedRebuild(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.IDXPROPERTIES)) {
            this.lexer.nextToken();
            this.exprParser.parseAssignItem(stmt.getProperties(), stmt);
        }
        if (this.lexer.token() == Token.IN) {
            this.lexer.nextToken();
            this.accept(Token.TABLE);
            SQLName inTable = this.exprParser.name();
            stmt.setIn(inTable);
        }
        if (this.lexer.token() == Token.ROW || this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
            SQLExternalRecordFormat format = this.getExprParser().parseRowFormat();
            stmt.setRowFormat(format);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
            this.lexer.nextToken();
            this.accept(Token.AS);
            SQLName name = this.exprParser.name();
            stmt.setStoredAs(name);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
            this.lexer.nextToken();
            this.exprParser.parseAssignItem(stmt.getTableProperties(), stmt);
        }
        return stmt;
    }

    protected SQLStatement parseExport() {
        this.lexer.nextToken();
        this.accept(Token.TABLE);
        SQLExportTableStatement stmt = new SQLExportTableStatement();
        stmt.setTable(new SQLExprTableSource(this.exprParser.name()));
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(stmt.getPartition(), stmt, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            SQLExpr to = this.exprParser.primary();
            stmt.setTo(to);
        }
        return stmt;
    }

    protected SQLStatement parseImport() {
        this.lexer.nextToken();
        SQLImportTableStatement stmt = new SQLImportTableStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.nextToken();
            stmt.setExtenal(true);
        }
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            stmt.setTable(new SQLExprTableSource(this.exprParser.name()));
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(stmt.getPartition(), stmt, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLExpr to = this.exprParser.primary();
            stmt.setFrom(to);
        }
        return stmt;
    }

    @Override
    protected SQLAlterTableItem parseAlterTablePartitionAndItem() {
        Lexer.SavePoint sp = this.lexer.mark();
        this.lexer.nextToken();
        ArrayList partitions = new ArrayList();
        this.accept(Token.LPAREN);
        this.parseAssignItems(partitions, null);
        this.accept(Token.RPAREN);
        if (this.lexer.identifierEquals("COMPACT")) {
            HiveAlterTableCompactItem item = this.parseAlterTableCompact();
            for (SQLAssignItem condition : partitions) {
                item.getPartition().add(condition);
                condition.setParent(item);
            }
            return item;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CHANGE)) {
            SQLAlterTableAlterColumn item = this.parseAlterTableChangeColumn();
            for (SQLAssignItem condition : partitions) {
                item.getPartition().add(condition);
                condition.setParent(item);
            }
            return item;
        }
        if (this.lexer.token() == Token.REPLACE) {
            SQLAlterTableReplaceColumn item = this.parseAlterTableReplaceColumn();
            for (SQLAssignItem condition : partitions) {
                item.getPartition().add(condition);
                condition.setParent(item);
            }
            return item;
        }
        this.lexer.reset(sp);
        return super.parseAlterTablePartitionAndItem();
    }

    @Override
    protected SQLStatement parseAlterDatabase() {
        this.accept(Token.ALTER);
        if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.DATABASE);
        }
        SQLAlterDatabaseStatement stmt = new SQLAlterDatabaseStatement();
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.DBPROPERTIES)) {
                this.lexer.nextToken();
                this.exprParser.parseAssignItem(stmt.getProperties(), stmt);
            } else {
                throw new ParserException("TODO " + this.lexer.info());
            }
        }
        return stmt;
    }

    @Override
    protected SQLStatement parseAlterSchema() {
        return this.parseAlterDatabase();
    }

    @Override
    public SQLStatement parseCreateSchema() {
        return this.parseCreateDatabase();
    }

    @Override
    public HiveExprParser getExprParser() {
        return (HiveExprParser)this.exprParser;
    }

    @Override
    public SQLStatement parseSet() {
        this.accept(Token.SET);
        SQLSetStatement stmt = new SQLSetStatement(this.getDbType());
        this.parseSetAssignItem(stmt.getItems(), stmt);
        return stmt;
    }

    public void parseSetAssignItem(List<? super SQLAssignItem> items, SQLObject parent) {
        this.parseSetAssignItem(items, parent, true);
    }

    public void parseSetAssignItem(List<? super SQLAssignItem> items, SQLObject parent, boolean variant) {
        OdpsSetAssignItem item = new OdpsSetAssignItem();
        Lexer.SavePoint mark = this.lexer.mark();
        SQLExpr var = this.exprParser.primary();
        if (variant && var instanceof SQLIdentifierExpr) {
            var = new SQLVariantRefExpr(((SQLIdentifierExpr)var).getName());
        }
        if (this.lexer.token() != Token.EQ) {
            this.lexer.reset(mark);
            var = this.parseSetAssignTarget();
        }
        item.setTarget(var);
        this.accept(Token.EQ);
        item.setToken(Token.EQ);
        SQLExpr expr = this.parseSetAssignValue();
        if (this.lexer.token() == Token.COMMA) {
            SQLListExpr listExpr = new SQLListExpr();
            listExpr.addItem(expr);
            expr.setParent(listExpr);
            do {
                this.lexer.nextToken();
                SQLExpr listItem = this.parseSetAssignValue();
                listItem.setParent(listExpr);
                listExpr.addItem(listItem);
            } while (this.lexer.token() == Token.COMMA);
            item.setValue(listExpr);
        } else {
            item.setValue(expr);
        }
        items.add(item);
    }

    private void parseMergeUpdateSet(SQLMergeStatement.MergeUpdateClause updateClause) {
        while (true) {
            SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
            updateClause.addItem(item);
            item.setParent(updateClause);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    @Override
    public SQLStatement parseMerge() {
        this.accept(Token.MERGE);
        SQLMergeStatement stmt = new SQLMergeStatement();
        stmt.setDbType(this.dbType);
        this.accept(Token.INTO);
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
        }
        stmt.setInto(this.exprParser.name());
        stmt.getInto().setAlias(this.tableAlias());
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLAssignItem ptExpr = new SQLAssignItem();
                ptExpr.setTarget(this.exprParser.name());
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextTokenValue();
                    SQLExpr ptValue = this.exprParser.expr();
                    ptExpr.setValue(ptValue);
                }
                stmt.addPartition(ptExpr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        this.accept(Token.USING);
        SQLTableSource using = this.createSQLSelectParser().parseTableSource();
        stmt.setUsing(using);
        this.accept(Token.ON);
        stmt.setOn(this.exprParser.expr());
        boolean insertFlag = false;
        if (this.lexer.token() == Token.WHEN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.MATCHED) {
                HiveMergeUpdateClause updateClause = new HiveMergeUpdateClause();
                this.lexer.nextToken();
                SQLExpr firstWhere = null;
                if (this.lexer.token() == Token.AND) {
                    this.lexer.nextToken();
                    firstWhere = this.exprParser.expr();
                }
                this.accept(Token.THEN);
                if (this.lexer.token() == Token.UPDATE) {
                    this.accept(Token.UPDATE);
                    this.accept(Token.SET);
                    this.parseMergeUpdateSet(updateClause);
                    updateClause.setWhere(firstWhere);
                    SQLExpr deleteWhere = null;
                    if (this.lexer.token() == Token.WHEN) {
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.MATCHED) {
                            this.lexer.nextToken();
                            if (this.lexer.token() == Token.AND) {
                                this.lexer.nextToken();
                                deleteWhere = this.exprParser.expr();
                            }
                            this.accept(Token.THEN);
                            this.accept(Token.DELETE);
                            updateClause.setDeleteWhere(deleteWhere);
                            updateClause.setHasDelete(true);
                        }
                    }
                } else {
                    this.accept(Token.DELETE);
                    updateClause.setHasDelete(true);
                    updateClause.setDeleteWhere(firstWhere);
                    updateClause.setDeleteFirst(true);
                    SQLExpr updateWhere = null;
                    if (this.lexer.token() == Token.WHEN) {
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.MATCHED) {
                            this.lexer.nextToken();
                            if (this.lexer.token() == Token.AND) {
                                this.lexer.nextToken();
                                updateWhere = this.exprParser.expr();
                            }
                            this.accept(Token.THEN);
                            this.accept(Token.UPDATE);
                            this.accept(Token.SET);
                            this.parseMergeUpdateSet(updateClause);
                            updateClause.setWhere(updateWhere);
                        }
                    }
                }
                stmt.setUpdateClause(updateClause);
            } else if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                insertFlag = true;
            }
        }
        if (!insertFlag) {
            if (this.lexer.token() == Token.WHEN) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                insertFlag = true;
            }
        }
        if (insertFlag) {
            SQLMergeStatement.MergeInsertClause insertClause = new SQLMergeStatement.MergeInsertClause();
            this.accept(Token.MATCHED);
            if (this.lexer.token() == Token.AND) {
                this.lexer.nextToken();
                insertClause.setWhere(this.exprParser.expr());
            }
            this.accept(Token.THEN);
            this.accept(Token.INSERT);
            if (this.lexer.token() == Token.LPAREN) {
                this.accept(Token.LPAREN);
                this.exprParser.exprList(insertClause.getColumns(), insertClause);
                this.accept(Token.RPAREN);
            }
            this.accept(Token.VALUES);
            this.accept(Token.LPAREN);
            this.exprParser.exprList(insertClause.getValues(), insertClause);
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                insertClause.setWhere(this.exprParser.expr());
            }
            stmt.setInsertClause(insertClause);
        }
        SQLErrorLoggingClause errorClause = this.parseErrorLoggingClause();
        stmt.setErrorLoggingClause(errorClause);
        return stmt;
    }

    @Override
    public void parseAlterDrop(SQLAlterTableStatement stmt) {
        Lexer.SavePoint savePoint = this.lexer.mark();
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.GLOBAL)) {
            ArgodbAlterTableDropIndex item = new ArgodbAlterTableDropIndex();
            this.exprParser.parseIndex(item.getIndexDefinition());
            stmt.addItem(item);
        } else {
            this.lexer.reset(savePoint);
            super.parseAlterDrop(stmt);
        }
    }

    @Override
    protected SQLAlterTableItem parseDialectAlterItem() {
        if (this.lexer.token() == Token.DELETE) {
            ArgodbAlterTableDeleteColumnItem item = new ArgodbAlterTableDeleteColumnItem();
            this.lexer.nextToken();
            this.acceptIdentifier(Token.COLUMNS.name);
            this.accept(Token.LPAREN);
            while (true) {
                SQLName column = this.exprParser.name();
                item.addColumn(column);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            return item;
        }
        if (this.lexer.identifierEquals("COMPACT")) {
            return this.parseAlterTableCompact();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.UNSET)) {
            this.lexer.nextToken();
            this.acceptIdentifier("TBLPROPERTIES");
            HiveAlterTableUnsetProperty unsetProperty = new HiveAlterTableUnsetProperty();
            if (this.lexer.token() == Token.IF) {
                this.lexer.nextToken();
                this.accept(Token.EXISTS);
            }
            this.accept(Token.LPAREN);
            while (true) {
                unsetProperty.addProperty(this.exprParser.charExpr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            return unsetProperty;
        }
        return null;
    }

    public HiveAlterTableCompactItem parseAlterTableCompact() {
        this.lexer.nextToken();
        HiveAlterTableCompactItem item = new HiveAlterTableCompactItem();
        if (this.lexer.token() == Token.LITERAL_ALIAS && HiveAlterTableCompactItem.CompactTypeEnum.contains(this.lexer.stringVal())) {
            item.setCompactType(HiveAlterTableCompactItem.CompactTypeEnum.parse(this.lexer.stringVal()));
            this.lexer.nextToken();
        } else {
            item.setCompactExpr(this.exprParser.charExpr());
        }
        if (this.lexer.token() == Token.AND) {
            this.lexer.nextToken();
            this.acceptIdentifier("WAIT");
            item.setAndWait(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED)) {
            this.lexer.nextToken();
            this.accept(Token.INTO);
            if (this.lexer.token() != Token.LITERAL_INT) {
                throw new ParserException("into buckets must be integer. " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
            }
            item.setBuckets(this.lexer.integerValue().intValue());
            this.lexer.nextToken();
            this.acceptIdentifier("BUCKETS");
        }
        if (this.lexer.token() == Token.ORDER) {
            item.setOrderBy(this.exprParser.parseOrderBy());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.POOL)) {
            this.lexer.nextToken();
            item.setPoolName(this.exprParser.charExpr());
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.accept(Token.OVERWRITE);
            this.acceptIdentifier("TBLPROPERTIES");
            this.accept(Token.LPAREN);
            this.parseAssignItems(item.getOverwriteProperties(), item);
            this.accept(Token.RPAREN);
        }
        return item;
    }

    @Override
    public SQLDeleteStatement parseDeleteStatement() {
        SQLDeleteStatement deleteStatement = new SQLDeleteStatement(this.getDbType());
        if (this.lexer.token() == Token.DELETE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            SQLName tableName = this.exprParser.name();
            deleteStatement.setTableName(tableName);
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                SQLTableSource tableSource = this.createSQLSelectParser().parseTableSource();
                deleteStatement.setFrom(tableSource);
            }
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                while (true) {
                    SQLAssignItem ptExpr = new SQLAssignItem();
                    ptExpr.setTarget(this.exprParser.name());
                    if (this.lexer.token() == Token.EQ) {
                        this.lexer.nextTokenValue();
                        SQLExpr ptValue = this.exprParser.expr();
                        ptExpr.setValue(ptValue);
                    }
                    deleteStatement.addPartition(ptExpr);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            deleteStatement.setWhere(where);
        }
        return deleteStatement;
    }

    @Override
    protected SQLAlterTableItem parseAlterTableSetItem() {
        SQLObjectImpl alterTableItem;
        Lexer.SavePoint sp = this.lexer.mark();
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.SERDEPROPERTIES)) {
            this.lexer.nextToken();
            HiveAlterTableSetSerdeproperties setOption = new HiveAlterTableSetSerdeproperties();
            this.accept(Token.LPAREN);
            while (true) {
                SQLAssignItem item = this.exprParser.parseAssignItem();
                setOption.addOption(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            alterTableItem = setOption;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.FILEFORMAT)) {
            this.lexer.nextToken();
            HiveAlterTableSetFileformat setFileformat = new HiveAlterTableSetFileformat();
            SQLExpr expr = this.exprParser.expr();
            setFileformat.setFileFormat(expr);
            alterTableItem = setFileformat;
        } else {
            if (this.lexer.identifierEquals(FnvHash.Constants.SERDE)) {
                this.lexer.nextToken();
                HiveAlterTableSetSerde setSerde = new HiveAlterTableSetSerde();
                setSerde.setSerdeClassName(this.exprParser.expr());
                if (this.lexer.token() == Token.WITH) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("SERDEPROPERTIES");
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(setSerde.getOptions(), setSerde);
                    this.accept(Token.RPAREN);
                }
                return setSerde;
            }
            this.lexer.reset(sp);
            return super.parseAlterTableSetItem();
        }
        return alterTableItem;
    }

    protected SQLStatement parseShowRangePartition() {
        throw new ParserException("syntax error, " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal() + ", pos " + this.lexer.pos());
    }

    @Override
    protected SQLAlterTableAlterColumn parseAlterTableChangeColumn() {
        SQLAlterTableAlterColumn alterColumn = super.parseAlterTableChangeColumn();
        if (this.lexer.identifierEquals(FnvHash.Constants.FIRST)) {
            this.lexer.nextToken();
            SQLName first = this.exprParser.name();
            alterColumn.setFirst(first);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RESTRICT)) {
            this.lexer.nextToken();
            alterColumn.setCascadeType(SQLAlterTableAlterColumn.CascadeType.RESTRICT);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.CASCADE)) {
            this.lexer.nextToken();
            alterColumn.setCascadeType(SQLAlterTableAlterColumn.CascadeType.CASCADE);
        }
        return alterColumn;
    }

    @Override
    protected SQLStatement parseAlterView() {
        Lexer.SavePoint sp = this.lexer.mark();
        this.lexer.nextToken();
        SQLName viewName = this.exprParser.name();
        SQLExprTableSource exprTableSource = new SQLExprTableSource(viewName);
        SQLAlterViewStatement alterViewStatement = new SQLAlterViewStatement(this.dbType);
        alterViewStatement.setTableSource(exprTableSource);
        if (this.lexer.identifierEquals(FnvHash.Constants.UNSET)) {
            this.lexer.nextToken();
            this.acceptIdentifier("TBLPROPERTIES");
            HiveAlterViewUnsetProperty unsetProperty = new HiveAlterViewUnsetProperty();
            if (this.lexer.token() == Token.IF) {
                this.lexer.nextToken();
                this.accept(Token.EXISTS);
            }
            this.accept(Token.LPAREN);
            while (true) {
                unsetProperty.addProperty(this.exprParser.charExpr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            alterViewStatement.setAlterViewItem(unsetProperty);
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            this.acceptIdentifier("TBLPROPERTIES");
            HiveAlterViewSetProperty setProperty = new HiveAlterViewSetProperty();
            this.accept(Token.LPAREN);
            this.parseAssignItems(setProperty.getProperties(), setProperty, false);
            this.accept(Token.RPAREN);
            alterViewStatement.setAlterViewItem(setProperty);
        } else if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            HiveSelectParser selectParser = this.createSQLSelectParser();
            SQLSelect select = selectParser.select();
            alterViewStatement.setSubQuery(select);
        } else {
            this.lexer.reset(sp);
            return super.parseAlterView();
        }
        return alterViewStatement;
    }
}

