/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.hive.ast;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLStatementImpl;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.dialect.hive.visitor.HiveASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class HiveLockTableStatement
extends SQLStatementImpl {
    private boolean unlock = false;
    private SQLName table;
    private List<SQLAssignItem> partitions = new ArrayList<SQLAssignItem>();
    private LockType lockType;

    public HiveLockTableStatement() {
        this.setDbType(DbType.hive);
    }

    public LockType getLockType() {
        return this.lockType;
    }

    public void setLockType(LockType lockType) {
        this.lockType = lockType;
    }

    public boolean isUnlock() {
        return this.unlock;
    }

    public void setUnlock(boolean unlock) {
        this.unlock = unlock;
    }

    public SQLName getTable() {
        return this.table;
    }

    public void setTable(SQLName table) {
        if (table != null) {
            table.setParent(this);
        }
        this.table = table;
    }

    public void addPartition(SQLAssignItem partition) {
        if (partition != null) {
            partition.setParent(this);
        }
        if (this.partitions == null) {
            this.partitions = new ArrayList<SQLAssignItem>();
        }
        this.partitions.add(partition);
    }

    public List<SQLAssignItem> getPartitions() {
        return this.partitions;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof HiveASTVisitor) {
            this.accept0((HiveASTVisitor)visitor);
        } else {
            this.acceptChild(visitor, this.table);
            this.acceptChild(visitor, this.partitions);
        }
    }

    public void accept0(HiveASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.table);
            this.acceptChild((SQLASTVisitor)visitor, this.partitions);
        }
        visitor.endVisit(this);
    }

    public static enum LockType {
        SHARED,
        EXCLUSIVE;

    }
}

