/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.greenplum.visitor;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLOrderingSpecification;
import com.alibaba.fastsql.sql.ast.SQLParameter;
import com.alibaba.fastsql.sql.ast.SQLPartitionBy;
import com.alibaba.fastsql.sql.ast.SQLSubPartition;
import com.alibaba.fastsql.sql.ast.SQLSubPartitionByList;
import com.alibaba.fastsql.sql.ast.SQLSubPartitionByRange;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterDatabaseStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableAddPartition;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExplainStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.expr.GreenplumColonExpr;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.expr.GreenplumDistinctFromExpr;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.expr.GreenplumEmptyExpr;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.expr.GreenplumPartitionElementExpr;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.expr.GreenplumSubpartitionElementExpr;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterDatabaseOnwerItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterDatabaseRenameItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterDatabaseResetItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterDatabaseSetItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterDatabaseWithItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterSchemaStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterSequenceStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableAddPartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableAlterPartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableAlterPartitionAction;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableDropPartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableExchangePartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableRenamePartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSet;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSetDistribute;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSetItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSetSchema;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSetSubparition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSetWithOption;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSplitPartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableTruncatePartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterViewAlterColumnItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterViewStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumCheckPointStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumClusterStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumColumnDefinition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumColumnEncodingConstraint;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumCommitStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumCreateRoleStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumCreateSchemaStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumCreateSequenceStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDataTypeInterval;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDeallocateStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDeclareStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDropIndexStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDropRoleStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDropSchemaStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDropSequenceStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumEndTransactionStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumExecuteStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumFetchStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumLoadStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumLockStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumMoveStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumPartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumPartitionBy;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumPartitionRangeValue;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumPrepareStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumReassignOwnedStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumReindexStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumRollbackStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumSelectStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumSetExtStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumSetTransactionStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumShowStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumStartTransactionStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumSubPartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumVacuumStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.visitor.GreenplumASTVisitor;
import com.alibaba.fastsql.sql.dialect.postgresql.visitor.PGOutputVisitor;
import java.util.List;
import org.apache.commons.math3.util.Pair;

public class GreenplumOutputVisitor
extends PGOutputVisitor
implements GreenplumASTVisitor {
    public GreenplumOutputVisitor(Appendable appender) {
        super(appender);
        this.dbType = DbType.greenplum;
    }

    public GreenplumOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.greenplum;
    }

    @Override
    public boolean visit(SQLExplainStatement x) {
        List<SQLCommentHint> headHints = x.getHeadHintsDirect();
        if (headHints != null) {
            for (SQLCommentHint hint : headHints) {
                this.visit(hint);
                this.println();
            }
        }
        return super.visit(x);
    }

    @Override
    public void endVisit(GreenplumSelectQueryBlock x) {
    }

    @Override
    public boolean visit(GreenplumSelectQueryBlock x) {
        super.visit(x);
        return false;
    }

    @Override
    public void endVisit(GreenplumSelectStatement x) {
    }

    @Override
    public boolean visit(GreenplumSelectStatement x) {
        return true;
    }

    @Override
    public boolean visit(SQLAlterDatabaseStatement x) {
        this.print0(this.ucase ? "ALTER DATABASE " : "alter database ");
        x.getName().accept(this);
        this.print0(" ");
        if (x.getItem() != null) {
            x.getItem().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(GreenplumColonExpr x) {
        x.getFrom().accept(this);
        this.print0(":");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumColonExpr x) {
    }

    @Override
    public boolean visit(GreenplumDistinctFromExpr x) {
        this.print0(this.ucase ? "IS " : "is ");
        if (x.isNot()) {
            this.print0(this.ucase ? "NOT " : "not ");
        }
        this.print0(this.ucase ? "DISTINCT " : "distinct ");
        this.print0(this.ucase ? "FROM " : "from ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumDistinctFromExpr x) {
    }

    @Override
    public boolean visit(GreenplumCreateTableStatement x) {
        this.printCreateTable(x, true);
        this.printAs(x);
        return false;
    }

    @Override
    public void endVisit(GreenplumCreateTableStatement x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableSet x) {
        this.print0(this.ucase ? "SET " : "set ");
        for (GreenplumAlterTableSetItem itm : x.getSetItems()) {
            itm.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableSet x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableSetDistribute x) {
        this.print0(this.ucase ? "DISTRIBUTED " : "distributed ");
        if (x.isRandom()) {
            this.print0(this.ucase ? "RANDOMLY " : "randomly ");
        } else {
            this.print0(this.ucase ? "BY (" : "by (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print0(") ");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableSetDistribute x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableSetWithOption x) {
        this.print0(this.ucase ? "WITH (" : "with (");
        this.printAndAccept(x.getOptions(), ", ");
        this.print0(") ");
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableSetWithOption x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableSetSchema x) {
        this.print0(this.ucase ? "SCHEMA " : "schema ");
        x.getNewSchema().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableSetSchema x) {
    }

    @Override
    public boolean visit(SQLAlterTableAddPartition x) {
        if (x instanceof GreenplumAlterTableAddPartition) {
            return this.visit((GreenplumAlterTableAddPartition)x);
        }
        return super.visit(x);
    }

    @Override
    public void endVisit(SQLAlterTableAddPartition x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableAddPartition x) {
        this.print0(this.ucase ? "ADD " : "add ");
        if (x.isDefault()) {
            this.print0(this.ucase ? "DEFAULT " : "default ");
        }
        this.print0(this.ucase ? "PARTITION " : "partition ");
        if (x.getForRank() != null) {
            this.print0(this.ucase ? " FOR (" : "for (");
            x.getForRank().accept(this);
            this.print0(")");
        }
        if (x.isHasIf()) {
            this.print0(x.isPartitionExists() ? "IF NOT EXISTS " : "if not exists ");
        }
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        if (x.getPartitionName() != null) {
            x.getPartitionName().accept(this);
            this.print0(" ");
        }
        if (x.getPartititonElememt() != null) {
            x.getPartititonElememt().accept(this);
        }
        if (x.getSubpartitionSpec() != null) {
            if (x.getPartititonElememt() != null) {
                this.print0(" (");
            } else {
                this.print0(" ");
            }
            this.printlnAndAccept(x.getSubpartitionSpec(), ", ");
            if (x.getPartititonElememt() != null) {
                this.print0(" )");
            }
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableAddPartition x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableAlterPartition x) {
        boolean alter;
        boolean bl = alter = x.getPartitionName() != null || x.getForRank() != null || x.getForValue() != null;
        if (alter) {
            this.print0(this.ucase ? "ALTER PARTITION " : "alter partition ");
        }
        if (x.getPartitionName() != null) {
            x.getPartitionName().accept(this);
            this.print0(" ");
        }
        if (x.getForRank() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForRank().accept(this);
            this.print0(") ");
        }
        if (x.getForValue() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForValue().accept(this);
            this.print0(") ");
        }
        this.printAndAccept(x.getPartitionActions(), ", ");
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableAlterPartition x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableAlterPartitionAction x) {
        this.print0(this.ucase ? "ALTER " : "alter ");
        if (x.isDefault()) {
            this.print0(this.ucase ? "DEFAULT " : "default ");
        }
        this.print0(this.ucase ? "PARTITON " : "partition ");
        if (x.getForValue() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForValue().accept(this);
            this.print0(")");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableAlterPartitionAction x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableDropPartition x) {
        this.print0(this.ucase ? "DROP " : "drop ");
        if (x.isDefault()) {
            this.print0(this.ucase ? "DEFAULT " : "default ");
        }
        this.print0(this.ucase ? "PARTITION " : "partition ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        if (x.getPartitionName() != null) {
            x.getPartitionName().accept(this);
        }
        if (x.getForRank() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForRank().accept(this);
            this.print0(")");
        }
        if (x.getForValue() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForValue().accept(this);
            this.print0(")");
        }
        if (x.isCascade()) {
            this.print0(this.ucase ? "CASCADE " : "cascade");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableDropPartition x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableTruncatePartition x) {
        this.print0(this.ucase ? "TRUNCATE " : "truncate ");
        if (x.isDefault()) {
            this.print0(this.ucase ? "DEFAULT " : "default ");
        }
        this.print0(this.ucase ? "PARTITION " : "partition ");
        if (x.getPartitionName() != null) {
            x.getPartitionName().accept(this);
        }
        if (x.getForRank() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForRank().accept(this);
            this.print0(")");
        }
        if (x.getForValue() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForValue().accept(this);
            this.print0(")");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableTruncatePartition x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableRenamePartition x) {
        this.print0(this.ucase ? "RENAME " : "rename ");
        if (x.isDefault()) {
            this.print0(this.ucase ? "DEFAULT " : "default ");
        }
        this.print0(this.ucase ? "PARTITION " : "partition ");
        if (x.getPartitionName() != null) {
            x.getPartitionName().accept(this);
        }
        if (x.getForRank() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForRank().accept(this);
            this.print0(")");
        }
        if (x.getForValue() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForValue().accept(this);
            this.print0(")");
        }
        this.print0(this.ucase ? " TO " : " to ");
        x.getTargetPartitionName().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableRenamePartition x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableExchangePartition x) {
        this.print0(this.ucase ? "EXCHANGE " : "exchange ");
        if (x.isDefault()) {
            this.print0(this.ucase ? "DEFAULT " : "default ");
        }
        this.print0(this.ucase ? "PARTITION " : "partition ");
        if (x.getPartitionName() != null) {
            x.getPartitionName().accept(this);
        }
        if (x.getForRank() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForRank().accept(this);
            this.print0(")");
        }
        if (x.getForValue() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForValue().accept(this);
            this.print0(")");
        }
        this.print0(this.ucase ? " WITH TABLE " : " with table ");
        x.getWithTable().accept(this);
        if (x.isWithValidation()) {
            this.print0(this.ucase ? " WITH VALIDATION " : " with validation ");
        }
        if (x.isWithNotValidation()) {
            this.print0(this.ucase ? " WITHOUT VALIDATION " : " without validation ");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableExchangePartition x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableSetSubparition x) {
        this.print0(this.ucase ? "SET SUBPARTITION TEMPLATE (" : "set subpartition template (");
        if (x.getSubpartitions() != null) {
            this.printlnAndAccept(x.getSubpartitions(), ", ");
        }
        this.print0(")");
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableSetSubparition x) {
    }

    @Override
    public boolean visit(GreenplumAlterTableSplitPartition x) {
        this.print0(this.ucase ? "SPLIT " : "split ");
        if (x.isDefault()) {
            this.print0(this.ucase ? "DEFAULT " : "default ");
        }
        this.print0(this.ucase ? "PARTITION " : "partition ");
        if (x.getPartitionName() != null) {
            x.getPartitionName().accept(this);
        }
        if (x.getForRank() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForRank().accept(this);
            this.print0(")");
        }
        if (x.getForValue() != null) {
            this.print0(this.ucase ? "FOR (" : "for (");
            x.getForValue().accept(this);
            this.print0(")");
        }
        if (x.getAtValue() != null) {
            this.print0(this.ucase ? " AT " : " at ");
            if (x.getAtValue() instanceof SQLListExpr) {
                x.getAtValue().accept(this);
            } else {
                this.print0("(");
                x.getAtValue().accept(this);
                this.print0(")");
            }
        }
        if (x.getStartValue() != null) {
            this.print0(this.ucase ? "START (" : "start (");
            if (x.getStartValue() != null) {
                this.printExpr(x.getStartValue());
            }
            this.print0(") ");
            if (x.isStartInclusive()) {
                this.print0(this.ucase ? "INCLUSIVE " : "inclusive ");
            }
            if (x.isStartExclusive()) {
                this.print0(this.ucase ? "EXCLUSIVE " : "exclusive ");
            }
            this.println();
        }
        if (x.getEndValue() != null) {
            this.print0(this.ucase ? "END (" : "end (");
            if (x.getEndValue() != null) {
                this.printExpr(x.getEndValue());
            }
            this.print0(") ");
            if (x.isEndInclusive()) {
                this.print0(this.ucase ? "INCLUSIVE " : "inclusive ");
            }
            if (x.isEndExclusive()) {
                this.print0(this.ucase ? "EXCLUSIVE " : "exclusive ");
            }
            this.println();
        }
        if (x.getIntoPartitionNames() != null && x.getIntoPartitionNames().size() == 2) {
            this.print0(this.ucase ? " INTO (" : " into (");
            this.print0(this.ucase ? "PARTITION " : "partition ");
            x.getIntoPartitionNames().get(0).accept(this);
            this.print0(", ");
            this.print0(this.ucase ? "PARTITION " : "partition ");
            x.getIntoPartitionNames().get(1).accept(this);
            this.print0(")");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterTableSplitPartition x) {
    }

    @Override
    public boolean visit(GreenplumEmptyExpr x) {
        return false;
    }

    @Override
    public void endVisit(GreenplumEmptyExpr x) {
    }

    @Override
    public boolean visit(GreenplumDropSchemaStatement x) {
        this.print0(this.ucase ? "DROP " : "drop ");
        this.print0(this.ucase ? "SCHEMA " : "schema ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.printAndAccept(x.getSchemas(), ", ");
        if (x.isCascade()) {
            this.printCascade();
        }
        if (x.isRestrict()) {
            this.print0(this.ucase ? " RESTRICT" : " restrict");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumDropSchemaStatement x) {
    }

    @Override
    public boolean visit(GreenplumDropSequenceStatement x) {
        this.print0(this.ucase ? "DROP " : "drop ");
        this.print0(this.ucase ? "SEQUENCE " : "sequence ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.printAndAccept(x.getSequences(), ", ");
        if (x.isCascade()) {
            this.printCascade();
        }
        if (x.isRestrict()) {
            this.print0(this.ucase ? " RESTRICT" : " restrict");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumDropSequenceStatement x) {
    }

    @Override
    public boolean visit(GreenplumDropIndexStatement x) {
        this.print0(this.ucase ? "DROP " : "drop ");
        this.print0(this.ucase ? "INDEX " : "index ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.printAndAccept(x.getIndexes(), ", ");
        if (x.isCascade()) {
            this.printCascade();
        }
        if (x.isRestrict()) {
            this.print0(this.ucase ? " RESTRICT" : " restrict");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumDropIndexStatement x) {
    }

    @Override
    public boolean visit(GreenplumDropRoleStatement x) {
        this.print0(this.ucase ? "DROP " : "drop ");
        this.print0(this.ucase ? "Role " : "role ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.printAndAccept(x.getRoles(), ", ");
        return false;
    }

    @Override
    public void endVisit(GreenplumDropRoleStatement x) {
    }

    @Override
    public boolean visit(GreenplumStartTransactionStatement x) {
        this.print0(this.ucase ? "BEGIN " : "begin ");
        if (x.isWork()) {
            this.print0(this.ucase ? "WORK " : "work ");
        } else if (x.isTransaction()) {
            this.print0(this.ucase ? "TRANSACTION " : "transaction ");
        }
        if (x.getIsolationLevel() != null) {
            this.print0(this.ucase ? "ISOLATION LEVEL " : "isolation level ");
            String text = x.getIsolationLevel().getText();
            this.print0(this.ucase ? text.toUpperCase() : text.toLowerCase());
            this.print(" ");
        }
        if (x.isReadOnly()) {
            this.print0(this.ucase ? "READ ONLY " : "read only ");
        } else if (x.isWriteOnly()) {
            this.print0(this.ucase ? "WRITE ONLY " : "write only ");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumStartTransactionStatement x) {
    }

    @Override
    public boolean visit(GreenplumCheckPointStatement x) {
        this.print0(this.ucase ? "CHECKPOINT " : "checkpoint ");
        return false;
    }

    @Override
    public void endVisit(GreenplumCheckPointStatement x) {
    }

    @Override
    public boolean visit(GreenplumClusterStatement x) {
        this.print0(this.ucase ? "CLUSTER " : "cluster ");
        if (x.getIndexName() != null) {
            x.getIndexName().accept(this);
            this.print0(this.ucase ? " ON " : " on ");
        }
        if (x.getTableName() != null) {
            x.getTableName().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumClusterStatement x) {
    }

    @Override
    public boolean visit(GreenplumAlterDatabaseOnwerItem x) {
        this.print0(this.ucase ? "ONWER TO " : "onwer to ");
        x.getOnwerTo().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterDatabaseOnwerItem x) {
    }

    @Override
    public boolean visit(GreenplumAlterDatabaseRenameItem x) {
        this.print0(this.ucase ? "RENAME TO " : "rename to ");
        x.getNewName().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterDatabaseRenameItem x) {
    }

    @Override
    public boolean visit(GreenplumAlterDatabaseResetItem x) {
        this.print0(this.ucase ? "RESET " : "reset ");
        x.getReset().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterDatabaseResetItem x) {
    }

    @Override
    public boolean visit(GreenplumAlterDatabaseSetItem x) {
        this.print0(this.ucase ? "SET " : "set ");
        x.getSqlAssignItem().getTarget().accept(this);
        if (x.isTo()) {
            this.print0(this.ucase ? " TO " : " to ");
        }
        if (x.isEq()) {
            this.print0(" = ");
        }
        if (x.getSqlAssignItem().getValue() != null) {
            x.getSqlAssignItem().getValue().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterDatabaseSetItem x) {
    }

    @Override
    public boolean visit(GreenplumAlterDatabaseWithItem x) {
        this.print0(this.ucase ? "WITH CONNECTION LIMIT " : "set connection limit ");
        x.getConnlimit().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterDatabaseWithItem x) {
    }

    @Override
    public boolean visit(GreenplumAlterSchemaStatement x) {
        this.print0(this.ucase ? "ALTER SCHEMA " : "alter schema ");
        x.getName().accept(this);
        this.print0(" ");
        if (x.getNewName() != null) {
            this.print0(this.ucase ? "RENAME TO " : "rename to ");
            x.getNewName().accept(this);
        }
        if (x.getNewOwner() != null) {
            this.print0(this.ucase ? "OWNER TO " : "owner to ");
            x.getNewOwner().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterSchemaStatement x) {
    }

    @Override
    public boolean visit(GreenplumAlterViewStatement x) {
        this.print0(this.ucase ? "ALTER VIEW " : "alter view ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getName().accept(this);
        this.print0(" ");
        if (x.getAlterViewActionItem() != null) {
            x.getAlterViewActionItem().accept(this);
        }
        if (x.getOwnerTo() != null) {
            this.print(this.ucase ? "OWNER TO " : "owner to ");
            x.getOwnerTo().accept(this);
            this.print0(" ");
        }
        if (x.getRenameTo() != null) {
            this.print(this.ucase ? "RENAME TO " : "rename to ");
            x.getRenameTo().accept(this);
            this.print0(" ");
        }
        if (x.getSetSchema() != null) {
            this.print(this.ucase ? "SET SCHEMA " : "set schema ");
            x.getSetSchema().accept(this);
            this.print0(" ");
        }
        if (x.getSetOptions() != null) {
            this.print(this.ucase ? "SET ( " : "set (");
            this.printAndAccept(x.getSetOptions(), ", ");
            this.print(") ");
        }
        if (x.getResetOption() != null) {
            this.print(this.ucase ? "RESET " : "reset ");
            x.getResetOption().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterViewStatement x) {
    }

    @Override
    public boolean visit(GreenplumAlterSequenceStatement x) {
        this.print0(this.ucase ? "ALTER SEQUENCE " : "alter sequence ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getName().accept(this);
        this.print0(" ");
        if (x.getIncrement() != null) {
            this.print0(this.ucase ? "INCREMENT " : "increment ");
            if (x.isIncrementBy()) {
                this.print0(this.ucase ? "BY " : "by ");
            }
            x.getIncrement().accept(this);
            this.print0(" ");
        }
        if (x.getMinValue() != null) {
            this.print0(this.ucase ? "MINVALUE " : "minvalue ");
            x.getMinValue().accept(this);
            this.print0(" ");
        }
        if (x.getMaxValue() != null) {
            this.print0(this.ucase ? "MAXVALUE " : "maxvalue ");
            x.getMaxValue().accept(this);
            this.print0(" ");
        }
        if (x.isNoMinVaLue()) {
            this.print0(this.ucase ? "NO MINVALUE " : "no minvalue ");
        }
        if (x.isNoMaxVaLue()) {
            this.print0(this.ucase ? "NO MAXVALUE " : "no maxvalue ");
        }
        if (x.getStartValue() != null) {
            this.print0(this.ucase ? "START " : "start ");
            if (x.isStartWith()) {
                this.print0(this.ucase ? "WITH " : "with ");
            }
            x.getStartValue().accept(this);
            this.print0(" ");
        }
        if (x.getRestartValue() != null) {
            this.print0(this.ucase ? "RESTART " : "restart ");
            if (x.isRestartWith()) {
                this.print0(this.ucase ? "WITH " : "with ");
            }
            x.getRestartValue().accept(this);
            this.print0(" ");
        }
        if (x.getCache() != null) {
            this.print0(this.ucase ? "CACHE " : "cache ");
            x.getCache().accept(this);
            this.print0(" ");
        }
        if (x.isUseCycle()) {
            if (x.isNocycle()) {
                this.print0(this.ucase ? "NO CYCLE " : "no cycle ");
            } else {
                this.print0(this.ucase ? "CYCLE " : "cycle ");
            }
        }
        if (x.getOwnerBy() != null) {
            this.print0(this.ucase ? "OWNED BY " : "owned by ");
            x.getOwnerBy().accept(this);
            this.print0(" ");
        }
        if (x.getOwnerTo() != null) {
            this.print0(this.ucase ? "OWNER TO " : "owner to ");
            x.getOwnerTo().accept(this);
            this.print0(" ");
        }
        if (x.getRenameTo() != null) {
            this.print0(this.ucase ? "RENAME TO " : "rename to ");
            x.getRenameTo().accept(this);
            this.print0(" ");
        }
        if (x.getSetSchema() != null) {
            this.print0(this.ucase ? "SET SCHEMA " : "set schema ");
            x.getSetSchema().accept(this);
            this.print0(" ");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterSequenceStatement x) {
    }

    @Override
    public boolean visit(GreenplumAlterViewAlterColumnItem x) {
        return false;
    }

    @Override
    public void endVisit(GreenplumAlterViewAlterColumnItem x) {
    }

    @Override
    public boolean visit(GreenplumShowStatement x) {
        if (x.isAll()) {
            this.print0(this.ucase ? "SHOW ALL" : "show all");
        }
        if (x.getValue() != null) {
            this.print0(this.ucase ? "SHOW " : "show ");
            x.getValue().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumShowStatement x) {
    }

    @Override
    public boolean visit(GreenplumRollbackStatement x) {
        this.print0(this.ucase ? "ROLLBACK " : "rollback ");
        if (x.isWork()) {
            this.print0(this.ucase ? "WORK " : "work ");
        }
        if (x.isTransaction()) {
            this.print0(this.ucase ? "TRANSACTION " : "transaction ");
        }
        if (x.getToSavePoint() != null) {
            this.print0(this.ucase ? "TO " : "to ");
            if (x.isSavepoint()) {
                this.print0(this.ucase ? "SAVEPOINT " : "savepoint ");
            }
            x.getToSavePoint().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumRollbackStatement x) {
    }

    @Override
    public boolean visit(GreenplumSetTransactionStatement x) {
        String str = x.isCharacteristics() ? "SET SESSION CHARACTERISTICS AS TRANSACTION " : "SET TRANSACTION ";
        this.print0(this.ucase ? str : str.toLowerCase());
        x.getTransactionMode().accept(this);
        this.print0(" ");
        if (x.getIsolationLevel() != null) {
            this.print0(this.ucase ? x.getIsolationLevel().getText() : x.getIsolationLevel().getText().toLowerCase());
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumSetTransactionStatement x) {
    }

    @Override
    public boolean visit(GreenplumSetExtStatement x) {
        this.print0(this.ucase ? "SET " : "set ");
        if (x.getOption() != null) {
            this.print0(this.ucase ? x.getOption().name() : x.getOption().name().toLowerCase());
            this.print0(" ");
        }
        if (x.isRole()) {
            this.print0(this.ucase ? "ROLE " : "role ");
            x.getValue().accept(this);
        }
        if (x.isSessionAuth()) {
            this.print0(this.ucase ? "SESSION AUTHORIZATION " : "session authorization ");
            x.getValue().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumSetExtStatement x) {
    }

    @Override
    public boolean visit(GreenplumPartitionElementExpr x) {
        if (x.getValues() != null) {
            this.print0(this.ucase ? "VALUES (" : "values (");
            this.printAndAccept(x.getValues(), ", ");
            this.print0(")");
            this.println();
        }
        if (x.getStartValue() != null) {
            this.print0(this.ucase ? "START (" : "start (");
            if (x.getStartValue() != null) {
                this.printExpr(x.getStartValue());
            }
            this.print0(") ");
            if (x.isStartInclusive()) {
                this.print0(this.ucase ? "INCLUSIVE" : "inclusive");
            }
            if (x.isStartExclusive()) {
                this.print0(this.ucase ? "EXCLUSIVE" : "exclusive");
            }
            this.println();
        }
        if (x.getEndValue() != null) {
            this.print0(this.ucase ? "END (" : "end (");
            if (x.getEndValue() != null) {
                this.printExpr(x.getEndValue());
            }
            this.print0(") ");
            if (x.isEndInclusive()) {
                this.print0(this.ucase ? "INCLUSIVE" : "inclusive");
            }
            if (x.isEndExclusive()) {
                this.print0(this.ucase ? "EXCLUSIVE" : "exclusive");
            }
            this.println();
        }
        if (x.getWithProperties() != null) {
            this.print0(this.ucase ? "WITH (" : "with (");
            this.printAndAccept(x.getWithProperties(), ", ");
            this.print0(") ");
            this.println();
        }
        if (x.getTablespace() != null) {
            this.print0(this.ucase ? "TABLESPACE (" : "tablespace (");
            x.getTablespace().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumPartitionElementExpr x) {
    }

    @Override
    public boolean visit(GreenplumSubpartitionElementExpr x) {
        if (x.isDefault()) {
            this.print0(this.ucase ? "DEFAULT " : "default ");
        }
        if (x.getSubpartitionName() != null) {
            this.print0(this.ucase ? "SUBPARTITION " : "subpartition ");
            x.getSubpartitionName().accept(this);
            this.print0(" ");
        }
        if (x.getValues() != null) {
            this.print0(this.ucase ? "VALUES (" : "values (");
            this.printAndAccept(x.getValues(), ", ");
            this.print0(")");
        }
        if (x.getStartValue() != null) {
            this.print0(this.ucase ? "START (" : "start (");
            if (x.getStartValue() != null) {
                this.printExpr(x.getStartValue());
            }
            this.print0(") ");
            if (x.isStartInclusive()) {
                this.print0(this.ucase ? "INCLUSIVE" : "inclusive");
            }
            if (x.isStartExclusive()) {
                this.print0(this.ucase ? "EXCLUSIVE" : "exclusive");
            }
        }
        if (x.getEndValue() != null) {
            this.print0(this.ucase ? "END (" : "end (");
            if (x.getEndValue() != null) {
                this.printExpr(x.getEndValue());
            }
            this.print0(") ");
            if (x.isEndInclusive()) {
                this.print0(this.ucase ? "INCLUSIVE" : "inclusive");
            }
            if (x.isEndExclusive()) {
                this.print0(this.ucase ? "EXCLUSIVE" : "exclusive");
            }
        }
        if (x.getEveryValue() != null) {
            this.print0(this.ucase ? "EVERY (" : "every (");
            if (x.getEveryValue() != null) {
                this.printExpr(x.getEveryValue());
            }
            this.print0(") ");
        }
        if (x.getWithProperties() != null) {
            this.print0(this.ucase ? "WITH (" : "with (");
            this.printAndAccept(x.getWithProperties(), ", ");
            this.print0(") ");
        }
        if (x.getTablespace() != null) {
            this.print0(this.ucase ? "TABLESPACE (" : "tablespace (");
            x.getTablespace().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumSubpartitionElementExpr x) {
    }

    @Override
    public boolean visit(GreenplumPartitionBy x) {
        if (x.getPartitionByType() == GreenplumPartitionBy.Type.RANGE) {
            this.print0(this.ucase ? "PARTITION BY RANGE (" : "partition by range (");
        } else {
            this.print0(this.ucase ? "PARTITION BY LIST (" : "partition by list (");
        }
        this.printAndAccept(x.getColumns(), ",");
        this.print(")");
        this.incrementIndent();
        this.printAndAccept(x.getSubPartitionBys(), " ");
        this.println();
        this.print("(");
        this.printAndAccept(x.getPartitions(), ",");
        this.println();
        this.print(")");
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(GreenplumPartitionBy x) {
    }

    @Override
    public boolean visit(SQLSubPartitionByRange x) {
        this.println();
        this.print0(this.ucase ? "SUBPARTITION BY RANGE (" : "subpartition by range (");
        this.printAndAccept(x.getColumns(), ",");
        this.print(")");
        this.incrementIndent();
        this.printSubPartitionTemplate(x.getSubPartitionTemplate());
        this.decrementIndent();
        return false;
    }

    private void printSubPartitionTemplate(List<SQLSubPartition> subPartitionTemplate) {
        this.println();
        if (!subPartitionTemplate.isEmpty()) {
            this.print0(this.ucase ? "SUBPARTITION TEMPLATE (" : "subpartition template (");
            this.printAndAccept(subPartitionTemplate, ", ");
            this.print(")");
        }
    }

    @Override
    public boolean visit(SQLSubPartitionByList x) {
        this.println();
        this.print0(this.ucase ? "SUBPARTITION BY LIST (" : "subpartition by list (");
        x.getColumn().accept(this);
        this.print(")");
        this.incrementIndent();
        this.printSubPartitionTemplate(x.getSubPartitionTemplate());
        this.decrementIndent();
        return false;
    }

    private void printAs(GreenplumCreateTableStatement x) {
        GreenplumCreateTableStatement.AsQueryTypeEnum asQueryType = x.getAsQueryType();
        if (asQueryType == null) {
            return;
        }
        this.println();
        this.print0(this.ucase ? "AS" : "as");
        this.println();
        if (asQueryType == GreenplumCreateTableStatement.AsQueryTypeEnum.SELECT) {
            this.visit(x.getSelect());
        }
        if (asQueryType == GreenplumCreateTableStatement.AsQueryTypeEnum.TABLE) {
            this.print0(this.ucase ? "TABLE " : "table ");
            this.visit(x.getAsTable());
        }
        if (asQueryType == GreenplumCreateTableStatement.AsQueryTypeEnum.VALUES) {
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(x.getValuesList(), ", ");
        }
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        boolean visit = super.visit(x);
        if (!(x instanceof GreenplumColumnDefinition)) {
            return visit;
        }
        GreenplumColumnDefinition column = (GreenplumColumnDefinition)x;
        this.parseEncodingOptions(column.getEncodingOptions());
        return visit;
    }

    @Override
    public boolean visit(GreenplumPartition partition) {
        List<GreenplumColumnEncodingConstraint> columnEncodingConstraint;
        List<SQLAssignItem> options;
        List<SQLSubPartition> subPartitions;
        List<GreenplumPartitionRangeValue> rangeValues;
        this.println();
        if (partition.getPartitionType() == GreenplumPartition.PartitionType.DEFAULT) {
            this.print0(this.ucase ? "DEFAULT PARTITION " : "default partition ");
            partition.getName().accept(this);
            return false;
        }
        if (partition.getName() != null) {
            this.print0(this.ucase ? "PARTITION " : "partition ");
            partition.getName().accept(this);
            this.print0(" ");
        }
        if (partition.getValues() != null) {
            partition.getValues().accept(this);
            this.print0(" ");
        }
        if (!(rangeValues = partition.getGreenplumPartitionRangeValues()).isEmpty()) {
            this.printAndAccept(rangeValues, " ");
            this.print0(" ");
        }
        if (!(subPartitions = partition.getSubPartitions()).isEmpty()) {
            this.print("(");
            this.printAndAccept(subPartitions, " ");
            this.print(")");
            this.print0(" ");
        }
        if (!(options = partition.getPartitionOptions()).isEmpty()) {
            this.printWithOptions(options);
            this.print0(" ");
        }
        if (!(columnEncodingConstraint = partition.getColumnEncodingConstraint()).isEmpty()) {
            this.printAndAccept(columnEncodingConstraint, " ");
            this.print0(" ");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumPartition x) {
    }

    @Override
    protected void printDataType(SQLDataType x) {
        if (x instanceof GreenplumDataTypeInterval) {
            this.printGreenplumDataTypeInterval((GreenplumDataTypeInterval)x);
            return;
        }
        super.printDataType(x);
    }

    private void printGreenplumDataTypeInterval(GreenplumDataTypeInterval x) {
        this.print0(this.ucase ? x.getName().toUpperCase() : x.getName().toLowerCase());
        if (x.getMainField() == null) {
            return;
        }
        this.print0(" ");
        this.print0(this.ucase ? x.getMainField().toString().toUpperCase() : x.getMainField().toString().toLowerCase());
        this.print0(" ");
        if (x.getToField() != null) {
            this.print0(this.ucase ? "TO" : "to");
            this.print0(" ");
            this.print0(this.ucase ? x.getToField().toString().toUpperCase() : x.getToField().toString().toLowerCase());
        }
        if (x.getPrecision() != null) {
            this.print0("(");
            this.print0(this.ucase ? x.getPrecision().toString().toUpperCase() : x.getPrecision().toString().toLowerCase());
            this.print0(")");
        }
    }

    private void printGreenplumDistributed(GreenplumCreateTableStatement stmt) {
        if (stmt.isDistributedRandomly()) {
            this.print(" ");
            this.print0(this.ucase ? "DISTRIBUTED RANDOMLY" : "distributed randomly");
            return;
        }
        if (stmt.isDistributedReplicated()) {
            this.print(" ");
            this.print0(this.ucase ? "DISTRIBUTED REPLICATED" : "distributed replicated");
            return;
        }
        if (stmt.getDistributedColumns().isEmpty()) {
            return;
        }
        this.println();
        this.print0(this.ucase ? "DISTRIBUTED BY (" : "distributed by (");
        this.println();
        this.printAndAccept(stmt.getDistributedColumns(), ", ");
        this.println();
        this.print(')');
    }

    @Override
    protected void printCreateTable(SQLCreateTableStatement x, boolean printSelect) {
        SQLExpr storedAs;
        List<SQLAssignItem> options;
        SQLCreateTableStatement.Type tableType;
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isExternal()) {
            this.print0(this.ucase ? "EXTERNAL " : "external ");
        }
        if ((tableType = x.getType()) == SQLCreateTableStatement.Type.TEMPORARY) {
            this.print0(this.ucase ? "TEMPORARY " : "temporary ");
        }
        if (x.isDimension()) {
            this.print0(this.ucase ? "DIMENSION " : "dimension ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        this.printTableSourceExpr(x.getName());
        if (x.getLike() != null) {
            this.printLike(x);
        } else {
            this.printTableElements(x.getTableElementList());
        }
        List<SQLExprTableSource> inherits = ((GreenplumCreateTableStatement)x).getInheritTables();
        if (!inherits.isEmpty()) {
            this.print0(this.ucase ? " INHERITS (" : " inherits (");
            this.printAndAccept(inherits, ", ");
            this.print(')');
        }
        if ((options = x.getTableOptions()).size() > 0) {
            this.printWithOptions(options);
        }
        if (((GreenplumCreateTableStatement)x).isOnCommitDrop()) {
            this.println();
            this.print0(this.ucase ? "ON COMMIT DROP" : "on commit drop");
        } else if (((GreenplumCreateTableStatement)x).isOnCommitDeleteRows()) {
            this.println();
            this.print0(this.ucase ? "ON COMMIT DELETE ROWS" : "on commit delete rows");
        } else if (x.isOnCommitPreserveRows()) {
            this.println();
            this.print0(this.ucase ? "ON COMMIT PRESERVE ROWS" : "on commit preserve rows");
        }
        SQLName tablespace = x.getTablespace();
        if (tablespace != null) {
            this.println();
            this.print0(this.ucase ? "TABLESPACE " : "tablespace ");
            tablespace.accept(this);
        }
        this.printGreenplumDistributed((GreenplumCreateTableStatement)x);
        SQLPartitionBy partitioning = x.getPartitioning();
        if (partitioning instanceof GreenplumPartitionBy) {
            this.println();
            this.visit((GreenplumPartitionBy)partitioning);
        }
        if ((storedAs = x.getStoredAs()) != null) {
            this.print0(this.ucase ? " STORE AS " : " store as ");
            this.printExpr(storedAs, this.parameterized);
        }
    }

    private void printLike(SQLCreateTableStatement x) {
        this.print0(this.ucase ? " (LIKE " : "(LIKE ");
        this.print(x.getLike().getTableName());
        GreenplumCreateTableStatement statement = (GreenplumCreateTableStatement)x;
        for (GreenplumCreateTableStatement.LikeOptionEnum option : statement.getLikeIncludingLists()) {
            this.print0(this.ucase ? " INCLUDING " : " including ");
            this.print0(this.ucase ? option.name().toUpperCase() : option.name().toLowerCase());
        }
        for (GreenplumCreateTableStatement.LikeOptionEnum option : statement.getLikeExcludingLists()) {
            this.print0(this.ucase ? " EXCLUDING " : " excluding ");
            this.print0(this.ucase ? option.name().toUpperCase() : option.name().toLowerCase());
        }
        List<GreenplumColumnEncodingConstraint> columnEncodingConstraints = ((GreenplumCreateTableStatement)x).getColumnEncodingConstraints();
        if (!columnEncodingConstraints.isEmpty()) {
            this.print(", ");
            this.printAndAccept(columnEncodingConstraints, ", ");
        }
        this.print(")");
    }

    @Override
    public boolean visit(GreenplumSubPartition subPartition) {
        this.println();
        this.printSubPartition(subPartition);
        return false;
    }

    @Override
    public void endVisit(GreenplumSubPartition x) {
    }

    private void printSubPartition(GreenplumSubPartition subPartition) {
        List<GreenplumColumnEncodingConstraint> columnEncodingConstraints;
        if (subPartition.getPartitionType() == GreenplumSubPartition.PartitionType.DEFAULT) {
            this.print0(this.ucase ? "DEFAULT SUBPARTITION " : "default subpartition ");
            subPartition.getName().accept(this);
            return;
        }
        if (subPartition.getPartitionType() == GreenplumSubPartition.PartitionType.LIST) {
            this.print0(this.ucase ? "SUBPARTITION " : "subpartition ");
            subPartition.getName().accept(this);
            this.print(" ");
            subPartition.getValues().accept(this);
        }
        if (!subPartition.getGreenplumPartitionRangeValues().isEmpty()) {
            this.printAndAccept(subPartition.getGreenplumPartitionRangeValues(), " ");
            this.print0(" ");
        }
        if (!subPartition.getSubPartitionOptions().isEmpty()) {
            this.printWithOptions(subPartition.getSubPartitionOptions());
            this.print0(" ");
        }
        if (!(columnEncodingConstraints = subPartition.getColumnEncodingConstraints()).isEmpty()) {
            this.printAndAccept(columnEncodingConstraints, " ");
            this.print0(" ");
        }
    }

    private void printWithOptions(List<SQLAssignItem> Options2) {
        this.println();
        this.print0(this.ucase ? "WITH (" : "with (");
        this.printAndAccept(Options2, ", ");
        this.print(')');
    }

    @Override
    public boolean visit(SQLParameter x) {
        if (x.getName() != null) {
            x.getName().accept(this);
            this.print(" ");
        }
        this.printDataType(x.getDataType());
        if (x.getDefaultValue() != null) {
            this.print(" = ");
            x.getDefaultValue().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateFunctionStatement x) {
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "CREATE OR REPLACE FUNCTION " : "create or replace function ");
        } else {
            this.print0(this.ucase ? "CREATE FUNCTION " : "create function ");
        }
        x.getName().accept(this);
        this.print("(");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(")");
        if (x.getReturnDataType() != null) {
            this.print0(this.ucase ? " RETURNS " : " returns ");
            this.printDataType(x.getReturnDataType());
        }
        this.println();
        if (x.getBlock() != null) {
            ++this.indentCount;
            this.printIndent();
            this.print("AS ");
            this.print("$$");
            x.getBlock().accept(this);
            this.print("$$");
            --this.indentCount;
        }
        return false;
    }

    @Override
    public boolean visit(GreenplumPartitionRangeValue x) {
        GreenplumPartitionRangeValue.RangeType rangeType = x.getRangeType();
        this.print0(this.ucase ? rangeType.name().toUpperCase() : rangeType.name().toLowerCase());
        if (!x.getRangeValues().isEmpty()) {
            this.print(" (");
            int index = 0;
            int last = x.getRangeValues().size() - 1;
            for (Pair<SQLDataType, SQLExpr> pair : x.getRangeValues()) {
                if (pair.getFirst() != null) {
                    ((SQLDataType)pair.getFirst()).accept(this);
                    this.print(" ");
                }
                if (pair.getSecond() != null) {
                    ((SQLExpr)pair.getSecond()).accept(this);
                }
                if (index != last) {
                    this.print(", ");
                }
                ++index;
            }
            this.print(")");
        }
        if (x.getRangeValueParameter() != null) {
            this.print(" ");
            x.getRangeValueParameter().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumPartitionRangeValue x) {
    }

    @Override
    public boolean visit(GreenplumColumnDefinition x) {
        return false;
    }

    @Override
    public void endVisit(GreenplumColumnDefinition x) {
    }

    @Override
    public boolean visit(GreenplumColumnEncodingConstraint column) {
        if (column.isDefault()) {
            this.print0(this.ucase ? "DEFAULT " : "default ");
        }
        this.print0(this.ucase ? "COLUMN " : "column ");
        if (column.getName() != null) {
            column.getName().accept(this);
        }
        this.parseEncodingOptions(column.getEncodingOptions());
        return false;
    }

    @Override
    public void endVisit(GreenplumColumnEncodingConstraint x) {
    }

    private void parseEncodingOptions(List<SQLAssignItem> encodingOptions) {
        if (encodingOptions.isEmpty()) {
            return;
        }
        this.print0(this.ucase ? " ENCODING (" : "encoding (");
        this.printAndAccept(encodingOptions, ", ");
        this.print(")");
    }

    @Override
    public boolean visit(GreenplumCreateSchemaStatement x) {
        this.print0(this.ucase ? "CREATE SCHEMA " : "create schema ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        if (x.isAuthorization()) {
            if (x.getName() != null) {
                x.getName().accept(this);
                this.print(" ");
            }
            this.print0(this.ucase ? "AUTHORIZATION " : "authorization ");
            x.getUserName().accept(this);
            this.print(" ");
        }
        if (!x.isAuthorization() && x.getName() != null) {
            x.getName().accept(this);
            this.print(" ");
        }
        if (!x.getSchemaElements().isEmpty()) {
            this.incrementIndent();
            this.println();
            this.printAndAccept(x.getSchemaElements(), " ");
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumCreateSchemaStatement x) {
    }

    @Override
    public boolean visit(GreenplumCreateSequenceStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isTemporary()) {
            if (x.isPrintTmp()) {
                this.print0(this.ucase ? "TEMP " : "temp ");
            } else {
                this.print0(this.ucase ? "TEMPORARY " : "temporary ");
            }
        }
        this.print0(this.ucase ? "SEQUENCE " : "sequence ");
        if (x.getName() != null) {
            x.getName().accept(this);
            this.print(" ");
        }
        this.incrementIndent();
        if (x.getIncrementBy() != null) {
            this.println();
            this.print0(this.ucase ? "INCREMENT " : "increment ");
            if (!x.isOmittedBy()) {
                this.print0(this.ucase ? "BY " : "by ");
            }
            x.getIncrementBy().accept(this);
        }
        if (x.isNoMinValue()) {
            this.println();
            this.print0(this.ucase ? "NO MINVALUE " : "no minvalue ");
        } else if (x.getMaxValue() != null) {
            this.println();
            this.print0(this.ucase ? "MINVALUE " : "minvalue ");
            x.getMaxValue().accept(this);
            this.print(" ");
        }
        if (x.isNoMaxValue()) {
            this.println();
            this.print0(this.ucase ? "NO MAXVALUE " : "no maxvalue ");
        } else if (x.getMaxValue() != null) {
            this.println();
            this.print0(this.ucase ? "MAXVALUE " : "maxvalue ");
            x.getMaxValue().accept(this);
            this.print(" ");
        }
        if (x.getStartWith() != null) {
            this.println();
            this.print0(this.ucase ? "START " : "start ");
            if (!x.isOmittedWith()) {
                this.print0(this.ucase ? "WITH " : "with ");
            }
            x.getStartWith().accept(this);
            this.print(" ");
        }
        if (x.getCache() != null && x.getCache().booleanValue()) {
            this.println();
            this.print0(this.ucase ? "CACHE " : "cache ");
            if (x.getCacheValue() != null) {
                x.getCacheValue().accept(this);
            }
        }
        if (x.isPrintNoCycle()) {
            this.println();
            this.print0(this.ucase ? "NO CYCLE " : "no cycle ");
        } else if (x.getCycle() != null && x.getCycle().booleanValue()) {
            this.println();
            this.print0(this.ucase ? "CYCLE " : "cycle ");
        }
        if (x.isPrintOwnedNone()) {
            this.println();
            this.print0(this.ucase ? "OWNED BY NONE " : "owned by none ");
        } else if (x.getOwned() != null) {
            this.println();
            this.print0(this.ucase ? "OWNED BY " : "owned by ");
            x.getOwned().accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(GreenplumCreateSequenceStatement x) {
    }

    @Override
    public boolean visit(SQLCreateDatabaseStatement x) {
        this.print0(this.ucase ? "CREATE DATABASE " : "create database ");
        x.getName().accept(this);
        this.print(" ");
        this.printAndAccept(x.getDbProperties(), " ");
        return false;
    }

    @Override
    public boolean visit(GreenplumCreateRoleStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isCreateUser()) {
            this.print0(this.ucase ? "USER " : "user ");
        } else {
            this.print0(this.ucase ? "ROLE " : "role ");
        }
        x.getName().accept(this);
        this.println();
        this.printAndAccept(x.getOptions(), "\n");
        if (x.getConnectionLimit() != null) {
            this.print0(this.ucase ? "CONNECTION LIMIT " : "connection limit ");
            x.getConnectionLimit().accept(this);
            this.println();
        }
        if (x.getPassword() != null) {
            if (x.isEncrypted()) {
                this.print0(this.ucase ? "ENCRYPTED " : "encrypted ");
            } else if (x.isUnencrypted()) {
                this.print0(this.ucase ? "UNENCRYPTED " : "unencrypted ");
            }
            this.print0(this.ucase ? "PASSWORD " : "password ");
            x.getPassword().accept(this);
            this.println();
        }
        if (x.getValidUntilTime() != null) {
            this.print0(this.ucase ? "VALID UNTIL " : "valid until ");
            x.getValidUntilTime().accept(this);
            this.println();
        }
        if (!x.getInRoleRoleNames().isEmpty()) {
            this.print0(this.ucase ? "IN ROLE " : "in role ");
            this.printAndAccept(x.getInRoleRoleNames(), ", ");
            this.println();
        }
        if (!x.getRoleRoleNames().isEmpty()) {
            this.print0(this.ucase ? "ROLE " : "role ");
            this.printAndAccept(x.getRoleRoleNames(), ", ");
            this.println();
        }
        if (!x.getAdminRoleNames().isEmpty()) {
            this.print0(this.ucase ? "ADMIN " : "admin ");
            this.printAndAccept(x.getAdminRoleNames(), ", ");
            this.println();
        }
        if (!x.getUserRoleNames().isEmpty()) {
            this.print0(this.ucase ? "USER " : "user ");
            this.printAndAccept(x.getUserRoleNames(), ", ");
            this.println();
        }
        if (!x.getSysId().isEmpty()) {
            this.print0(this.ucase ? "SYSID " : "sysid ");
            this.printAndAccept(x.getSysId(), ", ");
            this.println();
        }
        if (x.getResourceQueueName() != null) {
            this.print0(this.ucase ? "RESOURCE QUEUE " : "resource queue ");
            x.getResourceQueueName().accept(this);
            this.println();
        }
        if (x.getResourceGroupName() != null) {
            this.print0(this.ucase ? "RESOURCE GROUP " : "resource group ");
            x.getResourceGroupName().accept(this);
            this.println();
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumCreateRoleStatement x) {
    }

    @Override
    public boolean visit(SQLDropViewStatement x) {
        super.visit(x);
        if (x.isRestrict()) {
            this.print0(this.ucase ? " RESTRICT" : " restrict");
        }
        return false;
    }

    @Override
    public boolean visit(GreenplumCommitStatement x) {
        this.print0(this.ucase ? "COMMIT " : "commit ");
        if (x.isWork()) {
            this.print0(this.ucase ? "WORK " : "work ");
        } else if (x.isTransaction()) {
            this.print0(this.ucase ? "TRANSACTION " : "transaction ");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumCommitStatement x) {
    }

    @Override
    public boolean visit(GreenplumDeallocateStatement x) {
        this.print0(this.ucase ? "DEALLOCATE " : "deallocate ");
        if (x.isPrepare()) {
            this.print0(this.ucase ? "PREPARE " : "prepare ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumDeallocateStatement x) {
    }

    @Override
    public boolean visit(GreenplumEndTransactionStatement x) {
        this.print0(this.ucase ? "END " : "end ");
        if (x.isWork()) {
            this.print0(this.ucase ? "WORK " : "workd ");
        } else if (x.isTransaction()) {
            this.print0(this.ucase ? "TRANSACTION " : "transaction ");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumEndTransactionStatement x) {
    }

    @Override
    public boolean visit(GreenplumLoadStatement x) {
        this.print0(this.ucase ? "LOAD " : "load");
        x.getFileName().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumLoadStatement x) {
    }

    @Override
    public boolean visit(GreenplumMoveStatement x) {
        this.print0(this.ucase ? "MOVE " : "move ");
        if (x.getForwardDirection() != null) {
            x.getForwardDirection().accept(this);
            this.print(" ");
        }
        if (x.getCount() != null) {
            x.getCount().accept(this);
            this.print(" ");
        }
        if (x.isFrom()) {
            this.print0(this.ucase ? "FROM " : "from ");
        } else if (x.isIn()) {
            this.print0(this.ucase ? "IN " : "in ");
        }
        x.getCursorName().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumMoveStatement x) {
    }

    @Override
    public boolean visit(GreenplumReindexStatement x) {
        this.print0(this.ucase ? "REINDEX " : "reindex ");
        if (x.getType() != null) {
            x.getType().accept(this);
            this.print(" ");
        }
        if (x.getName() != null) {
            x.getName().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumReindexStatement x) {
    }

    @Override
    public boolean visit(GreenplumReassignOwnedStatement x) {
        this.print0(this.ucase ? "REASSIGN OWNED BY " : "reassign owned by ");
        this.printAndAccept(x.getOldRoles(), ", ");
        this.print0(this.ucase ? " TO " : " to ");
        x.getNewRole().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumReassignOwnedStatement x) {
    }

    @Override
    public boolean visit(GreenplumPrepareStatement x) {
        this.print0(this.ucase ? "PREPARE " : "prepare ");
        x.getName().accept(this);
        this.print(" ");
        if (x.getTypes() != null) {
            this.print("(");
            this.printAndAccept(x.getTypes(), ", ");
            this.print(") ");
        }
        this.print0(this.ucase ? "AS " : "as ");
        this.println();
        x.getAsStatement().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumPrepareStatement x) {
    }

    @Override
    public boolean visit(GreenplumDeclareStatement x) {
        this.print0(this.ucase ? "DECLARE " : "declare ");
        x.getName().accept(this);
        this.print(" ");
        if (x.isBinary()) {
            this.print0(this.ucase ? "BINARY " : "binary ");
        }
        if (x.isInsensitive()) {
            this.print0(this.ucase ? "INSENSITIVE " : "insensitive ");
        }
        if (x.isNoScroll()) {
            this.print0(this.ucase ? "NO SCROLL " : "no scroll ");
        }
        this.print0(this.ucase ? "CURSOR " : "cursor ");
        if (x.isWithHold()) {
            this.print0(this.ucase ? "WITH HOLD " : "with hold ");
        } else if (x.isWithoutHold()) {
            this.print0(this.ucase ? "WITHOUT HOLD " : "without hold ");
        }
        this.println();
        this.print0(this.ucase ? "FOR" : "FOR");
        this.println();
        x.getQuery().accept(this);
        if (x.isReadOnly()) {
            this.println();
            this.print0(this.ucase ? "FOR READ ONLY" : "FOR READ ONLY");
        }
        return false;
    }

    @Override
    public void endVisit(GreenplumDeclareStatement x) {
    }

    @Override
    public boolean visit(GreenplumFetchStatement x) {
        this.print0(this.ucase ? "FETCH " : "fetch ");
        if (x.getForwardDirection() != null) {
            x.getForwardDirection().accept(this);
            this.print(" ");
        }
        if (x.getCount() != null) {
            x.getCount().accept(this);
            this.print(" ");
        }
        if (x.isFrom()) {
            this.print0(this.ucase ? "FROM " : "from ");
        } else if (x.isIn()) {
            this.print0(this.ucase ? "In " : "in ");
        }
        x.getCursorName().accept(this);
        return false;
    }

    @Override
    public void endVisit(GreenplumFetchStatement x) {
    }

    @Override
    public boolean visit(GreenplumLockStatement x) {
        this.print0(this.ucase ? "LOCK " : "lock ");
        if (x.isPrintTable()) {
            this.print0(this.ucase ? "TABLE " : "table ");
        }
        if (x.isOnly()) {
            this.print0(this.ucase ? "ONLY " : "only ");
        }
        this.printAndAccept(x.getTableNames(), ", ");
        if (x.getLockMode() != null) {
            this.print0(this.ucase ? " IN " : " in ");
            this.printLockMode(x.getLockMode(), this.ucase);
            this.print0(this.ucase ? " MODE " : "mode ");
        }
        if (x.isNowait()) {
            this.print0(this.ucase ? "NOWAIT" : "nowait");
        }
        return false;
    }

    private void printLockMode(GreenplumLockStatement.LockMode lockMode, boolean ucase) {
        String mode = "";
        switch (lockMode) {
            case SHARE: {
                mode = "SHARE";
                break;
            }
            case SHARE_UPDATE_EXCLUSIVE: {
                mode = "SHARE UPDATE EXCLUSIVE";
                break;
            }
            case SHARE_ROW_EXCLUSIVE: {
                mode = "SHARE ROW EXCLUSIVE";
                break;
            }
            case ACCESS_EXCLUSIVE: {
                mode = "ACCESS EXCLUSIVE";
                break;
            }
            case ROW_EXCLUSIVE: {
                mode = "ROW EXCLUSIVE";
                break;
            }
            case ACCESS_SHARE: {
                mode = "ACCESS SHARE";
                break;
            }
            case ROW_SHARE: {
                mode = "ROW SHARE";
                break;
            }
            case EXCLUSIVE: {
                mode = "EXCLUSIVE";
                break;
            }
        }
        this.print0(ucase ? mode.toUpperCase() : mode.toLowerCase());
    }

    @Override
    public void endVisit(GreenplumLockStatement x) {
    }

    @Override
    public boolean visit(GreenplumExecuteStatement x) {
        return false;
    }

    @Override
    public void endVisit(GreenplumExecuteStatement x) {
        this.print0(this.ucase ? "EXECUTE " : "execute ");
        if (x.getStatementName() != null) {
            x.getStatementName().accept(this);
            this.print(" ");
        }
        if (!x.getParameters().isEmpty()) {
            this.print("( ");
            this.printAndAccept(x.getParameters(), ", ");
            this.print(" )");
        }
    }

    @Override
    public boolean visit(GreenplumVacuumStatement x) {
        this.print(this.ucase ? "VACUUM" : "vacuum");
        if (x.getParameters() != null) {
            if (x.isInBrackets()) {
                this.print(" (");
                for (int i = 0; i < x.getParameters().size(); ++i) {
                    this.print(x.getParameters().get(i).name());
                    if (i == x.getParameters().size() - 1) continue;
                    this.print(", ");
                }
                this.print(")");
            } else {
                for (GreenplumVacuumStatement.VacuumParameterEnum parameter : x.getParameters()) {
                    this.print(" ");
                    this.print(parameter.name());
                }
            }
        }
        if (x.getTableSources() != null && !x.getTableSources().isEmpty()) {
            this.print(" ");
            this.printList(x.getTableSources(), ", ");
        }
        return false;
    }

    protected <E extends SQLObject> void printList(List<E> items, String delimiter) {
        if (items != null && items.size() > 0) {
            int itemSize = items.size();
            for (int i = 0; i < itemSize; ++i) {
                SQLObject sqlName = (SQLObject)items.get(i);
                sqlName.accept(this);
                if (i != itemSize - 1) {
                    this.print(delimiter);
                }
                if (!this.isPrettyFormat() || !sqlName.hasAfterComment()) continue;
                this.print(' ');
                this.printlnComment(sqlName.getAfterCommentsDirect());
            }
        }
    }

    @Override
    public boolean visit(SQLSelectOrderByItem x) {
        SQLCommentHint hint;
        SQLSelectOrderByItem.NullsOrderType nullsOrderType;
        SQLOrderingSpecification type;
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLIntegerExpr) {
            this.print(((SQLIntegerExpr)expr).getNumber().longValue());
        } else {
            this.printExpr(expr, this.parameterized);
        }
        String collate = x.getCollate();
        if (collate != null) {
            this.print0(this.ucase ? " COLLATE " : " collate ");
            this.print0(collate);
        }
        if (x.getOpclass() != null) {
            this.print(" ");
            this.print(x.getOpclass());
        }
        if ((type = x.getType()) != null) {
            this.print(' ');
            this.print0(this.ucase ? type.name : type.name_lcase);
        }
        if ((nullsOrderType = x.getNullsOrderType()) != null) {
            this.print(' ');
            this.print0(nullsOrderType.toFormalString());
        }
        if ((hint = x.getHint()) != null) {
            this.visit(hint);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateIndexStatement x) {
        super.visit(x);
        if (x.getWhere() != null) {
            this.println();
            this.print(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept(this);
        }
        return false;
    }
}

