/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.greenplum.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLParameter;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDefaultExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterDatabaseStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableAddPartition;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDropDatabaseStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExplainStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLFetchStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLStartTransactionStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.expr.GreenplumEmptyExpr;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.expr.GreenplumPartitionElementExpr;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.expr.GreenplumSubpartitionElementExpr;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterDatabaseOnwerItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterDatabaseRenameItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterDatabaseResetItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterDatabaseSetItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterDatabaseWithItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterSchemaStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterSequenceStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableAddPartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableAlterPartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableAlterPartitionAction;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableDropPartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableExchangePartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableRenamePartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSet;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSetDistribute;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSetItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSetSchema;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSetSubparition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSetWithOption;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableSplitPartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterTableTruncatePartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterViewActionItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterViewAlterColumnItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumAlterViewStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumCheckPointStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumClusterStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumCommitStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumCreateRoleStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumCreateSchemaStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumCreateSequenceStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDeallocateStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDeclareStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDropIndexStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDropRoleStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDropSchemaStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDropSequenceStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumEndTransactionStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumExecuteStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumFetchStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumLoadStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumLockStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumMoveStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumPrepareStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumReassignOwnedStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumReindexStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumRollbackStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumSelectStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumShowStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumStartTransactionStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumVacuumStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.parser.GreenplumCreateTableParser;
import com.alibaba.fastsql.sql.dialect.greenplum.parser.GreenplumExprParser;
import com.alibaba.fastsql.sql.dialect.greenplum.parser.GreenplumSelectParser;
import com.alibaba.fastsql.sql.dialect.postgresql.parser.PGSQLStatementParser;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLCreateTableParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class GreenplumStatementParser
extends PGSQLStatementParser {
    public GreenplumStatementParser(String sql, SQLParserFeature ... features) {
        super(new GreenplumExprParser(sql, features));
        this.dbType = DbType.greenplum;
    }

    @Override
    public GreenplumSelectStatement parseSelect() {
        GreenplumSelectParser selectParser = new GreenplumSelectParser(this.exprParser, this.selectListCache);
        SQLSelect select = selectParser.select();
        return new GreenplumSelectStatement(select);
    }

    @Override
    protected SQLStatement parseAlterSchema() {
        this.lexer.nextToken();
        this.accept(Token.SCHEMA);
        GreenplumAlterSchemaStatement alterSchemaStatement = new GreenplumAlterSchemaStatement();
        alterSchemaStatement.setName(this.exprParser.name());
        alterSchemaStatement.setDbType(this.dbType);
        if (this.lexer.token() == Token.RENAME) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            alterSchemaStatement.setNewName(this.exprParser.name());
        } else if (this.lexer.identifierEquals(FnvHash.Constants.OWNER)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            alterSchemaStatement.setNewOwner(this.exprParser.name());
        } else {
            throw new ParserException("TODO " + this.lexer.info());
        }
        return alterSchemaStatement;
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new GreenplumCreateTableParser(this.exprParser);
    }

    @Override
    protected SQLStatement parseAlterDatabase() {
        this.lexer.nextToken();
        this.accept(Token.DATABASE);
        SQLAlterDatabaseStatement sqlAlterDatabaseStatement = new SQLAlterDatabaseStatement();
        sqlAlterDatabaseStatement.setDbType(this.dbType);
        sqlAlterDatabaseStatement.setName(this.exprParser.name());
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("connection");
            this.accept(Token.LIMIT);
            GreenplumAlterDatabaseWithItem item = new GreenplumAlterDatabaseWithItem();
            item.setConnlimit(this.exprParser.expr());
            sqlAlterDatabaseStatement.setItem(item);
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            GreenplumAlterDatabaseSetItem item = new GreenplumAlterDatabaseSetItem();
            SQLAssignItem sqlAssignItem = new SQLAssignItem();
            sqlAssignItem.setTarget(this.exprParser.primary());
            if (this.lexer.token() == Token.TO) {
                this.lexer.nextToken();
                item.setTo(true);
            }
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
                item.setEq(true);
            }
            if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS) {
                sqlAssignItem.setValue(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.DEFAULT) {
                sqlAssignItem.setValue(new SQLDefaultExpr());
            }
            item.setSqlAssignItem(sqlAssignItem);
            sqlAlterDatabaseStatement.setItem(item);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RESET)) {
            this.lexer.nextToken();
            GreenplumAlterDatabaseResetItem item = new GreenplumAlterDatabaseResetItem();
            item.setReset(this.exprParser.expr());
            sqlAlterDatabaseStatement.setItem(item);
        } else if (this.lexer.token() == Token.RENAME) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            GreenplumAlterDatabaseRenameItem item = new GreenplumAlterDatabaseRenameItem();
            item.setNewName(this.exprParser.name());
            sqlAlterDatabaseStatement.setItem(item);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.OWNER)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            GreenplumAlterDatabaseOnwerItem item = new GreenplumAlterDatabaseOnwerItem();
            item.setOnwerTo(this.exprParser.name());
            sqlAlterDatabaseStatement.setItem(item);
        }
        return sqlAlterDatabaseStatement;
    }

    @Override
    public SQLCreateFunctionStatement parseCreateFunction() {
        return super.parseCreateFunction();
    }

    private void parserParameters(List<SQLParameter> parameters, SQLObject parent) {
        if (this.lexer.token() == Token.RPAREN) {
            return;
        }
        while (true) {
            SQLParameter parameter = new SQLParameter();
            if (this.lexer.token() == Token.IN || this.lexer.token() == Token.OUT || this.lexer.token() == Token.INOUT) {
                if (this.lexer.token() == Token.IN) {
                    parameter.setParamType(SQLParameter.ParameterType.IN);
                } else if (this.lexer.token() == Token.OUT) {
                    parameter.setParamType(SQLParameter.ParameterType.OUT);
                } else if (this.lexer.token() == Token.INOUT) {
                    parameter.setParamType(SQLParameter.ParameterType.INOUT);
                }
                this.lexer.nextToken();
                this.parseParameter(parameter);
            } else {
                parameter.setParamType(SQLParameter.ParameterType.DEFAULT);
                this.parseParameter(parameter);
            }
            parameters.add(parameter);
            if (this.lexer.token() != Token.COMMA && this.lexer.token() != Token.SEMI) break;
            this.lexer.nextToken();
        }
    }

    protected void parseParameter(SQLParameter parameter) {
        SQLDataType sqlDataType;
        if (this.lexer.token() != Token.IDENTIFIER) {
            return;
        }
        Lexer.SavePoint mark = this.lexer.mark();
        SQLName name = this.exprParser.name();
        if (this.lexer.token() == Token.IDENTIFIER) {
            sqlDataType = this.exprParser.parseDataType();
        } else {
            this.lexer.reset(mark);
            name = null;
            sqlDataType = this.exprParser.parseDataType();
        }
        if (this.lexer.token() == Token.DEFAULT || this.lexer.token() == Token.EQ) {
            this.lexer.nextToken();
            parameter.setDefaultValue(this.exprParser.expr());
        }
        parameter.setName(name);
        parameter.setDataType(sqlDataType);
    }

    @Override
    protected SQLAlterTableAlterColumn parseAlterColumn() {
        SQLAlterTableAlterColumn alterColumn = super.parseAlterColumn();
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            alterColumn.setUsing(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.SET) {
            if (this.lexer.token() == Token.STATISTICS) {
                this.lexer.nextToken();
                alterColumn.setSetStatistics(this.exprParser.integerExpr());
            } else if (this.lexer.identifierEquals("storage")) {
                this.lexer.nextToken();
                alterColumn.setStorageType(this.exprParser.primary());
            } else {
                this.setErrorEndPos(this.lexer.pos());
                this.printError(this.lexer.token());
            }
        }
        return alterColumn;
    }

    @Override
    protected SQLStatement parseAlterView() {
        this.accept(Token.VIEW);
        GreenplumAlterViewStatement stmt = new GreenplumAlterViewStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.ALTER) {
            stmt.setAlterViewActionItem(this.parseAlterViewActionItem());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.OWNER)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            stmt.setOwnerTo(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RENAME)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            stmt.setRenameTo(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SCHEMA) {
                this.lexer.nextToken();
                stmt.setSetSchema(this.exprParser.expr());
            } else {
                ArrayList<SQLAssignItem> sqlAssignItems = Lists.newArrayList();
                this.exprParser.parseAssignItem(sqlAssignItems, stmt);
                stmt.setSetOptions(sqlAssignItems);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RESET)) {
            this.lexer.nextToken();
            stmt.setResetOption(this.exprParser.expr());
        }
        return stmt;
    }

    private GreenplumAlterViewActionItem parseAlterViewActionItem() {
        GreenplumAlterViewAlterColumnItem item = new GreenplumAlterViewAlterColumnItem();
        this.accept(Token.ALTER);
        if (this.lexer.token() == Token.COLUMN) {
            this.lexer.nextToken();
            item.setHasColumn(true);
        }
        item.setColumnName(this.exprParser.expr());
        if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            this.accept(Token.DEFAULT);
            item.setSetDefaultExpr(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.DROP) {
            this.lexer.nextToken();
            this.accept(Token.DEFAULT);
            item.setDropDefault(true);
        }
        return item;
    }

    @Override
    public SQLStatement parseAlterSequence() {
        GreenplumAlterSequenceStatement stmt = new GreenplumAlterSequenceStatement();
        stmt.setDbType(this.dbType);
        this.accept(Token.SEQUENCE);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.identifierEquals("INCREMENT")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BY) {
                this.lexer.nextToken();
                stmt.setIncrementBy(true);
            }
            stmt.setIncrement(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals("MINVALUE")) {
            this.lexer.nextToken();
            stmt.setMinValue(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals("MAXVALUE")) {
            this.lexer.nextToken();
            stmt.setMaxValue(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.NO)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("MINVALUE")) {
                this.lexer.nextToken();
                stmt.setNoMinVaLue(true);
            }
            if (this.lexer.identifierEquals("MAXVALUE")) {
                this.lexer.nextToken();
                stmt.setNoMaxVaLue(true);
            }
            if (this.lexer.identifierEquals("CYCLE")) {
                this.lexer.nextToken();
                stmt.setNocycle(true);
                stmt.setUseCycle(true);
            }
            throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        if (this.lexer.token() == Token.START || this.lexer.identifierEquals(FnvHash.Constants.START)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                stmt.setStartWith(true);
            }
            stmt.setStartValue(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.RESTART || this.lexer.identifierEquals(FnvHash.Constants.RESTART)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                stmt.setRestartWith(true);
            }
            stmt.setRestartValue(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.CACHE) {
            this.lexer.nextToken();
            stmt.setCache(this.exprParser.primary());
        }
        if (this.lexer.identifierEquals("CYCLE")) {
            this.lexer.nextToken();
            stmt.setUseCycle(true);
            stmt.setNocycle(false);
        }
        if (this.lexer.identifierEquals("OWNED")) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            stmt.setOwnerBy(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.OWNER)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            stmt.setOwnerTo(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RENAME)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            stmt.setRenameTo(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            this.accept(Token.SCHEMA);
            stmt.setSetSchema(this.exprParser.expr());
        }
        return stmt;
    }

    @Override
    protected SQLAlterTableItem parseAlterTableSetItem() {
        this.lexer.nextToken();
        SQLAlterTableItem sqlAlterTableItem = null;
        GreenplumAlterTableSet greenplumAlterTableSet = new GreenplumAlterTableSet();
        Lexer lexer = this.exprParser.getLexer();
        ArrayList<GreenplumAlterTableSetItem> items = Lists.newArrayList();
        while (true) {
            if (lexer.token() == Token.SCHEMA) {
                lexer.nextToken();
                GreenplumAlterTableSetSchema item = new GreenplumAlterTableSetSchema(this.exprParser.expr());
                items.add(item);
                continue;
            }
            if (lexer.token() == Token.DISTRIBUTED) {
                lexer.nextToken();
                GreenplumAlterTableSetDistribute byItem = new GreenplumAlterTableSetDistribute();
                if (lexer.token() == Token.BY) {
                    lexer.nextToken();
                    byItem.setRandom(false);
                    ArrayList<SQLName> columns = Lists.newArrayList();
                    boolean lparen = false;
                    if (lexer.token() == Token.LPAREN) {
                        lparen = true;
                        lexer.nextToken();
                    }
                    this.exprParser.names(columns, byItem);
                    if (lparen) {
                        this.accept(Token.RPAREN);
                    }
                    byItem.setColumns(columns);
                } else {
                    this.accept(Token.RANDOMLY);
                    byItem.setRandom(true);
                }
                items.add(byItem);
                continue;
            }
            if (lexer.token() != Token.WITH) break;
            lexer.nextToken();
            GreenplumAlterTableSetWithOption option = new GreenplumAlterTableSetWithOption();
            ArrayList<SQLAssignItem> sqlAssignItems = Lists.newArrayList();
            this.exprParser.parseAssignItem(sqlAssignItems, option);
            option.setOptions(sqlAssignItems);
            items.add(option);
        }
        if (lexer.token() != Token.EOF && lexer.token() != Token.SEMI) {
            sqlAlterTableItem = this.parseAlterTableSetSubpartition();
        }
        if (sqlAlterTableItem == null) {
            greenplumAlterTableSet.setSetItems(items);
            sqlAlterTableItem = greenplumAlterTableSet;
        }
        return sqlAlterTableItem;
    }

    @Override
    public SQLStatement parseCreateSchema() {
        this.accept(Token.CREATE);
        this.accept(Token.SCHEMA);
        GreenplumCreateSchemaStatement stmt = new GreenplumCreateSchemaStatement();
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        if (this.lexer.identifierEquals("AUTHORIZATION")) {
            stmt.setAuthorization(true);
            this.lexer.nextToken();
        }
        if (stmt.isAuthorization()) {
            stmt.setUserName(this.exprParser.name());
        } else {
            stmt.setName(this.exprParser.name());
            if (this.lexer.identifierEquals("AUTHORIZATION")) {
                stmt.setAuthorization(true);
                this.lexer.nextToken();
                stmt.setUserName(this.exprParser.name());
            }
        }
        this.parseSchemaElements(stmt.getSchemaElements());
        return stmt;
    }

    private void parseSchemaElements(List<SQLStatement> schemaElements) {
        while (this.lexer.token() == Token.CREATE || this.lexer.token() == Token.GRANT) {
            this.parseSchemaElement(schemaElements);
        }
    }

    private void parseSchemaElement(List<SQLStatement> schemaElements) {
        Token token = this.lexer.token();
        if (token != Token.CREATE && token != Token.GRANT) {
            return;
        }
        if (token == Token.GRANT) {
            schemaElements.add(this.parseGrant());
            return;
        }
        Lexer.SavePoint mark = this.lexer.mark();
        this.lexer.nextToken();
        token = this.lexer.token();
        this.lexer.reset(mark);
        switch (token) {
            case TABLE: {
                schemaElements.add(this.getSQLCreateTableParser().parseCreateTable());
                return;
            }
            case VIEW: {
                schemaElements.add(this.parseCreateView());
                return;
            }
            case INDEX: {
                schemaElements.add(this.parseCreateIndex(true));
                return;
            }
            case SEQUENCE: {
                schemaElements.add(this.parseCreateSequence(true));
                return;
            }
            case TRIGGER: {
                schemaElements.add(this.parseCreateTrigger());
                return;
            }
            case GRANT: {
                schemaElements.add(this.parseGrant());
                return;
            }
        }
        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    @Override
    public SQLStatement parseCreateSequence(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        GreenplumCreateSequenceStatement stmt = new GreenplumCreateSequenceStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token() == Token.TEMPORARY) {
            stmt.setTemporary(true);
        } else if (this.lexer.token() == Token.TEMP) {
            stmt.setTemporary(true);
            stmt.setPrintTmp(true);
        }
        this.accept(Token.SEQUENCE);
        stmt.setName(this.exprParser.name());
        if (this.lexer.identifierEquals(FnvHash.Constants.INCREMENT)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BY) {
                this.lexer.nextToken();
            } else {
                stmt.setOmittedBy(true);
            }
            stmt.setIncrementBy(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.NO)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.MINVALUE)) {
                this.lexer.nextToken();
                stmt.setNoMinValue(true);
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.MINVALUE)) {
            this.lexer.nextToken();
            stmt.setMinValue(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.NO)) {
            if (this.lexer.identifierEquals(FnvHash.Constants.MAXVALUE)) {
                this.lexer.nextToken();
                stmt.setNoMaxValue(true);
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.MAXVALUE)) {
            this.lexer.nextToken();
            stmt.setMaxValue(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.START || this.lexer.identifierEquals(FnvHash.Constants.START)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
            } else {
                stmt.setOmittedWith(true);
            }
            stmt.setStartWith(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.CACHE || this.lexer.identifierEquals(FnvHash.Constants.CACHE)) {
            this.lexer.nextToken();
            stmt.setCache(Boolean.TRUE);
            if (this.lexer.token() == Token.LITERAL_INT) {
                stmt.setCacheValue(this.exprParser.primary());
            }
        }
        boolean isNo = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.NO)) {
            isNo = true;
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CYCLE)) {
            this.lexer.nextToken();
            if (isNo) {
                stmt.setCycle(Boolean.FALSE);
            } else {
                stmt.setCycle(Boolean.TRUE);
                stmt.setPrintNoCycle(Boolean.TRUE);
            }
        }
        if (this.lexer.identifierEquals("OWNED")) {
            this.lexer.nextToken();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NONE) {
                stmt.setPrintOwnedNone(true);
            } else {
                stmt.setOwned(this.exprParser.expr());
            }
        }
        return stmt;
    }

    @Override
    protected SQLAlterTableItem parseAlterTableAlterPartition() {
        this.lexer.nextToken();
        GreenplumAlterTableAlterPartition alterTableAlterPartition = new GreenplumAlterTableAlterPartition();
        alterTableAlterPartition.setPartitionActions(Lists.newArrayList());
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            if (this.lexer.identifierEquals("rank")) {
                alterTableAlterPartition.setForRank(this.exprParser.expr());
            } else {
                alterTableAlterPartition.setForValue(this.exprParser.expr());
            }
            this.accept(Token.RPAREN);
        } else if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_ALIAS || this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.VARIANT) {
            alterTableAlterPartition.setPartitionName(this.exprParser.name());
        }
        Lexer.SavePoint savePoint = this.lexer.mark();
        SQLAlterTableItem item = this.parsePartitionAction();
        if (item == null) {
            this.lexer.reset(savePoint);
            return alterTableAlterPartition;
        }
        alterTableAlterPartition.getPartitionActions().add(item);
        while (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            item = this.parsePartitionAction();
            if (item == null) break;
            alterTableAlterPartition.getPartitionActions().add(item);
        }
        return alterTableAlterPartition;
    }

    private SQLAlterTableItem parsePartitionAction() {
        SQLAlterTableItem sqlAlterTableItem;
        switch (this.lexer.token()) {
            case ADD: {
                this.lexer.nextToken();
                boolean isDefault = false;
                if (this.lexer.token() == Token.DEFAULT) {
                    this.lexer.nextToken();
                    isDefault = true;
                }
                this.accept(Token.PARTITION);
                GreenplumAlterTableAddPartition alterTableAddPartition = (GreenplumAlterTableAddPartition)this.parseAlterTableAddPartition();
                alterTableAddPartition.setDefault(isDefault);
                sqlAlterTableItem = alterTableAddPartition;
                break;
            }
            case DROP: {
                this.lexer.nextToken();
                sqlAlterTableItem = this.parseAlterTableDropPartition(false);
                break;
            }
            case ALTER: {
                GreenplumAlterTableAlterPartitionAction action = new GreenplumAlterTableAlterPartitionAction();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.DEFAULT) {
                    this.lexer.nextToken();
                    action.setDefault(true);
                }
                this.accept(Token.PARTITION);
                if (this.lexer.token() == Token.FOR) {
                    this.lexer.nextToken();
                    action.setForValue(this.exprParser.expr());
                }
                if (this.lexer.token() == Token.IDENTIFIER) {
                    action = null;
                }
                sqlAlterTableItem = action;
                break;
            }
            case SET: {
                this.lexer.nextToken();
                sqlAlterTableItem = this.parseAlterTableSetSubpartition();
                break;
            }
            case COMMA: 
            case SEMI: 
            case EOF: {
                sqlAlterTableItem = null;
                break;
            }
            default: {
                sqlAlterTableItem = this.parseGreenplumSpecialItem();
            }
        }
        return sqlAlterTableItem;
    }

    @Override
    protected SQLAlterTableItem parseAlterTableDropPartition(boolean ifExists) {
        GreenplumAlterTableDropPartition dropPartition = new GreenplumAlterTableDropPartition();
        if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
            dropPartition.setDefault(true);
        }
        this.accept(Token.PARTITION);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            dropPartition.setIfExists(true);
        } else {
            dropPartition.setIfExists(false);
        }
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            if (this.lexer.identifierEquals("rank")) {
                dropPartition.setForRank(this.exprParser.expr());
            } else if (this.lexer.token() != Token.RPAREN) {
                dropPartition.setForValue(this.exprParser.expr());
            } else {
                dropPartition.setForValue(new GreenplumEmptyExpr());
            }
            this.accept(Token.RPAREN);
        } else if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS || this.lexer.token() == Token.VARIANT) {
            dropPartition.setPartitionName(this.exprParser.name());
        }
        if (this.lexer.token() == Token.CASCADE) {
            dropPartition.setCascade(true);
        }
        return dropPartition;
    }

    @Override
    protected SQLAlterTableItem parseAlterTableSetSubpartition() {
        this.accept(Token.SUBPARTITION);
        this.acceptIdentifier("template");
        this.accept(Token.LPAREN);
        GreenplumAlterTableSetSubparition setSubparition = new GreenplumAlterTableSetSubparition();
        GreenplumSubpartitionElementExpr subpartitionElementExpr = this.parseSubpartitionElementExpr();
        if (subpartitionElementExpr != null) {
            setSubparition.setSubpartitions(Lists.newArrayList());
            ArrayList<GreenplumSubpartitionElementExpr> elementExprs = Lists.newArrayList();
            elementExprs.add(subpartitionElementExpr);
            while (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                subpartitionElementExpr = this.parseSubpartitionElementExpr();
                if (subpartitionElementExpr == null) break;
                elementExprs.add(subpartitionElementExpr);
            }
            setSubparition.getSubpartitions().addAll(elementExprs);
        }
        this.accept(Token.RPAREN);
        return setSubparition;
    }

    @Override
    protected SQLAlterTableItem parseAlterTableExchangePartition() {
        GreenplumAlterTableExchangePartition exchangePartition = new GreenplumAlterTableExchangePartition();
        this.lexer.nextToken();
        if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
            exchangePartition.setDefault(true);
        }
        this.accept(Token.PARTITION);
        if (this.lexer.token() != Token.WITH) {
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                if (this.lexer.identifierEquals("rank")) {
                    exchangePartition.setForRank(this.exprParser.expr());
                } else {
                    exchangePartition.setForValue(this.exprParser.expr());
                }
                this.accept(Token.RPAREN);
            } else if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_ALIAS || this.lexer.token() == Token.LITERAL_CHARS) {
                exchangePartition.setPartitionName(this.exprParser.name());
            }
        }
        this.accept(Token.WITH);
        this.accept(Token.TABLE);
        exchangePartition.setWithTable(this.exprParser.name());
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("validation");
            exchangePartition.setWithValidation(true);
        }
        if (this.lexer.token() == Token.WITHOUT) {
            this.lexer.nextToken();
            this.acceptIdentifier("validation");
            exchangePartition.setWithNotValidation(true);
        }
        return exchangePartition;
    }

    @Override
    protected SQLAlterTableItem parseGreenplumSpecialItem() {
        if (this.lexer.identifierEquals("exchange")) {
            return this.parseAlterTableExchangePartition();
        }
        if (this.lexer.token() == Token.RENAME) {
            this.lexer.nextToken();
            GreenplumAlterTableRenamePartition renamePartition = new GreenplumAlterTableRenamePartition();
            if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                renamePartition.setDefault(true);
            }
            this.accept(Token.PARTITION);
            if (this.lexer.token() != Token.TO) {
                if (this.lexer.token() == Token.FOR) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    if (this.lexer.identifierEquals("rank")) {
                        renamePartition.setForRank(this.exprParser.expr());
                    } else {
                        renamePartition.setForValue(this.exprParser.expr());
                    }
                    this.accept(Token.RPAREN);
                } else if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_ALIAS || this.lexer.token() == Token.LITERAL_CHARS) {
                    renamePartition.setPartitionName(this.exprParser.name());
                }
            }
            this.accept(Token.TO);
            renamePartition.setTargetPartitionName(this.exprParser.name());
            return renamePartition;
        }
        if (this.lexer.identifierEquals("split")) {
            this.lexer.nextToken();
            GreenplumAlterTableSplitPartition splitPartition = new GreenplumAlterTableSplitPartition();
            if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                splitPartition.setDefault(true);
            }
            this.accept(Token.PARTITION);
            if (this.lexer.identifierEquals(FnvHash.Constants.AT)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                splitPartition.setAtValue(this.exprParser.expr());
                this.accept(Token.RPAREN);
            } else if (this.lexer.token() == Token.START) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                splitPartition.setStartValue(this.exprParser.primary());
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.INCLUSIVE) {
                    this.lexer.nextToken();
                    splitPartition.setStartInclusive(true);
                }
                if (this.lexer.token() == Token.EXCLUSIVE) {
                    this.lexer.nextToken();
                    splitPartition.setStartExclusive(true);
                }
                this.accept(Token.END);
                this.accept(Token.LPAREN);
                splitPartition.setEndValue(this.exprParser.primary());
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.INCLUSIVE) {
                    this.lexer.nextToken();
                    splitPartition.setEndInclusive(true);
                }
                if (this.lexer.token() == Token.EXCLUSIVE) {
                    this.lexer.nextToken();
                    splitPartition.setEndExclusive(true);
                }
            } else if (!splitPartition.isDefault()) {
                if (this.lexer.token() == Token.FOR) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    if (this.lexer.identifierEquals("rank")) {
                        splitPartition.setForRank(this.exprParser.expr());
                    } else {
                        splitPartition.setForValue(this.exprParser.expr());
                    }
                    this.accept(Token.RPAREN);
                } else if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_ALIAS || this.lexer.token() == Token.LITERAL_CHARS) {
                    splitPartition.setPartitionName(this.exprParser.name());
                }
                if (!this.lexer.identifierEquals("AT")) {
                    this.setErrorEndPos(this.lexer.pos());
                    this.printError(this.lexer.token());
                }
                this.lexer.nextToken();
                splitPartition.setAtValue(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                ArrayList<SQLExpr> partitions = Lists.newArrayList();
                this.accept(Token.PARTITION);
                partitions.add(this.exprParser.name());
                this.accept(Token.COMMA);
                this.accept(Token.PARTITION);
                partitions.add(this.exprParser.name());
                this.accept(Token.RPAREN);
                splitPartition.setIntoPartitionNames(partitions);
            }
            return splitPartition;
        }
        if (this.lexer.token() == Token.TRUNCATE) {
            this.lexer.nextToken();
            GreenplumAlterTableTruncatePartition truncatePartition = new GreenplumAlterTableTruncatePartition();
            if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                truncatePartition.setDefault(true);
            }
            this.accept(Token.PARTITION);
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                if (this.lexer.identifierEquals("rank")) {
                    truncatePartition.setForRank(this.exprParser.expr());
                } else {
                    truncatePartition.setForValue(this.exprParser.expr());
                }
                this.accept(Token.RPAREN);
            } else if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_ALIAS || this.lexer.token() == Token.LITERAL_CHARS) {
                truncatePartition.setPartitionName(this.exprParser.name());
            }
            return truncatePartition;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    protected SQLAlterTableAddPartition parseAlterTableAddPartition() {
        GreenplumSubpartitionElementExpr subpartitionElementExpr;
        GreenplumAlterTableAddPartition alterTableAddPartition = new GreenplumAlterTableAddPartition();
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            alterTableAddPartition.setHasIf(true);
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                this.accept(Token.EXISTS);
                alterTableAddPartition.setPartitionExists(true);
            } else {
                alterTableAddPartition.setPartitionExists(false);
            }
        }
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            alterTableAddPartition.setForRank(this.exprParser.expr());
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_ALIAS || this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.VARIANT) {
            alterTableAddPartition.setPartitionName(this.exprParser.name());
        }
        Lexer.SavePoint savePoint = this.lexer.mark();
        GreenplumPartitionElementExpr greenplumPartitionElementExpr = this.parsePartitionElementExpr();
        if (greenplumPartitionElementExpr != null) {
            alterTableAddPartition.setPartititonElememt(greenplumPartitionElementExpr);
        } else {
            this.lexer.reset(savePoint);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
        }
        if ((subpartitionElementExpr = this.parseSubpartitionElementExpr()) != null) {
            alterTableAddPartition.setSubpartitionSpec(Lists.newArrayList());
            ArrayList<GreenplumSubpartitionElementExpr> elementExprs = Lists.newArrayList();
            elementExprs.add(subpartitionElementExpr);
            while (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                subpartitionElementExpr = this.parseSubpartitionElementExpr();
                elementExprs.add(subpartitionElementExpr);
            }
            alterTableAddPartition.getSubpartitionSpec().addAll(elementExprs);
        }
        if (this.lexer.token() == Token.RPAREN) {
            this.lexer.nextToken();
        }
        return alterTableAddPartition;
    }

    private GreenplumPartitionElementExpr parsePartitionElementExpr() {
        boolean isNull = false;
        GreenplumPartitionElementExpr greenplumPartitionElementExpr = new GreenplumPartitionElementExpr();
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            ArrayList<SQLExpr> sqlExprs = Lists.newArrayList();
            this.exprParser.exprList(sqlExprs, greenplumPartitionElementExpr);
            this.accept(Token.RPAREN);
            isNull = true;
            greenplumPartitionElementExpr.setValues(sqlExprs);
        }
        if (this.lexer.token() == Token.START) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            greenplumPartitionElementExpr.setStartValue(this.exprParser.expr());
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.INCLUSIVE) {
                this.lexer.nextToken();
                greenplumPartitionElementExpr.setStartInclusive(true);
            }
            if (this.lexer.token() == Token.EXCLUSIVE) {
                this.lexer.nextToken();
                greenplumPartitionElementExpr.setStartExclusive(true);
            }
            isNull = true;
        }
        if (this.lexer.token() == Token.END) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            greenplumPartitionElementExpr.setEndValue(this.exprParser.primary());
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.INCLUSIVE) {
                this.lexer.nextToken();
                greenplumPartitionElementExpr.setEndInclusive(true);
            }
            if (this.lexer.token() == Token.EXCLUSIVE) {
                this.lexer.nextToken();
                greenplumPartitionElementExpr.setEndExclusive(true);
            }
            isNull = true;
        }
        if (this.lexer.token() == Token.EVERY) {
            return null;
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            ArrayList<SQLAssignItem> sqlAssignItems = Lists.newArrayList();
            this.exprParser.parseAssignItem(sqlAssignItems, greenplumPartitionElementExpr);
            greenplumPartitionElementExpr.setWithProperties(sqlAssignItems);
            isNull = true;
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            this.lexer.nextToken();
            greenplumPartitionElementExpr.setTablespace(this.exprParser.expr());
            isNull = true;
        }
        if (!isNull) {
            return null;
        }
        return greenplumPartitionElementExpr;
    }

    private GreenplumSubpartitionElementExpr parseSubpartitionElementExpr() {
        boolean isNull = false;
        GreenplumSubpartitionElementExpr greenplumSubpartitionElementExpr = new GreenplumSubpartitionElementExpr();
        if (this.lexer.token() == Token.DEFAULT) {
            greenplumSubpartitionElementExpr.setDefault(true);
            this.lexer.nextToken();
            this.accept(Token.SUBPARTITION);
            greenplumSubpartitionElementExpr.setSubpartitionName(this.exprParser.expr());
            isNull = true;
        }
        if (this.lexer.token() == Token.SUBPARTITION) {
            this.lexer.nextToken();
            greenplumSubpartitionElementExpr.setSubpartitionName(this.exprParser.expr());
            isNull = true;
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            ArrayList<SQLExpr> sqlExprs = Lists.newArrayList();
            this.exprParser.exprList(sqlExprs, greenplumSubpartitionElementExpr);
            this.accept(Token.RPAREN);
            greenplumSubpartitionElementExpr.setValues(sqlExprs);
            isNull = true;
        }
        if (this.lexer.token() == Token.START) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            greenplumSubpartitionElementExpr.setStartValue(this.exprParser.primary());
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.INCLUSIVE) {
                this.lexer.nextToken();
                greenplumSubpartitionElementExpr.setStartInclusive(true);
            }
            if (this.lexer.token() == Token.EXCLUSIVE) {
                this.lexer.nextToken();
                greenplumSubpartitionElementExpr.setStartExclusive(true);
            }
            isNull = true;
        }
        if (this.lexer.token() == Token.END) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            greenplumSubpartitionElementExpr.setEndValue(this.exprParser.primary());
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.INCLUSIVE) {
                this.lexer.nextToken();
                greenplumSubpartitionElementExpr.setEndInclusive(true);
            }
            if (this.lexer.token() == Token.EXCLUSIVE) {
                this.lexer.nextToken();
                greenplumSubpartitionElementExpr.setEndExclusive(true);
            }
            isNull = true;
        }
        if (this.lexer.token() == Token.EVERY) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            greenplumSubpartitionElementExpr.setEveryValue(this.exprParser.primary());
            this.accept(Token.RPAREN);
            isNull = true;
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            ArrayList<SQLAssignItem> sqlAssignItems = Lists.newArrayList();
            this.exprParser.parseAssignItem(sqlAssignItems, greenplumSubpartitionElementExpr);
            greenplumSubpartitionElementExpr.setWithProperties(sqlAssignItems);
            isNull = true;
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            this.lexer.nextToken();
            greenplumSubpartitionElementExpr.setTablespace(this.exprParser.expr());
            isNull = true;
        }
        if (!isNull) {
            return null;
        }
        return greenplumSubpartitionElementExpr;
    }

    @Override
    public SQLStatement parseRollback() {
        this.lexer.nextToken();
        GreenplumRollbackStatement rollbackStatement = new GreenplumRollbackStatement();
        rollbackStatement.setDbType(this.dbType);
        if (this.lexer.identifierEquals("work")) {
            this.lexer.nextToken();
            rollbackStatement.setWork(true);
        }
        if (this.lexer.identifierEquals("transaction")) {
            this.lexer.nextToken();
            rollbackStatement.setTransaction(true);
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("savepoint")) {
                this.lexer.nextToken();
                rollbackStatement.setSavepoint(true);
                rollbackStatement.setToSavePoint(this.exprParser.expr());
            }
        }
        return rollbackStatement;
    }

    @Override
    public SQLStatement parseCreateDatabase() {
        SQLAssignItem owner;
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.DATABASE) {
            this.accept(Token.DATABASE);
        }
        SQLCreateDatabaseStatement stmt = new SQLCreateDatabaseStatement(this.dbType);
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("OWNER");
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            owner = new SQLAssignItem(new SQLIdentifierExpr("owner"), this.exprParser.expr());
            stmt.getDbProperties().add(owner);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.OWNER)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            owner = new SQLAssignItem(new SQLIdentifierExpr("OWNER"), this.exprParser.expr());
            stmt.getDbProperties().add(owner);
        }
        if (this.lexer.identifierEquals("TEMPLATE")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLAssignItem template = new SQLAssignItem(new SQLIdentifierExpr("TEMPLATE"), this.exprParser.expr());
            stmt.getDbProperties().add(template);
        }
        if (this.lexer.token() == Token.ENCODING) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLAssignItem encoding = new SQLAssignItem(new SQLIdentifierExpr("ENCODING"), this.exprParser.expr());
            stmt.getDbProperties().add(encoding);
        }
        if (this.lexer.identifierEquals("LC_COLLATE")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLAssignItem lc_collate = new SQLAssignItem(new SQLIdentifierExpr("LC_COLLATE"), this.exprParser.expr());
            stmt.getDbProperties().add(lc_collate);
        }
        if (this.lexer.identifierEquals("LC_TYPE")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLAssignItem lc_type = new SQLAssignItem(new SQLIdentifierExpr("LC_TYPE"), this.exprParser.expr());
            stmt.getDbProperties().add(lc_type);
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLAssignItem tablespace = new SQLAssignItem(new SQLIdentifierExpr("TABLESPACE"), this.exprParser.expr());
            stmt.getDbProperties().add(tablespace);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CONNECTION)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLAssignItem connection_limit = new SQLAssignItem(new SQLIdentifierExpr("CONNECTION LIMIT"), this.exprParser.expr());
            stmt.getDbProperties().add(connection_limit);
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCreateRole() {
        this.accept(Token.CREATE);
        GreenplumCreateRoleStatement stmt = new GreenplumCreateRoleStatement(this.dbType);
        if (this.lexer.token() == Token.USER) {
            stmt.setCreateUser(true);
            this.lexer.nextToken();
        } else {
            this.acceptIdentifier("ROLE");
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
        }
        this.parseRoleOption(stmt);
        return stmt;
    }

    @Override
    public SQLStatement parseCreateUser() {
        return this.parseCreateRole();
    }

    private void parseRoleOption(GreenplumCreateRoleStatement createRoleStmt) {
        List<SQLExpr> options = createRoleStmt.getOptions();
        SQLIdentifierExpr option = null;
        if (this.lexer.identifierEquals("SUPERUSER") || this.lexer.identifierEquals("NOSUPERUSER") || this.lexer.identifierEquals("CREATEDB") || this.lexer.identifierEquals("NOCREATEDB") || this.lexer.identifierEquals("CREATEROLE") || this.lexer.identifierEquals("NOCREATEROLE") || this.lexer.identifierEquals("CREATEEXTTABLE") || this.lexer.identifierEquals("NOCREATEEXTTABLE") || this.lexer.identifierEquals("INHERIT") || this.lexer.identifierEquals("NOINHERIT") || this.lexer.identifierEquals("LOGIN") || this.lexer.identifierEquals("NOLOGIN") || this.lexer.identifierEquals("REPLICATION") || this.lexer.identifierEquals("NOREPLICATION")) {
            option = new SQLIdentifierExpr(this.lexer.stringVal());
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals("CONNECTION")) {
            this.lexer.nextToken();
            this.acceptIdentifier("LIMIT");
            createRoleStmt.setConnectionLimit(this.exprParser.integerExpr());
        } else if (this.lexer.identifierEquals("ENCRYPTED") || this.lexer.identifierEquals("UNENCRYPTED") || this.lexer.identifierEquals("PASSWORD")) {
            if (this.lexer.identifierEquals("ENCRYPTED")) {
                createRoleStmt.setEncrypted(true);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("UNENCRYPTED")) {
                createRoleStmt.setUnencrypted(true);
                this.lexer.nextToken();
            }
            this.acceptIdentifier("PASSWORD");
            createRoleStmt.setPassword(this.exprParser.charExpr());
        } else if (this.lexer.identifierEquals("VALID")) {
            this.lexer.nextToken();
            this.accept(Token.UNTIL);
            createRoleStmt.setValidUntilTime(this.exprParser.charExpr());
        } else if (this.lexer.token() == Token.IN) {
            this.lexer.nextToken();
            this.acceptIdentifier("ROLE");
            this.exprParser.exprList(createRoleStmt.getInRoleRoleNames(), createRoleStmt);
        } else if (this.lexer.identifierEquals("ROLE")) {
            this.lexer.nextToken();
            this.exprParser.exprList(createRoleStmt.getRoleRoleNames(), createRoleStmt);
        } else if (this.lexer.identifierEquals("ADMIN")) {
            this.lexer.nextToken();
            this.exprParser.exprList(createRoleStmt.getAdminRoleNames(), createRoleStmt);
        } else if (this.lexer.token() == Token.USER) {
            this.lexer.nextToken();
            this.exprParser.exprList(createRoleStmt.getUserRoleNames(), createRoleStmt);
        } else if (this.lexer.identifierEquals("SYSID")) {
            this.lexer.nextToken();
            this.exprParser.exprList(createRoleStmt.getSysId(), createRoleStmt);
        } else {
            if (this.lexer.identifierEquals("RESOURCE")) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("QUEUE")) {
                    this.lexer.nextToken();
                    createRoleStmt.setResourceQueueName(this.exprParser.expr());
                } else if (this.lexer.token() == Token.GROUP) {
                    this.lexer.nextToken();
                    createRoleStmt.setResourceGroupName(this.exprParser.expr());
                }
                return;
            }
            return;
        }
        if (option != null) {
            options.add(option);
        }
        this.parseRoleOption(createRoleStmt);
    }

    @Override
    protected SQLDropTableStatement parseDropTable(boolean acceptDrop) {
        SQLDropTableStatement stmt = super.parseDropTable(acceptDrop);
        if (this.lexer.token() == Token.CASCADE) {
            this.lexer.nextToken();
            stmt.setCascade(true);
        } else if (this.lexer.token() == Token.RESTRICT) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        }
        return stmt;
    }

    @Override
    public SQLStatement parseDropIndex() {
        GreenplumDropIndexStatement stmt = new GreenplumDropIndexStatement(this.getDbType());
        this.accept(Token.INDEX);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addIndex(name);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.CASCADE) {
            this.lexer.nextToken();
            stmt.setCascade(true);
        } else if (this.lexer.token() == Token.RESTRICT) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        }
        return stmt;
    }

    @Override
    protected SQLStatement parseDropRole() {
        GreenplumDropRoleStatement stmt = new GreenplumDropRoleStatement(this.getDbType());
        this.accept(Token.DROP);
        this.acceptIdentifier("ROLE");
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addRole(name);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    protected SQLDropDatabaseStatement parseDropDatabase(boolean acceptDrop) {
        Lexer.SavePoint mark = this.lexer.mark();
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        GreenplumDropSchemaStatement stmt = new GreenplumDropSchemaStatement(this.getDbType());
        if (this.lexer.token() == Token.DATABASE) {
            return super.parseDropDatabase(acceptDrop);
        }
        this.accept(Token.SCHEMA);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addSchema(name);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.CASCADE) {
            this.lexer.nextToken();
            stmt.setCascade(true);
        } else if (this.lexer.token() == Token.RESTRICT) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        }
        return stmt;
    }

    @Override
    protected SQLDropSequenceStatement parseDropSequence(boolean acceptDrop) {
        GreenplumDropSequenceStatement stmt = new GreenplumDropSequenceStatement(this.getDbType());
        this.accept(Token.SEQUENCE);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addSequence(name);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.CASCADE) {
            this.lexer.nextToken();
            stmt.setCascade(true);
        } else if (this.lexer.token() == Token.RESTRICT) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        }
        return stmt;
    }

    @Override
    protected SQLDropViewStatement parseDropView(boolean acceptDrop) {
        SQLDropViewStatement stmt = super.parseDropView(acceptDrop);
        if (this.lexer.token() == Token.CASCADE) {
            this.lexer.nextToken();
            stmt.setCascade(true);
        } else if (this.lexer.token() == Token.RESTRICT) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        }
        return stmt;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.BEGIN) {
            GreenplumStartTransactionStatement stmt = this.parseGreenplumBegin();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("CHECKPOINT")) {
            GreenplumCheckPointStatement stmt = new GreenplumCheckPointStatement();
            statementList.add(stmt);
            this.lexer.nextToken();
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTER)) {
            GreenplumClusterStatement stmt = this.parseCluster();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("DEALLOCATE")) {
            GreenplumDeallocateStatement stmt = this.parseDeallocate();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("END")) {
            GreenplumEndTransactionStatement stmt = this.parseEnd();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("LOAD")) {
            GreenplumLoadStatement stmt = this.parseLoad();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("MOVE")) {
            GreenplumMoveStatement stmt = this.parseMove();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("REINDEX")) {
            GreenplumReindexStatement stmt = this.parseReindex();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("REASSIGN")) {
            GreenplumReassignOwnedStatement stmt = this.parseReassign();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("PREPARE")) {
            GreenplumPrepareStatement stmt = this.parsePrepare();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.LOCK) {
            GreenplumLockStatement stmt = this.parseLock();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("EXECUTE")) {
            GreenplumExecuteStatement stmt = this.parseExecute();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.HINT) {
            List<SQLCommentHint> hints = this.exprParser.parseHints();
            SQLStatement stmt = this.parseStatement();
            stmt.setHeadHints(hints);
            statementList.add(stmt);
            return true;
        }
        return super.parseStatementListDialect(statementList);
    }

    private GreenplumLockStatement parseLock() {
        this.accept(Token.LOCK);
        GreenplumLockStatement stmt = new GreenplumLockStatement();
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            stmt.setPrintTable(true);
        }
        if (this.lexer.token() == Token.ONLY) {
            this.lexer.nextToken();
            stmt.setOnly(true);
        }
        stmt.getTableNames().add(this.exprParser.name());
        while (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            stmt.getTableNames().add(this.exprParser.name());
        }
        if (this.lexer.token() == Token.IN) {
            this.lexer.nextToken();
            this.parseLockMode(stmt);
            this.acceptIdentifier("MODE");
        }
        if (this.lexer.token() == Token.NOWAIT || this.lexer.identifierEquals("NOWAIT")) {
            this.lexer.nextToken();
            stmt.setNowait(true);
        }
        return stmt;
    }

    private void parseLockMode(GreenplumLockStatement stmt) {
        if (this.lexer.token() == Token.ACCESS || this.lexer.identifierEquals("ACCESS")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SHARE) {
                this.lexer.nextToken();
                stmt.setLockMode(GreenplumLockStatement.LockMode.ACCESS_SHARE);
            } else if (this.lexer.token() == Token.EXCLUSIVE) {
                this.lexer.nextToken();
                stmt.setLockMode(GreenplumLockStatement.LockMode.ACCESS_EXCLUSIVE);
            }
        } else if (this.lexer.token() == Token.ROW) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SHARE) {
                this.lexer.nextToken();
                stmt.setLockMode(GreenplumLockStatement.LockMode.ROW_SHARE);
            } else if (this.lexer.token() == Token.EXCLUSIVE) {
                this.lexer.nextToken();
                stmt.setLockMode(GreenplumLockStatement.LockMode.ROW_EXCLUSIVE);
            }
        } else if (this.lexer.token() == Token.SHARE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.UPDATE) {
                this.lexer.nextToken();
                this.accept(Token.EXCLUSIVE);
                stmt.setLockMode(GreenplumLockStatement.LockMode.SHARE_UPDATE_EXCLUSIVE);
            } else if (this.lexer.token() == Token.ROW) {
                this.lexer.nextToken();
                this.accept(Token.EXCLUSIVE);
                stmt.setLockMode(GreenplumLockStatement.LockMode.SHARE_ROW_EXCLUSIVE);
            } else {
                stmt.setLockMode(GreenplumLockStatement.LockMode.SHARE);
            }
        } else if (this.lexer.token() == Token.EXCLUSIVE) {
            this.lexer.nextToken();
            stmt.setLockMode(GreenplumLockStatement.LockMode.EXCLUSIVE);
        }
    }

    private GreenplumPrepareStatement parsePrepare() {
        this.acceptIdentifier("PREPARE");
        GreenplumPrepareStatement stmt = new GreenplumPrepareStatement();
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            List<SQLDataType> types = stmt.getTypes();
            types.add(this.exprParser.parseDataType());
            while (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                types.add(this.exprParser.parseDataType());
            }
            this.accept(Token.RPAREN);
        }
        this.accept(Token.AS);
        if (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.INSERT || this.lexer.token() == Token.UPDATE || this.lexer.token() == Token.DELETE || this.lexer.token() == Token.VALUES) {
            stmt.setAsStatement(this.parseStatement());
        }
        return stmt;
    }

    private GreenplumReassignOwnedStatement parseReassign() {
        this.acceptIdentifier("REASSIGN");
        this.acceptIdentifier("OWNED");
        this.accept(Token.BY);
        GreenplumReassignOwnedStatement stmt = new GreenplumReassignOwnedStatement();
        this.exprParser.exprList(stmt.getOldRoles(), stmt);
        this.accept(Token.TO);
        stmt.setNewRole(this.exprParser.expr());
        return stmt;
    }

    private GreenplumReindexStatement parseReindex() {
        this.acceptIdentifier("REINDEX");
        GreenplumReindexStatement stmt = new GreenplumReindexStatement();
        if (this.lexer.token() == Token.INDEX || this.lexer.token() == Token.TABLE || this.lexer.token() == Token.DATABASE || this.lexer.identifierEquals("SYSTEM")) {
            stmt.setType(this.exprParser.expr());
        }
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    private GreenplumMoveStatement parseMove() {
        this.acceptIdentifier("MOVE");
        GreenplumMoveStatement stmt = new GreenplumMoveStatement();
        if (this.lexer.identifierEquals("LAST") || this.lexer.token() == Token.NEXT || this.lexer.token() == Token.FIRST || this.lexer.token() == Token.ALL) {
            String name = this.lexer.stringVal();
            stmt.setForwardDirection(new SQLIdentifierExpr(name));
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals("ABSOLUTE") || this.lexer.identifierEquals("RELATIVE")) {
            String name = this.lexer.stringVal();
            stmt.setForwardDirection(new SQLIdentifierExpr(name));
            this.lexer.nextToken();
            stmt.setCount(this.exprParser.expr());
        } else if (this.lexer.identifierEquals("FORWARD")) {
            String name = this.lexer.stringVal();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.ALL) {
                String all = this.lexer.stringVal();
                name = name + " " + all;
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.LITERAL_INT) {
                stmt.setCount(this.exprParser.integerExpr());
            }
            stmt.setForwardDirection(new SQLIdentifierExpr(name));
        } else if (this.lexer.token() == Token.LITERAL_INT) {
            stmt.setCount(this.exprParser.integerExpr());
        }
        if (stmt.getForwardDirection() != null || stmt.getCount() != null) {
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setFrom(true);
            } else if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setIn(true);
            }
        }
        stmt.setCursorName(this.exprParser.name());
        return stmt;
    }

    private GreenplumLoadStatement parseLoad() {
        this.acceptIdentifier("LOAD");
        GreenplumLoadStatement stmt = new GreenplumLoadStatement();
        SQLCharExpr sqlCharExpr = this.exprParser.charExpr();
        stmt.setFileName(sqlCharExpr);
        return stmt;
    }

    private GreenplumEndTransactionStatement parseEnd() {
        GreenplumEndTransactionStatement stmt = new GreenplumEndTransactionStatement();
        this.accept(Token.END);
        if (this.lexer.identifierEquals("WORK")) {
            stmt.setWork(true);
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals("TRANSACTION")) {
            stmt.setTransaction(true);
            this.lexer.nextToken();
        }
        return stmt;
    }

    private GreenplumDeallocateStatement parseDeallocate() {
        GreenplumDeallocateStatement stmt = new GreenplumDeallocateStatement();
        this.acceptIdentifier("DEALLOCATE");
        if (this.lexer.identifierEquals("PREPARE")) {
            stmt.setPrepare(true);
            this.lexer.nextToken();
        }
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    private GreenplumClusterStatement parseCluster() {
        GreenplumClusterStatement stmt = new GreenplumClusterStatement();
        this.acceptIdentifier("CLUSTER");
        if (this.lexer.token() == Token.IDENTIFIER) {
            SQLName name = this.exprParser.name();
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                stmt.setIndexName(name);
                name = this.exprParser.name();
            }
            stmt.setTableName(name);
        }
        return stmt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GreenplumStartTransactionStatement parseGreenplumBegin() {
        this.accept(Token.BEGIN);
        GreenplumStartTransactionStatement stmt = new GreenplumStartTransactionStatement();
        if (this.lexer.identifierEquals("WORK")) {
            this.lexer.nextToken();
            stmt.setWork(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.TRANSACTION)) {
            this.lexer.nextToken();
            stmt.setTransaction(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ISOLATION)) {
            this.lexer.nextToken();
            this.acceptIdentifier("LEVEL");
            if (this.lexer.identifierEquals(FnvHash.Constants.READ)) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.UNCOMMITTED)) {
                    this.lexer.nextToken();
                    stmt.setIsolationLevel(SQLStartTransactionStatement.IsolationLevel.READ_UNCOMMITTED);
                } else {
                    if (!this.lexer.identifierEquals(FnvHash.Constants.COMMITTED)) throw new ParserException(this.lexer.info());
                    this.lexer.nextToken();
                    stmt.setIsolationLevel(SQLStartTransactionStatement.IsolationLevel.READ_COMMITTED);
                }
            } else if (this.lexer.identifierEquals(FnvHash.Constants.REPEATABLE)) {
                this.lexer.nextToken();
                this.acceptIdentifier("READ");
                stmt.setIsolationLevel(SQLStartTransactionStatement.IsolationLevel.REPEATABLE_READ);
            } else {
                if (!this.lexer.identifierEquals(FnvHash.Constants.SERIALIZABLE)) throw new ParserException(this.lexer.info());
                this.lexer.nextToken();
                stmt.setIsolationLevel(SQLStartTransactionStatement.IsolationLevel.SERIALIZABLE);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.READ)) {
            this.lexer.nextToken();
            this.accept(Token.ONLY);
            stmt.setReadOnly(true);
            return stmt;
        } else {
            if (!this.lexer.identifierEquals("WRITE")) return stmt;
            this.lexer.nextToken();
            this.accept(Token.ONLY);
            stmt.setReadOnly(true);
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCommit() {
        this.acceptIdentifier("COMMIT");
        GreenplumCommitStatement stmt = new GreenplumCommitStatement();
        if (this.lexer.identifierEquals("WORK")) {
            this.lexer.nextToken();
            stmt.setWork(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.TRANSACTION)) {
            this.lexer.nextToken();
            stmt.setTransaction(true);
        }
        return stmt;
    }

    @Override
    public SQLStatement parseDeclare() {
        this.accept(Token.DECLARE);
        GreenplumDeclareStatement stmt = new GreenplumDeclareStatement();
        stmt.setName(this.exprParser.name());
        if (this.lexer.identifierEquals("BINARY")) {
            this.lexer.nextToken();
            stmt.setBinary(true);
        }
        if (this.lexer.identifierEquals("INSENSITIVE")) {
            this.lexer.nextToken();
            stmt.setInsensitive(true);
        }
        if (this.lexer.identifierEquals("NO")) {
            this.lexer.nextToken();
            this.acceptIdentifier("SCROLL");
            stmt.setNoScroll(true);
        }
        this.accept(Token.CURSOR);
        if (this.lexer.token() == Token.WITH || this.lexer.token() == Token.WITHOUT) {
            Token token = this.lexer.token();
            this.lexer.nextToken();
            this.acceptIdentifier("HOLD");
            if (token == Token.WITH) {
                stmt.setWithHold(true);
            } else {
                stmt.setWithHold(true);
            }
        }
        this.accept(Token.FOR);
        if (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.VALUES) {
            stmt.setQuery(this.parseStatement());
        }
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            this.acceptIdentifier("READ");
            this.accept(Token.ONLY);
            stmt.setReadOnly(true);
        }
        return stmt;
    }

    @Override
    public SQLExplainStatement parseExplain() {
        this.accept(Token.EXPLAIN);
        if (this.lexer.identifierEquals("PLAN")) {
            this.lexer.nextToken();
        }
        SQLExplainStatement explain = new SQLExplainStatement(this.dbType);
        if (this.lexer.token() == Token.ANALYZE || this.lexer.identifierEquals("ANALYZE")) {
            explain.setType(this.lexer.stringVal());
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals("VERBOSE")) {
            this.lexer.nextToken();
            explain.setType("VERBOSE");
        } else if (this.lexer.token() == Token.LPAREN) {
            // empty if block
        }
        explain.setStatement(this.parseStatement());
        return explain;
    }

    @Override
    public SQLFetchStatement parseFetch() {
        this.accept(Token.FETCH);
        GreenplumFetchStatement stmt = new GreenplumFetchStatement();
        if (this.lexer.identifierEquals("LAST") || this.lexer.token() == Token.NEXT || this.lexer.token() == Token.FIRST || this.lexer.token() == Token.ALL) {
            String name = this.lexer.stringVal();
            stmt.setForwardDirection(new SQLIdentifierExpr(name));
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals("ABSOLUTE") || this.lexer.identifierEquals("RELATIVE")) {
            String name = this.lexer.stringVal();
            stmt.setForwardDirection(new SQLIdentifierExpr(name));
            this.lexer.nextToken();
            stmt.setCount(this.exprParser.expr());
        } else if (this.lexer.identifierEquals("FORWARD")) {
            String name = this.lexer.stringVal();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.ALL) {
                String all = this.lexer.stringVal();
                name = name + all;
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.LITERAL_INT) {
                stmt.setCount(this.exprParser.integerExpr());
            }
        } else if (this.lexer.token() == Token.LITERAL_INT) {
            stmt.setCount(this.exprParser.integerExpr());
        }
        if (stmt.getForwardDirection() != null || stmt.getCount() != null) {
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setFrom(true);
            } else if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setIn(true);
            }
        }
        stmt.setCursorName(this.exprParser.name());
        return stmt;
    }

    @Override
    public SQLStatement parseShow() {
        GreenplumShowStatement showStatement = new GreenplumShowStatement();
        showStatement.setDbType(this.dbType);
        this.accept(Token.SHOW);
        if (this.lexer.token() == Token.ALL) {
            this.lexer.nextToken();
            showStatement.setAll(true);
        } else {
            showStatement.setValue(this.exprParser.expr());
        }
        return showStatement;
    }

    @Override
    public SQLStatement parseCreate() {
        char markChar = this.lexer.current();
        int markBp = this.lexer.bp();
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        this.accept(Token.CREATE);
        boolean global = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.GLOBAL)) {
            this.lexer.nextToken();
            global = true;
        }
        boolean temporary = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.TEMPORARY) || this.lexer.token() == Token.TEMPORARY || this.lexer.token() == Token.TEMP) {
            this.lexer.nextToken();
            temporary = true;
        }
        boolean nonclustered = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.NONCLUSTERED)) {
            this.lexer.nextToken();
            nonclustered = true;
        }
        Token token = this.lexer.token();
        switch (this.lexer.token()) {
            case TABLE: {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                SQLCreateTableParser createTableParser = this.getSQLCreateTableParser();
                SQLCreateTableStatement stmt = createTableParser.parseCreateTable();
                if (temporary) {
                    if (global) {
                        stmt.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
                    } else {
                        stmt.setType(SQLCreateTableStatement.Type.TEMPORARY);
                    }
                }
                if (comments != null) {
                    stmt.addBeforeComment(comments);
                }
                return stmt;
            }
            case INDEX: 
            case UNIQUE: {
                SQLCreateIndexStatement createIndex = this.parseCreateIndex(false);
                if (nonclustered) {
                    createIndex.setType("NONCLUSTERED");
                }
                return createIndex;
            }
            case SEQUENCE: {
                return this.parseCreateSequence(false);
            }
            case DATABASE: {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("LINK")) {
                    this.lexer.reset(markBp, markChar, Token.CREATE);
                    return this.parseCreateDbLink();
                }
                this.lexer.reset(markBp, markChar, Token.CREATE);
                SQLStatement stmt = this.parseCreateDatabase();
                if (comments != null) {
                    stmt.addBeforeComment(comments);
                    comments = null;
                }
                return stmt;
            }
            case SCHEMA: {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("LINK")) {
                    this.lexer.reset(markBp, markChar, Token.CREATE);
                    return this.parseCreateDbLink();
                }
                this.lexer.reset(markBp, markChar, Token.CREATE);
                SQLStatement stmt = this.parseCreateSchema();
                if (comments != null) {
                    stmt.addBeforeComment(comments);
                    comments = null;
                }
                return stmt;
            }
            case USER: {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateUser();
            }
            case FUNCTION: {
                SQLCreateFunctionStatement createFunct;
                this.lexer.reset(markBp, markChar, Token.CREATE);
                SQLCreateFunctionStatement stmt = createFunct = this.parseCreateFunction();
                return stmt;
            }
        }
        if (token == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.PROCEDURE) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateProcedure();
            }
            if (this.lexer.token() == Token.VIEW) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateView();
            }
            if (this.lexer.token() == Token.TRIGGER) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateTrigger();
            }
            if (this.lexer.token() == Token.FUNCTION) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateFunction();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.PACKAGE)) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreatePackage();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TYPE)) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateType();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.PUBLIC)) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateSynonym();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SYNONYM)) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateSynonym();
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PUBLIC)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("SYNONYM")) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateSynonym();
            }
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateDbLink();
        }
        if (this.lexer.identifierEquals("SHARE")) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateDbLink();
        }
        if (this.lexer.identifierEquals("SYNONYM")) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateSynonym();
        }
        if (token == Token.VIEW) {
            return this.parseCreateView();
        }
        if (token == Token.TRIGGER) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateTrigger();
        }
        if (token == Token.PROCEDURE) {
            SQLCreateProcedureStatement stmt = this.parseCreateProcedure();
            stmt.setCreate(true);
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.BITMAP)) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateIndex(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.MATERIALIZED)) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateMaterializedView();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TYPE)) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateType();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            SQLCreateTableStatement createTable = this.parseCreateTable();
            if (comments != null) {
                createTable.addBeforeComment(comments);
                comments = null;
            }
            return createTable;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TABLEGROUP)) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateTableGroup();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DIMENSION)) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateTable();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ROLE)) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateRole();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RESOURCE)) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateResourceGroup();
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    public void parseStatementList(List<SQLStatement> statementList, int max, SQLObject parent) {
        if (this.lexer.token() == Token.END) {
            int startLine = this.lexer.getPosLine();
            int startCol = this.lexer.getPosColumn();
            GreenplumEndTransactionStatement stmt = this.parseEnd();
            this.addToStatementList(statementList, stmt, startLine, startCol);
        }
        super.parseStatementList(statementList, max, parent);
    }

    private GreenplumExecuteStatement parseExecute() {
        GreenplumExecuteStatement stmt = new GreenplumExecuteStatement();
        this.lexer.nextToken();
        stmt.setStatementName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getParameters(), stmt);
            this.accept(Token.RPAREN);
        }
        return stmt;
    }

    @Override
    protected SQLStatement parseVacuum() {
        GreenplumVacuumStatement.VacuumParameterEnum parameter;
        GreenplumVacuumStatement stmt = new GreenplumVacuumStatement();
        this.lexer.nextToken();
        ArrayList<GreenplumVacuumStatement.VacuumParameterEnum> parameters = new ArrayList<GreenplumVacuumStatement.VacuumParameterEnum>();
        if (this.lexer.token() == Token.LPAREN) {
            stmt.setInBrackets(true);
            this.lexer.nextToken();
            while (true) {
                if ((parameter = this.parseVacuumParameter()) == null) {
                    throw new ParserException("syntax error. " + (Object)((Object)this.lexer.token()), this.lexer.getPosLine(), this.lexer.getPosColumn());
                }
                parameters.add(parameter);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        } else {
            while ((parameter = this.parseVacuumParameter()) != null) {
                parameters.add(parameter);
            }
        }
        stmt.setParameters(parameters);
        while (this.lexer.token() != Token.EOF && this.lexer.token() != Token.SEMI) {
            SQLTableSource tableSource = this.createSQLSelectParser().parseTableSource();
            stmt.addTableSource(tableSource);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    private GreenplumVacuumStatement.VacuumParameterEnum parseVacuumParameter() {
        GreenplumVacuumStatement.VacuumParameterEnum parameter;
        if (this.lexer.token() == Token.FULL) {
            parameter = GreenplumVacuumStatement.VacuumParameterEnum.FULL;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.FREEZE)) {
            parameter = GreenplumVacuumStatement.VacuumParameterEnum.FREEZE;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.VERBOSE)) {
            parameter = GreenplumVacuumStatement.VacuumParameterEnum.VERBOSE;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.ANALYZE)) {
            parameter = GreenplumVacuumStatement.VacuumParameterEnum.ANALYZE;
        } else {
            return null;
        }
        this.lexer.nextToken();
        return parameter;
    }

    @Override
    public SQLCreateIndexStatement parseCreateIndex(boolean acceptCreate) {
        SQLCreateIndexStatement createIndexStatement = super.parseCreateIndex(acceptCreate);
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            createIndexStatement.setWhere(this.exprParser.expr());
        }
        return createIndexStatement;
    }
}

