/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.greenplum.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.dialect.postgresql.parser.PGLexer;
import com.alibaba.fastsql.sql.parser.Keywords;
import com.alibaba.fastsql.sql.parser.NotAllowCommentException;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.Token;
import java.util.HashMap;

public class GreenplumLexer
extends PGLexer {
    public static final Keywords DEFAULT_GP_KEYWORDS;

    public GreenplumLexer(String input) {
        super(input, new SQLParserFeature[0]);
        this.keywods = DEFAULT_GP_KEYWORDS;
        this.dbType = DbType.greenplum;
    }

    @Override
    public void scanComment() {
        if (!this.isAllowComment()) {
            throw new NotAllowCommentException();
        }
        if (this.ch == '/' && this.charAt(this.pos + 1) == '*' && this.charAt(this.pos + 2) == '+') {
            this.scanHint();
        } else {
            super.scanComment();
        }
    }

    private void scanHint() {
        Token lastToken = this.token;
        int depth = 1;
        this.scanChar();
        this.scanChar();
        this.mark = this.pos;
        this.bufPos = 0;
        while (true) {
            if (this.ch == '/' && this.charAt(this.pos + 1) == '*') {
                this.scanChar();
                this.scanChar();
                ++depth;
                this.bufPos += 2;
            }
            if (this.ch == '*' && this.charAt(this.pos + 1) == '/') {
                this.scanChar();
                this.scanChar();
                if (0 == --depth) break;
                this.bufPos += 2;
            }
            if (this.ch == '\u001a') {
                throw new ParserException("unterminated /* comment. " + this.info(), this.posLine, this.posColumn);
            }
            this.scanChar();
            ++this.bufPos;
        }
        this.stringVal = this.subString(this.mark, this.bufPos);
        this.token = Token.HINT;
        ++this.commentCount;
        if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
            return;
        }
        if (!this.isAllowComment() && !this.isSafeComment(this.stringVal)) {
            throw new NotAllowCommentException();
        }
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.putAll(PGLexer.DEFAULT_PG_KEYWORDS.getKeywords());
        map.put("DISTRIBUTED", Token.DISTRIBUTED);
        map.put("PARTITION", Token.PARTITION);
        map.put("~~", Token.TILDE_TILDE);
        map.put("!~~", Token.BANG_TILDE_TILDE);
        map.put("TEMP", Token.TEMP);
        map.put("TEMPORARY", Token.TEMPORARY);
        map.put("ENCODING", Token.ENCODING);
        map.put("~~*", Token.TILDE_TILDE_STAR);
        map.put("!~~*", Token.BANG_TILDE_TILDE_STAR);
        map.put("ADD", Token.ADD);
        map.put("RANDOMLY", Token.RANDOMLY);
        map.put("ENCODING", Token.ENCODING);
        map.put("STATISTICS", Token.STATISTICS);
        map.put("SUBPARTITION", Token.SUBPARTITION);
        map.put("INCLUSIVE", Token.INCLUSIVE);
        map.put("EXCLUSIVE", Token.EXCLUSIVE);
        map.put("RENAME", Token.RENAME);
        map.put("EVERY", Token.EVERY);
        map.put("SESSION", Token.SESSION);
        map.put("UNLOGGED", Token.UNLOGGED);
        DEFAULT_GP_KEYWORDS = new Keywords(map);
    }
}

