/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.greenplum.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLOrderingSpecification;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.expr.GreenplumDistinctFromExpr;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumColumnDefinition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumDataTypeInterval;
import com.alibaba.fastsql.sql.dialect.greenplum.parser.GreenplumLexer;
import com.alibaba.fastsql.sql.dialect.greenplum.parser.GreenplumSelectParser;
import com.alibaba.fastsql.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GreenplumExprParser
extends PGExprParser {
    public GreenplumExprParser(String sql, SQLParserFeature ... features) {
        super(new GreenplumLexer(sql));
        this.dbType = DbType.greenplum;
        this.lexer.nextToken();
    }

    public GreenplumExprParser(Lexer lexer) {
        super(lexer);
        this.dbType = DbType.greenplum;
    }

    @Override
    public SQLExpr exprRest(SQLExpr expr) {
        SQLExpr sqlExpr = super.exprRest(expr);
        sqlExpr = this.arrayColonExpr(sqlExpr);
        return super.primaryRest(sqlExpr);
    }

    @Override
    public SQLDataType parseDataType() {
        if (this.lexer.token() == Token.INTERVAL) {
            return this.parserIntervalDataType();
        }
        if (this.lexer.identifierEquals("bit") || this.lexer.identifierEquals("char")) {
            return this.parseVaryingDataType();
        }
        return super.parseDataType();
    }

    private SQLDataType parseVaryingDataType() {
        SQLDataType bigDataType = super.parseDataType();
        if (this.lexer.identifierEquals("varying")) {
            SQLDataType sqlDataType = super.parseDataType();
            sqlDataType.setName(bigDataType.getName() + " " + sqlDataType.getName());
            return sqlDataType;
        }
        return bigDataType;
    }

    @Override
    protected SQLExpr parseIsDistinctFrom() {
        this.accept(Token.IS);
        boolean isNot = false;
        if (this.lexer.token() == Token.NOT) {
            isNot = true;
            this.lexer.nextToken();
        }
        this.accept(Token.DISTINCT);
        this.accept(Token.FROM);
        SQLExpr sqlExpr = this.expr();
        return new GreenplumDistinctFromExpr(isNot, sqlExpr);
    }

    private GreenplumDataTypeInterval parserIntervalDataType() {
        this.accept(Token.INTERVAL);
        GreenplumDataTypeInterval interval = new GreenplumDataTypeInterval();
        if (this.lexer.token() != Token.IDENTIFIER) {
            return interval;
        }
        if (this.lexer.identifierEquals("YEAR")) {
            interval.setMainField(this.expr());
            this.parserIntervalDataTypeTo(interval, Collections.singletonList("MONTH"));
        } else if (this.lexer.identifierEquals("MONTH")) {
            interval.setMainField(this.expr());
        } else if (this.lexer.identifierEquals("DAY")) {
            interval.setMainField(this.expr());
            this.parserIntervalDataTypeTo(interval, Arrays.asList("HOUR", "MINUTE", "SECOND"));
        } else if (this.lexer.identifierEquals("HOUR")) {
            interval.setMainField(this.expr());
            this.parserIntervalDataTypeTo(interval, Arrays.asList("MINUTE", "SECOND"));
        } else if (this.lexer.identifierEquals("MINUTE")) {
            interval.setMainField(this.expr());
            this.parserIntervalDataTypeTo(interval, Collections.singletonList("SECOND"));
        } else if (this.lexer.identifierEquals("SECOND")) {
            interval.setMainField(this.expr());
            interval.setToSecond(true);
        } else {
            throw new ParserException("syntax error : " + this.lexer.info());
        }
        this.parserIntervalDataTypePecision(interval);
        return interval;
    }

    private void parserIntervalDataTypePecision(GreenplumDataTypeInterval interval) {
        if (this.lexer.token() != Token.LPAREN) {
            return;
        }
        if (!interval.isToSecond()) {
            throw new ParserException("syntax error : " + this.lexer.info());
        }
        this.accept(Token.LPAREN);
        interval.setPrecision(this.expr());
        this.accept(Token.RPAREN);
    }

    private void parserIntervalDataTypeTo(GreenplumDataTypeInterval interval, List<String> identifiers) {
        if (this.lexer.token() != Token.TO) {
            return;
        }
        this.accept(Token.TO);
        boolean identifierChecked = false;
        for (String identifier : identifiers) {
            identifierChecked = identifierChecked || this.lexer.identifierEquals(identifier);
        }
        if (!identifierChecked) {
            throw new ParserException("syntax error : " + this.lexer.info());
        }
        if (this.lexer.identifierEquals("SECOND")) {
            interval.setToSecond(true);
        }
        interval.setToField(this.expr());
    }

    @Override
    public GreenplumSelectParser createSelectParser() {
        return new GreenplumSelectParser(this);
    }

    @Override
    public SQLColumnDefinition parseColumn(SQLObject parent) {
        SQLColumnDefinition column = this.createColumnDefinition();
        column.setName(this.name());
        Token token = this.lexer.token();
        if (token == Token.TYPE && column instanceof GreenplumColumnDefinition) {
            ((GreenplumColumnDefinition)column).setType(true);
        }
        if (token != Token.SET && token != Token.DROP && token != Token.PRIMARY && token != Token.RPAREN && token != Token.COMMA) {
            column.setDataType(this.parseDataType());
        }
        SQLColumnDefinition sqlColumnDefinition = this.parseColumnRest(column);
        return this.parseEncodings(sqlColumnDefinition);
    }

    private SQLColumnDefinition parseEncodings(SQLColumnDefinition sqlColumnDefinition) {
        if (!(sqlColumnDefinition instanceof GreenplumColumnDefinition)) {
            return sqlColumnDefinition;
        }
        GreenplumColumnDefinition column = (GreenplumColumnDefinition)sqlColumnDefinition;
        if (this.lexer.token() != Token.ENCODING) {
            return column;
        }
        this.lexer.nextToken();
        this.accept(Token.LPAREN);
        while (true) {
            if (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.token() == Token.RPAREN) break;
            column.addEncodingOption(this.parseAssignItem());
        }
        this.accept(Token.RPAREN);
        return column;
    }

    @Override
    public SQLColumnDefinition createColumnDefinition() {
        GreenplumColumnDefinition column = new GreenplumColumnDefinition();
        column.setDbType(this.dbType);
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLSelectOrderByItem parseIndexColumn() {
        SQLSelectOrderByItem item = new SQLSelectOrderByItem();
        this.setAllowIdentifierMethod(false);
        try {
            SQLExpr expr;
            int startLine = this.lexer.getPosLine();
            int startCol = this.lexer.getPosColumn();
            if (this.lexer.token() == Token.LITERAL_ALIAS) {
                expr = this.name();
                expr = this.primaryRest(expr);
            } else {
                expr = this.expr();
            }
            if (this.isEnabled(SQLParserFeature.IgnoreNameQuotes) && expr instanceof SQLPropertyExpr) {
                String name;
                SQLPropertyExpr propertyExpr = (SQLPropertyExpr)expr;
                SQLExpr owner = propertyExpr.getOwner();
                if (owner != null) {
                    String ownerStr = SQLUtils.toSQLString(owner);
                    if (ownerStr.length() > 1) {
                        ownerStr = StringUtils.removeNameQuotes(ownerStr);
                    }
                    propertyExpr.setOwner(ownerStr);
                }
                if ((name = propertyExpr.getName()).length() > 1) {
                    name = StringUtils.removeNameQuotes(name);
                    propertyExpr.setName(name);
                }
                expr = propertyExpr;
            }
            expr.setStartLine(startLine);
            expr.setStartColumn(startCol);
            item.setExpr(expr);
        }
        finally {
            this.setAllowIdentifierMethod(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
            this.lexer.nextToken();
            String collate = this.lexer.stringVal();
            item.setCollate(collate);
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.IDENTIFIER && !this.lexer.identifierEquals(FnvHash.Constants.NULLS)) {
            item.setOpclass(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.ASC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.ASC);
        } else if (this.lexer.token() == Token.DESC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.DESC);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.NULLS)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.FIRST) || this.lexer.token() == Token.FIRST) {
                this.lexer.nextToken();
                item.setNullsOrderType(SQLSelectOrderByItem.NullsOrderType.NullsFirst);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.LAST)) {
                this.lexer.nextToken();
                item.setNullsOrderType(SQLSelectOrderByItem.NullsOrderType.NullsLast);
            } else {
                throw new ParserException("TODO " + this.lexer.info(), this.lexer.getPosLine(), this.lexer.getPosColumn());
            }
        }
        if (this.lexer.token() == Token.HINT) {
            item.setHint(this.parseHint());
        }
        return item;
    }
}

