/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.greenplum.parser;

import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLPartition;
import com.alibaba.fastsql.sql.ast.SQLPartitionBy;
import com.alibaba.fastsql.sql.ast.SQLPartitionValue;
import com.alibaba.fastsql.sql.ast.SQLSubPartition;
import com.alibaba.fastsql.sql.ast.SQLSubPartitionBy;
import com.alibaba.fastsql.sql.ast.SQLSubPartitionByList;
import com.alibaba.fastsql.sql.ast.SQLSubPartitionByRange;
import com.alibaba.fastsql.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLConstraint;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumColumnEncodingConstraint;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumPartition;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumPartitionBy;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumPartitionRangeValue;
import com.alibaba.fastsql.sql.dialect.greenplum.ast.stmt.GreenplumSubPartition;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLCreateTableParser;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.Pair;

public class GreenplumCreateTableParser
extends SQLCreateTableParser {
    public GreenplumCreateTableParser(String sql) {
        super(sql);
    }

    public GreenplumCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable(boolean acceptCreate) {
        GreenplumCreateTableStatement createTable = this.newCreateStatement();
        if (acceptCreate) {
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                createTable.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.CREATE);
        }
        if (this.lexer.identifierEquals("GLOBAL") || this.lexer.identifierEquals("LOCAL")) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.TEMPORARY || this.lexer.token() == Token.TEMP) {
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.LOCAL_TEMPORARY);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DIMENSION)) {
            this.lexer.nextToken();
            createTable.setDimension(true);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createTable.setIfNotExiists(true);
        }
        createTable.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LIKE) {
                this.parseCreateTableLike(createTable);
            } else {
                do {
                    SQLTableElement column;
                    Token token;
                    if ((token = this.lexer.token()) == Token.IDENTIFIER || token == Token.LITERAL_ALIAS) {
                        column = this.exprParser.parseColumn();
                        column.setParent(createTable);
                        createTable.getTableElementList().add(column);
                    } else if (token == Token.PRIMARY || token == Token.UNIQUE || token == Token.CHECK || token == Token.CONSTRAINT || token == Token.FOREIGN) {
                        SQLConstraint constraint = this.exprParser.parseConstaint();
                        constraint.setParent(createTable);
                        createTable.getTableElementList().add((SQLTableElement)((Object)constraint));
                    } else if (token == Token.DEFAULT || token == Token.COLUMN) {
                        column = this.parseColumnEncoding();
                        createTable.getTableElementList().add(column);
                    } else {
                        if (token == Token.TABLESPACE) {
                            throw new ParserException("TODO " + this.lexer.info());
                        }
                        if (token == Token.RPAREN) break;
                        column = this.exprParser.parseColumn();
                        createTable.getTableElementList().add(column);
                    }
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                } while (this.lexer.token() != Token.RPAREN);
            }
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals(FnvHash.Constants.INHERITS)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLName inherits = this.exprParser.name();
                List<SQLExprTableSource> inheritTables = createTable.getInheritTables();
                inheritTables.add(new SQLExprTableSource(inherits));
                this.parseInheritsRest(inheritTables);
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("oids")) {
                createTable.getTableOptions().add(new SQLAssignItem(new SQLIdentifierExpr("oids"), new SQLBooleanExpr(true)));
                this.lexer.nextToken();
            } else {
                this.accept(Token.LPAREN);
                this.parseAssignItems(createTable.getTableOptions(), createTable, false);
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            this.acceptIdentifier(Token.COMMIT.name());
            if (this.lexer.identifierEquals("PRESERVE")) {
                this.lexer.nextToken();
                this.accept(Token.ROWS);
                createTable.setOnCommitPreserveRows(true);
            } else if (this.lexer.token() == Token.DELETE) {
                this.lexer.nextToken();
                this.accept(Token.ROWS);
                createTable.setOnCommitDeleteRows(true);
            } else if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                createTable.setOnCommitDrop(true);
            } else {
                this.printError(Token.PRESERVE, Token.DELETE, Token.DROP);
            }
        }
        if (this.lexer.identifierEquals("without")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("oids")) {
                createTable.getTableOptions().add(new SQLAssignItem(new SQLIdentifierExpr("oids"), new SQLBooleanExpr(false)));
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            this.lexer.nextToken();
            createTable.setTablespace(this.exprParser.name());
        }
        boolean isCreateTableAs = false;
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            boolean lparen = false;
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                lparen = true;
            }
            this.parseAsQuery(createTable);
            if (lparen) {
                this.accept(Token.RPAREN);
            }
            for (SQLTableElement sqlTableElement : createTable.getTableElementList()) {
                SQLColumnDefinition columnDefinition = (SQLColumnDefinition)sqlTableElement;
                if (columnDefinition.getDataType() == null) continue;
                throw new ParserException("'create table as' not need column type. " + this.lexer.info());
            }
            isCreateTableAs = true;
        }
        if (!isCreateTableAs) {
            for (SQLTableElement sqlTableElement : createTable.getTableElementList()) {
                if (!(sqlTableElement instanceof SQLColumnDefinition) || ((SQLColumnDefinition)sqlTableElement).getDataType() != null) continue;
                throw new ParserException("create table need column type. " + this.lexer.info());
            }
        }
        if (this.lexer.token() == Token.DISTRIBUTED) {
            this.parseDistributed(createTable);
        }
        if (this.lexer.token() == Token.PARTITION) {
            createTable.setPartitioning(this.parsePartitionBy());
        }
        return createTable;
    }

    private List<GreenplumColumnEncodingConstraint> parseColumnEncodings() {
        ArrayList<GreenplumColumnEncodingConstraint> columns = Lists.newArrayList();
        while (this.lexer.token() == Token.DEFAULT || this.lexer.token() == Token.COLUMN) {
            columns.add((GreenplumColumnEncodingConstraint)this.parseColumnEncoding());
        }
        return columns;
    }

    private SQLTableElement parseColumnEncoding() {
        GreenplumColumnEncodingConstraint columnEncoding = new GreenplumColumnEncodingConstraint();
        if (this.lexer.token() == Token.DEFAULT) {
            this.accept(Token.DEFAULT);
            this.accept(Token.COLUMN);
            columnEncoding.setDefault(true);
        } else {
            this.accept(Token.COLUMN);
            if (this.lexer.token() == Token.IDENTIFIER) {
                columnEncoding.setName(this.exprParser.name());
            }
        }
        if (this.lexer.token() == Token.ENCODING) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(columnEncoding.getEncodingOptions(), columnEncoding);
            this.accept(Token.RPAREN);
        }
        return columnEncoding;
    }

    private void parseAsQuery(GreenplumCreateTableStatement createTable) {
        Token token = this.lexer.token();
        if (token == Token.SELECT || token == Token.WITH) {
            createTable.setAsQueryType(GreenplumCreateTableStatement.AsQueryTypeEnum.SELECT);
            this.parseAsSelect(createTable);
        } else if (token == Token.TABLE) {
            createTable.setAsQueryType(GreenplumCreateTableStatement.AsQueryTypeEnum.TABLE);
            this.parseAsTable(createTable);
        } else if (token == Token.VALUES) {
            createTable.setAsQueryType(GreenplumCreateTableStatement.AsQueryTypeEnum.VALUES);
            this.parseAsValues(createTable);
        }
    }

    private void parseAsValues(GreenplumCreateTableStatement createTable) {
        this.accept(Token.VALUES);
        this.parseValueClause(createTable.getValuesList(), 0, createTable);
    }

    private void parseAsTable(GreenplumCreateTableStatement createTable) {
        this.accept(Token.TABLE);
        createTable.setAsTable(new SQLExprTableSource(this.exprParser.expr()));
    }

    private void parseAsSelect(GreenplumCreateTableStatement createTable) {
        SQLSelect select = null;
        select = this.createSQLSelectParser().select();
        createTable.setSelect(select);
    }

    private void parseInheritsRest(List<SQLExprTableSource> inheritTables) {
        if (this.lexer.token() != Token.COMMA) {
            return;
        }
        this.lexer.nextToken();
        SQLName inherits = this.exprParser.name();
        inheritTables.add(new SQLExprTableSource(inherits));
        this.parseInheritsRest(inheritTables);
    }

    private void parseCreateTableLike(GreenplumCreateTableStatement createTable) {
        if (this.lexer.token() != Token.LIKE) {
            return;
        }
        this.lexer.nextToken();
        SQLName name = this.exprParser.name();
        createTable.setLike(name);
        while (this.lexer.identifierEquals("INCLUDING") || this.lexer.identifierEquals("EXCLUDING")) {
            List<GreenplumCreateTableStatement.LikeOptionEnum> likeOptions = this.lexer.identifierEquals("INCLUDING") ? createTable.getLikeIncludingLists() : createTable.getLikeExcludingLists();
            this.lexer.nextToken();
            String option = this.lexer.stringVal().toUpperCase();
            if (!GreenplumCreateTableStatement.LikeOptionEnum.contains(option)) continue;
            GreenplumCreateTableStatement.LikeOptionEnum likeOptionEnum = GreenplumCreateTableStatement.LikeOptionEnum.valueOf(option);
            likeOptions.add(likeOptionEnum);
            this.lexer.nextToken();
        }
        List<GreenplumColumnEncodingConstraint> columnEncodingConstraints = createTable.getColumnEncodingConstraints();
        while (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            columnEncodingConstraints.add((GreenplumColumnEncodingConstraint)this.parseColumnEncoding());
        }
    }

    @Override
    protected GreenplumCreateTableStatement newCreateStatement() {
        return new GreenplumCreateTableStatement(this.getDbType());
    }

    @Override
    public SQLPartitionBy parsePartitionBy() {
        this.lexer.nextToken();
        this.accept(Token.BY);
        if (this.lexer.identifierEquals("RANGE")) {
            this.lexer.nextToken();
            GreenplumPartitionBy partitionBy = this.partitionBy();
            partitionBy.setPartitionByType(GreenplumPartitionBy.Type.RANGE);
            return partitionBy;
        }
        if (this.lexer.identifierEquals("LIST")) {
            this.acceptIdentifier("LIST");
            GreenplumPartitionBy partitionBy = this.partitionBy();
            partitionBy.setPartitionByType(GreenplumPartitionBy.Type.LIST);
            return partitionBy;
        }
        throw new ParserException("TODO : " + this.lexer.info());
    }

    protected void parseDistributed(GreenplumCreateTableStatement stmt) {
        this.lexer.nextToken();
        if (this.lexer.token() == Token.RANDOMLY) {
            this.lexer.nextToken();
            stmt.setDistributedRandomly(true);
            return;
        }
        if (this.lexer.identifierEquals("replicated")) {
            this.lexer.nextToken();
            stmt.setDistributedReplicated(true);
            return;
        }
        this.accept(Token.BY);
        this.accept(Token.LPAREN);
        while (true) {
            SQLName column = this.exprParser.name();
            stmt.addDistributedColumn(column);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
    }

    protected GreenplumPartitionBy partitionBy() {
        this.accept(Token.LPAREN);
        GreenplumPartitionBy clause = new GreenplumPartitionBy();
        this.exprParser.exprList(clause.getColumns(), clause);
        this.accept(Token.RPAREN);
        this.parsePartitionByRest(clause);
        return clause;
    }

    protected void parsePartitionByRest(GreenplumPartitionBy clause) {
        while (this.lexer.token() == Token.SUBPARTITION) {
            SQLSubPartitionBy subPartitionBy = this.subPartitionBy();
            clause.addSubPartitionBy(subPartitionBy);
        }
        this.accept(Token.LPAREN);
        while (true) {
            GreenplumPartition partition = (GreenplumPartition)this.parsePartition();
            clause.addPartition(partition);
            this.parsePartitionWith(partition);
            this.parseColumnReference(partition);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
    }

    private void parseColumnReference(GreenplumPartition partition) {
        if (this.lexer.token() != Token.DEFAULT && this.lexer.token() != Token.COLUMN) {
            return;
        }
        partition.getColumnEncodingConstraint().addAll(this.parseColumnEncodings());
    }

    private void parsePartitionWith(SQLPartition partition) {
        if (this.lexer.token() != Token.WITH || !(partition instanceof GreenplumPartition)) {
            return;
        }
        this.accept(Token.WITH);
        this.accept(Token.LPAREN);
        this.parseAssignItems(((GreenplumPartition)partition).getPartitionOptions(), partition, false);
        this.accept(Token.RPAREN);
    }

    protected void partitionClauseRest(SQLPartitionBy clause) {
        if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
            this.lexer.nextToken();
            SQLIntegerExpr countExpr = this.exprParser.integerExpr();
            clause.setPartitionsCount(countExpr);
        }
        if (this.lexer.token() == Token.STORE) {
            this.lexer.nextToken();
            this.accept(Token.IN);
            this.accept(Token.LPAREN);
            this.exprParser.names(clause.getStoreIn(), clause);
            this.accept(Token.RPAREN);
        }
    }

    protected SQLSubPartitionBy subPartitionBy() {
        SQLSubPartitionBy subPartitionBy;
        SQLName column;
        this.lexer.nextToken();
        this.accept(Token.BY);
        if (this.lexer.identifierEquals(FnvHash.Constants.LIST)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            SQLSubPartitionByList byList = new SQLSubPartitionByList();
            column = this.exprParser.name();
            byList.setColumn(column);
            this.accept(Token.RPAREN);
            subPartitionBy = byList;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            SQLSubPartitionByRange byRange = new SQLSubPartitionByRange();
            column = this.exprParser.name();
            byRange.getColumns().add(column);
            this.accept(Token.RPAREN);
            subPartitionBy = byRange;
        } else {
            throw new ParserException("TODO : " + this.lexer.info());
        }
        if (this.lexer.token() == Token.SUBPARTITION) {
            this.lexer.nextToken();
            this.acceptIdentifier("TEMPLATE");
            this.accept(Token.LPAREN);
            while (true) {
                SQLSubPartition subPartition = this.parseSubPartition();
                subPartition.setParent(subPartitionBy);
                subPartitionBy.getSubPartitionTemplate().add(subPartition);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return subPartitionBy;
    }

    protected SQLSubPartition parseSubPartition() {
        SQLPartitionValue values;
        GreenplumSubPartition subPartition = new GreenplumSubPartition();
        if (this.lexer.token() == Token.DEFAULT) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SUBPARTITION) {
                this.lexer.nextToken();
                subPartition.setPartitionType(GreenplumSubPartition.PartitionType.DEFAULT);
                SQLName name = this.exprParser.name();
                subPartition.setName(name);
                return subPartition;
            }
            this.lexer.reset(mark);
        }
        if (this.lexer.token() == Token.SUBPARTITION) {
            this.lexer.nextToken();
            subPartition.setName(this.exprParser.name());
        }
        if (this.lexer.token() == Token.VALUES) {
            subPartition.setPartitionType(GreenplumSubPartition.PartitionType.LIST);
            values = this.exprParser.parsePartitionValues();
            subPartition.setValues(values);
        } else if (this.lexer.token() == Token.START) {
            subPartition.addGreenplumPartitionRangeValue(this.parsePartitionRangeValue());
            if (this.lexer.token() == Token.END) {
                subPartition.addGreenplumPartitionRangeValue(this.parsePartitionRangeValue());
            }
            if (this.lexer.token() == Token.EVERY) {
                subPartition.addGreenplumPartitionRangeValue(this.parsePartitionRangeValue());
            }
        } else if (this.lexer.token() == Token.END) {
            subPartition.setPartitionType(GreenplumSubPartition.PartitionType.RANGE);
            subPartition.addGreenplumPartitionRangeValue(this.parsePartitionRangeValue());
            if (this.lexer.token() == Token.EVERY) {
                subPartition.addGreenplumPartitionRangeValue(this.parsePartitionRangeValue());
            }
        }
        values = this.exprParser.parsePartitionValues();
        if (values != null) {
            subPartition.setValues(values);
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(subPartition.getSubPartitionOptions(), subPartition, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.DEFAULT || this.lexer.token() == Token.COLUMN) {
            subPartition.getColumnEncodingConstraints().addAll(this.parseColumnEncodings());
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            this.lexer.nextToken();
            subPartition.setTableSpace(this.exprParser.name());
        }
        return subPartition;
    }

    protected SQLPartition parsePartition() {
        SQLSubPartition subPartition;
        GreenplumPartition partition = new GreenplumPartition();
        if (this.lexer.token() == Token.DEFAULT) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                partition.setPartitionType(GreenplumPartition.PartitionType.DEFAULT);
                partition.setName(this.exprParser.name());
                return partition;
            }
            this.lexer.reset(mark);
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.accept(Token.PARTITION);
            partition.setName(this.exprParser.name());
        }
        if (this.lexer.token() == Token.VALUES) {
            partition.setPartitionType(GreenplumPartition.PartitionType.LIST);
            SQLPartitionValue values = this.exprParser.parsePartitionValues();
            partition.setValues(values);
        } else if (this.lexer.token() == Token.START) {
            partition.setPartitionType(GreenplumPartition.PartitionType.RANGE);
            partition.addGreenplumPartitionRangeValue(this.parsePartitionRangeValue());
            if (this.lexer.token() == Token.END) {
                partition.addGreenplumPartitionRangeValue(this.parsePartitionRangeValue());
            }
            if (this.lexer.token() == Token.EVERY) {
                partition.addGreenplumPartitionRangeValue(this.parsePartitionRangeValue());
            }
        } else if (this.lexer.token() == Token.END) {
            partition.setPartitionType(GreenplumPartition.PartitionType.RANGE);
            partition.addGreenplumPartitionRangeValue(this.parsePartitionRangeValue());
            if (this.lexer.token() == Token.EVERY) {
                partition.addGreenplumPartitionRangeValue(this.parsePartitionRangeValue());
            }
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                subPartition = this.parseSubPartition();
                partition.addSubPartition(subPartition);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                subPartition = this.parseSubPartition();
                partition.addSubPartition(subPartition);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return partition;
    }

    private GreenplumPartitionRangeValue parsePartitionRangeValue() {
        GreenplumPartitionRangeValue value = new GreenplumPartitionRangeValue();
        if (this.lexer.token() == Token.START) {
            this.lexer.nextToken();
            value.setRangeType(GreenplumPartitionRangeValue.RangeType.START);
        } else if (this.lexer.token() == Token.END) {
            this.lexer.nextToken();
            value.setRangeType(GreenplumPartitionRangeValue.RangeType.END);
        } else {
            this.accept(Token.EVERY);
            value.setRangeType(GreenplumPartitionRangeValue.RangeType.EVERY);
        }
        this.accept(Token.LPAREN);
        this.parseRangeValue(value.getRangeValues());
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.INCLUSIVE || this.lexer.token() == Token.EXCLUSIVE) {
            value.setRangeValueParameter(new SQLIdentifierExpr(this.lexer.stringVal()));
            this.lexer.nextToken();
        }
        return value;
    }

    private void parseRangeValue(List<Pair<SQLDataType, SQLExpr>> rangeValues) {
        if (this.lexer.token() == Token.RPAREN) {
            return;
        }
        if (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
        }
        SQLDataType sqlDataType = null;
        if (this.lexer.token() == Token.IDENTIFIER) {
            sqlDataType = this.exprParser.parseDataType();
        }
        SQLExpr expr = this.exprParser.expr();
        rangeValues.add((Pair<SQLDataType, SQLExpr>)new Pair((Object)sqlDataType, (Object)expr));
        this.parseRangeValue(rangeValues);
    }
}

