/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.explorer.vistor;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.dialect.explorer.vistor.ExplorerASTVisitor;
import com.alibaba.fastsql.sql.dialect.explorer.vistor.ExplorerLexer;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.google.common.base.Strings;
import java.util.List;

public class ExplorerOutputVisitor
extends MySqlOutputVisitor
implements ExplorerASTVisitor {
    public ExplorerOutputVisitor(Appendable appender) {
        super(appender);
    }

    public ExplorerOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        SQLExpr expr;
        if (x.isConnectByRoot()) {
            this.print0(this.ucase ? "CONNECT_BY_ROOT " : "connect_by_root ");
        }
        if ((expr = x.getExpr()) instanceof SQLIdentifierExpr) {
            String name = ((SQLIdentifierExpr)expr).getName();
            this.print0(ExplorerOutputVisitor.buildBackticks(name));
        } else if (expr instanceof SQLPropertyExpr) {
            this.visit((SQLPropertyExpr)expr);
        } else {
            this.printExpr(expr, this.parameterized);
        }
        String alias = x.getAlias();
        if (alias != null && alias.length() > 0) {
            this.print0(this.ucase ? " AS " : " as ");
            char c0 = alias.charAt(0);
            boolean special = false;
            if (c0 != '\"' && c0 != '\'' && c0 != '`' && c0 != '[') {
                for (int i = 1; i < alias.length(); ++i) {
                    char ch = alias.charAt(i);
                    if (ch >= '\u0100' || ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '$') continue;
                    special = true;
                }
            }
            if (!this.printNameQuote && !special) {
                this.print0(ExplorerOutputVisitor.buildBackticks(alias));
            } else {
                this.print(this.quote);
                String unquoteAlias = null;
                if (c0 == '`' && alias.charAt(alias.length() - 1) == '`') {
                    unquoteAlias = alias.substring(1, alias.length() - 1);
                } else if (c0 == '\'' && alias.charAt(alias.length() - 1) == '\'') {
                    unquoteAlias = alias.substring(1, alias.length() - 1);
                } else if (c0 == '\"' && alias.charAt(alias.length() - 1) == '\"') {
                    unquoteAlias = alias.substring(1, alias.length() - 1);
                } else {
                    this.print0(alias);
                }
                if (unquoteAlias != null) {
                    this.print0(unquoteAlias);
                }
                this.print(this.quote);
            }
            return false;
        }
        List<String> aliasList = x.getAliasList();
        if (aliasList == null) {
            return false;
        }
        this.println();
        this.print0(this.ucase ? "AS (" : "as (");
        int aliasSize = aliasList.size();
        if (aliasSize > 5) {
            ++this.indentCount;
            this.println();
        }
        for (int i = 0; i < aliasSize; ++i) {
            if (i != 0) {
                if (aliasSize > 5) {
                    this.println(",");
                } else {
                    this.print0(", ");
                }
            }
            this.print0(aliasList.get(i));
        }
        if (aliasSize > 5) {
            --this.indentCount;
            this.println();
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        SQLExpr owner = x.getOwner();
        String mapTableName = null;
        String ownerName = null;
        if (owner instanceof SQLIdentifierExpr) {
            ownerName = ((SQLIdentifierExpr)owner).getName();
            if (this.tableMapping != null && (mapTableName = (String)this.tableMapping.get(ownerName)) == null && ownerName.length() > 2 && ownerName.charAt(0) == '`' && ownerName.charAt(ownerName.length() - 1) == '`') {
                ownerName = ownerName.substring(1, ownerName.length() - 1);
                mapTableName = (String)this.tableMapping.get(ownerName);
            }
        }
        if (mapTableName != null) {
            for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof SQLSelectQueryBlock)) continue;
                SQLTableSource from = ((SQLSelectQueryBlock)parent).getFrom();
                if (!this.isTableSourceAlias(from, mapTableName, ownerName)) break;
                mapTableName = null;
                break;
            }
        }
        if (mapTableName != null) {
            this.printName0(mapTableName);
        } else if (owner instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr ownerIdent = (SQLIdentifierExpr)owner;
            this.printName(ownerIdent, ownerIdent.getName(), this.shardingSupport && this.parameterized);
        } else {
            this.printExpr(owner, this.parameterized);
        }
        this.print('.');
        String name = x.getName();
        if ("*".equals(name)) {
            this.print0(name);
        } else {
            this.printName0(ExplorerOutputVisitor.buildBackticks(name));
        }
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        this.printName0(ExplorerOutputVisitor.buildBackticks(x.getName()));
        return false;
    }

    public static String buildBackticks(String text) {
        if (Strings.isNullOrEmpty(text)) {
            return text;
        }
        if (ExplorerLexer.DEFAULT_EXPLORER_KEYWORDS.containsValueString(text)) {
            return String.format("`%s`", text);
        }
        return text;
    }

    private boolean printName(SQLName x, String name, boolean shardingSupport) {
        if (shardingSupport) {
            SQLObject parent = x.getParent();
            boolean bl = shardingSupport = parent instanceof SQLExprTableSource || parent instanceof SQLPropertyExpr;
            if (parent instanceof SQLPropertyExpr && parent.getParent() instanceof SQLExprTableSource) {
                shardingSupport = false;
            }
        }
        if (shardingSupport) {
            boolean quote = name.charAt(0) == '`' && name.charAt(name.length() - 1) == '`';
            String unwrappedName = this.unwrapShardingTable(name);
            if (unwrappedName != name) {
                boolean isAlias = false;
                for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof SQLSelectQueryBlock)) continue;
                    SQLTableSource from = ((SQLSelectQueryBlock)parent).getFrom();
                    if (quote) {
                        String name2 = name.substring(1, name.length() - 1);
                        if (!this.isTableSourceAlias(from, name, name2)) break;
                        isAlias = true;
                        break;
                    }
                    if (!this.isTableSourceAlias(from, name)) break;
                    isAlias = true;
                    break;
                }
                if (!isAlias) {
                    this.print0(unwrappedName);
                    this.incrementReplaceCunt();
                    return false;
                }
                this.printName0(name);
                return false;
            }
        }
        this.printName0(name);
        return false;
    }
}

