/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.statement;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLWithSubqueryClause
extends SQLObjectImpl {
    private Boolean recursive;
    private final List<Entry> entries = new ArrayList<Entry>();

    @Override
    public SQLWithSubqueryClause clone() {
        SQLWithSubqueryClause x = new SQLWithSubqueryClause();
        x.recursive = this.recursive;
        for (Entry entry : this.entries) {
            Entry entry2 = entry.clone();
            entry2.setParent(x);
            x.entries.add(entry2);
        }
        return x;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void addEntry(Entry entry) {
        if (entry != null) {
            entry.setParent(this);
        }
        this.entries.add(entry);
    }

    public Boolean getRecursive() {
        return this.recursive;
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry entry = this.entries.get(i);
                if (entry == null) continue;
                entry.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public Entry findEntry(long alias_hash) {
        if (alias_hash == 0L) {
            return null;
        }
        for (Entry entry : this.entries) {
            if (entry.aliasHashCode64() != alias_hash) continue;
            return entry;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLWithSubqueryClause that = (SQLWithSubqueryClause)o;
        if (this.recursive != null ? !this.recursive.equals(that.recursive) : that.recursive != null) {
            return false;
        }
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        int result = this.recursive != null ? this.recursive.hashCode() : 0;
        result = 31 * result + this.entries.hashCode();
        return result;
    }

    public static class Entry
    extends SQLTableSourceImpl
    implements SQLReplaceable {
        protected final List<SQLName> columns = new ArrayList<SQLName>();
        protected SQLSelect subQuery;
        protected SQLStatement returningStatement;
        protected SQLExpr expr;

        public Entry() {
        }

        public Entry(String alias, SQLSelect select) {
            this.setAlias(alias);
            this.setSubQuery(select);
        }

        public Entry(String alias, SQLExpr expr) {
            this.setAlias(alias);
            this.setExpr(expr);
        }

        public void cloneTo(Entry x) {
            for (SQLName column : this.columns) {
                SQLName column2 = column.clone();
                column2.setParent(x);
                x.columns.add(column2);
            }
            if (this.subQuery != null) {
                x.setSubQuery(this.subQuery.clone());
            }
            if (this.returningStatement != null) {
                this.setReturningStatement(this.returningStatement.clone());
            }
            x.alias = this.alias;
            x.expr = this.expr;
        }

        @Override
        public boolean replace(SQLExpr expr, SQLExpr target) {
            if (this.flashback == expr) {
                this.setFlashback(target);
                return true;
            }
            for (int i = 0; i < this.columns.size(); ++i) {
                if (this.columns.get(i) != expr) continue;
                target.setParent(this);
                this.columns.set(i, (SQLName)expr);
                return true;
            }
            return false;
        }

        @Override
        public Entry clone() {
            Entry x = new Entry();
            this.cloneTo(x);
            return x;
        }

        public SQLExpr getExpr() {
            return this.expr;
        }

        public void setExpr(SQLExpr expr) {
            this.expr = expr;
        }

        @Override
        protected void accept0(SQLASTVisitor visitor) {
            if (visitor.visit(this)) {
                for (int i = 0; i < this.columns.size(); ++i) {
                    SQLExpr column = this.columns.get(i);
                    if (column == null) continue;
                    column.accept(visitor);
                }
                if (this.subQuery != null) {
                    this.subQuery.accept(visitor);
                }
                if (this.returningStatement != null) {
                    this.returningStatement.accept(visitor);
                }
                if (this.expr != null) {
                    this.expr.accept(visitor);
                }
            }
            visitor.endVisit(this);
        }

        public SQLSelect getSubQuery() {
            return this.subQuery;
        }

        public void setSubQuery(SQLSelect subQuery) {
            if (subQuery != null) {
                subQuery.setParent(this);
            }
            this.subQuery = subQuery;
        }

        public SQLStatement getReturningStatement() {
            return this.returningStatement;
        }

        public void setReturningStatement(SQLStatement returningStatement) {
            if (returningStatement != null) {
                returningStatement.setParent(this);
            }
            this.returningStatement = returningStatement;
        }

        public List<SQLName> getColumns() {
            return this.columns;
        }

        @Override
        public SQLTableSource findTableSourceWithColumn(long columnNameHash, String columnName, int option) {
            SQLSelectQueryBlock queryBlock;
            for (SQLName column : this.columns) {
                if (column.nameHashCode64() != columnNameHash) continue;
                return this;
            }
            if (this.subQuery != null && (queryBlock = this.subQuery.getFirstQueryBlock()) != null && queryBlock.findSelectItem(columnNameHash) != null) {
                return this;
            }
            return null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.columns.equals(entry.columns)) {
                return false;
            }
            if (this.subQuery != null ? !this.subQuery.equals(entry.subQuery) : entry.subQuery != null) {
                return false;
            }
            return this.returningStatement != null ? this.returningStatement.equals(entry.returningStatement) : entry.returningStatement == null;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
            result = 31 * result + (this.subQuery != null ? this.subQuery.hashCode() : 0);
            result = 31 * result + (this.returningStatement != null ? this.returningStatement.hashCode() : 0);
            return result;
        }
    }
}

