/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.statement;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSampling;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.repository.SchemaObject;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class SQLExprTableSource
extends SQLTableSourceImpl
implements SQLReplaceable {
    protected SQLExpr expr;
    protected List<SQLName> partitions;
    protected SQLTableSampling sampling;
    protected SchemaObject schemaObject;
    protected List<SQLName> columns;

    public SQLExprTableSource() {
    }

    public SQLExprTableSource(String tableName) {
        this(SQLUtils.toSQLExpr(tableName), null);
    }

    public SQLExprTableSource(SQLExpr expr) {
        this(expr, null);
    }

    public SQLExprTableSource(SQLExpr expr, String alias) {
        this.setExpr(expr);
        this.setAlias(alias);
    }

    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setExpr(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.expr = x;
        this.setStartColumn(this.expr.getStartColumn());
        this.setStartLine(this.expr.getStartLine());
    }

    public void setExpr(String name) {
        this.setExpr(new SQLIdentifierExpr(name));
    }

    public SQLTableSampling getSampling() {
        return this.sampling;
    }

    public void setSampling(SQLTableSampling x) {
        if (x != null) {
            x.setParent(this);
        }
        this.sampling = x;
    }

    public SQLName getName() {
        if (this.expr instanceof SQLName) {
            return (SQLName)this.expr;
        }
        return null;
    }

    public String getTableName() {
        if (this.expr == null) {
            return null;
        }
        if (this.expr instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)this.expr).getName();
        }
        if (this.expr instanceof SQLPropertyExpr) {
            return ((SQLPropertyExpr)this.expr).getSimpleName();
        }
        return null;
    }

    public String getSchema() {
        if (this.expr == null) {
            return null;
        }
        if (this.expr instanceof SQLPropertyExpr) {
            SQLExpr owner = ((SQLPropertyExpr)this.expr).getOwner();
            if (owner instanceof SQLIdentifierExpr) {
                return ((SQLIdentifierExpr)owner).getName();
            }
            if (owner instanceof SQLPropertyExpr) {
                return ((SQLPropertyExpr)owner).getSimpleName();
            }
            if (owner instanceof SQLAllColumnExpr) {
                return "*";
            }
            return null;
        }
        return null;
    }

    public String getCatalog() {
        if (this.expr instanceof SQLPropertyExpr) {
            SQLExpr catalogExpr;
            SQLExpr owner = ((SQLPropertyExpr)this.expr).getOwner();
            if (owner instanceof SQLPropertyExpr && (catalogExpr = ((SQLPropertyExpr)owner).getOwner()) instanceof SQLIdentifierExpr) {
                return ((SQLIdentifierExpr)catalogExpr).getName();
            }
            return null;
        }
        return null;
    }

    public boolean setCatalog(String catalog) {
        if (this.expr instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyOwner;
            SQLExpr propertyOwnerOwner;
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)this.expr;
            SQLExpr owner = propertyExpr.getOwner();
            if (owner instanceof SQLIdentifierExpr) {
                if (catalog == null) {
                    return false;
                }
                propertyExpr.setOwner(new SQLPropertyExpr(catalog, ((SQLIdentifierExpr)owner).getName()));
                return true;
            }
            if (owner instanceof SQLPropertyExpr && (propertyOwnerOwner = (propertyOwner = (SQLPropertyExpr)owner).getOwner()) instanceof SQLIdentifierExpr) {
                if (catalog == null) {
                    propertyExpr.setOwner(((SQLIdentifierExpr)propertyOwnerOwner).getName());
                } else {
                    propertyOwner.setOwner(new SQLIdentifierExpr(catalog));
                }
                return true;
            }
        }
        return false;
    }

    public void setCatalog(String catalog, String schema) {
        if (catalog == null) {
            throw new IllegalArgumentException("catalog is null.");
        }
        if (schema == null) {
            throw new IllegalArgumentException("schema is null.");
        }
        this.setSchema(schema);
        this.setCatalog(catalog);
    }

    public void setSchema(String schema) {
        if (this.expr instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)this.expr;
            if (StringUtils.isEmpty(schema)) {
                this.setExpr(new SQLIdentifierExpr(propertyExpr.getName()));
            } else {
                propertyExpr.setOwner(schema);
            }
        } else {
            if (StringUtils.isEmpty(schema)) {
                return;
            }
            String ident = ((SQLIdentifierExpr)this.expr).getName();
            this.setExpr(new SQLPropertyExpr(schema, ident));
        }
    }

    public void setSimpleName(String name) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("schema is empty.");
        }
        if (this.expr == null) {
            this.expr = new SQLIdentifierExpr(name);
        } else if (this.expr instanceof SQLPropertyExpr) {
            ((SQLPropertyExpr)this.expr).setName(name);
        } else {
            this.expr = new SQLIdentifierExpr(name);
        }
    }

    public List<SQLName> getPartitions() {
        if (this.partitions == null) {
            this.partitions = new ArrayList<SQLName>(2);
        }
        return this.partitions;
    }

    public int getPartitionSize() {
        if (this.partitions == null) {
            return 0;
        }
        return this.partitions.size();
    }

    public void addPartition(SQLName partition) {
        if (partition != null) {
            partition.setParent(this);
        }
        if (this.partitions == null) {
            this.partitions = new ArrayList<SQLName>(2);
        }
        this.partitions.add(partition);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor);
        }
        visitor.endVisit(this);
    }

    protected void acceptChild(SQLASTVisitor visitor) {
        if (this.expr != null) {
            this.expr.accept(visitor);
        }
        if (this.sampling != null) {
            this.sampling.accept(visitor);
        }
        if (this.aliasExpr != null) {
            this.aliasExpr.accept(visitor);
        }
    }

    @Override
    public String computeAlias() {
        String alias = this.getAlias();
        if (alias == null && this.expr instanceof SQLName) {
            alias = ((SQLName)this.expr).getSimpleName();
        }
        return SQLUtils.normalize(alias);
    }

    @Override
    public SQLExprTableSource clone() {
        SQLExprTableSource x = new SQLExprTableSource();
        this.cloneTo(x);
        return x;
    }

    public void cloneTo(SQLExprTableSource x) {
        x.alias = this.alias;
        if (this.expr != null) {
            x.setExpr(this.expr.clone());
        }
        if (this.partitions != null) {
            for (SQLName p : this.partitions) {
                SQLName p1 = p.clone();
                x.addPartition(p1);
            }
        }
        if (this.schemaObject != null) {
            x.setSchemaObject(this.schemaObject);
        }
        if (this.columns != null) {
            x.columns = new ArrayList<SQLName>(this.columns.size());
            for (SQLName column : this.columns) {
                SQLName clonedColumn = column.clone();
                clonedColumn.setParent(x);
                x.columns.add(clonedColumn);
            }
        }
        if (this.aliasExpr != null) {
            x.setAliasExpr(this.aliasExpr.clone());
        }
    }

    public List<SQLName> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<SQLName>(2);
        }
        return this.columns;
    }

    public List<SQLName> getColumnsDirect() {
        return this.columns;
    }

    public SchemaObject getSchemaObject() {
        return this.schemaObject;
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        this.schemaObject = schemaObject;
    }

    @Override
    public boolean containsAlias(String alias) {
        long hashCode64 = FnvHash.hashCode64(alias);
        return this.containsAlias(hashCode64);
    }

    public boolean containsAlias(long aliasHash) {
        long exprNameHash;
        if (this.aliasHashCode64() == aliasHash) {
            return true;
        }
        if (this.expr instanceof SQLPropertyExpr && (exprNameHash = ((SQLPropertyExpr)this.expr).hashCode64()) == aliasHash) {
            return true;
        }
        if (this.expr instanceof SQLName) {
            exprNameHash = ((SQLName)this.expr).nameHashCode64();
            return exprNameHash == aliasHash;
        }
        return false;
    }

    @Override
    public SQLColumnDefinition findColumn(String columnName) {
        if (columnName == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(columnName);
        return this.findColumn(hash);
    }

    @Override
    public SQLColumnDefinition findColumn(long columnNameHash) {
        SQLObject object = this.resolveColum(columnNameHash);
        if (object instanceof SQLColumnDefinition) {
            return (SQLColumnDefinition)object;
        }
        return null;
    }

    @Override
    public SQLObject resolveColum(long columnNameHash) {
        SQLStatement stmt;
        if (this.schemaObject != null && (stmt = this.schemaObject.getStatement()) instanceof SQLCreateTableStatement) {
            SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)stmt;
            return createTableStmt.findColumn(columnNameHash);
        }
        SQLObject resolvedOwnerObject = null;
        if (this.expr instanceof SQLIdentifierExpr) {
            resolvedOwnerObject = ((SQLIdentifierExpr)this.expr).getResolvedOwnerObject();
        }
        if (resolvedOwnerObject == null) {
            return resolvedOwnerObject;
        }
        if (resolvedOwnerObject instanceof SQLWithSubqueryClause.Entry) {
            SQLSelect subQuery = ((SQLWithSubqueryClause.Entry)resolvedOwnerObject).getSubQuery();
            if (subQuery == null) {
                return null;
            }
            SQLSelectQueryBlock firstQueryBlock = subQuery.getFirstQueryBlock();
            if (firstQueryBlock == null) {
                return null;
            }
            SQLSelectItem selectItem = firstQueryBlock.findSelectItem(columnNameHash);
            if (selectItem != null) {
                return selectItem;
            }
        }
        return null;
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(String columnName) {
        if (columnName == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(columnName);
        return this.findTableSourceWithColumn(hash, columnName, 0);
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(long columnName_hash, String name, int option) {
        SQLTableSource tableSource;
        SQLCreateTableStatement createTableStmt;
        SQLStatement stmt;
        if (this.schemaObject != null && (stmt = this.schemaObject.getStatement()) instanceof SQLCreateTableStatement && (createTableStmt = (SQLCreateTableStatement)stmt).findColumn(columnName_hash) != null) {
            return this;
        }
        if (this.expr instanceof SQLIdentifierExpr && (tableSource = ((SQLIdentifierExpr)this.expr).getResolvedTableSource()) != null) {
            return this;
        }
        return null;
    }

    @Override
    public SQLTableSource findTableSource(long alias_hash) {
        long hash;
        long exprNameHash;
        if (alias_hash == 0L) {
            return null;
        }
        if (this.aliasHashCode64() == alias_hash) {
            return this;
        }
        if (this.expr instanceof SQLName && (exprNameHash = ((SQLName)this.expr).nameHashCode64()) == alias_hash) {
            return this;
        }
        if (this.expr instanceof SQLPropertyExpr && (hash = ((SQLPropertyExpr)this.expr).hashCode64()) == alias_hash) {
            return this;
        }
        return null;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (expr == this.expr) {
            this.setExpr(target);
            return true;
        }
        if (this.partitions != null) {
            for (int i = 0; i < this.partitions.size(); ++i) {
                if (this.partitions.get(i) != expr) continue;
                target.setParent(this);
                this.partitions.set(i, (SQLName)target);
                return true;
            }
        }
        return false;
    }

    @Override
    public long aliasHashCode64() {
        if (this.alias != null) {
            if (this.aliasHashCode64 == 0L) {
                this.aliasHashCode64 = FnvHash.hashCode64(this.alias);
            }
            return this.aliasHashCode64;
        }
        if (this.expr instanceof SQLName) {
            return ((SQLName)this.expr).nameHashCode64();
        }
        return 0L;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SQLExprTableSource that = (SQLExprTableSource)o;
        if (this.expr != null ? !this.expr.equals(that.expr) : that.expr != null) {
            return false;
        }
        if (this.partitions != null ? !this.partitions.equals(that.partitions) : that.partitions != null) {
            return false;
        }
        if (this.sampling != null ? !this.sampling.equals(that.sampling) : that.sampling != null) {
            return false;
        }
        if (this.schemaObject != null ? !this.schemaObject.equals(that.schemaObject) : that.schemaObject != null) {
            return false;
        }
        return this.columns != null ? this.columns.equals(that.columns) : that.columns == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.expr != null ? this.expr.hashCode() : 0);
        result = 31 * result + (this.partitions != null ? this.partitions.hashCode() : 0);
        result = 31 * result + (this.sampling != null ? this.sampling.hashCode() : 0);
        result = 31 * result + (this.schemaObject != null ? this.schemaObject.hashCode() : 0);
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        return result;
    }
}

