/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.FastsqlException;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDeclareItem;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLParameter;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class SQLIdentifierExpr
extends SQLExprImpl
implements SQLName,
Comparable<SQLIdentifierExpr> {
    protected String name;
    private long hashCode64;
    private SQLObject resolvedColumn;
    private SQLObject resolvedOwnerObject;

    public SQLIdentifierExpr() {
    }

    public SQLIdentifierExpr(String name) {
        this.name = name;
    }

    public SQLIdentifierExpr(String name, long hash_lower) {
        this.name = name;
        this.hashCode64 = hash_lower;
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    public String getLowerName() {
        if (this.name == null) {
            return null;
        }
        return this.name.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.hashCode64 = 0L;
        if (this.parent instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)this.parent;
            propertyExpr.computeHashCode64();
        }
    }

    @Override
    public long nameHashCode64() {
        return this.hashCode64();
    }

    @Override
    public long hashCode64() {
        if (this.hashCode64 == 0L && this.name != null) {
            this.hashCode64 = FnvHash.hashCode64(this.name);
        }
        return this.hashCode64;
    }

    @Override
    public void output(Appendable buf) {
        try {
            buf.append(this.name);
        }
        catch (IOException ex) {
            throw new FastsqlException("output error", ex);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        long value = this.hashCode64();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SQLIdentifierExpr)) {
            return false;
        }
        SQLIdentifierExpr other = (SQLIdentifierExpr)obj;
        return this.hashCode64() == other.hashCode64();
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public SQLIdentifierExpr clone() {
        SQLIdentifierExpr x = new SQLIdentifierExpr(this.name, this.hashCode64);
        x.resolvedColumn = this.resolvedColumn;
        x.resolvedOwnerObject = this.resolvedOwnerObject;
        if (this.hint != null) {
            x.hint = this.hint.clone();
        }
        return x;
    }

    public SQLIdentifierExpr simplify() {
        String normalized = SQLUtils.normalize(this.name);
        if (normalized != this.name) {
            return new SQLIdentifierExpr(normalized, this.hashCode64);
        }
        return this;
    }

    public String normalizedName() {
        return SQLUtils.normalize(this.name);
    }

    @Override
    public SQLColumnDefinition getResolvedColumn() {
        if (this.resolvedColumn instanceof SQLColumnDefinition) {
            return (SQLColumnDefinition)this.resolvedColumn;
        }
        if (this.resolvedColumn instanceof SQLSelectItem) {
            SQLSelectItem selectItem = (SQLSelectItem)this.resolvedColumn;
            SQLExpr expr = selectItem.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                return ((SQLIdentifierExpr)expr).getResolvedColumn();
            }
            if (expr instanceof SQLPropertyExpr) {
                return ((SQLPropertyExpr)expr).getResolvedColumn();
            }
        }
        return null;
    }

    public SQLSelectItem getResolvedSelectItem() {
        if (this.resolvedColumn instanceof SQLSelectItem) {
            return (SQLSelectItem)this.resolvedColumn;
        }
        return null;
    }

    public SQLObject getResolvedColumnObject() {
        return this.resolvedColumn;
    }

    public void setResolvedColumn(SQLColumnDefinition resolvedColumn) {
        this.resolvedColumn = resolvedColumn;
    }

    public void setResolvedColumn(SQLSelectItem selectItem) {
        this.resolvedColumn = selectItem;
    }

    public SQLTableSource getResolvedTableSource() {
        if (this.resolvedOwnerObject instanceof SQLTableSource) {
            return (SQLTableSource)this.resolvedOwnerObject;
        }
        return null;
    }

    public void setResolvedTableSource(SQLTableSource resolvedTableSource) {
        this.resolvedOwnerObject = resolvedTableSource;
    }

    public SQLObject getResolvedOwnerObject() {
        return this.resolvedOwnerObject;
    }

    public void setResolvedOwnerObject(SQLObject resolvedOwnerObject) {
        this.resolvedOwnerObject = resolvedOwnerObject;
    }

    public SQLParameter getResolvedParameter() {
        if (this.resolvedColumn instanceof SQLParameter) {
            return (SQLParameter)this.resolvedColumn;
        }
        return null;
    }

    public void setResolvedParameter(SQLParameter resolvedParameter) {
        this.resolvedColumn = resolvedParameter;
    }

    public SQLDeclareItem getResolvedDeclareItem() {
        if (this.resolvedColumn instanceof SQLDeclareItem) {
            return (SQLDeclareItem)this.resolvedColumn;
        }
        return null;
    }

    public void setResolvedDeclareItem(SQLDeclareItem resolvedDeclareItem) {
        this.resolvedColumn = resolvedDeclareItem;
    }

    @Override
    public SQLDataType computeDataType() {
        SQLSelectItem selectItem;
        SQLColumnDefinition resolvedColumn = this.getResolvedColumn();
        if (resolvedColumn != null) {
            return resolvedColumn.getDataType();
        }
        if (this.resolvedColumn instanceof SQLSelectItem) {
            return ((SQLSelectItem)this.resolvedColumn).computeDataType();
        }
        SQLSelectQueryBlock queryBlock = null;
        if (this.resolvedOwnerObject instanceof SQLSubqueryTableSource) {
            SQLSelect select = ((SQLSubqueryTableSource)this.resolvedOwnerObject).getSelect();
            queryBlock = select.getFirstQueryBlock();
        } else if (this.resolvedOwnerObject instanceof SQLUnionQueryTableSource) {
            SQLUnionQuery union = ((SQLUnionQueryTableSource)this.resolvedOwnerObject).getUnion();
            queryBlock = union.getFirstQueryBlock();
        } else if (this.resolvedOwnerObject instanceof SQLWithSubqueryClause.Entry) {
            queryBlock = ((SQLWithSubqueryClause.Entry)this.resolvedOwnerObject).getSubQuery().getFirstQueryBlock();
        }
        if (queryBlock != null && (selectItem = queryBlock.findSelectItem(this.nameHashCode64())) != null) {
            return selectItem.computeDataType();
        }
        return null;
    }

    public boolean nameEquals(String name) {
        return SQLUtils.nameEquals(this.name, name);
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.emptyList();
    }

    public static boolean matchIgnoreCase(SQLExpr expr, String name) {
        if (!(expr instanceof SQLIdentifierExpr)) {
            return false;
        }
        SQLIdentifierExpr ident = (SQLIdentifierExpr)expr;
        return ident.getName().equalsIgnoreCase(name);
    }

    @Override
    public int compareTo(SQLIdentifierExpr o) {
        return this.normalizedName().compareTo(o.normalizedName());
    }
}

