/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.FastsqlException;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDecimalExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNullExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumberExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.fastsql.sql.parser.ParserException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class SQLExprUtils {
    public static boolean equals(SQLExpr a, SQLExpr b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Class<?> clazz_a = a.getClass();
        Class<?> clazz_b = b.getClass();
        if (clazz_a == SQLPropertyExpr.class && clazz_b == SQLIdentifierExpr.class) {
            return ((SQLPropertyExpr)a).equals((SQLIdentifierExpr)b);
        }
        if (clazz_a != clazz_b) {
            return false;
        }
        if (clazz_a == SQLIdentifierExpr.class) {
            SQLIdentifierExpr x_a = (SQLIdentifierExpr)a;
            SQLIdentifierExpr x_b = (SQLIdentifierExpr)b;
            return x_a.hashCode() == x_b.hashCode();
        }
        if (clazz_a == SQLBinaryOpExpr.class) {
            SQLBinaryOpExpr x_a = (SQLBinaryOpExpr)a;
            SQLBinaryOpExpr x_b = (SQLBinaryOpExpr)b;
            return x_a.equals(x_b);
        }
        return a.equals(b);
    }

    public static boolean isLiteralExpr(SQLExpr expr) {
        if (expr instanceof SQLLiteralExpr) {
            return true;
        }
        if (expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binary = (SQLBinaryOpExpr)expr;
            return SQLExprUtils.isLiteralExpr(binary.left) && SQLExprUtils.isLiteralExpr(binary.right);
        }
        return false;
    }

    public static SQLExpr fromJavaObject(Object o) {
        return SQLExprUtils.fromJavaObject(o, null);
    }

    public static SQLExpr fromJavaObject(Object o, TimeZone timeZone) {
        if (o == null) {
            return new SQLNullExpr();
        }
        if (o instanceof String) {
            return new SQLCharExpr((String)o);
        }
        if (o instanceof BigDecimal) {
            return new SQLDecimalExpr((BigDecimal)o);
        }
        if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof BigInteger) {
            return new SQLIntegerExpr((Number)o);
        }
        if (o instanceof Number) {
            return new SQLNumberExpr((Number)o);
        }
        if (o instanceof Date) {
            return new SQLTimestampExpr((Date)o, timeZone);
        }
        throw new ParserException("not support class : " + o.getClass());
    }

    public static SQLInListExpr conditionIn(String column, List<Object> values, TimeZone timeZone) {
        SQLInListExpr in = new SQLInListExpr();
        in.setExpr(SQLUtils.toSQLExpr(column));
        for (Object value : values) {
            in.addTarget(SQLExprUtils.fromJavaObject(value, timeZone));
        }
        return in;
    }

    public static String quote(String str, DbType dbType, char quote) {
        SQLExprImpl expr;
        if (quote == '`') {
            expr = new SQLIdentifierExpr(str);
        } else if (quote == '\"') {
            expr = dbType == DbType.oracle || dbType == DbType.presto ? new SQLIdentifierExpr(str) : new SQLCharExpr(str);
        } else if (quote == '\'') {
            expr = new SQLCharExpr(str);
        } else {
            throw new FastsqlException("quote not support");
        }
        return SQLUtils.toSQLString(expr, dbType);
    }
}

