/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.FastsqlException;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import com.alibaba.fastsql.util.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;

public class SQLBinaryExpr
extends SQLExprImpl
implements SQLLiteralExpr,
SQLValuableExpr {
    private String text;
    private transient Number val;

    public SQLBinaryExpr() {
    }

    public SQLBinaryExpr(String value) {
        this.text = value;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public Number getValue() {
        if (this.text == null) {
            return null;
        }
        if (this.val == null) {
            long[] words = new long[this.text.length() / 64 + 1];
            for (int i = this.text.length() - 1; i >= 0; --i) {
                int wordIndex;
                char ch = this.text.charAt(i);
                if (ch != '1') continue;
                int n = wordIndex = i >> 6;
                words[n] = words[n] | 1L << this.text.length() - 1 - i;
            }
            if (words.length == 1) {
                this.val = words[0];
            } else {
                byte[] bytes = new byte[words.length * 8];
                for (int i = 0; i < words.length; ++i) {
                    Utils.putLong(bytes, (words.length - 1 - i) * 8, words[i]);
                }
                this.val = new BigInteger(bytes);
            }
        }
        return this.val;
    }

    public void setValue(String value) {
        this.text = value;
    }

    @Override
    public void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public void output(Appendable buf) {
        try {
            buf.append("b'");
            buf.append(this.text);
            buf.append('\'');
        }
        catch (IOException ex) {
            throw new FastsqlException("output error", ex);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public SQLBinaryExpr clone() {
        return new SQLBinaryExpr(this.text);
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLBinaryExpr other = (SQLBinaryExpr)obj;
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

